"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypedocDocgen = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
  Adds a simple Typescript documentation generator
 */
class TypedocDocgen {
    constructor(project) {
        project.addDevDeps("typedoc@^0.21.4");
        const docgen = project.addTask("docgen", {
            description: `Generate TypeScript API reference ${project.docsDirectory}`,
            exec: `typedoc ${project.srcdir} --disableSources --out ${project.docsDirectory}`,
        });
        // spawn after a successful compile
        project.postCompileTask.spawn(docgen);
    }
}
exports.TypedocDocgen = TypedocDocgen;
_a = JSII_RTTI_SYMBOL_1;
TypedocDocgen[_a] = { fqn: "projen.typescript.TypedocDocgen", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZXNjcmlwdC10eXBlZG9jLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3R5cGVzY3JpcHQvdHlwZXNjcmlwdC10eXBlZG9jLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBRUE7O0dBRUc7QUFDSCxNQUFhLGFBQWE7SUFDeEIsWUFBWSxPQUEwQjtRQUNwQyxPQUFPLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFFdEMsTUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUU7WUFDdkMsV0FBVyxFQUFFLHFDQUFxQyxPQUFPLENBQUMsYUFBYSxFQUFFO1lBQ3pFLElBQUksRUFBRSxXQUFXLE9BQU8sQ0FBQyxNQUFNLDJCQUEyQixPQUFPLENBQUMsYUFBYSxFQUFFO1NBQ2xGLENBQUMsQ0FBQztRQUVILG1DQUFtQztRQUNuQyxPQUFPLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN4QyxDQUFDOztBQVhILHNDQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVHlwZVNjcmlwdFByb2plY3QgfSBmcm9tIFwiLi4vdHlwZXNjcmlwdFwiO1xuXG4vKipcbiAgQWRkcyBhIHNpbXBsZSBUeXBlc2NyaXB0IGRvY3VtZW50YXRpb24gZ2VuZXJhdG9yXG4gKi9cbmV4cG9ydCBjbGFzcyBUeXBlZG9jRG9jZ2VuIHtcbiAgY29uc3RydWN0b3IocHJvamVjdDogVHlwZVNjcmlwdFByb2plY3QpIHtcbiAgICBwcm9qZWN0LmFkZERldkRlcHMoXCJ0eXBlZG9jQF4wLjIxLjRcIik7XG5cbiAgICBjb25zdCBkb2NnZW4gPSBwcm9qZWN0LmFkZFRhc2soXCJkb2NnZW5cIiwge1xuICAgICAgZGVzY3JpcHRpb246IGBHZW5lcmF0ZSBUeXBlU2NyaXB0IEFQSSByZWZlcmVuY2UgJHtwcm9qZWN0LmRvY3NEaXJlY3Rvcnl9YCxcbiAgICAgIGV4ZWM6IGB0eXBlZG9jICR7cHJvamVjdC5zcmNkaXJ9IC0tZGlzYWJsZVNvdXJjZXMgLS1vdXQgJHtwcm9qZWN0LmRvY3NEaXJlY3Rvcnl9YCxcbiAgICB9KTtcblxuICAgIC8vIHNwYXduIGFmdGVyIGEgc3VjY2Vzc2Z1bCBjb21waWxlXG4gICAgcHJvamVjdC5wb3N0Q29tcGlsZVRhc2suc3Bhd24oZG9jZ2VuKTtcbiAgfVxufVxuIl19