"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeTsconfigOptions = exports.TypeScriptLibraryProject = exports.TypeScriptAppProject = exports.TypeScriptProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const semver = require("semver");
const common_1 = require("../common");
const component_1 = require("../component");
const javascript_1 = require("../javascript");
const sample_file_1 = require("../sample-file");
const textfile_1 = require("../textfile");
const typescript_1 = require("../typescript");
/**
 * TypeScript project
 * @pjid typescript
 */
class TypeScriptProject extends javascript_1.NodeProject {
    constructor(options) {
        var _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1;
        super({
            ...options,
            // disable .projenrc.js if typescript is enabled
            projenrcJs: options.projenrcTs ? false : options.projenrcJs,
            jestOptions: {
                ...options.jestOptions,
                jestConfig: {
                    ...(_d = options.jestOptions) === null || _d === void 0 ? void 0 : _d.jestConfig,
                    testMatch: [],
                },
            },
        });
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : "src";
        this.libdir = (_f = options.libdir) !== null && _f !== void 0 ? _f : "lib";
        this.docgen = options.docgen;
        this.docsDirectory = (_g = options.docsDirectory) !== null && _g !== void 0 ? _g : "docs/";
        this.compileTask.exec("tsc --build");
        this.watchTask = this.addTask("watch", {
            description: "Watch & compile in the background",
            exec: "tsc --build -w",
        });
        this.testdir = (_h = options.testdir) !== null && _h !== void 0 ? _h : "test";
        this.gitignore.include(`/${this.testdir}/`);
        (_j = this.npmignore) === null || _j === void 0 ? void 0 : _j.exclude(`/${this.testdir}/`);
        // if the test directory is under `src/`, then we will run our tests against
        // the javascript files and not let jest compile it for us.
        const compiledTests = this.testdir.startsWith(this.srcdir + path.posix.sep);
        if (options.entrypointTypes || this.entrypoint !== "") {
            const entrypointTypes = (_k = options.entrypointTypes) !== null && _k !== void 0 ? _k : `${path
                .join(path.dirname(this.entrypoint), path.basename(this.entrypoint, ".js"))
                .replace(/\\/g, "/")}.d.ts`;
            this.package.addField("types", entrypointTypes);
        }
        const compilerOptionDefaults = {
            alwaysStrict: true,
            declaration: true,
            esModuleInterop: true,
            experimentalDecorators: true,
            inlineSourceMap: true,
            inlineSources: true,
            lib: ["es2019"],
            module: "CommonJS",
            noEmitOnError: false,
            noFallthroughCasesInSwitch: true,
            noImplicitAny: true,
            noImplicitReturns: true,
            noImplicitThis: true,
            noUnusedLocals: true,
            noUnusedParameters: true,
            resolveJsonModule: true,
            strict: true,
            strictNullChecks: true,
            strictPropertyInitialization: true,
            stripInternal: true,
            target: "ES2019",
        };
        if (!options.disableTsconfig) {
            this.tsconfig = new javascript_1.TypescriptConfig(this, mergeTsconfigOptions({
                include: [`${this.srcdir}/**/*.ts`],
                // exclude: ['node_modules'], // TODO: shouldn't we exclude node_modules?
                compilerOptions: {
                    rootDir: this.srcdir,
                    outDir: this.libdir,
                    ...compilerOptionDefaults,
                },
            }, options.tsconfig));
        }
        const tsconfigDevFile = (_l = options.tsconfigDevFile) !== null && _l !== void 0 ? _l : "tsconfig.dev.json";
        this.tsconfigDev = new javascript_1.TypescriptConfig(this, mergeTsconfigOptions({
            fileName: tsconfigDevFile,
            include: [
                common_1.PROJEN_RC,
                `${this.srcdir}/**/*.ts`,
                `${this.testdir}/**/*.ts`,
            ],
            exclude: ["node_modules"],
            compilerOptions: compilerOptionDefaults,
        }, options.tsconfig, options.tsconfigDev));
        this.gitignore.include(`/${this.srcdir}/`);
        (_m = this.npmignore) === null || _m === void 0 ? void 0 : _m.exclude(`/${this.srcdir}/`);
        if (this.srcdir !== this.libdir) {
            // separated, can ignore the entire libdir
            this.gitignore.exclude(`/${this.libdir}`);
        }
        else {
            // collocated, can only ignore the compiled output
            this.gitignore.exclude(`/${this.libdir}/**/*.js`);
            this.gitignore.exclude(`/${this.libdir}/**/*.d.ts`);
        }
        (_o = this.npmignore) === null || _o === void 0 ? void 0 : _o.include(`/${this.libdir}/`);
        (_p = this.npmignore) === null || _p === void 0 ? void 0 : _p.include(`/${this.libdir}/**/*.js`);
        (_q = this.npmignore) === null || _q === void 0 ? void 0 : _q.include(`/${this.libdir}/**/*.d.ts`);
        this.gitignore.exclude("/dist/");
        (_r = this.npmignore) === null || _r === void 0 ? void 0 : _r.exclude("dist"); // jsii-pacmak expects this to be "dist" and not "/dist". otherwise it will tamper with it
        (_s = this.npmignore) === null || _s === void 0 ? void 0 : _s.exclude("/tsconfig.json");
        (_t = this.npmignore) === null || _t === void 0 ? void 0 : _t.exclude("/.github/");
        (_u = this.npmignore) === null || _u === void 0 ? void 0 : _u.exclude("/.vscode/");
        (_v = this.npmignore) === null || _v === void 0 ? void 0 : _v.exclude("/.idea/");
        (_w = this.npmignore) === null || _w === void 0 ? void 0 : _w.exclude("/.projenrc.js");
        (_x = this.npmignore) === null || _x === void 0 ? void 0 : _x.exclude("tsconfig.tsbuildinfo");
        if (this.jest) {
            if (compiledTests) {
                this.addJestCompiled(this.jest);
            }
            else {
                this.addJestNoCompile(this.jest);
            }
        }
        if ((_y = options.eslint) !== null && _y !== void 0 ? _y : true) {
            this.eslint = new javascript_1.Eslint(this, {
                tsconfigPath: `./${this.tsconfigDev.fileName}`,
                dirs: [this.srcdir],
                devdirs: [this.testdir, "build-tools"],
                fileExtensions: [".ts", ".tsx"],
                ...options.eslintOptions,
            });
            this.tsconfigEslint = this.tsconfigDev;
        }
        const tsver = options.typescriptVersion
            ? `@${options.typescriptVersion}`
            : "";
        this.addDevDeps(`typescript${tsver}`, 
        // @types/node versions numbers match the node runtime versions' major.minor, however, new
        // releases are only created when API changes are included in a node release... We might for
        // example have dependencies that require `node >= 12.22`, but as 12.21 and 12.22 did not
        // include API changes, `@types/node@12.20.x` is the "correct" version to use. As it is not
        // possible to easily determine the correct version to use, we pick up the latest version.
        //
        // Additionally, we default to tracking the 12.x line, as the current earliest LTS release of
        // node is 12.x, so this is what corresponds to the broadest compatibility with supported node
        // runtimes.
        `@types/node@^${semver.major((_z = this.package.minNodeVersion) !== null && _z !== void 0 ? _z : "12.0.0")}`);
        // generate sample code in `src` and `lib` if these directories are empty or non-existent.
        if ((_0 = options.sampleCode) !== null && _0 !== void 0 ? _0 : true) {
            new SampleCode(this);
        }
        if (this.docgen) {
            new typescript_1.TypedocDocgen(this);
        }
        const projenrcTypeScript = (_1 = options.projenrcTs) !== null && _1 !== void 0 ? _1 : false;
        if (projenrcTypeScript) {
            new typescript_1.Projenrc(this, options.projenrcTsOptions);
        }
    }
    /**
     * Tests are compiled to `lib/TESTDIR`, so we don't need jest to compile them
     * for us. just run them directly from javascript.
     */
    addJestCompiled(jest) {
        var _d;
        this.addDevDeps("@types/jest");
        const testout = path.posix.relative(this.srcdir, this.testdir);
        const libtest = path.posix.join(this.libdir, testout);
        const srctest = this.testdir;
        (_d = this.npmignore) === null || _d === void 0 ? void 0 : _d.exclude(`/${libtest}/`);
        jest.addTestMatch(`**/${libtest}/**/?(*.)+(spec|test).js?(x)`);
        jest.addWatchIgnorePattern(`/${this.srcdir}/`);
        const resolveSnapshotPath = (test, ext) => {
            const fullpath = test.replace(libtest, srctest);
            return path.join(path.dirname(fullpath), "__snapshots__", path.basename(fullpath, ".js") + ".ts" + ext);
        };
        const resolveTestPath = (snap, ext) => {
            const filename = path.basename(snap, ".ts" + ext) + ".js";
            const dir = path.dirname(path.dirname(snap)).replace(srctest, libtest);
            return path.join(dir, filename);
        };
        const resolver = new textfile_1.TextFile(this, path.posix.join(common_1.PROJEN_DIR, "jest-snapshot-resolver.js"));
        if (!resolver.marker) {
            resolver.addLine(`// ${resolver.marker}`);
        }
        resolver.addLine('const path = require("path");');
        resolver.addLine(`const libtest = "${libtest}";`);
        resolver.addLine(`const srctest= "${srctest}";`);
        resolver.addLine("module.exports = {");
        resolver.addLine(`  resolveSnapshotPath: ${resolveSnapshotPath.toString()},`);
        resolver.addLine(`  resolveTestPath: ${resolveTestPath.toString()},`);
        resolver.addLine("  testPathForConsistencyCheck: path.join('some', '__tests__', 'example.test.js')");
        resolver.addLine("};");
        jest.addSnapshotResolver(`./${resolver.path}`);
    }
    addJestNoCompile(jest) {
        this.addDevDeps("@types/jest", "ts-jest");
        jest.addTestMatch(`<rootDir>/${this.srcdir}/**/__tests__/**/*.ts?(x)`);
        jest.addTestMatch(`<rootDir>/(${this.testdir}|${this.srcdir})/**/?(*.)+(spec|test).ts?(x)`);
        // add relevant deps
        jest.config.preset = "ts-jest";
        jest.config.globals = {
            "ts-jest": {
                tsconfig: this.tsconfigDev.fileName,
            },
        };
    }
}
exports.TypeScriptProject = TypeScriptProject;
_a = JSII_RTTI_SYMBOL_1;
TypeScriptProject[_a] = { fqn: "projen.typescript.TypeScriptProject", version: "0.52.53" };
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        const srcCode = [
            "export class Hello {",
            "  public sayHello() {",
            "    return 'hello, world!';",
            "  }",
            "}",
        ].join("\n");
        const testCode = [
            "import { Hello } from '../src';",
            "",
            "test('hello', () => {",
            "  expect(new Hello().sayHello()).toBe('hello, world!');",
            "});",
        ].join("\n");
        new sample_file_1.SampleDir(project, project.srcdir, {
            files: {
                "index.ts": srcCode,
            },
        });
        new sample_file_1.SampleDir(project, project.testdir, {
            files: {
                "hello.test.ts": testCode,
            },
        });
    }
}
/**
 * TypeScript app.
 *
 * @pjid typescript-app
 */
class TypeScriptAppProject extends TypeScriptProject {
    constructor(options) {
        super({
            allowLibraryDependencies: false,
            releaseWorkflow: false,
            entrypoint: "",
            package: false,
            ...options,
        });
    }
}
exports.TypeScriptAppProject = TypeScriptAppProject;
_b = JSII_RTTI_SYMBOL_1;
TypeScriptAppProject[_b] = { fqn: "projen.typescript.TypeScriptAppProject", version: "0.52.53" };
/**
 * @deprecated use `TypeScriptProject`
 */
class TypeScriptLibraryProject extends TypeScriptProject {
}
exports.TypeScriptLibraryProject = TypeScriptLibraryProject;
_c = JSII_RTTI_SYMBOL_1;
TypeScriptLibraryProject[_c] = { fqn: "projen.typescript.TypeScriptLibraryProject", version: "0.52.53" };
/**
 * @internal
 */
function mergeTsconfigOptions(...options) {
    const definedOptions = options.filter(Boolean);
    return definedOptions.reduce((previous, current) => {
        var _d, _e, _f, _g;
        return ({
            ...previous,
            ...current,
            include: [...((_d = previous.include) !== null && _d !== void 0 ? _d : []), ...((_e = current.include) !== null && _e !== void 0 ? _e : [])],
            exclude: [...((_f = previous.exclude) !== null && _f !== void 0 ? _f : []), ...((_g = current.exclude) !== null && _g !== void 0 ? _g : [])],
            compilerOptions: {
                ...previous.compilerOptions,
                ...current.compilerOptions,
            },
        });
    }, { compilerOptions: {} });
}
exports.mergeTsconfigOptions = mergeTsconfigOptions;
//# sourceMappingURL=data:application/json;base64,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