import { Component } from "./component";
import { Project } from "./project";
import { Task } from "./task";
/**
 * Options for `Version`.
 */
export interface VersionOptions {
    /**
     * A name of a .json file to set the `version` field in after a bump.
     *
     * @example "package.json"
     */
    readonly versionInputFile: string;
    /**
     * The name of the directory into which `changelog.md` and `version.txt` files
     * are emitted.
     */
    readonly artifactsDirectory: string;
    /**
     * Custom configuration for versionrc file used by standard-release
     */
    readonly versionrcOptions?: Record<string, any>;
}
export declare class Version extends Component {
    static readonly STANDARD_VERSION = "standard-version@^9";
    readonly bumpTask: Task;
    readonly unbumpTask: Task;
    /**
     * The name of the changelog file (under `artifactsDirectory`).
     */
    readonly changelogFileName: string;
    /**
     * The name of the file that contains the version (under `artifactsDirectory`).
     */
    readonly versionFileName: string;
    /**
     * The name of the file that contains the release tag (under `artifactsDirectory`).
     */
    readonly releaseTagFileName: string;
    constructor(project: Project, options: VersionOptions);
}
