"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Version = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("./component");
class Version extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.changelogFileName = "changelog.md";
        this.versionFileName = "version.txt";
        this.releaseTagFileName = "releasetag.txt";
        const versionInputFile = options.versionInputFile;
        // this command determines if there were any changes since the last release
        // (the top-most commit is not a bump). it is used as a condition for both
        // the `bump` and the `release` tasks.
        const changesSinceLastRelease = '! git log --oneline -1 | grep -q "chore(release):"';
        const changelogFile = path_1.posix.join(options.artifactsDirectory, this.changelogFileName);
        const bumpFile = path_1.posix.join(options.artifactsDirectory, this.versionFileName);
        const releaseTagFile = path_1.posix.join(options.artifactsDirectory, this.releaseTagFileName);
        const env = {
            OUTFILE: versionInputFile,
            CHANGELOG: changelogFile,
            BUMPFILE: bumpFile,
            RELEASETAG: releaseTagFile,
            // doesn't work if custom configuration is long
            VERSIONRCOPTIONS: JSON.stringify(options.versionrcOptions),
        };
        this.bumpTask = project.addTask("bump", {
            description: "Bumps version based on latest git tag and generates a changelog entry",
            condition: changesSinceLastRelease,
            env: env,
        });
        this.bumpTask.builtin("release/bump-version");
        this.unbumpTask = project.addTask("unbump", {
            description: "Restores version to 0.0.0",
            env: env,
        });
        this.unbumpTask.builtin("release/reset-version");
        project.addGitIgnore(`/${changelogFile}`);
        project.addGitIgnore(`/${bumpFile}`);
        project.addPackageIgnore(`/${changelogFile}`);
        project.addPackageIgnore(`/${bumpFile}`);
    }
}
exports.Version = Version;
_a = JSII_RTTI_SYMBOL_1;
Version[_a] = { fqn: "projen.Version", version: "0.52.53" };
Version.STANDARD_VERSION = "standard-version@^9";
//# sourceMappingURL=data:application/json;base64,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