"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevContainer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * Relative path of devcontainer file to generate
 */
const DEVCONTAINER_FILE = ".devcontainer.json";
/**
 * A development environment running VSCode in a container; used by GitHub
 * codespaces.
 */
class DevContainer extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this.postCreateTasks = new Array();
        this.ports = new Array();
        this.vscodeExtensions = new Array();
        this.dockerImage = options === null || options === void 0 ? void 0 : options.dockerImage;
        if (options === null || options === void 0 ? void 0 : options.tasks) {
            for (const task of options.tasks) {
                this.addTasks(task);
            }
        }
        if (options === null || options === void 0 ? void 0 : options.ports) {
            this.addPorts(...options.ports);
        }
        if (options === null || options === void 0 ? void 0 : options.vscodeExtensions) {
            this.addVscodeExtensions(...options.vscodeExtensions);
        }
        this.config = {
            image: () => { var _b; return (_b = this.dockerImage) === null || _b === void 0 ? void 0 : _b.image; },
            build: {
                dockerfile: () => { var _b; return (_b = this.dockerImage) === null || _b === void 0 ? void 0 : _b.dockerFile; },
            },
            postCreateCommand: () => this.renderTasks(),
            forwardPorts: this.ports,
            extensions: this.vscodeExtensions,
        };
        new json_1.JsonFile(this.project, DEVCONTAINER_FILE, {
            obj: this.config,
            omitEmpty: true,
        });
    }
    addDockerImage(image) {
        if (this.dockerImage) {
            throw new Error("dockerImage cannot be redefined.");
        }
        this.dockerImage = image;
    }
    /**
     * Adds tasks to run when the container starts. Tasks will be run in sequence.
     *
     * @param tasks The new tasks
     */
    addTasks(...tasks) {
        this.postCreateTasks.push(...tasks);
    }
    /**
     * Adds ports that should be exposed (forwarded) from the container.
     *
     * @param ports The new ports
     */
    addPorts(...ports) {
        this.ports.push(...ports);
    }
    /**
     * Adds a list of VSCode extensions that should be automatically installed
     * in the container.
     *
     * @param extensions The extension IDs
     */
    addVscodeExtensions(...extensions) {
        this.vscodeExtensions.push(...extensions);
    }
    renderTasks() {
        if (this.postCreateTasks.length !== 0) {
            return this.postCreateTasks
                .map((task) => `( npx projen ${task.name} )`)
                .join(" && ");
        }
        else {
            return undefined;
        }
    }
}
exports.DevContainer = DevContainer;
_a = JSII_RTTI_SYMBOL_1;
DevContainer[_a] = { fqn: "projen.vscode.DevContainer", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGV2Y29udGFpbmVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3ZzY29kZS9kZXZjb250YWluZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw0Q0FBeUM7QUFNekMsa0NBQW1DO0FBSW5DOztHQUVHO0FBQ0gsTUFBTSxpQkFBaUIsR0FBRyxvQkFBb0IsQ0FBQztBQVUvQzs7O0dBR0c7QUFDSCxNQUFhLFlBQWEsU0FBUSxxQkFBUztJQVd6QyxZQUFZLE9BQWdCLEVBQUUsVUFBK0IsRUFBRTtRQUM3RCxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFZixJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksS0FBSyxFQUFRLENBQUM7UUFDekMsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLEtBQUssRUFBVSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLEtBQUssRUFBVSxDQUFDO1FBRTVDLElBQUksQ0FBQyxXQUFXLEdBQUcsT0FBTyxhQUFQLE9BQU8sdUJBQVAsT0FBTyxDQUFFLFdBQVcsQ0FBQztRQUV4QyxJQUFJLE9BQU8sYUFBUCxPQUFPLHVCQUFQLE9BQU8sQ0FBRSxLQUFLLEVBQUU7WUFDbEIsS0FBSyxNQUFNLElBQUksSUFBSSxPQUFPLENBQUMsS0FBSyxFQUFFO2dCQUNoQyxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQ3JCO1NBQ0Y7UUFDRCxJQUFJLE9BQU8sYUFBUCxPQUFPLHVCQUFQLE9BQU8sQ0FBRSxLQUFLLEVBQUU7WUFDbEIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQztTQUNqQztRQUNELElBQUksT0FBTyxhQUFQLE9BQU8sdUJBQVAsT0FBTyxDQUFFLGdCQUFnQixFQUFFO1lBQzdCLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxHQUFHLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1NBQ3ZEO1FBRUQsSUFBSSxDQUFDLE1BQU0sR0FBRztZQUNaLEtBQUssRUFBRSxHQUFHLEVBQUUsd0JBQUMsSUFBSSxDQUFDLFdBQVcsMENBQUUsS0FBSyxHQUFBO1lBQ3BDLEtBQUssRUFBRTtnQkFDTCxVQUFVLEVBQUUsR0FBRyxFQUFFLHdCQUFDLElBQUksQ0FBQyxXQUFXLDBDQUFFLFVBQVUsR0FBQTthQUMvQztZQUNELGlCQUFpQixFQUFFLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUU7WUFDM0MsWUFBWSxFQUFFLElBQUksQ0FBQyxLQUFLO1lBQ3hCLFVBQVUsRUFBRSxJQUFJLENBQUMsZ0JBQWdCO1NBQ2xDLENBQUM7UUFFRixJQUFJLGVBQVEsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLGlCQUFpQixFQUFFO1lBQzVDLEdBQUcsRUFBRSxJQUFJLENBQUMsTUFBTTtZQUNoQixTQUFTLEVBQUUsSUFBSTtTQUNoQixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU0sY0FBYyxDQUFDLEtBQWdDO1FBQ3BELElBQUksSUFBSSxDQUFDLFdBQVcsRUFBRTtZQUNwQixNQUFNLElBQUksS0FBSyxDQUFDLGtDQUFrQyxDQUFDLENBQUM7U0FDckQ7UUFDRCxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBRUQ7Ozs7T0FJRztJQUNJLFFBQVEsQ0FBQyxHQUFHLEtBQWE7UUFDOUIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsR0FBRyxLQUFLLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRUQ7Ozs7T0FJRztJQUNJLFFBQVEsQ0FBQyxHQUFHLEtBQWU7UUFDaEMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsR0FBRyxLQUFLLENBQUMsQ0FBQztJQUM1QixDQUFDO0lBRUQ7Ozs7O09BS0c7SUFDSSxtQkFBbUIsQ0FBQyxHQUFHLFVBQW9CO1FBQ2hELElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsR0FBRyxVQUFVLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRU8sV0FBVztRQUNqQixJQUFJLElBQUksQ0FBQyxlQUFlLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtZQUNyQyxPQUFPLElBQUksQ0FBQyxlQUFlO2lCQUN4QixHQUFHLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLGdCQUFnQixJQUFJLENBQUMsSUFBSSxJQUFJLENBQUM7aUJBQzVDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztTQUNqQjthQUFNO1lBQ0wsT0FBTyxTQUFTLENBQUM7U0FDbEI7SUFDSCxDQUFDOztBQTNGSCxvQ0E0RkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQgfSBmcm9tIFwiLi4vY29tcG9uZW50XCI7XG5pbXBvcnQge1xuICBEZXZFbnZpcm9ubWVudERvY2tlckltYWdlLFxuICBEZXZFbnZpcm9ubWVudE9wdGlvbnMsXG4gIElEZXZFbnZpcm9ubWVudCxcbn0gZnJvbSBcIi4uL2Rldi1lbnZcIjtcbmltcG9ydCB7IEpzb25GaWxlIH0gZnJvbSBcIi4uL2pzb25cIjtcbmltcG9ydCB7IFByb2plY3QgfSBmcm9tIFwiLi4vcHJvamVjdFwiO1xuaW1wb3J0IHsgVGFzayB9IGZyb20gXCIuLi90YXNrXCI7XG5cbi8qKlxuICogUmVsYXRpdmUgcGF0aCBvZiBkZXZjb250YWluZXIgZmlsZSB0byBnZW5lcmF0ZVxuICovXG5jb25zdCBERVZDT05UQUlORVJfRklMRSA9IFwiLmRldmNvbnRhaW5lci5qc29uXCI7XG5cbi8qKlxuICogQ29uc3RydWN0b3Igb3B0aW9ucyBmb3IgdGhlIERldkNvbnRhaW5lciBjb21wb25lbnQuXG4gKlxuICogVGhlIGRlZmF1bHQgZG9ja2VyIGltYWdlIHVzZWQgZm9yIEdpdEh1YiBDb2Rlc3BhY2VzIGlzIGRlZmluZWQgaGVyZTpcbiAqIEBzZWUgaHR0cHM6Ly9naXRodWIuY29tL21pY3Jvc29mdC92c2NvZGUtZGV2LWNvbnRhaW5lcnMvdHJlZS9tYXN0ZXIvY29udGFpbmVycy9jb2Rlc3BhY2VzLWxpbnV4XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRGV2Q29udGFpbmVyT3B0aW9ucyBleHRlbmRzIERldkVudmlyb25tZW50T3B0aW9ucyB7fVxuXG4vKipcbiAqIEEgZGV2ZWxvcG1lbnQgZW52aXJvbm1lbnQgcnVubmluZyBWU0NvZGUgaW4gYSBjb250YWluZXI7IHVzZWQgYnkgR2l0SHViXG4gKiBjb2Rlc3BhY2VzLlxuICovXG5leHBvcnQgY2xhc3MgRGV2Q29udGFpbmVyIGV4dGVuZHMgQ29tcG9uZW50IGltcGxlbWVudHMgSURldkVudmlyb25tZW50IHtcbiAgcHJpdmF0ZSBkb2NrZXJJbWFnZTogRGV2RW52aXJvbm1lbnREb2NrZXJJbWFnZSB8IHVuZGVmaW5lZDtcbiAgcHJpdmF0ZSByZWFkb25seSBwb3N0Q3JlYXRlVGFza3M6IFRhc2tbXTtcbiAgcHJpdmF0ZSByZWFkb25seSBwb3J0czogc3RyaW5nW107XG4gIHByaXZhdGUgcmVhZG9ubHkgdnNjb2RlRXh0ZW5zaW9uczogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIERpcmVjdCBhY2Nlc3MgdG8gdGhlIGRldmNvbnRhaW5lciBjb25maWd1cmF0aW9uIChlc2NhcGUgaGF0Y2gpXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgY29uZmlnOiBhbnk7XG5cbiAgY29uc3RydWN0b3IocHJvamVjdDogUHJvamVjdCwgb3B0aW9uczogRGV2Q29udGFpbmVyT3B0aW9ucyA9IHt9KSB7XG4gICAgc3VwZXIocHJvamVjdCk7XG5cbiAgICB0aGlzLnBvc3RDcmVhdGVUYXNrcyA9IG5ldyBBcnJheTxUYXNrPigpO1xuICAgIHRoaXMucG9ydHMgPSBuZXcgQXJyYXk8c3RyaW5nPigpO1xuICAgIHRoaXMudnNjb2RlRXh0ZW5zaW9ucyA9IG5ldyBBcnJheTxzdHJpbmc+KCk7XG5cbiAgICB0aGlzLmRvY2tlckltYWdlID0gb3B0aW9ucz8uZG9ja2VySW1hZ2U7XG5cbiAgICBpZiAob3B0aW9ucz8udGFza3MpIHtcbiAgICAgIGZvciAoY29uc3QgdGFzayBvZiBvcHRpb25zLnRhc2tzKSB7XG4gICAgICAgIHRoaXMuYWRkVGFza3ModGFzayk7XG4gICAgICB9XG4gICAgfVxuICAgIGlmIChvcHRpb25zPy5wb3J0cykge1xuICAgICAgdGhpcy5hZGRQb3J0cyguLi5vcHRpb25zLnBvcnRzKTtcbiAgICB9XG4gICAgaWYgKG9wdGlvbnM/LnZzY29kZUV4dGVuc2lvbnMpIHtcbiAgICAgIHRoaXMuYWRkVnNjb2RlRXh0ZW5zaW9ucyguLi5vcHRpb25zLnZzY29kZUV4dGVuc2lvbnMpO1xuICAgIH1cblxuICAgIHRoaXMuY29uZmlnID0ge1xuICAgICAgaW1hZ2U6ICgpID0+IHRoaXMuZG9ja2VySW1hZ2U/LmltYWdlLFxuICAgICAgYnVpbGQ6IHtcbiAgICAgICAgZG9ja2VyZmlsZTogKCkgPT4gdGhpcy5kb2NrZXJJbWFnZT8uZG9ja2VyRmlsZSxcbiAgICAgIH0sXG4gICAgICBwb3N0Q3JlYXRlQ29tbWFuZDogKCkgPT4gdGhpcy5yZW5kZXJUYXNrcygpLFxuICAgICAgZm9yd2FyZFBvcnRzOiB0aGlzLnBvcnRzLFxuICAgICAgZXh0ZW5zaW9uczogdGhpcy52c2NvZGVFeHRlbnNpb25zLFxuICAgIH07XG5cbiAgICBuZXcgSnNvbkZpbGUodGhpcy5wcm9qZWN0LCBERVZDT05UQUlORVJfRklMRSwge1xuICAgICAgb2JqOiB0aGlzLmNvbmZpZyxcbiAgICAgIG9taXRFbXB0eTogdHJ1ZSxcbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBhZGREb2NrZXJJbWFnZShpbWFnZTogRGV2RW52aXJvbm1lbnREb2NrZXJJbWFnZSkge1xuICAgIGlmICh0aGlzLmRvY2tlckltYWdlKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXCJkb2NrZXJJbWFnZSBjYW5ub3QgYmUgcmVkZWZpbmVkLlwiKTtcbiAgICB9XG4gICAgdGhpcy5kb2NrZXJJbWFnZSA9IGltYWdlO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgdGFza3MgdG8gcnVuIHdoZW4gdGhlIGNvbnRhaW5lciBzdGFydHMuIFRhc2tzIHdpbGwgYmUgcnVuIGluIHNlcXVlbmNlLlxuICAgKlxuICAgKiBAcGFyYW0gdGFza3MgVGhlIG5ldyB0YXNrc1xuICAgKi9cbiAgcHVibGljIGFkZFRhc2tzKC4uLnRhc2tzOiBUYXNrW10pIHtcbiAgICB0aGlzLnBvc3RDcmVhdGVUYXNrcy5wdXNoKC4uLnRhc2tzKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIHBvcnRzIHRoYXQgc2hvdWxkIGJlIGV4cG9zZWQgKGZvcndhcmRlZCkgZnJvbSB0aGUgY29udGFpbmVyLlxuICAgKlxuICAgKiBAcGFyYW0gcG9ydHMgVGhlIG5ldyBwb3J0c1xuICAgKi9cbiAgcHVibGljIGFkZFBvcnRzKC4uLnBvcnRzOiBzdHJpbmdbXSkge1xuICAgIHRoaXMucG9ydHMucHVzaCguLi5wb3J0cyk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIGxpc3Qgb2YgVlNDb2RlIGV4dGVuc2lvbnMgdGhhdCBzaG91bGQgYmUgYXV0b21hdGljYWxseSBpbnN0YWxsZWRcbiAgICogaW4gdGhlIGNvbnRhaW5lci5cbiAgICpcbiAgICogQHBhcmFtIGV4dGVuc2lvbnMgVGhlIGV4dGVuc2lvbiBJRHNcbiAgICovXG4gIHB1YmxpYyBhZGRWc2NvZGVFeHRlbnNpb25zKC4uLmV4dGVuc2lvbnM6IHN0cmluZ1tdKSB7XG4gICAgdGhpcy52c2NvZGVFeHRlbnNpb25zLnB1c2goLi4uZXh0ZW5zaW9ucyk7XG4gIH1cblxuICBwcml2YXRlIHJlbmRlclRhc2tzKCkge1xuICAgIGlmICh0aGlzLnBvc3RDcmVhdGVUYXNrcy5sZW5ndGggIT09IDApIHtcbiAgICAgIHJldHVybiB0aGlzLnBvc3RDcmVhdGVUYXNrc1xuICAgICAgICAubWFwKCh0YXNrKSA9PiBgKCBucHggcHJvamVuICR7dGFzay5uYW1lfSApYClcbiAgICAgICAgLmpvaW4oXCIgJiYgXCIpO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgIH1cbiAgfVxufVxuIl19