"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeLaunchConfig = exports.InternalConsoleOptions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * Controls the visibility of the VSCode Debug Console panel during a debugging session
 * Source: https://code.visualstudio.com/docs/editor/debugging#_launchjson-attributes
 */
var InternalConsoleOptions;
(function (InternalConsoleOptions) {
    InternalConsoleOptions["NEVER_OPEN"] = "neverOpen";
    InternalConsoleOptions["OPEN_ON_FIRST_SESSION_START"] = "openOnFirstSessionStart";
    InternalConsoleOptions["OPEN_ON_SESSION_START"] = "openOnSessionStart";
})(InternalConsoleOptions = exports.InternalConsoleOptions || (exports.InternalConsoleOptions = {}));
/**
 * VSCode launch configuration file (launch.json), useful for enabling in-editor debugger
 */
class VsCodeLaunchConfig extends component_1.Component {
    constructor(vscode) {
        super(vscode.project);
        this.content = {
            version: "0.2.0",
            configurations: [],
        };
        new json_1.JsonFile(vscode.project, ".vscode/launch.json", {
            obj: this.content,
        });
    }
    /**
     * Adds a VsCodeLaunchConfigurationEntry (e.g. a node.js debugger) to `.vscode/launch.json.
     * Each configuration entry has following mandatory fields: type, request and name.
     * See https://code.visualstudio.com/docs/editor/debugging#_launchjson-attributes for details.
     * @param cfg VsCodeLaunchConfigurationEntry
     */
    addConfiguration(cfg) {
        this.content.configurations.push(cfg);
    }
}
exports.VsCodeLaunchConfig = VsCodeLaunchConfig;
_a = JSII_RTTI_SYMBOL_1;
VsCodeLaunchConfig[_a] = { fqn: "projen.vscode.VsCodeLaunchConfig", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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