"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NextComponent = exports.NextJsTypeScriptProject = exports.NextJsProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const javascript_1 = require("../javascript");
const sample_file_1 = require("../sample-file");
const typescript_1 = require("../typescript");
const util_1 = require("../util");
const postcss_1 = require("./postcss");
/**
 * Next.js project without TypeScript.
 *
 * @pjid nextjs
 */
class NextJsProject extends javascript_1.NodeProject {
    constructor(options) {
        var _d, _e, _f, _g;
        super({
            jest: false,
            minNodeVersion: "12.13.0",
            ...options,
        });
        this.srcdir = (_d = options.srcdir) !== null && _d !== void 0 ? _d : "pages";
        this.assetsdir = (_e = options.assetsdir) !== null && _e !== void 0 ? _e : "public";
        this.tailwind = (_f = options.tailwind) !== null && _f !== void 0 ? _f : true;
        new NextComponent(this, { typescript: false, tailwind: this.tailwind });
        // generate sample code in `pages` and `public` if these directories are empty or non-existent.
        if ((_g = options.sampleCode) !== null && _g !== void 0 ? _g : true) {
            new NextSampleCode(this, {
                fileExt: "js",
                srcdir: this.srcdir,
                assetsdir: this.assetsdir,
                tailwind: this.tailwind,
            });
        }
    }
}
exports.NextJsProject = NextJsProject;
_a = JSII_RTTI_SYMBOL_1;
NextJsProject[_a] = { fqn: "projen.web.NextJsProject", version: "0.52.53" };
/**
 * Next.js project with TypeScript.
 *
 * @pjid nextjs-ts
 */
class NextJsTypeScriptProject extends typescript_1.TypeScriptAppProject {
    constructor(options) {
        var _d, _e, _f, _g;
        const defaultOptions = {
            srcdir: "pages",
            eslint: false,
            minNodeVersion: "12.13.0",
            jest: false,
            tsconfig: {
                include: ["**/*.ts", "**/*.tsx"],
                compilerOptions: {
                    // required by Next.js
                    esModuleInterop: true,
                    module: "esnext",
                    moduleResolution: javascript_1.TypeScriptModuleResolution.NODE,
                    isolatedModules: true,
                    resolveJsonModule: true,
                    jsx: javascript_1.TypeScriptJsxMode.PRESERVE,
                    // recommended by Next.js
                    allowJs: true,
                    skipLibCheck: true,
                    forceConsistentCasingInFileNames: true,
                    noEmit: true,
                    lib: ["dom", "dom.iterable", "esnext"],
                    strict: false,
                    target: "es5",
                },
            },
        };
        // never generate default TypeScript sample code, since this class provides its own
        super(util_1.deepMerge([
            defaultOptions,
            options,
            { sampleCode: false },
        ]));
        this.srcdir = (_d = options.srcdir) !== null && _d !== void 0 ? _d : "pages";
        this.assetsdir = (_e = options.assetsdir) !== null && _e !== void 0 ? _e : "public";
        this.tailwind = (_f = options.tailwind) !== null && _f !== void 0 ? _f : true;
        new NextComponent(this, { typescript: true, tailwind: this.tailwind });
        // 'next build' command fails if tsconfig.json is immutable
        if (this.tsconfig) {
            this.tsconfig.file.readonly = false;
        }
        // generate sample code in `pages` and `public` if these directories are empty or non-existent.
        if ((_g = options.sampleCode) !== null && _g !== void 0 ? _g : true) {
            new NextSampleCode(this, {
                fileExt: "tsx",
                srcdir: this.srcdir,
                assetsdir: this.assetsdir,
                tailwind: this.tailwind,
            });
        }
    }
}
exports.NextJsTypeScriptProject = NextJsTypeScriptProject;
_b = JSII_RTTI_SYMBOL_1;
NextJsTypeScriptProject[_b] = { fqn: "projen.web.NextJsTypeScriptProject", version: "0.52.53" };
class NextComponent extends component_1.Component {
    constructor(project, options) {
        var _d, _e, _f;
        super(project);
        this.typescript = (_d = options.typescript) !== null && _d !== void 0 ? _d : false;
        this.tailwind = (_e = options.tailwind) !== null && _e !== void 0 ? _e : true;
        project.addDeps("next", "react", "react-dom");
        if (this.typescript) {
            project.addDevDeps("@types/react", "@types/react-dom");
        }
        if (this.tailwind) {
            new postcss_1.PostCss(project, { tailwind: true });
        }
        // NextJS CLI commands, see: https://nextjs.org/docs/api-reference/cli
        project.addTask("dev", {
            description: "Starts the Next.js application in development mode",
            exec: "next dev",
        });
        project.compileTask.exec("next build");
        project.addTask("export", {
            description: "Exports the application for production deployment",
            exec: "next export",
        });
        project.addTask("server", {
            description: "Starts the Next.js application in production mode",
            exec: "next start",
        });
        project.addTask("telemetry", {
            description: "Checks the status of Next.js telemetry collection",
            exec: "next telemetry",
        });
        (_f = project.npmignore) === null || _f === void 0 ? void 0 : _f.exclude("# Next.js", "/.next/");
        project.gitignore.exclude("# Next.js", "/.next/");
    }
}
exports.NextComponent = NextComponent;
_c = JSII_RTTI_SYMBOL_1;
NextComponent[_c] = { fqn: "projen.web.NextComponent", version: "0.52.53" };
class NextSampleCode extends component_1.Component {
    constructor(project, options) {
        var _d;
        super(project);
        this.fileExt = (_d = options.fileExt) !== null && _d !== void 0 ? _d : "js";
        this.srcdir = options.srcdir;
        this.assetsdir = options.assetsdir;
        this.tailwind = options.tailwind;
        const indexJs = [
            'import Head from "next/head"',
            "",
            "export default function Home() {",
            "  return (",
            '    <div className="container">',
            "      <Head>",
            "        <title>Create Next App</title>",
            "      </Head>",
            "",
            "      <main>",
            '        <h1 className="title">',
            '          Welcome to <a href="https://nextjs.org">Next.js!</a>',
            "        </h1>",
            "",
            '        <p className="description">',
            "          Get started by editing <code>pages/index.js</code>",
            "        </p>",
            "",
            '        <div className="grid">',
            '          <a href="https://nextjs.org/docs" className="card">',
            "            <h3>Documentation &rarr;</h3>",
            "            <p>Find in-depth information about Next.js features and API.</p>",
            "          </a>",
            "",
            '          <a href="https://nextjs.org/learn" className="card">',
            "            <h3>Learn &rarr;</h3>",
            "            <p>Learn about Next.js in an interactive course with quizzes!</p>",
            "          </a>",
            "",
            "          <a",
            '            href="https://github.com/vercel/next.js/tree/master/examples"',
            '            className="card"',
            "          >",
            "            <h3>Examples &rarr;</h3>",
            "            <p>Discover and deploy boilerplate example Next.js projects.</p>",
            "          </a>",
            "",
            "          <a",
            '            href="https://vercel.com/import?filter=next.js&utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"',
            '            className="card"',
            "          >",
            "            <h3>Deploy &rarr;</h3>",
            "            <p>",
            "              Instantly deploy your Next.js site to a public URL with Vercel.",
            "            </p>",
            "          </a>",
            "        </div>",
            "      </main>",
            "",
            "      <footer>",
            "        <a",
            '          href="https://vercel.com?utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"',
            '          target="_blank"',
            '          rel="noopener noreferrer"',
            "        >",
            "          Powered by Vercel",
            '          <img src="/vercel.svg" alt="Vercel Logo" className="logo" />',
            "        </a>",
            "      </footer>",
            "",
            "      <style jsx>{`",
            "        .container {",
            "          min-height: 100vh;",
            "          padding: 0 0.5rem;",
            "          display: flex;",
            "          flex-direction: column;",
            "          justify-content: center;",
            "          align-items: center;",
            "        }",
            "",
            "        main {",
            "          padding: 5rem 0;",
            "          flex: 1;",
            "          display: flex;",
            "          flex-direction: column;",
            "          justify-content: center;",
            "          align-items: center;",
            "        }",
            "",
            "        footer {",
            "          width: 100%;",
            "          height: 100px;",
            "          border-top: 1px solid #eaeaea;",
            "          display: flex;",
            "          justify-content: center;",
            "          align-items: center;",
            "        }",
            "",
            "        footer img {",
            "          margin-left: 0.5rem;",
            "        }",
            "",
            "        footer a {",
            "          display: flex;",
            "          justify-content: center;",
            "          align-items: center;",
            "        }",
            "",
            "        a {",
            "          color: inherit;",
            "          text-decoration: none;",
            "        }",
            "",
            "        .title a {",
            "          color: #0070f3;",
            "          text-decoration: none;",
            "        }",
            "",
            "        .title a:hover,",
            "        .title a:focus,",
            "        .title a:active {",
            "          text-decoration: underline;",
            "        }",
            "",
            "        .title {",
            "          margin: 0;",
            "          line-height: 1.15;",
            "          font-size: 4rem;",
            "        }",
            "",
            "        .title,",
            "        .description {",
            "          text-align: center;",
            "        }",
            "",
            "        .description {",
            "          line-height: 1.5;",
            "          font-size: 1.5rem;",
            "        }",
            "",
            "        code {",
            "          background: #fafafa;",
            "          border-radius: 5px;",
            "          padding: 0.75rem;",
            "          font-size: 1.1rem;",
            "          font-family: Menlo, Monaco, Lucida Console, Liberation Mono,",
            "            DejaVu Sans Mono, Bitstream Vera Sans Mono, Courier New, monospace;",
            "        }",
            "",
            "        .grid {",
            "          display: flex;",
            "          align-items: center;",
            "          justify-content: center;",
            "          flex-wrap: wrap;",
            "",
            "          max-width: 800px;",
            "          margin-top: 3rem;",
            "        }",
            "",
            "        .card {",
            "          margin: 1rem;",
            "          flex-basis: 45%;",
            "          padding: 1.5rem;",
            "          text-align: left;",
            "          color: inherit;",
            "          text-decoration: none;",
            "          border: 1px solid #eaeaea;",
            "          border-radius: 10px;",
            "          transition: color 0.15s ease, border-color 0.15s ease;",
            "        }",
            "",
            "        .card:hover,",
            "        .card:focus,",
            "        .card:active {",
            "          color: #0070f3;",
            "          border-color: #0070f3;",
            "        }",
            "",
            "        .card h3 {",
            "          margin: 0 0 1rem 0;",
            "          font-size: 1.5rem;",
            "        }",
            "",
            "        .card p {",
            "          margin: 0;",
            "          font-size: 1.25rem;",
            "          line-height: 1.5;",
            "        }",
            "",
            "        .logo {",
            "          height: 1em;",
            "        }",
            "",
            "        @media (max-width: 600px) {",
            "          .grid {",
            "            width: 100%;",
            "            flex-direction: column;",
            "          }",
            "        }",
            "      `}</style>",
            "",
            "      <style jsx global>{`",
            "        html,",
            "        body {",
            "          padding: 0;",
            "          margin: 0;",
            "          font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto,",
            "            Oxygen, Ubuntu, Cantarell, Fira Sans, Droid Sans, Helvetica Neue,",
            "            sans-serif;",
            "        }",
            "",
            "        * {",
            "          box-sizing: border-box;",
            "        }",
            "      `}</style>",
            "    </div>",
            "  )",
            "}",
            "",
        ];
        if (this.tailwind) {
            indexJs.unshift('import "tailwindcss/tailwind.css"');
        }
        const vercelSvg = [
            '<svg width="283" height="64" viewBox="0 0 283 64" fill="none" ',
            '    xmlns="http://www.w3.org/2000/svg">',
            '    <path d="M141.04 16c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.46 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zM248.72 16c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.45 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zM200.24 34c0 6 3.92 10 10 10 4.12 0 7.21-1.87 8.8-4.92l7.68 4.43c-3.18 5.3-9.14 8.49-16.48 8.49-11.05 0-19-7.2-19-18s7.96-18 19-18c7.34 0 13.29 3.19 16.48 8.49l-7.68 4.43c-1.59-3.05-4.68-4.92-8.8-4.92-6.07 0-10 4-10 10zm82.48-29v46h-9V5h9zM36.95 0L73.9 64H0L36.95 0zm92.38 5l-27.71 48L73.91 5H84.3l17.32 30 17.32-30h10.39zm58.91 12v9.69c-1-.29-2.06-.49-3.2-.49-5.81 0-10 4-10 10V51h-9V17h9v9.2c0-5.08 5.91-9.2 13.2-9.2z" fill="#000"/>',
            "</svg>",
        ];
        new sample_file_1.SampleDir(project, this.srcdir, {
            files: {
                ["index." + this.fileExt]: indexJs.join("\n"),
            },
        });
        new sample_file_1.SampleDir(project, this.assetsdir, {
            files: {
                "vercel.svg": vercelSvg.join("\n"),
            },
        });
        new sample_file_1.SampleFile(project, "next-env.d.ts", {
            contents: [
                '/// <reference types="next" />',
                '/// <reference types="next/types/global" />',
                '/// <reference types="next/image-types/global" />',
                "// NOTE: This file should not be edited",
                "// see https://nextjs.org/docs/basic-features/typescript for more information.",
                "",
            ].join("\n"),
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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