"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostCss = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const json_1 = require("../json");
const tailwind_1 = require("./tailwind");
/**
 * Declares a PostCSS dependency with a default config file.
 */
class PostCss {
    constructor(project, options) {
        var _b, _c, _d;
        this.fileName = (_b = options === null || options === void 0 ? void 0 : options.fileName) !== null && _b !== void 0 ? _b : "postcss.config.json";
        project.addDeps("postcss");
        const config = { plugins: {} };
        if ((_c = options === null || options === void 0 ? void 0 : options.tailwind) !== null && _c !== void 0 ? _c : true) {
            config.plugins.tailwindcss = {};
            config.plugins.autoprefixer = {};
            this.tailwind = new tailwind_1.TailwindConfig(project, options === null || options === void 0 ? void 0 : options.tailwindOptions);
            project.addDeps("tailwindcss", "autoprefixer");
        }
        this.file = new json_1.JsonFile(project, this.fileName, {
            obj: config,
            marker: false,
        });
        (_d = project.npmignore) === null || _d === void 0 ? void 0 : _d.exclude(`/${this.fileName}`);
    }
}
exports.PostCss = PostCss;
_a = JSII_RTTI_SYMBOL_1;
PostCss[_a] = { fqn: "projen.web.PostCss", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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