"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TailwindConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const json_1 = require("../json");
/**
 * Declares a Tailwind CSS configuration file.
 *
 * There are multiple ways to add Tailwind CSS in your node project - see:
 * https://tailwindcss.com/docs/installation
 *
 * @see PostCss
 */
class TailwindConfig {
    constructor(project, options) {
        var _b, _c;
        this.fileName = (_b = options === null || options === void 0 ? void 0 : options.fileName) !== null && _b !== void 0 ? _b : "tailwind.config.json";
        this.file = new json_1.JsonFile(project, this.fileName, {
            obj: {
                purge: [],
                darkMode: false,
                theme: {
                    extend: {},
                },
                variants: {
                    extend: {},
                },
                plugins: [],
            },
        });
        (_c = project.npmignore) === null || _c === void 0 ? void 0 : _c.exclude(`/${this.fileName}`);
    }
}
exports.TailwindConfig = TailwindConfig;
_a = JSII_RTTI_SYMBOL_1;
TailwindConfig[_a] = { fqn: "projen.web.TailwindConfig", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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