"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.YamlFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const YAML = require("yaml");
const object_file_1 = require("./object-file");
/**
 * Represents a YAML file.
 */
class YamlFile extends object_file_1.ObjectFile {
    constructor(project, filePath, options) {
        var _b;
        super(project, filePath, options);
        this.lineWidth = (_b = options.lineWidth) !== null && _b !== void 0 ? _b : 0;
    }
    synthesizeContent(resolver) {
        const json = super.synthesizeContent(resolver);
        if (!json) {
            return undefined;
        }
        return [
            ...(this.marker ? [`# ${this.marker}`] : []),
            "",
            YAML.stringify(JSON.parse(json), {
                indent: 2,
                lineWidth: this.lineWidth,
            }),
        ].join("\n");
    }
}
exports.YamlFile = YamlFile;
_a = JSII_RTTI_SYMBOL_1;
YamlFile[_a] = { fqn: "projen.YamlFile", version: "0.52.53" };
//# sourceMappingURL=data:application/json;base64,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