from collections.abc import Callable
from enum import Enum
from typing import List, Optional, Union

from glide_shared.constants import TResult

DEFAULT_TIMEOUT_IN_MILLISECONDS: int = ...
MAX_REQUEST_ARGS_LEN: int = ...

class Level(Enum):
    Error = 0
    Warn = 1
    Info = 2
    Debug = 3
    Trace = 4
    Off = 5

    def is_lower(self, level: Level) -> bool: ...

class Script:
    def __init__(self, code: Union[str, bytes]) -> None: ...
    def get_hash(self) -> str: ...
    def __del__(self) -> None: ...

class ClusterScanCursor:
    def __init__(self, cursor: Optional[str] = None) -> None: ...
    def get_cursor(self) -> str: ...
    def is_finished(self) -> bool: ...

class OpenTelemetryConfig:
    def __init__(
        self,
        traces: Optional[OpenTelemetryTracesConfig] = None,
        metrics: Optional[OpenTelemetryMetricsConfig] = None,
        flush_interval_ms: Optional[int] = None,
    ) -> None: ...
    def get_traces(self) -> Optional[OpenTelemetryTracesConfig]: ...
    def set_traces(self, traces: OpenTelemetryTracesConfig) -> None: ...
    def get_metrics(self) -> Optional[OpenTelemetryMetricsConfig]: ...

class OpenTelemetryTracesConfig:
    def __init__(
        self, endpoint: str, sample_percentage: Optional[int] = None
    ) -> None: ...
    def get_endpoint(self) -> str: ...
    def get_sample_percentage(self) -> Optional[int]: ...

class OpenTelemetryMetricsConfig:
    def __init__(self, endpoint: str) -> None: ...
    def get_endpoint(self) -> str: ...

def start_socket_listener_external(init_callback: Callable) -> None: ...
def value_from_pointer(pointer: int) -> TResult: ...
def create_leaked_value(message: str) -> int: ...
def create_leaked_bytes_vec(args_vec: List[bytes]) -> int: ...
def get_statistics() -> dict: ...
def py_init(level: Optional[Level], file_name: Optional[str]) -> Level: ...
def py_log(log_level: Level, log_identifier: str, message: str) -> None: ...
def create_otel_span(name: str) -> int: ...
def drop_otel_span(span_ptr: int) -> None: ...
def init_opentelemetry(config: OpenTelemetryConfig) -> None: ...
