# -*- coding: utf-8 -*-
# Generated by Django 1.10.5 on 2017-03-22 16:31
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


def migrate_linked_scheduled_status(apps, schema_editor):
    ClientScheduledStatus = apps.get_model('member', 'ClientScheduledStatus')

    for css in ClientScheduledStatus.objects.filter(linked_scheduled_status__isnull=False):
        css.pair = css.linked_scheduled_status
        # remove linked_scheduled_status relationship
        css.linked_scheduled_status = None
        css.save()


def reverse_linked_scheduled_status(apps, schema_editor):
    ClientScheduledStatus = apps.get_model('member', 'ClientScheduledStatus')

    for css in ClientScheduledStatus.objects.filter(pair__isnull=False):
        # make exactly the opposite of 'migrate_linked_scheduled_status'
        css.linked_scheduled_status = css.pair
        # remove pair relationship
        css.pair = None
        css.save()


class Migration(migrations.Migration):
    """
    Change linked_scheduled_status relationship to OneToOneField, because
    the relationship exactly as a 'pair'
    """

    dependencies = [
        ('member', '0027_auto_20170313_1442'),
    ]

    operations = [
        migrations.AddField(
            model_name='clientscheduledstatus',
            name='pair',
            field=models.OneToOneField(
                blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                related_name='my_pair', to='member.ClientScheduledStatus',
                verbose_name='Client Scheduled Status Pair'
            ),
        ),
        migrations.RunPython(migrate_linked_scheduled_status, reverse_linked_scheduled_status),
        migrations.RemoveField(
            model_name='clientscheduledstatus',
            name='linked_scheduled_status',
        ),
    ]
