# Changelog

All notable changes to the predictiondata package will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.1.0] - 2025-11-17

### Added
- Initial release of predictiondata Python client
- `PredictionDataClient` class for accessing the API
- `Channel` class for filtering data streams
- `DataType` enum for type-safe data type selection
- Support for three data types:
  - Order books (incremental snapshots)
  - Trades (executed trades)
  - On-chain fills (blockchain settlement data)
- Async streaming via `replay()` method
- Single-day fetch via `fetch_day()` method
- Support for market slug-based and token ID-based queries
- Async context manager support for automatic cleanup
- Comprehensive test suite with pytest
- Multiple usage examples:
  - Basic usage
  - Multiple markets
  - Order book visualization
  - On-chain fills analysis
  - Single day fetch
  - Complete examples
- Full documentation:
  - README with API reference
  - QUICKSTART guide
  - HOW_TO_PUBLISH guide
  - BUILD_AND_INSTALL guide
  - CONTRIBUTING guide
- Type hints throughout the codebase
- Support for Python 3.8+

### Dependencies
- aiohttp >= 3.8.0 (for async HTTP)
- pandas >= 1.3.0 (for data manipulation)

### Known Limitations
- Currently only supports Polymarket exchange
- Requires Python 3.8 or higher
- Network access required for API calls

## [Unreleased]

### Planned Features
- Support for additional exchanges
- Offline data caching
- Real-time WebSocket streaming
- Data export to various formats (Parquet, CSV, etc.)
- Advanced filtering options
- Rate limiting and retry logic
- Progress bars for large date ranges
- Data validation and schema checking

---

## Version History

- **0.1.0** (2025-11-17) - Initial release

---

## Migration Guide

### For New Users

This is the initial release. See QUICKSTART.md to get started.

### For Future Versions

Migration guides will be added here as new versions are released with breaking changes.

---

## Support

For questions, issues, or feature requests:
- GitHub Issues: https://github.com/predictiondata/predictiondata_client/issues
- Email: support@predictiondata.dev
- Documentation: https://predictiondata.dev/docs

