# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.custom_fields import CustomFields  # noqa: F401,E501
from demisto_client.demisto_api.models.incident_status import IncidentStatus  # noqa: F401,E501
from demisto_client.demisto_api.models.label import Label  # noqa: F401,E501
from demisto_client.demisto_api.models.run_status import RunStatus  # noqa: F401,E501
from demisto_client.demisto_api.models.severity import Severity  # noqa: F401,E501
from demisto_client.demisto_api.models.sla_state import SLAState  # noqa: F401,E501


class CreateIncidentRequest(dict):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'shard_id': 'int',
        'account': 'str',
        'activated': 'datetime',
        'activatinging_user_id': 'str',
        'autime': 'int',
        'canvases': 'list[str]',
        'category': 'str',
        'close_notes': 'str',
        'close_reason': 'str',
        'closed': 'datetime',
        'closing_user_id': 'str',
        'create_investigation': 'bool',
        'created': 'datetime',
        'details': 'str',
        'dropped_count': 'int',
        'due_date': 'datetime',
        'has_role': 'bool',
        'id': 'str',
        'investigation_id': 'str',
        'is_playground': 'bool',
        'labels': 'list[Label]',
        'last_open': 'datetime',
        'linked_count': 'int',
        'linked_incidents': 'list[str]',
        'modified': 'datetime',
        'name': 'str',
        'notify_time': 'datetime',
        'occurred': 'datetime',
        'open_duration': 'int',
        'owner': 'str',
        'parent': 'str',
        'phase': 'str',
        'playbook_id': 'str',
        'previous_roles': 'list[str]',
        'raw_category': 'str',
        'raw_close_reason': 'str',
        'raw_json': 'str',
        'raw_name': 'str',
        'raw_phase': 'str',
        'raw_type': 'str',
        'reason': 'str',
        'reminder': 'datetime',
        'roles': 'list[str]',
        'run_status': 'RunStatus',
        'severity': 'Severity',
        'sla': 'SLAState',
        'sort_values': 'list[str]',
        'source_brand': 'str',
        'source_instance': 'str',
        'status': 'IncidentStatus',
        'type': 'str',
        'version': 'int',
        'custom_fields': 'CustomFields'
    }

    attribute_map = {
        'shard_id': 'ShardID',
        'account': 'account',
        'activated': 'activated',
        'activatinging_user_id': 'activatingingUserId',
        'autime': 'autime',
        'canvases': 'canvases',
        'category': 'category',
        'close_notes': 'closeNotes',
        'close_reason': 'closeReason',
        'closed': 'closed',
        'closing_user_id': 'closingUserId',
        'create_investigation': 'createInvestigation',
        'created': 'created',
        'details': 'details',
        'dropped_count': 'droppedCount',
        'due_date': 'dueDate',
        'has_role': 'hasRole',
        'id': 'id',
        'investigation_id': 'investigationId',
        'is_playground': 'isPlayground',
        'labels': 'labels',
        'last_open': 'lastOpen',
        'linked_count': 'linkedCount',
        'linked_incidents': 'linkedIncidents',
        'modified': 'modified',
        'name': 'name',
        'notify_time': 'notifyTime',
        'occurred': 'occurred',
        'open_duration': 'openDuration',
        'owner': 'owner',
        'parent': 'parent',
        'phase': 'phase',
        'playbook_id': 'playbookId',
        'previous_roles': 'previousRoles',
        'raw_category': 'rawCategory',
        'raw_close_reason': 'rawCloseReason',
        'raw_json': 'rawJSON',
        'raw_name': 'rawName',
        'raw_phase': 'rawPhase',
        'raw_type': 'rawType',
        'reason': 'reason',
        'reminder': 'reminder',
        'roles': 'roles',
        'run_status': 'runStatus',
        'severity': 'severity',
        'sla': 'sla',
        'sort_values': 'sortValues',
        'source_brand': 'sourceBrand',
        'source_instance': 'sourceInstance',
        'status': 'status',
        'type': 'type',
        'version': 'version',
        'custom_fields': 'CustomFields'
    }

    def __init__(self, shard_id=None, account=None, activated=None, activatinging_user_id=None, autime=None, canvases=None, category=None, close_notes=None, close_reason=None, closed=None, closing_user_id=None, create_investigation=None, created=None, details=None, dropped_count=None, due_date=None, has_role=None, id=None, investigation_id=None, is_playground=None, labels=None, last_open=None, linked_count=None, linked_incidents=None, modified=None, name=None, notify_time=None, occurred=None, open_duration=None, owner=None, parent=None, phase=None, playbook_id=None, previous_roles=None, raw_category=None, raw_close_reason=None, raw_json=None, raw_name=None, raw_phase=None, raw_type=None, reason=None, reminder=None, roles=None, run_status=None, severity=None, sla=None, sort_values=None, source_brand=None, source_instance=None, status=None, type=None, version=None, custom_fields=None):  # noqa: E501
        """CreateIncidentRequest - a model defined in Swagger"""  # noqa: E501

        self._shard_id = None
        self._account = None
        self._activated = None
        self._activatinging_user_id = None
        self._autime = None
        self._canvases = None
        self._category = None
        self._close_notes = None
        self._close_reason = None
        self._closed = None
        self._closing_user_id = None
        self._create_investigation = None
        self._created = None
        self._details = None
        self._dropped_count = None
        self._due_date = None
        self._has_role = None
        self._id = None
        self._investigation_id = None
        self._is_playground = None
        self._labels = None
        self._last_open = None
        self._linked_count = None
        self._linked_incidents = None
        self._modified = None
        self._name = None
        self._notify_time = None
        self._occurred = None
        self._open_duration = None
        self._owner = None
        self._parent = None
        self._phase = None
        self._playbook_id = None
        self._previous_roles = None
        self._raw_category = None
        self._raw_close_reason = None
        self._raw_json = None
        self._raw_name = None
        self._raw_phase = None
        self._raw_type = None
        self._reason = None
        self._reminder = None
        self._roles = None
        self._run_status = None
        self._severity = None
        self._sla = None
        self._sort_values = None
        self._source_brand = None
        self._source_instance = None
        self._status = None
        self._type = None
        self._version = None
        self._custom_fields = None
        self.discriminator = None

        if shard_id is not None:
            self.shard_id = shard_id
        if account is not None:
            self.account = account
        if activated is not None:
            self.activated = activated
        if activatinging_user_id is not None:
            self.activatinging_user_id = activatinging_user_id
        if autime is not None:
            self.autime = autime
        if canvases is not None:
            self.canvases = canvases
        if category is not None:
            self.category = category
        if close_notes is not None:
            self.close_notes = close_notes
        if close_reason is not None:
            self.close_reason = close_reason
        if closed is not None:
            self.closed = closed
        if closing_user_id is not None:
            self.closing_user_id = closing_user_id
        if create_investigation is not None:
            self.create_investigation = create_investigation
        if created is not None:
            self.created = created
        if details is not None:
            self.details = details
        if dropped_count is not None:
            self.dropped_count = dropped_count
        if due_date is not None:
            self.due_date = due_date
        if has_role is not None:
            self.has_role = has_role
        if id is not None:
            self.id = id
        if investigation_id is not None:
            self.investigation_id = investigation_id
        if is_playground is not None:
            self.is_playground = is_playground
        if labels is not None:
            self.labels = labels
        if last_open is not None:
            self.last_open = last_open
        if linked_count is not None:
            self.linked_count = linked_count
        if linked_incidents is not None:
            self.linked_incidents = linked_incidents
        if modified is not None:
            self.modified = modified
        if name is not None:
            self.name = name
        if notify_time is not None:
            self.notify_time = notify_time
        if occurred is not None:
            self.occurred = occurred
        if open_duration is not None:
            self.open_duration = open_duration
        if owner is not None:
            self.owner = owner
        if parent is not None:
            self.parent = parent
        if phase is not None:
            self.phase = phase
        if playbook_id is not None:
            self.playbook_id = playbook_id
        if previous_roles is not None:
            self.previous_roles = previous_roles
        if raw_category is not None:
            self.raw_category = raw_category
        if raw_close_reason is not None:
            self.raw_close_reason = raw_close_reason
        if raw_json is not None:
            self.raw_json = raw_json
        if raw_name is not None:
            self.raw_name = raw_name
        if raw_phase is not None:
            self.raw_phase = raw_phase
        if raw_type is not None:
            self.raw_type = raw_type
        if reason is not None:
            self.reason = reason
        if reminder is not None:
            self.reminder = reminder
        if roles is not None:
            self.roles = roles
        if run_status is not None:
            self.run_status = run_status
        if severity is not None:
            self.severity = severity
        if sla is not None:
            self.sla = sla
        if sort_values is not None:
            self.sort_values = sort_values
        if source_brand is not None:
            self.source_brand = source_brand
        if source_instance is not None:
            self.source_instance = source_instance
        if status is not None:
            self.status = status
        if type is not None:
            self.type = type
        if version is not None:
            self.version = version
        if custom_fields is not None:
            self.custom_fields = custom_fields

    @property
    def shard_id(self):
        """Gets the shard_id of this CreateIncidentRequest.  # noqa: E501


        :return: The shard_id of this CreateIncidentRequest.  # noqa: E501
        :rtype: int
        """
        return self._shard_id

    @shard_id.setter
    def shard_id(self, shard_id):
        """Sets the shard_id of this CreateIncidentRequest.


        :param shard_id: The shard_id of this CreateIncidentRequest.  # noqa: E501
        :type: int
        """

        self._shard_id = shard_id

    @property
    def account(self):
        """Gets the account of this CreateIncidentRequest.  # noqa: E501

        Account holds the tenant name so that slicing and dicing on the master can leverage bleve  # noqa: E501

        :return: The account of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this CreateIncidentRequest.

        Account holds the tenant name so that slicing and dicing on the master can leverage bleve  # noqa: E501

        :param account: The account of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._account = account

    @property
    def activated(self):
        """Gets the activated of this CreateIncidentRequest.  # noqa: E501

        When was this activated  # noqa: E501

        :return: The activated of this CreateIncidentRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._activated

    @activated.setter
    def activated(self, activated):
        """Sets the activated of this CreateIncidentRequest.

        When was this activated  # noqa: E501

        :param activated: The activated of this CreateIncidentRequest.  # noqa: E501
        :type: datetime
        """

        self._activated = activated

    @property
    def activatinging_user_id(self):
        """Gets the activatinging_user_id of this CreateIncidentRequest.  # noqa: E501

        The user that activated this investigation  # noqa: E501

        :return: The activatinging_user_id of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._activatinging_user_id

    @activatinging_user_id.setter
    def activatinging_user_id(self, activatinging_user_id):
        """Sets the activatinging_user_id of this CreateIncidentRequest.

        The user that activated this investigation  # noqa: E501

        :param activatinging_user_id: The activatinging_user_id of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._activatinging_user_id = activatinging_user_id

    @property
    def autime(self):
        """Gets the autime of this CreateIncidentRequest.  # noqa: E501

        AlmostUniqueTime is an attempt to have a unique sortable ID for an incident  # noqa: E501

        :return: The autime of this CreateIncidentRequest.  # noqa: E501
        :rtype: int
        """
        return self._autime

    @autime.setter
    def autime(self, autime):
        """Sets the autime of this CreateIncidentRequest.

        AlmostUniqueTime is an attempt to have a unique sortable ID for an incident  # noqa: E501

        :param autime: The autime of this CreateIncidentRequest.  # noqa: E501
        :type: int
        """

        self._autime = autime

    @property
    def canvases(self):
        """Gets the canvases of this CreateIncidentRequest.  # noqa: E501

        Canvases of the incident  # noqa: E501

        :return: The canvases of this CreateIncidentRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._canvases

    @canvases.setter
    def canvases(self, canvases):
        """Sets the canvases of this CreateIncidentRequest.

        Canvases of the incident  # noqa: E501

        :param canvases: The canvases of this CreateIncidentRequest.  # noqa: E501
        :type: list[str]
        """

        self._canvases = canvases

    @property
    def category(self):
        """Gets the category of this CreateIncidentRequest.  # noqa: E501

        Category  # noqa: E501

        :return: The category of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this CreateIncidentRequest.

        Category  # noqa: E501

        :param category: The category of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._category = category

    @property
    def close_notes(self):
        """Gets the close_notes of this CreateIncidentRequest.  # noqa: E501

        Notes for closing the incident  # noqa: E501

        :return: The close_notes of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._close_notes

    @close_notes.setter
    def close_notes(self, close_notes):
        """Sets the close_notes of this CreateIncidentRequest.

        Notes for closing the incident  # noqa: E501

        :param close_notes: The close_notes of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._close_notes = close_notes

    @property
    def close_reason(self):
        """Gets the close_reason of this CreateIncidentRequest.  # noqa: E501

        The reason for closing the incident (select from existing predefined values)  # noqa: E501

        :return: The close_reason of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._close_reason

    @close_reason.setter
    def close_reason(self, close_reason):
        """Sets the close_reason of this CreateIncidentRequest.

        The reason for closing the incident (select from existing predefined values)  # noqa: E501

        :param close_reason: The close_reason of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._close_reason = close_reason

    @property
    def closed(self):
        """Gets the closed of this CreateIncidentRequest.  # noqa: E501

        When was this closed  # noqa: E501

        :return: The closed of this CreateIncidentRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._closed

    @closed.setter
    def closed(self, closed):
        """Sets the closed of this CreateIncidentRequest.

        When was this closed  # noqa: E501

        :param closed: The closed of this CreateIncidentRequest.  # noqa: E501
        :type: datetime
        """

        self._closed = closed

    @property
    def closing_user_id(self):
        """Gets the closing_user_id of this CreateIncidentRequest.  # noqa: E501

        The user ID that closed this investigation  # noqa: E501

        :return: The closing_user_id of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._closing_user_id

    @closing_user_id.setter
    def closing_user_id(self, closing_user_id):
        """Sets the closing_user_id of this CreateIncidentRequest.

        The user ID that closed this investigation  # noqa: E501

        :param closing_user_id: The closing_user_id of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._closing_user_id = closing_user_id

    @property
    def create_investigation(self):
        """Gets the create_investigation of this CreateIncidentRequest.  # noqa: E501


        :return: The create_investigation of this CreateIncidentRequest.  # noqa: E501
        :rtype: bool
        """
        return self._create_investigation

    @create_investigation.setter
    def create_investigation(self, create_investigation):
        """Sets the create_investigation of this CreateIncidentRequest.


        :param create_investigation: The create_investigation of this CreateIncidentRequest.  # noqa: E501
        :type: bool
        """

        self._create_investigation = create_investigation

    @property
    def created(self):
        """Gets the created of this CreateIncidentRequest.  # noqa: E501

        When was this created  # noqa: E501

        :return: The created of this CreateIncidentRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this CreateIncidentRequest.

        When was this created  # noqa: E501

        :param created: The created of this CreateIncidentRequest.  # noqa: E501
        :type: datetime
        """

        self._created = created

    @property
    def details(self):
        """Gets the details of this CreateIncidentRequest.  # noqa: E501

        The details of the incident - reason, etc.  # noqa: E501

        :return: The details of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._details

    @details.setter
    def details(self, details):
        """Sets the details of this CreateIncidentRequest.

        The details of the incident - reason, etc.  # noqa: E501

        :param details: The details of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._details = details

    @property
    def dropped_count(self):
        """Gets the dropped_count of this CreateIncidentRequest.  # noqa: E501

        DroppedCount ...  # noqa: E501

        :return: The dropped_count of this CreateIncidentRequest.  # noqa: E501
        :rtype: int
        """
        return self._dropped_count

    @dropped_count.setter
    def dropped_count(self, dropped_count):
        """Sets the dropped_count of this CreateIncidentRequest.

        DroppedCount ...  # noqa: E501

        :param dropped_count: The dropped_count of this CreateIncidentRequest.  # noqa: E501
        :type: int
        """

        self._dropped_count = dropped_count

    @property
    def due_date(self):
        """Gets the due_date of this CreateIncidentRequest.  # noqa: E501

        SLA  # noqa: E501

        :return: The due_date of this CreateIncidentRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """Sets the due_date of this CreateIncidentRequest.

        SLA  # noqa: E501

        :param due_date: The due_date of this CreateIncidentRequest.  # noqa: E501
        :type: datetime
        """

        self._due_date = due_date

    @property
    def has_role(self):
        """Gets the has_role of this CreateIncidentRequest.  # noqa: E501

        Internal field to make queries on role faster  # noqa: E501

        :return: The has_role of this CreateIncidentRequest.  # noqa: E501
        :rtype: bool
        """
        return self._has_role

    @has_role.setter
    def has_role(self, has_role):
        """Sets the has_role of this CreateIncidentRequest.

        Internal field to make queries on role faster  # noqa: E501

        :param has_role: The has_role of this CreateIncidentRequest.  # noqa: E501
        :type: bool
        """

        self._has_role = has_role

    @property
    def id(self):
        """Gets the id of this CreateIncidentRequest.  # noqa: E501


        :return: The id of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CreateIncidentRequest.


        :param id: The id of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def investigation_id(self):
        """Gets the investigation_id of this CreateIncidentRequest.  # noqa: E501

        Investigation that was opened as a result of the incoming event  # noqa: E501

        :return: The investigation_id of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._investigation_id

    @investigation_id.setter
    def investigation_id(self, investigation_id):
        """Sets the investigation_id of this CreateIncidentRequest.

        Investigation that was opened as a result of the incoming event  # noqa: E501

        :param investigation_id: The investigation_id of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._investigation_id = investigation_id

    @property
    def is_playground(self):
        """Gets the is_playground of this CreateIncidentRequest.  # noqa: E501

        IsPlayGround  # noqa: E501

        :return: The is_playground of this CreateIncidentRequest.  # noqa: E501
        :rtype: bool
        """
        return self._is_playground

    @is_playground.setter
    def is_playground(self, is_playground):
        """Sets the is_playground of this CreateIncidentRequest.

        IsPlayGround  # noqa: E501

        :param is_playground: The is_playground of this CreateIncidentRequest.  # noqa: E501
        :type: bool
        """

        self._is_playground = is_playground

    @property
    def labels(self):
        """Gets the labels of this CreateIncidentRequest.  # noqa: E501

        Labels related to incident - each label is composed of a type and value  # noqa: E501

        :return: The labels of this CreateIncidentRequest.  # noqa: E501
        :rtype: list[Label]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this CreateIncidentRequest.

        Labels related to incident - each label is composed of a type and value  # noqa: E501

        :param labels: The labels of this CreateIncidentRequest.  # noqa: E501
        :type: list[Label]
        """

        self._labels = labels

    @property
    def last_open(self):
        """Gets the last_open of this CreateIncidentRequest.  # noqa: E501


        :return: The last_open of this CreateIncidentRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._last_open

    @last_open.setter
    def last_open(self, last_open):
        """Sets the last_open of this CreateIncidentRequest.


        :param last_open: The last_open of this CreateIncidentRequest.  # noqa: E501
        :type: datetime
        """

        self._last_open = last_open

    @property
    def linked_count(self):
        """Gets the linked_count of this CreateIncidentRequest.  # noqa: E501

        LinkedCount ...  # noqa: E501

        :return: The linked_count of this CreateIncidentRequest.  # noqa: E501
        :rtype: int
        """
        return self._linked_count

    @linked_count.setter
    def linked_count(self, linked_count):
        """Sets the linked_count of this CreateIncidentRequest.

        LinkedCount ...  # noqa: E501

        :param linked_count: The linked_count of this CreateIncidentRequest.  # noqa: E501
        :type: int
        """

        self._linked_count = linked_count

    @property
    def linked_incidents(self):
        """Gets the linked_incidents of this CreateIncidentRequest.  # noqa: E501

        LinkedIncidents incidents that were marked as linked by user  # noqa: E501

        :return: The linked_incidents of this CreateIncidentRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._linked_incidents

    @linked_incidents.setter
    def linked_incidents(self, linked_incidents):
        """Sets the linked_incidents of this CreateIncidentRequest.

        LinkedIncidents incidents that were marked as linked by user  # noqa: E501

        :param linked_incidents: The linked_incidents of this CreateIncidentRequest.  # noqa: E501
        :type: list[str]
        """

        self._linked_incidents = linked_incidents

    @property
    def modified(self):
        """Gets the modified of this CreateIncidentRequest.  # noqa: E501


        :return: The modified of this CreateIncidentRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """Sets the modified of this CreateIncidentRequest.


        :param modified: The modified of this CreateIncidentRequest.  # noqa: E501
        :type: datetime
        """

        self._modified = modified

    @property
    def name(self):
        """Gets the name of this CreateIncidentRequest.  # noqa: E501

        Incident Name - given by user  # noqa: E501

        :return: The name of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateIncidentRequest.

        Incident Name - given by user  # noqa: E501

        :param name: The name of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def notify_time(self):
        """Gets the notify_time of this CreateIncidentRequest.  # noqa: E501

        Incdicates when last this field was changed with a value that supposed to send a notification  # noqa: E501

        :return: The notify_time of this CreateIncidentRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._notify_time

    @notify_time.setter
    def notify_time(self, notify_time):
        """Sets the notify_time of this CreateIncidentRequest.

        Incdicates when last this field was changed with a value that supposed to send a notification  # noqa: E501

        :param notify_time: The notify_time of this CreateIncidentRequest.  # noqa: E501
        :type: datetime
        """

        self._notify_time = notify_time

    @property
    def occurred(self):
        """Gets the occurred of this CreateIncidentRequest.  # noqa: E501

        When this incident has really occurred  # noqa: E501

        :return: The occurred of this CreateIncidentRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._occurred

    @occurred.setter
    def occurred(self, occurred):
        """Sets the occurred of this CreateIncidentRequest.

        When this incident has really occurred  # noqa: E501

        :param occurred: The occurred of this CreateIncidentRequest.  # noqa: E501
        :type: datetime
        """

        self._occurred = occurred

    @property
    def open_duration(self):
        """Gets the open_duration of this CreateIncidentRequest.  # noqa: E501

        Duration incident was open  # noqa: E501

        :return: The open_duration of this CreateIncidentRequest.  # noqa: E501
        :rtype: int
        """
        return self._open_duration

    @open_duration.setter
    def open_duration(self, open_duration):
        """Sets the open_duration of this CreateIncidentRequest.

        Duration incident was open  # noqa: E501

        :param open_duration: The open_duration of this CreateIncidentRequest.  # noqa: E501
        :type: int
        """

        self._open_duration = open_duration

    @property
    def owner(self):
        """Gets the owner of this CreateIncidentRequest.  # noqa: E501

        The user who owns this incident  # noqa: E501

        :return: The owner of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """Sets the owner of this CreateIncidentRequest.

        The user who owns this incident  # noqa: E501

        :param owner: The owner of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._owner = owner

    @property
    def parent(self):
        """Gets the parent of this CreateIncidentRequest.  # noqa: E501

        Parent  # noqa: E501

        :return: The parent of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """Sets the parent of this CreateIncidentRequest.

        Parent  # noqa: E501

        :param parent: The parent of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._parent = parent

    @property
    def phase(self):
        """Gets the phase of this CreateIncidentRequest.  # noqa: E501

        Phase  # noqa: E501

        :return: The phase of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """Sets the phase of this CreateIncidentRequest.

        Phase  # noqa: E501

        :param phase: The phase of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._phase = phase

    @property
    def playbook_id(self):
        """Gets the playbook_id of this CreateIncidentRequest.  # noqa: E501

        The associated playbook for this incident  # noqa: E501

        :return: The playbook_id of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._playbook_id

    @playbook_id.setter
    def playbook_id(self, playbook_id):
        """Sets the playbook_id of this CreateIncidentRequest.

        The associated playbook for this incident  # noqa: E501

        :param playbook_id: The playbook_id of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._playbook_id = playbook_id

    @property
    def previous_roles(self):
        """Gets the previous_roles of this CreateIncidentRequest.  # noqa: E501

        PreviousRoleName - do not change this field manually  # noqa: E501

        :return: The previous_roles of this CreateIncidentRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._previous_roles

    @previous_roles.setter
    def previous_roles(self, previous_roles):
        """Sets the previous_roles of this CreateIncidentRequest.

        PreviousRoleName - do not change this field manually  # noqa: E501

        :param previous_roles: The previous_roles of this CreateIncidentRequest.  # noqa: E501
        :type: list[str]
        """

        self._previous_roles = previous_roles

    @property
    def raw_category(self):
        """Gets the raw_category of this CreateIncidentRequest.  # noqa: E501


        :return: The raw_category of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._raw_category

    @raw_category.setter
    def raw_category(self, raw_category):
        """Sets the raw_category of this CreateIncidentRequest.


        :param raw_category: The raw_category of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._raw_category = raw_category

    @property
    def raw_close_reason(self):
        """Gets the raw_close_reason of this CreateIncidentRequest.  # noqa: E501

        The reason for closing the incident (select from existing predefined values)  # noqa: E501

        :return: The raw_close_reason of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._raw_close_reason

    @raw_close_reason.setter
    def raw_close_reason(self, raw_close_reason):
        """Sets the raw_close_reason of this CreateIncidentRequest.

        The reason for closing the incident (select from existing predefined values)  # noqa: E501

        :param raw_close_reason: The raw_close_reason of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._raw_close_reason = raw_close_reason

    @property
    def raw_json(self):
        """Gets the raw_json of this CreateIncidentRequest.  # noqa: E501


        :return: The raw_json of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._raw_json

    @raw_json.setter
    def raw_json(self, raw_json):
        """Sets the raw_json of this CreateIncidentRequest.


        :param raw_json: The raw_json of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._raw_json = raw_json

    @property
    def raw_name(self):
        """Gets the raw_name of this CreateIncidentRequest.  # noqa: E501

        Incident RawName  # noqa: E501

        :return: The raw_name of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._raw_name

    @raw_name.setter
    def raw_name(self, raw_name):
        """Sets the raw_name of this CreateIncidentRequest.

        Incident RawName  # noqa: E501

        :param raw_name: The raw_name of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._raw_name = raw_name

    @property
    def raw_phase(self):
        """Gets the raw_phase of this CreateIncidentRequest.  # noqa: E501

        RawPhase  # noqa: E501

        :return: The raw_phase of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._raw_phase

    @raw_phase.setter
    def raw_phase(self, raw_phase):
        """Sets the raw_phase of this CreateIncidentRequest.

        RawPhase  # noqa: E501

        :param raw_phase: The raw_phase of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._raw_phase = raw_phase

    @property
    def raw_type(self):
        """Gets the raw_type of this CreateIncidentRequest.  # noqa: E501

        Incident raw type  # noqa: E501

        :return: The raw_type of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._raw_type

    @raw_type.setter
    def raw_type(self, raw_type):
        """Sets the raw_type of this CreateIncidentRequest.

        Incident raw type  # noqa: E501

        :param raw_type: The raw_type of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._raw_type = raw_type

    @property
    def reason(self):
        """Gets the reason of this CreateIncidentRequest.  # noqa: E501

        The reason for the resolve  # noqa: E501

        :return: The reason of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this CreateIncidentRequest.

        The reason for the resolve  # noqa: E501

        :param reason: The reason of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._reason = reason

    @property
    def reminder(self):
        """Gets the reminder of this CreateIncidentRequest.  # noqa: E501

        When if at all to send a reminder  # noqa: E501

        :return: The reminder of this CreateIncidentRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._reminder

    @reminder.setter
    def reminder(self, reminder):
        """Sets the reminder of this CreateIncidentRequest.

        When if at all to send a reminder  # noqa: E501

        :param reminder: The reminder of this CreateIncidentRequest.  # noqa: E501
        :type: datetime
        """

        self._reminder = reminder

    @property
    def roles(self):
        """Gets the roles of this CreateIncidentRequest.  # noqa: E501

        The role assigned to this investigation  # noqa: E501

        :return: The roles of this CreateIncidentRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """Sets the roles of this CreateIncidentRequest.

        The role assigned to this investigation  # noqa: E501

        :param roles: The roles of this CreateIncidentRequest.  # noqa: E501
        :type: list[str]
        """

        self._roles = roles

    @property
    def run_status(self):
        """Gets the run_status of this CreateIncidentRequest.  # noqa: E501


        :return: The run_status of this CreateIncidentRequest.  # noqa: E501
        :rtype: RunStatus
        """
        return self._run_status

    @run_status.setter
    def run_status(self, run_status):
        """Sets the run_status of this CreateIncidentRequest.


        :param run_status: The run_status of this CreateIncidentRequest.  # noqa: E501
        :type: RunStatus
        """

        self._run_status = run_status

    @property
    def severity(self):
        """Gets the severity of this CreateIncidentRequest.  # noqa: E501


        :return: The severity of this CreateIncidentRequest.  # noqa: E501
        :rtype: Severity
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this CreateIncidentRequest.


        :param severity: The severity of this CreateIncidentRequest.  # noqa: E501
        :type: Severity
        """

        self._severity = severity

    @property
    def sla(self):
        """Gets the sla of this CreateIncidentRequest.  # noqa: E501


        :return: The sla of this CreateIncidentRequest.  # noqa: E501
        :rtype: SLAState
        """
        return self._sla

    @sla.setter
    def sla(self, sla):
        """Sets the sla of this CreateIncidentRequest.


        :param sla: The sla of this CreateIncidentRequest.  # noqa: E501
        :type: SLAState
        """

        self._sla = sla

    @property
    def sort_values(self):
        """Gets the sort_values of this CreateIncidentRequest.  # noqa: E501


        :return: The sort_values of this CreateIncidentRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._sort_values

    @sort_values.setter
    def sort_values(self, sort_values):
        """Sets the sort_values of this CreateIncidentRequest.


        :param sort_values: The sort_values of this CreateIncidentRequest.  # noqa: E501
        :type: list[str]
        """

        self._sort_values = sort_values

    @property
    def source_brand(self):
        """Gets the source_brand of this CreateIncidentRequest.  # noqa: E501

        SourceBrand ...  # noqa: E501

        :return: The source_brand of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._source_brand

    @source_brand.setter
    def source_brand(self, source_brand):
        """Sets the source_brand of this CreateIncidentRequest.

        SourceBrand ...  # noqa: E501

        :param source_brand: The source_brand of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._source_brand = source_brand

    @property
    def source_instance(self):
        """Gets the source_instance of this CreateIncidentRequest.  # noqa: E501

        SourceInstance ...  # noqa: E501

        :return: The source_instance of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._source_instance

    @source_instance.setter
    def source_instance(self, source_instance):
        """Sets the source_instance of this CreateIncidentRequest.

        SourceInstance ...  # noqa: E501

        :param source_instance: The source_instance of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._source_instance = source_instance

    @property
    def status(self):
        """Gets the status of this CreateIncidentRequest.  # noqa: E501


        :return: The status of this CreateIncidentRequest.  # noqa: E501
        :rtype: IncidentStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this CreateIncidentRequest.


        :param status: The status of this CreateIncidentRequest.  # noqa: E501
        :type: IncidentStatus
        """

        self._status = status

    @property
    def type(self):
        """Gets the type of this CreateIncidentRequest.  # noqa: E501

        Incident type  # noqa: E501

        :return: The type of this CreateIncidentRequest.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this CreateIncidentRequest.

        Incident type  # noqa: E501

        :param type: The type of this CreateIncidentRequest.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def version(self):
        """Gets the version of this CreateIncidentRequest.  # noqa: E501


        :return: The version of this CreateIncidentRequest.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this CreateIncidentRequest.


        :param version: The version of this CreateIncidentRequest.  # noqa: E501
        :type: int
        """

        self._version = version

    @property
    def custom_fields(self):
        """Gets the custom_fields of this CreateIncidentRequest.  # noqa: E501


        :return: The custom_fields of this CreateIncidentRequest.  # noqa: E501
        :rtype: CustomFields
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """Sets the custom_fields of this CreateIncidentRequest.


        :param custom_fields: The custom_fields of this CreateIncidentRequest.  # noqa: E501
        :type: CustomFields
        """

        self._custom_fields = custom_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateIncidentRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateIncidentRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
