# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class DockerImage(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'created_at': 'str',
        'created_since': 'str',
        'id': 'str',
        'repository': 'str',
        'size': 'str',
        'tag': 'str'
    }

    attribute_map = {
        'created_at': 'createdAt',
        'created_since': 'createdSince',
        'id': 'id',
        'repository': 'repository',
        'size': 'size',
        'tag': 'tag'
    }

    def __init__(self, created_at=None, created_since=None, id=None, repository=None, size=None, tag=None):  # noqa: E501
        """DockerImage - a model defined in Swagger"""  # noqa: E501

        self._created_at = None
        self._created_since = None
        self._id = None
        self._repository = None
        self._size = None
        self._tag = None
        self.discriminator = None

        if created_at is not None:
            self.created_at = created_at
        if created_since is not None:
            self.created_since = created_since
        if id is not None:
            self.id = id
        if repository is not None:
            self.repository = repository
        if size is not None:
            self.size = size
        if tag is not None:
            self.tag = tag

    @property
    def created_at(self):
        """Gets the created_at of this DockerImage.  # noqa: E501


        :return: The created_at of this DockerImage.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this DockerImage.


        :param created_at: The created_at of this DockerImage.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def created_since(self):
        """Gets the created_since of this DockerImage.  # noqa: E501


        :return: The created_since of this DockerImage.  # noqa: E501
        :rtype: str
        """
        return self._created_since

    @created_since.setter
    def created_since(self, created_since):
        """Sets the created_since of this DockerImage.


        :param created_since: The created_since of this DockerImage.  # noqa: E501
        :type: str
        """

        self._created_since = created_since

    @property
    def id(self):
        """Gets the id of this DockerImage.  # noqa: E501


        :return: The id of this DockerImage.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DockerImage.


        :param id: The id of this DockerImage.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def repository(self):
        """Gets the repository of this DockerImage.  # noqa: E501


        :return: The repository of this DockerImage.  # noqa: E501
        :rtype: str
        """
        return self._repository

    @repository.setter
    def repository(self, repository):
        """Sets the repository of this DockerImage.


        :param repository: The repository of this DockerImage.  # noqa: E501
        :type: str
        """

        self._repository = repository

    @property
    def size(self):
        """Gets the size of this DockerImage.  # noqa: E501


        :return: The size of this DockerImage.  # noqa: E501
        :rtype: str
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this DockerImage.


        :param size: The size of this DockerImage.  # noqa: E501
        :type: str
        """

        self._size = size

    @property
    def tag(self):
        """Gets the tag of this DockerImage.  # noqa: E501


        :return: The tag of this DockerImage.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this DockerImage.


        :param tag: The tag of this DockerImage.  # noqa: E501
        :type: str
        """

        self._tag = tag

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DockerImage, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DockerImage):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
