# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.expiration_policy import ExpirationPolicy  # noqa: F401,E501
from demisto_client.demisto_api.models.expiration_settings_source import ExpirationSettingsSource  # noqa: F401,E501


class ExpirationSource(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'brand': 'str',
        'expiration_interval': 'int',
        'expiration_policy': 'ExpirationPolicy',
        'instance': 'str',
        'module_id': 'str',
        'set_time': 'datetime',
        'source': 'ExpirationSettingsSource',
        'user': 'str'
    }

    attribute_map = {
        'brand': 'brand',
        'expiration_interval': 'expirationInterval',
        'expiration_policy': 'expirationPolicy',
        'instance': 'instance',
        'module_id': 'moduleId',
        'set_time': 'setTime',
        'source': 'source',
        'user': 'user'
    }

    def __init__(self, brand=None, expiration_interval=None, expiration_policy=None, instance=None, module_id=None, set_time=None, source=None, user=None):  # noqa: E501
        """ExpirationSource - a model defined in Swagger"""  # noqa: E501

        self._brand = None
        self._expiration_interval = None
        self._expiration_policy = None
        self._instance = None
        self._module_id = None
        self._set_time = None
        self._source = None
        self._user = None
        self.discriminator = None

        if brand is not None:
            self.brand = brand
        if expiration_interval is not None:
            self.expiration_interval = expiration_interval
        if expiration_policy is not None:
            self.expiration_policy = expiration_policy
        if instance is not None:
            self.instance = instance
        if module_id is not None:
            self.module_id = module_id
        if set_time is not None:
            self.set_time = set_time
        if source is not None:
            self.source = source
        if user is not None:
            self.user = user

    @property
    def brand(self):
        """Gets the brand of this ExpirationSource.  # noqa: E501


        :return: The brand of this ExpirationSource.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this ExpirationSource.


        :param brand: The brand of this ExpirationSource.  # noqa: E501
        :type: str
        """

        self._brand = brand

    @property
    def expiration_interval(self):
        """Gets the expiration_interval of this ExpirationSource.  # noqa: E501


        :return: The expiration_interval of this ExpirationSource.  # noqa: E501
        :rtype: int
        """
        return self._expiration_interval

    @expiration_interval.setter
    def expiration_interval(self, expiration_interval):
        """Sets the expiration_interval of this ExpirationSource.


        :param expiration_interval: The expiration_interval of this ExpirationSource.  # noqa: E501
        :type: int
        """

        self._expiration_interval = expiration_interval

    @property
    def expiration_policy(self):
        """Gets the expiration_policy of this ExpirationSource.  # noqa: E501


        :return: The expiration_policy of this ExpirationSource.  # noqa: E501
        :rtype: ExpirationPolicy
        """
        return self._expiration_policy

    @expiration_policy.setter
    def expiration_policy(self, expiration_policy):
        """Sets the expiration_policy of this ExpirationSource.


        :param expiration_policy: The expiration_policy of this ExpirationSource.  # noqa: E501
        :type: ExpirationPolicy
        """

        self._expiration_policy = expiration_policy

    @property
    def instance(self):
        """Gets the instance of this ExpirationSource.  # noqa: E501


        :return: The instance of this ExpirationSource.  # noqa: E501
        :rtype: str
        """
        return self._instance

    @instance.setter
    def instance(self, instance):
        """Sets the instance of this ExpirationSource.


        :param instance: The instance of this ExpirationSource.  # noqa: E501
        :type: str
        """

        self._instance = instance

    @property
    def module_id(self):
        """Gets the module_id of this ExpirationSource.  # noqa: E501


        :return: The module_id of this ExpirationSource.  # noqa: E501
        :rtype: str
        """
        return self._module_id

    @module_id.setter
    def module_id(self, module_id):
        """Sets the module_id of this ExpirationSource.


        :param module_id: The module_id of this ExpirationSource.  # noqa: E501
        :type: str
        """

        self._module_id = module_id

    @property
    def set_time(self):
        """Gets the set_time of this ExpirationSource.  # noqa: E501


        :return: The set_time of this ExpirationSource.  # noqa: E501
        :rtype: datetime
        """
        return self._set_time

    @set_time.setter
    def set_time(self, set_time):
        """Sets the set_time of this ExpirationSource.


        :param set_time: The set_time of this ExpirationSource.  # noqa: E501
        :type: datetime
        """

        self._set_time = set_time

    @property
    def source(self):
        """Gets the source of this ExpirationSource.  # noqa: E501


        :return: The source of this ExpirationSource.  # noqa: E501
        :rtype: ExpirationSettingsSource
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this ExpirationSource.


        :param source: The source of this ExpirationSource.  # noqa: E501
        :type: ExpirationSettingsSource
        """

        self._source = source

    @property
    def user(self):
        """Gets the user of this ExpirationSource.  # noqa: E501


        :return: The user of this ExpirationSource.  # noqa: E501
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this ExpirationSource.


        :param user: The user of this ExpirationSource.  # noqa: E501
        :type: str
        """

        self._user = user

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ExpirationSource, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExpirationSource):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
