# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class FileMetadata(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'info': 'str',
        'is_media_file': 'bool',
        'md5': 'str',
        'sha1': 'str',
        'sha256': 'str',
        'sha512': 'str',
        'size': 'int',
        'ssdeep': 'str',
        'type': 'str'
    }

    attribute_map = {
        'info': 'info',
        'is_media_file': 'isMediaFile',
        'md5': 'md5',
        'sha1': 'sha1',
        'sha256': 'sha256',
        'sha512': 'sha512',
        'size': 'size',
        'ssdeep': 'ssdeep',
        'type': 'type'
    }

    def __init__(self, info=None, is_media_file=None, md5=None, sha1=None, sha256=None, sha512=None, size=None, ssdeep=None, type=None):  # noqa: E501
        """FileMetadata - a model defined in Swagger"""  # noqa: E501

        self._info = None
        self._is_media_file = None
        self._md5 = None
        self._sha1 = None
        self._sha256 = None
        self._sha512 = None
        self._size = None
        self._ssdeep = None
        self._type = None
        self.discriminator = None

        if info is not None:
            self.info = info
        if is_media_file is not None:
            self.is_media_file = is_media_file
        if md5 is not None:
            self.md5 = md5
        if sha1 is not None:
            self.sha1 = sha1
        if sha256 is not None:
            self.sha256 = sha256
        if sha512 is not None:
            self.sha512 = sha512
        if size is not None:
            self.size = size
        if ssdeep is not None:
            self.ssdeep = ssdeep
        if type is not None:
            self.type = type

    @property
    def info(self):
        """Gets the info of this FileMetadata.  # noqa: E501


        :return: The info of this FileMetadata.  # noqa: E501
        :rtype: str
        """
        return self._info

    @info.setter
    def info(self, info):
        """Sets the info of this FileMetadata.


        :param info: The info of this FileMetadata.  # noqa: E501
        :type: str
        """

        self._info = info

    @property
    def is_media_file(self):
        """Gets the is_media_file of this FileMetadata.  # noqa: E501


        :return: The is_media_file of this FileMetadata.  # noqa: E501
        :rtype: bool
        """
        return self._is_media_file

    @is_media_file.setter
    def is_media_file(self, is_media_file):
        """Sets the is_media_file of this FileMetadata.


        :param is_media_file: The is_media_file of this FileMetadata.  # noqa: E501
        :type: bool
        """

        self._is_media_file = is_media_file

    @property
    def md5(self):
        """Gets the md5 of this FileMetadata.  # noqa: E501


        :return: The md5 of this FileMetadata.  # noqa: E501
        :rtype: str
        """
        return self._md5

    @md5.setter
    def md5(self, md5):
        """Sets the md5 of this FileMetadata.


        :param md5: The md5 of this FileMetadata.  # noqa: E501
        :type: str
        """

        self._md5 = md5

    @property
    def sha1(self):
        """Gets the sha1 of this FileMetadata.  # noqa: E501


        :return: The sha1 of this FileMetadata.  # noqa: E501
        :rtype: str
        """
        return self._sha1

    @sha1.setter
    def sha1(self, sha1):
        """Sets the sha1 of this FileMetadata.


        :param sha1: The sha1 of this FileMetadata.  # noqa: E501
        :type: str
        """

        self._sha1 = sha1

    @property
    def sha256(self):
        """Gets the sha256 of this FileMetadata.  # noqa: E501


        :return: The sha256 of this FileMetadata.  # noqa: E501
        :rtype: str
        """
        return self._sha256

    @sha256.setter
    def sha256(self, sha256):
        """Sets the sha256 of this FileMetadata.


        :param sha256: The sha256 of this FileMetadata.  # noqa: E501
        :type: str
        """

        self._sha256 = sha256

    @property
    def sha512(self):
        """Gets the sha512 of this FileMetadata.  # noqa: E501


        :return: The sha512 of this FileMetadata.  # noqa: E501
        :rtype: str
        """
        return self._sha512

    @sha512.setter
    def sha512(self, sha512):
        """Sets the sha512 of this FileMetadata.


        :param sha512: The sha512 of this FileMetadata.  # noqa: E501
        :type: str
        """

        self._sha512 = sha512

    @property
    def size(self):
        """Gets the size of this FileMetadata.  # noqa: E501


        :return: The size of this FileMetadata.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this FileMetadata.


        :param size: The size of this FileMetadata.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def ssdeep(self):
        """Gets the ssdeep of this FileMetadata.  # noqa: E501


        :return: The ssdeep of this FileMetadata.  # noqa: E501
        :rtype: str
        """
        return self._ssdeep

    @ssdeep.setter
    def ssdeep(self, ssdeep):
        """Sets the ssdeep of this FileMetadata.


        :param ssdeep: The ssdeep of this FileMetadata.  # noqa: E501
        :type: str
        """

        self._ssdeep = ssdeep

    @property
    def type(self):
        """Gets the type of this FileMetadata.  # noqa: E501


        :return: The type of this FileMetadata.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this FileMetadata.


        :param type: The type of this FileMetadata.  # noqa: E501
        :type: str
        """

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FileMetadata, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileMetadata):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
