# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class HumanCron(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'at_time_hour': 'str',
        'at_time_minute': 'str',
        'days': 'list[str]',
        'hours_period': 'str',
        'scheduling_type': 'str',
        'time_period': 'int',
        'time_period_type': 'str'
    }

    attribute_map = {
        'at_time_hour': 'atTimeHour',
        'at_time_minute': 'atTimeMinute',
        'days': 'days',
        'hours_period': 'hoursPeriod',
        'scheduling_type': 'schedulingType',
        'time_period': 'timePeriod',
        'time_period_type': 'timePeriodType'
    }

    def __init__(self, at_time_hour=None, at_time_minute=None, days=None, hours_period=None, scheduling_type=None, time_period=None, time_period_type=None):  # noqa: E501
        """HumanCron - a model defined in Swagger"""  # noqa: E501

        self._at_time_hour = None
        self._at_time_minute = None
        self._days = None
        self._hours_period = None
        self._scheduling_type = None
        self._time_period = None
        self._time_period_type = None
        self.discriminator = None

        if at_time_hour is not None:
            self.at_time_hour = at_time_hour
        if at_time_minute is not None:
            self.at_time_minute = at_time_minute
        if days is not None:
            self.days = days
        if hours_period is not None:
            self.hours_period = hours_period
        if scheduling_type is not None:
            self.scheduling_type = scheduling_type
        if time_period is not None:
            self.time_period = time_period
        if time_period_type is not None:
            self.time_period_type = time_period_type

    @property
    def at_time_hour(self):
        """Gets the at_time_hour of this HumanCron.  # noqa: E501


        :return: The at_time_hour of this HumanCron.  # noqa: E501
        :rtype: str
        """
        return self._at_time_hour

    @at_time_hour.setter
    def at_time_hour(self, at_time_hour):
        """Sets the at_time_hour of this HumanCron.


        :param at_time_hour: The at_time_hour of this HumanCron.  # noqa: E501
        :type: str
        """

        self._at_time_hour = at_time_hour

    @property
    def at_time_minute(self):
        """Gets the at_time_minute of this HumanCron.  # noqa: E501


        :return: The at_time_minute of this HumanCron.  # noqa: E501
        :rtype: str
        """
        return self._at_time_minute

    @at_time_minute.setter
    def at_time_minute(self, at_time_minute):
        """Sets the at_time_minute of this HumanCron.


        :param at_time_minute: The at_time_minute of this HumanCron.  # noqa: E501
        :type: str
        """

        self._at_time_minute = at_time_minute

    @property
    def days(self):
        """Gets the days of this HumanCron.  # noqa: E501


        :return: The days of this HumanCron.  # noqa: E501
        :rtype: list[str]
        """
        return self._days

    @days.setter
    def days(self, days):
        """Sets the days of this HumanCron.


        :param days: The days of this HumanCron.  # noqa: E501
        :type: list[str]
        """

        self._days = days

    @property
    def hours_period(self):
        """Gets the hours_period of this HumanCron.  # noqa: E501


        :return: The hours_period of this HumanCron.  # noqa: E501
        :rtype: str
        """
        return self._hours_period

    @hours_period.setter
    def hours_period(self, hours_period):
        """Sets the hours_period of this HumanCron.


        :param hours_period: The hours_period of this HumanCron.  # noqa: E501
        :type: str
        """

        self._hours_period = hours_period

    @property
    def scheduling_type(self):
        """Gets the scheduling_type of this HumanCron.  # noqa: E501

        the following fields are deprecated. do not use them.  # noqa: E501

        :return: The scheduling_type of this HumanCron.  # noqa: E501
        :rtype: str
        """
        return self._scheduling_type

    @scheduling_type.setter
    def scheduling_type(self, scheduling_type):
        """Sets the scheduling_type of this HumanCron.

        the following fields are deprecated. do not use them.  # noqa: E501

        :param scheduling_type: The scheduling_type of this HumanCron.  # noqa: E501
        :type: str
        """

        self._scheduling_type = scheduling_type

    @property
    def time_period(self):
        """Gets the time_period of this HumanCron.  # noqa: E501


        :return: The time_period of this HumanCron.  # noqa: E501
        :rtype: int
        """
        return self._time_period

    @time_period.setter
    def time_period(self, time_period):
        """Sets the time_period of this HumanCron.


        :param time_period: The time_period of this HumanCron.  # noqa: E501
        :type: int
        """

        self._time_period = time_period

    @property
    def time_period_type(self):
        """Gets the time_period_type of this HumanCron.  # noqa: E501


        :return: The time_period_type of this HumanCron.  # noqa: E501
        :rtype: str
        """
        return self._time_period_type

    @time_period_type.setter
    def time_period_type(self, time_period_type):
        """Sets the time_period_type of this HumanCron.


        :param time_period_type: The time_period_type of this HumanCron.  # noqa: E501
        :type: str
        """

        self._time_period_type = time_period_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(HumanCron, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HumanCron):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
