# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.reputation_calc_alg import ReputationCalcAlg  # noqa: F401,E501


class IncidentType(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'autorun': 'bool',
        'closure_script': 'str',
        'color': 'str',
        'commit_message': 'str',
        'days': 'int',
        'days_r': 'int',
        'default': 'bool',
        'disabled': 'bool',
        'hours': 'int',
        'hours_r': 'int',
        'id': 'str',
        'locked': 'bool',
        'modified': 'datetime',
        'name': 'str',
        'playbook_id': 'str',
        'pre_processing_script': 'str',
        'prev_name': 'str',
        'readonly': 'bool',
        'reputation_calc': 'ReputationCalcAlg',
        'should_commit': 'bool',
        'sla': 'int',
        'sla_reminder': 'int',
        'sort_values': 'list[str]',
        'system': 'bool',
        'vc_should_ignore': 'bool',
        'version': 'int',
        'weeks': 'int',
        'weeks_r': 'int'
    }

    attribute_map = {
        'autorun': 'autorun',
        'closure_script': 'closureScript',
        'color': 'color',
        'commit_message': 'commitMessage',
        'days': 'days',
        'days_r': 'daysR',
        'default': 'default',
        'disabled': 'disabled',
        'hours': 'hours',
        'hours_r': 'hoursR',
        'id': 'id',
        'locked': 'locked',
        'modified': 'modified',
        'name': 'name',
        'playbook_id': 'playbookId',
        'pre_processing_script': 'preProcessingScript',
        'prev_name': 'prevName',
        'readonly': 'readonly',
        'reputation_calc': 'reputationCalc',
        'should_commit': 'shouldCommit',
        'sla': 'sla',
        'sla_reminder': 'slaReminder',
        'sort_values': 'sortValues',
        'system': 'system',
        'vc_should_ignore': 'vcShouldIgnore',
        'version': 'version',
        'weeks': 'weeks',
        'weeks_r': 'weeksR'
    }

    def __init__(self, autorun=None, closure_script=None, color=None, commit_message=None, days=None, days_r=None, default=None, disabled=None, hours=None, hours_r=None, id=None, locked=None, modified=None, name=None, playbook_id=None, pre_processing_script=None, prev_name=None, readonly=None, reputation_calc=None, should_commit=None, sla=None, sla_reminder=None, sort_values=None, system=None, vc_should_ignore=None, version=None, weeks=None, weeks_r=None):  # noqa: E501
        """IncidentType - a model defined in Swagger"""  # noqa: E501

        self._autorun = None
        self._closure_script = None
        self._color = None
        self._commit_message = None
        self._days = None
        self._days_r = None
        self._default = None
        self._disabled = None
        self._hours = None
        self._hours_r = None
        self._id = None
        self._locked = None
        self._modified = None
        self._name = None
        self._playbook_id = None
        self._pre_processing_script = None
        self._prev_name = None
        self._readonly = None
        self._reputation_calc = None
        self._should_commit = None
        self._sla = None
        self._sla_reminder = None
        self._sort_values = None
        self._system = None
        self._vc_should_ignore = None
        self._version = None
        self._weeks = None
        self._weeks_r = None
        self.discriminator = None

        if autorun is not None:
            self.autorun = autorun
        if closure_script is not None:
            self.closure_script = closure_script
        if color is not None:
            self.color = color
        if commit_message is not None:
            self.commit_message = commit_message
        if days is not None:
            self.days = days
        if days_r is not None:
            self.days_r = days_r
        if default is not None:
            self.default = default
        if disabled is not None:
            self.disabled = disabled
        if hours is not None:
            self.hours = hours
        if hours_r is not None:
            self.hours_r = hours_r
        if id is not None:
            self.id = id
        if locked is not None:
            self.locked = locked
        if modified is not None:
            self.modified = modified
        if name is not None:
            self.name = name
        if playbook_id is not None:
            self.playbook_id = playbook_id
        if pre_processing_script is not None:
            self.pre_processing_script = pre_processing_script
        if prev_name is not None:
            self.prev_name = prev_name
        if readonly is not None:
            self.readonly = readonly
        if reputation_calc is not None:
            self.reputation_calc = reputation_calc
        if should_commit is not None:
            self.should_commit = should_commit
        if sla is not None:
            self.sla = sla
        if sla_reminder is not None:
            self.sla_reminder = sla_reminder
        if sort_values is not None:
            self.sort_values = sort_values
        if system is not None:
            self.system = system
        if vc_should_ignore is not None:
            self.vc_should_ignore = vc_should_ignore
        if version is not None:
            self.version = version
        if weeks is not None:
            self.weeks = weeks
        if weeks_r is not None:
            self.weeks_r = weeks_r

    @property
    def autorun(self):
        """Gets the autorun of this IncidentType.  # noqa: E501


        :return: The autorun of this IncidentType.  # noqa: E501
        :rtype: bool
        """
        return self._autorun

    @autorun.setter
    def autorun(self, autorun):
        """Sets the autorun of this IncidentType.


        :param autorun: The autorun of this IncidentType.  # noqa: E501
        :type: bool
        """

        self._autorun = autorun

    @property
    def closure_script(self):
        """Gets the closure_script of this IncidentType.  # noqa: E501


        :return: The closure_script of this IncidentType.  # noqa: E501
        :rtype: str
        """
        return self._closure_script

    @closure_script.setter
    def closure_script(self, closure_script):
        """Sets the closure_script of this IncidentType.


        :param closure_script: The closure_script of this IncidentType.  # noqa: E501
        :type: str
        """

        self._closure_script = closure_script

    @property
    def color(self):
        """Gets the color of this IncidentType.  # noqa: E501


        :return: The color of this IncidentType.  # noqa: E501
        :rtype: str
        """
        return self._color

    @color.setter
    def color(self, color):
        """Sets the color of this IncidentType.


        :param color: The color of this IncidentType.  # noqa: E501
        :type: str
        """

        self._color = color

    @property
    def commit_message(self):
        """Gets the commit_message of this IncidentType.  # noqa: E501


        :return: The commit_message of this IncidentType.  # noqa: E501
        :rtype: str
        """
        return self._commit_message

    @commit_message.setter
    def commit_message(self, commit_message):
        """Sets the commit_message of this IncidentType.


        :param commit_message: The commit_message of this IncidentType.  # noqa: E501
        :type: str
        """

        self._commit_message = commit_message

    @property
    def days(self):
        """Gets the days of this IncidentType.  # noqa: E501


        :return: The days of this IncidentType.  # noqa: E501
        :rtype: int
        """
        return self._days

    @days.setter
    def days(self, days):
        """Sets the days of this IncidentType.


        :param days: The days of this IncidentType.  # noqa: E501
        :type: int
        """

        self._days = days

    @property
    def days_r(self):
        """Gets the days_r of this IncidentType.  # noqa: E501


        :return: The days_r of this IncidentType.  # noqa: E501
        :rtype: int
        """
        return self._days_r

    @days_r.setter
    def days_r(self, days_r):
        """Sets the days_r of this IncidentType.


        :param days_r: The days_r of this IncidentType.  # noqa: E501
        :type: int
        """

        self._days_r = days_r

    @property
    def default(self):
        """Gets the default of this IncidentType.  # noqa: E501


        :return: The default of this IncidentType.  # noqa: E501
        :rtype: bool
        """
        return self._default

    @default.setter
    def default(self, default):
        """Sets the default of this IncidentType.


        :param default: The default of this IncidentType.  # noqa: E501
        :type: bool
        """

        self._default = default

    @property
    def disabled(self):
        """Gets the disabled of this IncidentType.  # noqa: E501


        :return: The disabled of this IncidentType.  # noqa: E501
        :rtype: bool
        """
        return self._disabled

    @disabled.setter
    def disabled(self, disabled):
        """Sets the disabled of this IncidentType.


        :param disabled: The disabled of this IncidentType.  # noqa: E501
        :type: bool
        """

        self._disabled = disabled

    @property
    def hours(self):
        """Gets the hours of this IncidentType.  # noqa: E501


        :return: The hours of this IncidentType.  # noqa: E501
        :rtype: int
        """
        return self._hours

    @hours.setter
    def hours(self, hours):
        """Sets the hours of this IncidentType.


        :param hours: The hours of this IncidentType.  # noqa: E501
        :type: int
        """

        self._hours = hours

    @property
    def hours_r(self):
        """Gets the hours_r of this IncidentType.  # noqa: E501


        :return: The hours_r of this IncidentType.  # noqa: E501
        :rtype: int
        """
        return self._hours_r

    @hours_r.setter
    def hours_r(self, hours_r):
        """Sets the hours_r of this IncidentType.


        :param hours_r: The hours_r of this IncidentType.  # noqa: E501
        :type: int
        """

        self._hours_r = hours_r

    @property
    def id(self):
        """Gets the id of this IncidentType.  # noqa: E501


        :return: The id of this IncidentType.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this IncidentType.


        :param id: The id of this IncidentType.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def locked(self):
        """Gets the locked of this IncidentType.  # noqa: E501


        :return: The locked of this IncidentType.  # noqa: E501
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """Sets the locked of this IncidentType.


        :param locked: The locked of this IncidentType.  # noqa: E501
        :type: bool
        """

        self._locked = locked

    @property
    def modified(self):
        """Gets the modified of this IncidentType.  # noqa: E501


        :return: The modified of this IncidentType.  # noqa: E501
        :rtype: datetime
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """Sets the modified of this IncidentType.


        :param modified: The modified of this IncidentType.  # noqa: E501
        :type: datetime
        """

        self._modified = modified

    @property
    def name(self):
        """Gets the name of this IncidentType.  # noqa: E501


        :return: The name of this IncidentType.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this IncidentType.


        :param name: The name of this IncidentType.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def playbook_id(self):
        """Gets the playbook_id of this IncidentType.  # noqa: E501


        :return: The playbook_id of this IncidentType.  # noqa: E501
        :rtype: str
        """
        return self._playbook_id

    @playbook_id.setter
    def playbook_id(self, playbook_id):
        """Sets the playbook_id of this IncidentType.


        :param playbook_id: The playbook_id of this IncidentType.  # noqa: E501
        :type: str
        """

        self._playbook_id = playbook_id

    @property
    def pre_processing_script(self):
        """Gets the pre_processing_script of this IncidentType.  # noqa: E501


        :return: The pre_processing_script of this IncidentType.  # noqa: E501
        :rtype: str
        """
        return self._pre_processing_script

    @pre_processing_script.setter
    def pre_processing_script(self, pre_processing_script):
        """Sets the pre_processing_script of this IncidentType.


        :param pre_processing_script: The pre_processing_script of this IncidentType.  # noqa: E501
        :type: str
        """

        self._pre_processing_script = pre_processing_script

    @property
    def prev_name(self):
        """Gets the prev_name of this IncidentType.  # noqa: E501


        :return: The prev_name of this IncidentType.  # noqa: E501
        :rtype: str
        """
        return self._prev_name

    @prev_name.setter
    def prev_name(self, prev_name):
        """Sets the prev_name of this IncidentType.


        :param prev_name: The prev_name of this IncidentType.  # noqa: E501
        :type: str
        """

        self._prev_name = prev_name

    @property
    def readonly(self):
        """Gets the readonly of this IncidentType.  # noqa: E501


        :return: The readonly of this IncidentType.  # noqa: E501
        :rtype: bool
        """
        return self._readonly

    @readonly.setter
    def readonly(self, readonly):
        """Sets the readonly of this IncidentType.


        :param readonly: The readonly of this IncidentType.  # noqa: E501
        :type: bool
        """

        self._readonly = readonly

    @property
    def reputation_calc(self):
        """Gets the reputation_calc of this IncidentType.  # noqa: E501


        :return: The reputation_calc of this IncidentType.  # noqa: E501
        :rtype: ReputationCalcAlg
        """
        return self._reputation_calc

    @reputation_calc.setter
    def reputation_calc(self, reputation_calc):
        """Sets the reputation_calc of this IncidentType.


        :param reputation_calc: The reputation_calc of this IncidentType.  # noqa: E501
        :type: ReputationCalcAlg
        """

        self._reputation_calc = reputation_calc

    @property
    def should_commit(self):
        """Gets the should_commit of this IncidentType.  # noqa: E501


        :return: The should_commit of this IncidentType.  # noqa: E501
        :rtype: bool
        """
        return self._should_commit

    @should_commit.setter
    def should_commit(self, should_commit):
        """Sets the should_commit of this IncidentType.


        :param should_commit: The should_commit of this IncidentType.  # noqa: E501
        :type: bool
        """

        self._should_commit = should_commit

    @property
    def sla(self):
        """Gets the sla of this IncidentType.  # noqa: E501


        :return: The sla of this IncidentType.  # noqa: E501
        :rtype: int
        """
        return self._sla

    @sla.setter
    def sla(self, sla):
        """Sets the sla of this IncidentType.


        :param sla: The sla of this IncidentType.  # noqa: E501
        :type: int
        """

        self._sla = sla

    @property
    def sla_reminder(self):
        """Gets the sla_reminder of this IncidentType.  # noqa: E501


        :return: The sla_reminder of this IncidentType.  # noqa: E501
        :rtype: int
        """
        return self._sla_reminder

    @sla_reminder.setter
    def sla_reminder(self, sla_reminder):
        """Sets the sla_reminder of this IncidentType.


        :param sla_reminder: The sla_reminder of this IncidentType.  # noqa: E501
        :type: int
        """

        self._sla_reminder = sla_reminder

    @property
    def sort_values(self):
        """Gets the sort_values of this IncidentType.  # noqa: E501


        :return: The sort_values of this IncidentType.  # noqa: E501
        :rtype: list[str]
        """
        return self._sort_values

    @sort_values.setter
    def sort_values(self, sort_values):
        """Sets the sort_values of this IncidentType.


        :param sort_values: The sort_values of this IncidentType.  # noqa: E501
        :type: list[str]
        """

        self._sort_values = sort_values

    @property
    def system(self):
        """Gets the system of this IncidentType.  # noqa: E501


        :return: The system of this IncidentType.  # noqa: E501
        :rtype: bool
        """
        return self._system

    @system.setter
    def system(self, system):
        """Sets the system of this IncidentType.


        :param system: The system of this IncidentType.  # noqa: E501
        :type: bool
        """

        self._system = system

    @property
    def vc_should_ignore(self):
        """Gets the vc_should_ignore of this IncidentType.  # noqa: E501


        :return: The vc_should_ignore of this IncidentType.  # noqa: E501
        :rtype: bool
        """
        return self._vc_should_ignore

    @vc_should_ignore.setter
    def vc_should_ignore(self, vc_should_ignore):
        """Sets the vc_should_ignore of this IncidentType.


        :param vc_should_ignore: The vc_should_ignore of this IncidentType.  # noqa: E501
        :type: bool
        """

        self._vc_should_ignore = vc_should_ignore

    @property
    def version(self):
        """Gets the version of this IncidentType.  # noqa: E501


        :return: The version of this IncidentType.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this IncidentType.


        :param version: The version of this IncidentType.  # noqa: E501
        :type: int
        """

        self._version = version

    @property
    def weeks(self):
        """Gets the weeks of this IncidentType.  # noqa: E501


        :return: The weeks of this IncidentType.  # noqa: E501
        :rtype: int
        """
        return self._weeks

    @weeks.setter
    def weeks(self, weeks):
        """Sets the weeks of this IncidentType.


        :param weeks: The weeks of this IncidentType.  # noqa: E501
        :type: int
        """

        self._weeks = weeks

    @property
    def weeks_r(self):
        """Gets the weeks_r of this IncidentType.  # noqa: E501


        :return: The weeks_r of this IncidentType.  # noqa: E501
        :rtype: int
        """
        return self._weeks_r

    @weeks_r.setter
    def weeks_r(self, weeks_r):
        """Sets the weeks_r of this IncidentType.


        :param weeks_r: The weeks_r of this IncidentType.  # noqa: E501
        :type: int
        """

        self._weeks_r = weeks_r

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(IncidentType, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IncidentType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
