# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.date_range_filter import DateRangeFilter  # noqa: F401,E501
from demisto_client.demisto_api.models.duration import Duration  # noqa: F401,E501
from demisto_client.demisto_api.models.order import Order  # noqa: F401,E501
from demisto_client.demisto_api.models.period import Period  # noqa: F401,E501


class IndicatorFilter(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cache': 'dict(str, list[str])',
        'early_time_in_page': 'datetime',
        'first_seen': 'DateRangeFilter',
        'from_date': 'datetime',
        'from_date_license': 'datetime',
        'last_seen': 'DateRangeFilter',
        'later_time_in_page': 'datetime',
        'page': 'int',
        'period': 'Period',
        'prev_page': 'bool',
        'query': 'str',
        'search_after': 'list[str]',
        'search_before': 'list[str]',
        'size': 'int',
        'sort': 'list[Order]',
        'time_frame': 'Duration',
        'to_date': 'datetime'
    }

    attribute_map = {
        'cache': 'Cache',
        'early_time_in_page': 'earlyTimeInPage',
        'first_seen': 'firstSeen',
        'from_date': 'fromDate',
        'from_date_license': 'fromDateLicense',
        'last_seen': 'lastSeen',
        'later_time_in_page': 'laterTimeInPage',
        'page': 'page',
        'period': 'period',
        'prev_page': 'prevPage',
        'query': 'query',
        'search_after': 'searchAfter',
        'search_before': 'searchBefore',
        'size': 'size',
        'sort': 'sort',
        'time_frame': 'timeFrame',
        'to_date': 'toDate'
    }

    def __init__(self, cache=None, early_time_in_page=None, first_seen=None, from_date=None, from_date_license=None, last_seen=None, later_time_in_page=None, page=None, period=None, prev_page=None, query=None, search_after=None, search_before=None, size=None, sort=None, time_frame=None, to_date=None):  # noqa: E501
        """IndicatorFilter - a model defined in Swagger"""  # noqa: E501

        self._cache = None
        self._early_time_in_page = None
        self._first_seen = None
        self._from_date = None
        self._from_date_license = None
        self._last_seen = None
        self._later_time_in_page = None
        self._page = None
        self._period = None
        self._prev_page = None
        self._query = None
        self._search_after = None
        self._search_before = None
        self._size = None
        self._sort = None
        self._time_frame = None
        self._to_date = None
        self.discriminator = None

        if cache is not None:
            self.cache = cache
        if early_time_in_page is not None:
            self.early_time_in_page = early_time_in_page
        if first_seen is not None:
            self.first_seen = first_seen
        if from_date is not None:
            self.from_date = from_date
        if from_date_license is not None:
            self.from_date_license = from_date_license
        if last_seen is not None:
            self.last_seen = last_seen
        if later_time_in_page is not None:
            self.later_time_in_page = later_time_in_page
        if page is not None:
            self.page = page
        if period is not None:
            self.period = period
        if prev_page is not None:
            self.prev_page = prev_page
        if query is not None:
            self.query = query
        if search_after is not None:
            self.search_after = search_after
        if search_before is not None:
            self.search_before = search_before
        if size is not None:
            self.size = size
        if sort is not None:
            self.sort = sort
        if time_frame is not None:
            self.time_frame = time_frame
        if to_date is not None:
            self.to_date = to_date

    @property
    def cache(self):
        """Gets the cache of this IndicatorFilter.  # noqa: E501

        Cache of join functions  # noqa: E501

        :return: The cache of this IndicatorFilter.  # noqa: E501
        :rtype: dict(str, list[str])
        """
        return self._cache

    @cache.setter
    def cache(self, cache):
        """Sets the cache of this IndicatorFilter.

        Cache of join functions  # noqa: E501

        :param cache: The cache of this IndicatorFilter.  # noqa: E501
        :type: dict(str, list[str])
        """

        self._cache = cache

    @property
    def early_time_in_page(self):
        """Gets the early_time_in_page of this IndicatorFilter.  # noqa: E501


        :return: The early_time_in_page of this IndicatorFilter.  # noqa: E501
        :rtype: datetime
        """
        return self._early_time_in_page

    @early_time_in_page.setter
    def early_time_in_page(self, early_time_in_page):
        """Sets the early_time_in_page of this IndicatorFilter.


        :param early_time_in_page: The early_time_in_page of this IndicatorFilter.  # noqa: E501
        :type: datetime
        """

        self._early_time_in_page = early_time_in_page

    @property
    def first_seen(self):
        """Gets the first_seen of this IndicatorFilter.  # noqa: E501


        :return: The first_seen of this IndicatorFilter.  # noqa: E501
        :rtype: DateRangeFilter
        """
        return self._first_seen

    @first_seen.setter
    def first_seen(self, first_seen):
        """Sets the first_seen of this IndicatorFilter.


        :param first_seen: The first_seen of this IndicatorFilter.  # noqa: E501
        :type: DateRangeFilter
        """

        self._first_seen = first_seen

    @property
    def from_date(self):
        """Gets the from_date of this IndicatorFilter.  # noqa: E501


        :return: The from_date of this IndicatorFilter.  # noqa: E501
        :rtype: datetime
        """
        return self._from_date

    @from_date.setter
    def from_date(self, from_date):
        """Sets the from_date of this IndicatorFilter.


        :param from_date: The from_date of this IndicatorFilter.  # noqa: E501
        :type: datetime
        """

        self._from_date = from_date

    @property
    def from_date_license(self):
        """Gets the from_date_license of this IndicatorFilter.  # noqa: E501


        :return: The from_date_license of this IndicatorFilter.  # noqa: E501
        :rtype: datetime
        """
        return self._from_date_license

    @from_date_license.setter
    def from_date_license(self, from_date_license):
        """Sets the from_date_license of this IndicatorFilter.


        :param from_date_license: The from_date_license of this IndicatorFilter.  # noqa: E501
        :type: datetime
        """

        self._from_date_license = from_date_license

    @property
    def last_seen(self):
        """Gets the last_seen of this IndicatorFilter.  # noqa: E501


        :return: The last_seen of this IndicatorFilter.  # noqa: E501
        :rtype: DateRangeFilter
        """
        return self._last_seen

    @last_seen.setter
    def last_seen(self, last_seen):
        """Sets the last_seen of this IndicatorFilter.


        :param last_seen: The last_seen of this IndicatorFilter.  # noqa: E501
        :type: DateRangeFilter
        """

        self._last_seen = last_seen

    @property
    def later_time_in_page(self):
        """Gets the later_time_in_page of this IndicatorFilter.  # noqa: E501


        :return: The later_time_in_page of this IndicatorFilter.  # noqa: E501
        :rtype: datetime
        """
        return self._later_time_in_page

    @later_time_in_page.setter
    def later_time_in_page(self, later_time_in_page):
        """Sets the later_time_in_page of this IndicatorFilter.


        :param later_time_in_page: The later_time_in_page of this IndicatorFilter.  # noqa: E501
        :type: datetime
        """

        self._later_time_in_page = later_time_in_page

    @property
    def page(self):
        """Gets the page of this IndicatorFilter.  # noqa: E501

        0-based page  # noqa: E501

        :return: The page of this IndicatorFilter.  # noqa: E501
        :rtype: int
        """
        return self._page

    @page.setter
    def page(self, page):
        """Sets the page of this IndicatorFilter.

        0-based page  # noqa: E501

        :param page: The page of this IndicatorFilter.  # noqa: E501
        :type: int
        """

        self._page = page

    @property
    def period(self):
        """Gets the period of this IndicatorFilter.  # noqa: E501


        :return: The period of this IndicatorFilter.  # noqa: E501
        :rtype: Period
        """
        return self._period

    @period.setter
    def period(self, period):
        """Sets the period of this IndicatorFilter.


        :param period: The period of this IndicatorFilter.  # noqa: E501
        :type: Period
        """

        self._period = period

    @property
    def prev_page(self):
        """Gets the prev_page of this IndicatorFilter.  # noqa: E501

        MT support - these fields are for indicator search according to calculatedTime  # noqa: E501

        :return: The prev_page of this IndicatorFilter.  # noqa: E501
        :rtype: bool
        """
        return self._prev_page

    @prev_page.setter
    def prev_page(self, prev_page):
        """Sets the prev_page of this IndicatorFilter.

        MT support - these fields are for indicator search according to calculatedTime  # noqa: E501

        :param prev_page: The prev_page of this IndicatorFilter.  # noqa: E501
        :type: bool
        """

        self._prev_page = prev_page

    @property
    def query(self):
        """Gets the query of this IndicatorFilter.  # noqa: E501


        :return: The query of this IndicatorFilter.  # noqa: E501
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """Sets the query of this IndicatorFilter.


        :param query: The query of this IndicatorFilter.  # noqa: E501
        :type: str
        """

        self._query = query

    @property
    def search_after(self):
        """Gets the search_after of this IndicatorFilter.  # noqa: E501

        Efficient next page, pass max sort value from previous page  # noqa: E501

        :return: The search_after of this IndicatorFilter.  # noqa: E501
        :rtype: list[str]
        """
        return self._search_after

    @search_after.setter
    def search_after(self, search_after):
        """Sets the search_after of this IndicatorFilter.

        Efficient next page, pass max sort value from previous page  # noqa: E501

        :param search_after: The search_after of this IndicatorFilter.  # noqa: E501
        :type: list[str]
        """

        self._search_after = search_after

    @property
    def search_before(self):
        """Gets the search_before of this IndicatorFilter.  # noqa: E501

        Efficient prev page, pass min sort value from next page  # noqa: E501

        :return: The search_before of this IndicatorFilter.  # noqa: E501
        :rtype: list[str]
        """
        return self._search_before

    @search_before.setter
    def search_before(self, search_before):
        """Sets the search_before of this IndicatorFilter.

        Efficient prev page, pass min sort value from next page  # noqa: E501

        :param search_before: The search_before of this IndicatorFilter.  # noqa: E501
        :type: list[str]
        """

        self._search_before = search_before

    @property
    def size(self):
        """Gets the size of this IndicatorFilter.  # noqa: E501

        Size is limited to 1000, if not passed it defaults to 0, and no results will return  # noqa: E501

        :return: The size of this IndicatorFilter.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this IndicatorFilter.

        Size is limited to 1000, if not passed it defaults to 0, and no results will return  # noqa: E501

        :param size: The size of this IndicatorFilter.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def sort(self):
        """Gets the sort of this IndicatorFilter.  # noqa: E501

        The sort order  # noqa: E501

        :return: The sort of this IndicatorFilter.  # noqa: E501
        :rtype: list[Order]
        """
        return self._sort

    @sort.setter
    def sort(self, sort):
        """Sets the sort of this IndicatorFilter.

        The sort order  # noqa: E501

        :param sort: The sort of this IndicatorFilter.  # noqa: E501
        :type: list[Order]
        """

        self._sort = sort

    @property
    def time_frame(self):
        """Gets the time_frame of this IndicatorFilter.  # noqa: E501


        :return: The time_frame of this IndicatorFilter.  # noqa: E501
        :rtype: Duration
        """
        return self._time_frame

    @time_frame.setter
    def time_frame(self, time_frame):
        """Sets the time_frame of this IndicatorFilter.


        :param time_frame: The time_frame of this IndicatorFilter.  # noqa: E501
        :type: Duration
        """

        self._time_frame = time_frame

    @property
    def to_date(self):
        """Gets the to_date of this IndicatorFilter.  # noqa: E501


        :return: The to_date of this IndicatorFilter.  # noqa: E501
        :rtype: datetime
        """
        return self._to_date

    @to_date.setter
    def to_date(self, to_date):
        """Sets the to_date of this IndicatorFilter.


        :param to_date: The to_date of this IndicatorFilter.  # noqa: E501
        :type: datetime
        """

        self._to_date = to_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(IndicatorFilter, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IndicatorFilter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
