# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.investigation_playbook_task import InvestigationPlaybookTask  # noqa: F401,E501
from demisto_client.demisto_api.models.severity import Severity  # noqa: F401,E501


class InvestigationPlaybookTasksAPI(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ancestors': 'list[str]',
        'inc_severity': 'Severity',
        'inv_id': 'str',
        'inv_name': 'str',
        'task': 'InvestigationPlaybookTask'
    }

    attribute_map = {
        'ancestors': 'ancestors',
        'inc_severity': 'incSeverity',
        'inv_id': 'invId',
        'inv_name': 'invName',
        'task': 'task'
    }

    def __init__(self, ancestors=None, inc_severity=None, inv_id=None, inv_name=None, task=None):  # noqa: E501
        """InvestigationPlaybookTasksAPI - a model defined in Swagger"""  # noqa: E501

        self._ancestors = None
        self._inc_severity = None
        self._inv_id = None
        self._inv_name = None
        self._task = None
        self.discriminator = None

        if ancestors is not None:
            self.ancestors = ancestors
        if inc_severity is not None:
            self.inc_severity = inc_severity
        if inv_id is not None:
            self.inv_id = inv_id
        if inv_name is not None:
            self.inv_name = inv_name
        if task is not None:
            self.task = task

    @property
    def ancestors(self):
        """Gets the ancestors of this InvestigationPlaybookTasksAPI.  # noqa: E501


        :return: The ancestors of this InvestigationPlaybookTasksAPI.  # noqa: E501
        :rtype: list[str]
        """
        return self._ancestors

    @ancestors.setter
    def ancestors(self, ancestors):
        """Sets the ancestors of this InvestigationPlaybookTasksAPI.


        :param ancestors: The ancestors of this InvestigationPlaybookTasksAPI.  # noqa: E501
        :type: list[str]
        """

        self._ancestors = ancestors

    @property
    def inc_severity(self):
        """Gets the inc_severity of this InvestigationPlaybookTasksAPI.  # noqa: E501


        :return: The inc_severity of this InvestigationPlaybookTasksAPI.  # noqa: E501
        :rtype: Severity
        """
        return self._inc_severity

    @inc_severity.setter
    def inc_severity(self, inc_severity):
        """Sets the inc_severity of this InvestigationPlaybookTasksAPI.


        :param inc_severity: The inc_severity of this InvestigationPlaybookTasksAPI.  # noqa: E501
        :type: Severity
        """

        self._inc_severity = inc_severity

    @property
    def inv_id(self):
        """Gets the inv_id of this InvestigationPlaybookTasksAPI.  # noqa: E501


        :return: The inv_id of this InvestigationPlaybookTasksAPI.  # noqa: E501
        :rtype: str
        """
        return self._inv_id

    @inv_id.setter
    def inv_id(self, inv_id):
        """Sets the inv_id of this InvestigationPlaybookTasksAPI.


        :param inv_id: The inv_id of this InvestigationPlaybookTasksAPI.  # noqa: E501
        :type: str
        """

        self._inv_id = inv_id

    @property
    def inv_name(self):
        """Gets the inv_name of this InvestigationPlaybookTasksAPI.  # noqa: E501


        :return: The inv_name of this InvestigationPlaybookTasksAPI.  # noqa: E501
        :rtype: str
        """
        return self._inv_name

    @inv_name.setter
    def inv_name(self, inv_name):
        """Sets the inv_name of this InvestigationPlaybookTasksAPI.


        :param inv_name: The inv_name of this InvestigationPlaybookTasksAPI.  # noqa: E501
        :type: str
        """

        self._inv_name = inv_name

    @property
    def task(self):
        """Gets the task of this InvestigationPlaybookTasksAPI.  # noqa: E501


        :return: The task of this InvestigationPlaybookTasksAPI.  # noqa: E501
        :rtype: InvestigationPlaybookTask
        """
        return self._task

    @task.setter
    def task(self, task):
        """Sets the task of this InvestigationPlaybookTasksAPI.


        :param task: The task of this InvestigationPlaybookTasksAPI.  # noqa: E501
        :type: InvestigationPlaybookTask
        """

        self._task = task

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(InvestigationPlaybookTasksAPI, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InvestigationPlaybookTasksAPI):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
