# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class LayoutField(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'field_id': 'str',
        'id': 'str',
        'is_visible': 'bool',
        'modified': 'datetime',
        'primary_term': 'int',
        'sequence_number': 'int',
        'sort_values': 'list[str]',
        'version': 'int'
    }

    attribute_map = {
        'field_id': 'fieldId',
        'id': 'id',
        'is_visible': 'isVisible',
        'modified': 'modified',
        'primary_term': 'primaryTerm',
        'sequence_number': 'sequenceNumber',
        'sort_values': 'sortValues',
        'version': 'version'
    }

    def __init__(self, field_id=None, id=None, is_visible=None, modified=None, primary_term=None, sequence_number=None, sort_values=None, version=None):  # noqa: E501
        """LayoutField - a model defined in Swagger"""  # noqa: E501

        self._field_id = None
        self._id = None
        self._is_visible = None
        self._modified = None
        self._primary_term = None
        self._sequence_number = None
        self._sort_values = None
        self._version = None
        self.discriminator = None

        if field_id is not None:
            self.field_id = field_id
        if id is not None:
            self.id = id
        if is_visible is not None:
            self.is_visible = is_visible
        if modified is not None:
            self.modified = modified
        if primary_term is not None:
            self.primary_term = primary_term
        if sequence_number is not None:
            self.sequence_number = sequence_number
        if sort_values is not None:
            self.sort_values = sort_values
        if version is not None:
            self.version = version

    @property
    def field_id(self):
        """Gets the field_id of this LayoutField.  # noqa: E501


        :return: The field_id of this LayoutField.  # noqa: E501
        :rtype: str
        """
        return self._field_id

    @field_id.setter
    def field_id(self, field_id):
        """Sets the field_id of this LayoutField.


        :param field_id: The field_id of this LayoutField.  # noqa: E501
        :type: str
        """

        self._field_id = field_id

    @property
    def id(self):
        """Gets the id of this LayoutField.  # noqa: E501


        :return: The id of this LayoutField.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this LayoutField.


        :param id: The id of this LayoutField.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def is_visible(self):
        """Gets the is_visible of this LayoutField.  # noqa: E501


        :return: The is_visible of this LayoutField.  # noqa: E501
        :rtype: bool
        """
        return self._is_visible

    @is_visible.setter
    def is_visible(self, is_visible):
        """Sets the is_visible of this LayoutField.


        :param is_visible: The is_visible of this LayoutField.  # noqa: E501
        :type: bool
        """

        self._is_visible = is_visible

    @property
    def modified(self):
        """Gets the modified of this LayoutField.  # noqa: E501


        :return: The modified of this LayoutField.  # noqa: E501
        :rtype: datetime
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """Sets the modified of this LayoutField.


        :param modified: The modified of this LayoutField.  # noqa: E501
        :type: datetime
        """

        self._modified = modified

    @property
    def primary_term(self):
        """Gets the primary_term of this LayoutField.  # noqa: E501


        :return: The primary_term of this LayoutField.  # noqa: E501
        :rtype: int
        """
        return self._primary_term

    @primary_term.setter
    def primary_term(self, primary_term):
        """Sets the primary_term of this LayoutField.


        :param primary_term: The primary_term of this LayoutField.  # noqa: E501
        :type: int
        """

        self._primary_term = primary_term

    @property
    def sequence_number(self):
        """Gets the sequence_number of this LayoutField.  # noqa: E501


        :return: The sequence_number of this LayoutField.  # noqa: E501
        :rtype: int
        """
        return self._sequence_number

    @sequence_number.setter
    def sequence_number(self, sequence_number):
        """Sets the sequence_number of this LayoutField.


        :param sequence_number: The sequence_number of this LayoutField.  # noqa: E501
        :type: int
        """

        self._sequence_number = sequence_number

    @property
    def sort_values(self):
        """Gets the sort_values of this LayoutField.  # noqa: E501


        :return: The sort_values of this LayoutField.  # noqa: E501
        :rtype: list[str]
        """
        return self._sort_values

    @sort_values.setter
    def sort_values(self, sort_values):
        """Sets the sort_values of this LayoutField.


        :param sort_values: The sort_values of this LayoutField.  # noqa: E501
        :type: list[str]
        """

        self._sort_values = sort_values

    @property
    def version(self):
        """Gets the version of this LayoutField.  # noqa: E501


        :return: The version of this LayoutField.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this LayoutField.


        :param version: The version of this LayoutField.  # noqa: E501
        :type: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LayoutField, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LayoutField):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
