# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Period(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'by': 'str',
        'by_from': 'str',
        'by_to': 'str',
        'field': 'str',
        'from_value': 'str',
        'to_value': 'str'
    }

    attribute_map = {
        'by': 'by',
        'by_from': 'byFrom',
        'by_to': 'byTo',
        'field': 'field',
        'from_value': 'fromValue',
        'to_value': 'toValue'
    }

    def __init__(self, by=None, by_from=None, by_to=None, field=None, from_value=None, to_value=None):  # noqa: E501
        """Period - a model defined in Swagger"""  # noqa: E501

        self._by = None
        self._by_from = None
        self._by_to = None
        self._field = None
        self._from_value = None
        self._to_value = None
        self.discriminator = None

        if by is not None:
            self.by = by
        if by_from is not None:
            self.by_from = by_from
        if by_to is not None:
            self.by_to = by_to
        if field is not None:
            self.field = field
        if from_value is not None:
            self.from_value = from_value
        if to_value is not None:
            self.to_value = to_value

    @property
    def by(self):
        """Gets the by of this Period.  # noqa: E501

        By is used for legacty, and if exists it will override ByTo and ByFrom  # noqa: E501

        :return: The by of this Period.  # noqa: E501
        :rtype: str
        """
        return self._by

    @by.setter
    def by(self, by):
        """Sets the by of this Period.

        By is used for legacty, and if exists it will override ByTo and ByFrom  # noqa: E501

        :param by: The by of this Period.  # noqa: E501
        :type: str
        """

        self._by = by

    @property
    def by_from(self):
        """Gets the by_from of this Period.  # noqa: E501


        :return: The by_from of this Period.  # noqa: E501
        :rtype: str
        """
        return self._by_from

    @by_from.setter
    def by_from(self, by_from):
        """Sets the by_from of this Period.


        :param by_from: The by_from of this Period.  # noqa: E501
        :type: str
        """

        self._by_from = by_from

    @property
    def by_to(self):
        """Gets the by_to of this Period.  # noqa: E501


        :return: The by_to of this Period.  # noqa: E501
        :rtype: str
        """
        return self._by_to

    @by_to.setter
    def by_to(self, by_to):
        """Sets the by_to of this Period.


        :param by_to: The by_to of this Period.  # noqa: E501
        :type: str
        """

        self._by_to = by_to

    @property
    def field(self):
        """Gets the field of this Period.  # noqa: E501


        :return: The field of this Period.  # noqa: E501
        :rtype: str
        """
        return self._field

    @field.setter
    def field(self, field):
        """Sets the field of this Period.


        :param field: The field of this Period.  # noqa: E501
        :type: str
        """

        self._field = field

    @property
    def from_value(self):
        """Gets the from_value of this Period.  # noqa: E501


        :return: The from_value of this Period.  # noqa: E501
        :rtype: str
        """
        return self._from_value

    @from_value.setter
    def from_value(self, from_value):
        """Sets the from_value of this Period.


        :param from_value: The from_value of this Period.  # noqa: E501
        :type: str
        """

        self._from_value = from_value

    @property
    def to_value(self):
        """Gets the to_value of this Period.  # noqa: E501


        :return: The to_value of this Period.  # noqa: E501
        :rtype: str
        """
        return self._to_value

    @to_value.setter
    def to_value(self, to_value):
        """Sets the to_value of this Period.


        :param to_value: The to_value of this Period.  # noqa: E501
        :type: str
        """

        self._to_value = to_value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Period, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Period):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
