# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.playbook_inputs import PlaybookInputs  # noqa: F401,E501
from demisto_client.demisto_api.models.playbook_outputs import PlaybookOutputs  # noqa: F401,E501
from demisto_client.demisto_api.models.playbook_task import PlaybookTask  # noqa: F401,E501
from demisto_client.demisto_api.models.playbook_view import PlaybookView  # noqa: F401,E501
from demisto_client.demisto_api.models.version import Version  # noqa: F401,E501


class Playbook(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'brands': 'list[str]',
        'commands': 'list[str]',
        'comment': 'str',
        'commit_message': 'str',
        'dbot_created_by': 'str',
        'detached': 'bool',
        'from_server_version': 'Version',
        'has_role': 'bool',
        'hidden': 'bool',
        'id': 'str',
        'inputs': 'PlaybookInputs',
        'item_version': 'Version',
        'locked': 'bool',
        'missing_scripts_ids': 'list[str]',
        'modified': 'datetime',
        'name': 'str',
        'name_raw': 'str',
        'outputs': 'PlaybookOutputs',
        'pack_id': 'str',
        'prev_name': 'str',
        'previous_roles': 'list[str]',
        'primary_term': 'int',
        'private': 'bool',
        'propagation_labels': 'list[str]',
        'quiet': 'bool',
        'roles': 'list[str]',
        'script_ids': 'list[str]',
        'sequence_number': 'int',
        'should_commit': 'bool',
        'sort_values': 'list[str]',
        'source_playbook_id': 'str',
        'start_task_id': 'str',
        'system': 'bool',
        'tags': 'list[str]',
        'task_ids': 'list[str]',
        'tasks': 'dict(str, PlaybookTask)',
        'to_server_version': 'Version',
        'vc_should_ignore': 'bool',
        'version': 'int',
        'view': 'PlaybookView'
    }

    attribute_map = {
        'brands': 'brands',
        'commands': 'commands',
        'comment': 'comment',
        'commit_message': 'commitMessage',
        'dbot_created_by': 'dbotCreatedBy',
        'detached': 'detached',
        'from_server_version': 'fromServerVersion',
        'has_role': 'hasRole',
        'hidden': 'hidden',
        'id': 'id',
        'inputs': 'inputs',
        'item_version': 'itemVersion',
        'locked': 'locked',
        'missing_scripts_ids': 'missingScriptsIds',
        'modified': 'modified',
        'name': 'name',
        'name_raw': 'nameRaw',
        'outputs': 'outputs',
        'pack_id': 'packID',
        'prev_name': 'prevName',
        'previous_roles': 'previousRoles',
        'primary_term': 'primaryTerm',
        'private': 'private',
        'propagation_labels': 'propagationLabels',
        'quiet': 'quiet',
        'roles': 'roles',
        'script_ids': 'scriptIds',
        'sequence_number': 'sequenceNumber',
        'should_commit': 'shouldCommit',
        'sort_values': 'sortValues',
        'source_playbook_id': 'sourcePlaybookID',
        'start_task_id': 'startTaskId',
        'system': 'system',
        'tags': 'tags',
        'task_ids': 'taskIds',
        'tasks': 'tasks',
        'to_server_version': 'toServerVersion',
        'vc_should_ignore': 'vcShouldIgnore',
        'version': 'version',
        'view': 'view'
    }

    def __init__(self, brands=None, commands=None, comment=None, commit_message=None, dbot_created_by=None, detached=None, from_server_version=None, has_role=None, hidden=None, id=None, inputs=None, item_version=None, locked=None, missing_scripts_ids=None, modified=None, name=None, name_raw=None, outputs=None, pack_id=None, prev_name=None, previous_roles=None, primary_term=None, private=None, propagation_labels=None, quiet=None, roles=None, script_ids=None, sequence_number=None, should_commit=None, sort_values=None, source_playbook_id=None, start_task_id=None, system=None, tags=None, task_ids=None, tasks=None, to_server_version=None, vc_should_ignore=None, version=None, view=None):  # noqa: E501
        """Playbook - a model defined in Swagger"""  # noqa: E501

        self._brands = None
        self._commands = None
        self._comment = None
        self._commit_message = None
        self._dbot_created_by = None
        self._detached = None
        self._from_server_version = None
        self._has_role = None
        self._hidden = None
        self._id = None
        self._inputs = None
        self._item_version = None
        self._locked = None
        self._missing_scripts_ids = None
        self._modified = None
        self._name = None
        self._name_raw = None
        self._outputs = None
        self._pack_id = None
        self._prev_name = None
        self._previous_roles = None
        self._primary_term = None
        self._private = None
        self._propagation_labels = None
        self._quiet = None
        self._roles = None
        self._script_ids = None
        self._sequence_number = None
        self._should_commit = None
        self._sort_values = None
        self._source_playbook_id = None
        self._start_task_id = None
        self._system = None
        self._tags = None
        self._task_ids = None
        self._tasks = None
        self._to_server_version = None
        self._vc_should_ignore = None
        self._version = None
        self._view = None
        self.discriminator = None

        if brands is not None:
            self.brands = brands
        if commands is not None:
            self.commands = commands
        if comment is not None:
            self.comment = comment
        if commit_message is not None:
            self.commit_message = commit_message
        if dbot_created_by is not None:
            self.dbot_created_by = dbot_created_by
        if detached is not None:
            self.detached = detached
        if from_server_version is not None:
            self.from_server_version = from_server_version
        if has_role is not None:
            self.has_role = has_role
        if hidden is not None:
            self.hidden = hidden
        if id is not None:
            self.id = id
        if inputs is not None:
            self.inputs = inputs
        if item_version is not None:
            self.item_version = item_version
        if locked is not None:
            self.locked = locked
        if missing_scripts_ids is not None:
            self.missing_scripts_ids = missing_scripts_ids
        if modified is not None:
            self.modified = modified
        if name is not None:
            self.name = name
        if name_raw is not None:
            self.name_raw = name_raw
        if outputs is not None:
            self.outputs = outputs
        if pack_id is not None:
            self.pack_id = pack_id
        if prev_name is not None:
            self.prev_name = prev_name
        if previous_roles is not None:
            self.previous_roles = previous_roles
        if primary_term is not None:
            self.primary_term = primary_term
        if private is not None:
            self.private = private
        if propagation_labels is not None:
            self.propagation_labels = propagation_labels
        if quiet is not None:
            self.quiet = quiet
        if roles is not None:
            self.roles = roles
        if script_ids is not None:
            self.script_ids = script_ids
        if sequence_number is not None:
            self.sequence_number = sequence_number
        if should_commit is not None:
            self.should_commit = should_commit
        if sort_values is not None:
            self.sort_values = sort_values
        if source_playbook_id is not None:
            self.source_playbook_id = source_playbook_id
        if start_task_id is not None:
            self.start_task_id = start_task_id
        if system is not None:
            self.system = system
        if tags is not None:
            self.tags = tags
        if task_ids is not None:
            self.task_ids = task_ids
        if tasks is not None:
            self.tasks = tasks
        if to_server_version is not None:
            self.to_server_version = to_server_version
        if vc_should_ignore is not None:
            self.vc_should_ignore = vc_should_ignore
        if version is not None:
            self.version = version
        if view is not None:
            self.view = view

    @property
    def brands(self):
        """Gets the brands of this Playbook.  # noqa: E501


        :return: The brands of this Playbook.  # noqa: E501
        :rtype: list[str]
        """
        return self._brands

    @brands.setter
    def brands(self, brands):
        """Sets the brands of this Playbook.


        :param brands: The brands of this Playbook.  # noqa: E501
        :type: list[str]
        """

        self._brands = brands

    @property
    def commands(self):
        """Gets the commands of this Playbook.  # noqa: E501


        :return: The commands of this Playbook.  # noqa: E501
        :rtype: list[str]
        """
        return self._commands

    @commands.setter
    def commands(self, commands):
        """Sets the commands of this Playbook.


        :param commands: The commands of this Playbook.  # noqa: E501
        :type: list[str]
        """

        self._commands = commands

    @property
    def comment(self):
        """Gets the comment of this Playbook.  # noqa: E501


        :return: The comment of this Playbook.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this Playbook.


        :param comment: The comment of this Playbook.  # noqa: E501
        :type: str
        """

        self._comment = comment

    @property
    def commit_message(self):
        """Gets the commit_message of this Playbook.  # noqa: E501


        :return: The commit_message of this Playbook.  # noqa: E501
        :rtype: str
        """
        return self._commit_message

    @commit_message.setter
    def commit_message(self, commit_message):
        """Sets the commit_message of this Playbook.


        :param commit_message: The commit_message of this Playbook.  # noqa: E501
        :type: str
        """

        self._commit_message = commit_message

    @property
    def dbot_created_by(self):
        """Gets the dbot_created_by of this Playbook.  # noqa: E501

        Who has created this event - relevant only for manual incidents  # noqa: E501

        :return: The dbot_created_by of this Playbook.  # noqa: E501
        :rtype: str
        """
        return self._dbot_created_by

    @dbot_created_by.setter
    def dbot_created_by(self, dbot_created_by):
        """Sets the dbot_created_by of this Playbook.

        Who has created this event - relevant only for manual incidents  # noqa: E501

        :param dbot_created_by: The dbot_created_by of this Playbook.  # noqa: E501
        :type: str
        """

        self._dbot_created_by = dbot_created_by

    @property
    def detached(self):
        """Gets the detached of this Playbook.  # noqa: E501


        :return: The detached of this Playbook.  # noqa: E501
        :rtype: bool
        """
        return self._detached

    @detached.setter
    def detached(self, detached):
        """Sets the detached of this Playbook.


        :param detached: The detached of this Playbook.  # noqa: E501
        :type: bool
        """

        self._detached = detached

    @property
    def from_server_version(self):
        """Gets the from_server_version of this Playbook.  # noqa: E501


        :return: The from_server_version of this Playbook.  # noqa: E501
        :rtype: Version
        """
        return self._from_server_version

    @from_server_version.setter
    def from_server_version(self, from_server_version):
        """Sets the from_server_version of this Playbook.


        :param from_server_version: The from_server_version of this Playbook.  # noqa: E501
        :type: Version
        """

        self._from_server_version = from_server_version

    @property
    def has_role(self):
        """Gets the has_role of this Playbook.  # noqa: E501

        Internal field to make queries on role faster  # noqa: E501

        :return: The has_role of this Playbook.  # noqa: E501
        :rtype: bool
        """
        return self._has_role

    @has_role.setter
    def has_role(self, has_role):
        """Sets the has_role of this Playbook.

        Internal field to make queries on role faster  # noqa: E501

        :param has_role: The has_role of this Playbook.  # noqa: E501
        :type: bool
        """

        self._has_role = has_role

    @property
    def hidden(self):
        """Gets the hidden of this Playbook.  # noqa: E501


        :return: The hidden of this Playbook.  # noqa: E501
        :rtype: bool
        """
        return self._hidden

    @hidden.setter
    def hidden(self, hidden):
        """Sets the hidden of this Playbook.


        :param hidden: The hidden of this Playbook.  # noqa: E501
        :type: bool
        """

        self._hidden = hidden

    @property
    def id(self):
        """Gets the id of this Playbook.  # noqa: E501


        :return: The id of this Playbook.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Playbook.


        :param id: The id of this Playbook.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def inputs(self):
        """Gets the inputs of this Playbook.  # noqa: E501


        :return: The inputs of this Playbook.  # noqa: E501
        :rtype: PlaybookInputs
        """
        return self._inputs

    @inputs.setter
    def inputs(self, inputs):
        """Sets the inputs of this Playbook.


        :param inputs: The inputs of this Playbook.  # noqa: E501
        :type: PlaybookInputs
        """

        self._inputs = inputs

    @property
    def item_version(self):
        """Gets the item_version of this Playbook.  # noqa: E501


        :return: The item_version of this Playbook.  # noqa: E501
        :rtype: Version
        """
        return self._item_version

    @item_version.setter
    def item_version(self, item_version):
        """Sets the item_version of this Playbook.


        :param item_version: The item_version of this Playbook.  # noqa: E501
        :type: Version
        """

        self._item_version = item_version

    @property
    def locked(self):
        """Gets the locked of this Playbook.  # noqa: E501


        :return: The locked of this Playbook.  # noqa: E501
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """Sets the locked of this Playbook.


        :param locked: The locked of this Playbook.  # noqa: E501
        :type: bool
        """

        self._locked = locked

    @property
    def missing_scripts_ids(self):
        """Gets the missing_scripts_ids of this Playbook.  # noqa: E501


        :return: The missing_scripts_ids of this Playbook.  # noqa: E501
        :rtype: list[str]
        """
        return self._missing_scripts_ids

    @missing_scripts_ids.setter
    def missing_scripts_ids(self, missing_scripts_ids):
        """Sets the missing_scripts_ids of this Playbook.


        :param missing_scripts_ids: The missing_scripts_ids of this Playbook.  # noqa: E501
        :type: list[str]
        """

        self._missing_scripts_ids = missing_scripts_ids

    @property
    def modified(self):
        """Gets the modified of this Playbook.  # noqa: E501


        :return: The modified of this Playbook.  # noqa: E501
        :rtype: datetime
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """Sets the modified of this Playbook.


        :param modified: The modified of this Playbook.  # noqa: E501
        :type: datetime
        """

        self._modified = modified

    @property
    def name(self):
        """Gets the name of this Playbook.  # noqa: E501


        :return: The name of this Playbook.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Playbook.


        :param name: The name of this Playbook.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def name_raw(self):
        """Gets the name_raw of this Playbook.  # noqa: E501


        :return: The name_raw of this Playbook.  # noqa: E501
        :rtype: str
        """
        return self._name_raw

    @name_raw.setter
    def name_raw(self, name_raw):
        """Sets the name_raw of this Playbook.


        :param name_raw: The name_raw of this Playbook.  # noqa: E501
        :type: str
        """

        self._name_raw = name_raw

    @property
    def outputs(self):
        """Gets the outputs of this Playbook.  # noqa: E501


        :return: The outputs of this Playbook.  # noqa: E501
        :rtype: PlaybookOutputs
        """
        return self._outputs

    @outputs.setter
    def outputs(self, outputs):
        """Sets the outputs of this Playbook.


        :param outputs: The outputs of this Playbook.  # noqa: E501
        :type: PlaybookOutputs
        """

        self._outputs = outputs

    @property
    def pack_id(self):
        """Gets the pack_id of this Playbook.  # noqa: E501


        :return: The pack_id of this Playbook.  # noqa: E501
        :rtype: str
        """
        return self._pack_id

    @pack_id.setter
    def pack_id(self, pack_id):
        """Sets the pack_id of this Playbook.


        :param pack_id: The pack_id of this Playbook.  # noqa: E501
        :type: str
        """

        self._pack_id = pack_id

    @property
    def prev_name(self):
        """Gets the prev_name of this Playbook.  # noqa: E501


        :return: The prev_name of this Playbook.  # noqa: E501
        :rtype: str
        """
        return self._prev_name

    @prev_name.setter
    def prev_name(self, prev_name):
        """Sets the prev_name of this Playbook.


        :param prev_name: The prev_name of this Playbook.  # noqa: E501
        :type: str
        """

        self._prev_name = prev_name

    @property
    def previous_roles(self):
        """Gets the previous_roles of this Playbook.  # noqa: E501

        PreviousRoleName - do not change this field manually  # noqa: E501

        :return: The previous_roles of this Playbook.  # noqa: E501
        :rtype: list[str]
        """
        return self._previous_roles

    @previous_roles.setter
    def previous_roles(self, previous_roles):
        """Sets the previous_roles of this Playbook.

        PreviousRoleName - do not change this field manually  # noqa: E501

        :param previous_roles: The previous_roles of this Playbook.  # noqa: E501
        :type: list[str]
        """

        self._previous_roles = previous_roles

    @property
    def primary_term(self):
        """Gets the primary_term of this Playbook.  # noqa: E501


        :return: The primary_term of this Playbook.  # noqa: E501
        :rtype: int
        """
        return self._primary_term

    @primary_term.setter
    def primary_term(self, primary_term):
        """Sets the primary_term of this Playbook.


        :param primary_term: The primary_term of this Playbook.  # noqa: E501
        :type: int
        """

        self._primary_term = primary_term

    @property
    def private(self):
        """Gets the private of this Playbook.  # noqa: E501


        :return: The private of this Playbook.  # noqa: E501
        :rtype: bool
        """
        return self._private

    @private.setter
    def private(self, private):
        """Sets the private of this Playbook.


        :param private: The private of this Playbook.  # noqa: E501
        :type: bool
        """

        self._private = private

    @property
    def propagation_labels(self):
        """Gets the propagation_labels of this Playbook.  # noqa: E501


        :return: The propagation_labels of this Playbook.  # noqa: E501
        :rtype: list[str]
        """
        return self._propagation_labels

    @propagation_labels.setter
    def propagation_labels(self, propagation_labels):
        """Sets the propagation_labels of this Playbook.


        :param propagation_labels: The propagation_labels of this Playbook.  # noqa: E501
        :type: list[str]
        """

        self._propagation_labels = propagation_labels

    @property
    def quiet(self):
        """Gets the quiet of this Playbook.  # noqa: E501


        :return: The quiet of this Playbook.  # noqa: E501
        :rtype: bool
        """
        return self._quiet

    @quiet.setter
    def quiet(self, quiet):
        """Sets the quiet of this Playbook.


        :param quiet: The quiet of this Playbook.  # noqa: E501
        :type: bool
        """

        self._quiet = quiet

    @property
    def roles(self):
        """Gets the roles of this Playbook.  # noqa: E501

        The role assigned to this investigation  # noqa: E501

        :return: The roles of this Playbook.  # noqa: E501
        :rtype: list[str]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """Sets the roles of this Playbook.

        The role assigned to this investigation  # noqa: E501

        :param roles: The roles of this Playbook.  # noqa: E501
        :type: list[str]
        """

        self._roles = roles

    @property
    def script_ids(self):
        """Gets the script_ids of this Playbook.  # noqa: E501


        :return: The script_ids of this Playbook.  # noqa: E501
        :rtype: list[str]
        """
        return self._script_ids

    @script_ids.setter
    def script_ids(self, script_ids):
        """Sets the script_ids of this Playbook.


        :param script_ids: The script_ids of this Playbook.  # noqa: E501
        :type: list[str]
        """

        self._script_ids = script_ids

    @property
    def sequence_number(self):
        """Gets the sequence_number of this Playbook.  # noqa: E501


        :return: The sequence_number of this Playbook.  # noqa: E501
        :rtype: int
        """
        return self._sequence_number

    @sequence_number.setter
    def sequence_number(self, sequence_number):
        """Sets the sequence_number of this Playbook.


        :param sequence_number: The sequence_number of this Playbook.  # noqa: E501
        :type: int
        """

        self._sequence_number = sequence_number

    @property
    def should_commit(self):
        """Gets the should_commit of this Playbook.  # noqa: E501


        :return: The should_commit of this Playbook.  # noqa: E501
        :rtype: bool
        """
        return self._should_commit

    @should_commit.setter
    def should_commit(self, should_commit):
        """Sets the should_commit of this Playbook.


        :param should_commit: The should_commit of this Playbook.  # noqa: E501
        :type: bool
        """

        self._should_commit = should_commit

    @property
    def sort_values(self):
        """Gets the sort_values of this Playbook.  # noqa: E501


        :return: The sort_values of this Playbook.  # noqa: E501
        :rtype: list[str]
        """
        return self._sort_values

    @sort_values.setter
    def sort_values(self, sort_values):
        """Sets the sort_values of this Playbook.


        :param sort_values: The sort_values of this Playbook.  # noqa: E501
        :type: list[str]
        """

        self._sort_values = sort_values

    @property
    def source_playbook_id(self):
        """Gets the source_playbook_id of this Playbook.  # noqa: E501


        :return: The source_playbook_id of this Playbook.  # noqa: E501
        :rtype: str
        """
        return self._source_playbook_id

    @source_playbook_id.setter
    def source_playbook_id(self, source_playbook_id):
        """Sets the source_playbook_id of this Playbook.


        :param source_playbook_id: The source_playbook_id of this Playbook.  # noqa: E501
        :type: str
        """

        self._source_playbook_id = source_playbook_id

    @property
    def start_task_id(self):
        """Gets the start_task_id of this Playbook.  # noqa: E501


        :return: The start_task_id of this Playbook.  # noqa: E501
        :rtype: str
        """
        return self._start_task_id

    @start_task_id.setter
    def start_task_id(self, start_task_id):
        """Sets the start_task_id of this Playbook.


        :param start_task_id: The start_task_id of this Playbook.  # noqa: E501
        :type: str
        """

        self._start_task_id = start_task_id

    @property
    def system(self):
        """Gets the system of this Playbook.  # noqa: E501


        :return: The system of this Playbook.  # noqa: E501
        :rtype: bool
        """
        return self._system

    @system.setter
    def system(self, system):
        """Sets the system of this Playbook.


        :param system: The system of this Playbook.  # noqa: E501
        :type: bool
        """

        self._system = system

    @property
    def tags(self):
        """Gets the tags of this Playbook.  # noqa: E501


        :return: The tags of this Playbook.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this Playbook.


        :param tags: The tags of this Playbook.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    @property
    def task_ids(self):
        """Gets the task_ids of this Playbook.  # noqa: E501

        auto generated field that will contain all task ids in this playbook Needed for searching with bleve  # noqa: E501

        :return: The task_ids of this Playbook.  # noqa: E501
        :rtype: list[str]
        """
        return self._task_ids

    @task_ids.setter
    def task_ids(self, task_ids):
        """Sets the task_ids of this Playbook.

        auto generated field that will contain all task ids in this playbook Needed for searching with bleve  # noqa: E501

        :param task_ids: The task_ids of this Playbook.  # noqa: E501
        :type: list[str]
        """

        self._task_ids = task_ids

    @property
    def tasks(self):
        """Gets the tasks of this Playbook.  # noqa: E501


        :return: The tasks of this Playbook.  # noqa: E501
        :rtype: dict(str, PlaybookTask)
        """
        return self._tasks

    @tasks.setter
    def tasks(self, tasks):
        """Sets the tasks of this Playbook.


        :param tasks: The tasks of this Playbook.  # noqa: E501
        :type: dict(str, PlaybookTask)
        """

        self._tasks = tasks

    @property
    def to_server_version(self):
        """Gets the to_server_version of this Playbook.  # noqa: E501


        :return: The to_server_version of this Playbook.  # noqa: E501
        :rtype: Version
        """
        return self._to_server_version

    @to_server_version.setter
    def to_server_version(self, to_server_version):
        """Sets the to_server_version of this Playbook.


        :param to_server_version: The to_server_version of this Playbook.  # noqa: E501
        :type: Version
        """

        self._to_server_version = to_server_version

    @property
    def vc_should_ignore(self):
        """Gets the vc_should_ignore of this Playbook.  # noqa: E501


        :return: The vc_should_ignore of this Playbook.  # noqa: E501
        :rtype: bool
        """
        return self._vc_should_ignore

    @vc_should_ignore.setter
    def vc_should_ignore(self, vc_should_ignore):
        """Sets the vc_should_ignore of this Playbook.


        :param vc_should_ignore: The vc_should_ignore of this Playbook.  # noqa: E501
        :type: bool
        """

        self._vc_should_ignore = vc_should_ignore

    @property
    def version(self):
        """Gets the version of this Playbook.  # noqa: E501


        :return: The version of this Playbook.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Playbook.


        :param version: The version of this Playbook.  # noqa: E501
        :type: int
        """

        self._version = version

    @property
    def view(self):
        """Gets the view of this Playbook.  # noqa: E501


        :return: The view of this Playbook.  # noqa: E501
        :rtype: PlaybookView
        """
        return self._view

    @view.setter
    def view(self, view):
        """Sets the view of this Playbook.


        :param view: The view of this Playbook.  # noqa: E501
        :type: PlaybookView
        """

        self._view = view

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Playbook, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Playbook):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
