# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.dashboard import Dashboard  # noqa: F401,E501
from demisto_client.demisto_api.models.ending_type import EndingType  # noqa: F401,E501
from demisto_client.demisto_api.models.human_cron import HumanCron  # noqa: F401,E501
from demisto_client.demisto_api.models.report_fields_decoder import ReportFieldsDecoder  # noqa: F401,E501
from demisto_client.demisto_api.models.section import Section  # noqa: F401,E501


class Report(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'commit_message': 'str',
        'created_by': 'str',
        'cron': 'str',
        'cron_view': 'bool',
        'dashboard': 'Dashboard',
        'decoder': 'dict(str, ReportFieldsDecoder)',
        'description': 'str',
        'disable_header': 'bool',
        'ending_date': 'datetime',
        'ending_type': 'EndingType',
        'human_cron': 'HumanCron',
        'id': 'str',
        'latest_report_name': 'str',
        'latest_report_time': 'datetime',
        'latest_report_username': 'str',
        'latest_scheduled_report_time': 'datetime',
        'locked': 'bool',
        'modified': 'datetime',
        'name': 'str',
        'next_scheduled_time': 'datetime',
        'orientation': 'str',
        'paper_size': 'str',
        'prev_name': 'str',
        'prev_type': 'str',
        'recipients': 'list[str]',
        'recurrent': 'bool',
        'report_type': 'str',
        'run_once': 'bool',
        'running_user': 'str',
        'scheduled': 'bool',
        'sections': 'list[Section]',
        'sensitive': 'bool',
        'should_commit': 'bool',
        'sort_values': 'list[str]',
        'start_date': 'datetime',
        'system': 'bool',
        'tags': 'list[str]',
        'times': 'int',
        'timezone_offset': 'int',
        'type': 'str',
        'user_api_key': 'str',
        'user_api_key_id': 'str',
        'vc_should_ignore': 'bool',
        'version': 'int'
    }

    attribute_map = {
        'commit_message': 'commitMessage',
        'created_by': 'createdBy',
        'cron': 'cron',
        'cron_view': 'cronView',
        'dashboard': 'dashboard',
        'decoder': 'decoder',
        'description': 'description',
        'disable_header': 'disableHeader',
        'ending_date': 'endingDate',
        'ending_type': 'endingType',
        'human_cron': 'humanCron',
        'id': 'id',
        'latest_report_name': 'latestReportName',
        'latest_report_time': 'latestReportTime',
        'latest_report_username': 'latestReportUsername',
        'latest_scheduled_report_time': 'latestScheduledReportTime',
        'locked': 'locked',
        'modified': 'modified',
        'name': 'name',
        'next_scheduled_time': 'nextScheduledTime',
        'orientation': 'orientation',
        'paper_size': 'paperSize',
        'prev_name': 'prevName',
        'prev_type': 'prevType',
        'recipients': 'recipients',
        'recurrent': 'recurrent',
        'report_type': 'reportType',
        'run_once': 'runOnce',
        'running_user': 'runningUser',
        'scheduled': 'scheduled',
        'sections': 'sections',
        'sensitive': 'sensitive',
        'should_commit': 'shouldCommit',
        'sort_values': 'sortValues',
        'start_date': 'startDate',
        'system': 'system',
        'tags': 'tags',
        'times': 'times',
        'timezone_offset': 'timezoneOffset',
        'type': 'type',
        'user_api_key': 'userAPIKey',
        'user_api_key_id': 'userAPIKeyID',
        'vc_should_ignore': 'vcShouldIgnore',
        'version': 'version'
    }

    def __init__(self, commit_message=None, created_by=None, cron=None, cron_view=None, dashboard=None, decoder=None, description=None, disable_header=None, ending_date=None, ending_type=None, human_cron=None, id=None, latest_report_name=None, latest_report_time=None, latest_report_username=None, latest_scheduled_report_time=None, locked=None, modified=None, name=None, next_scheduled_time=None, orientation=None, paper_size=None, prev_name=None, prev_type=None, recipients=None, recurrent=None, report_type=None, run_once=None, running_user=None, scheduled=None, sections=None, sensitive=None, should_commit=None, sort_values=None, start_date=None, system=None, tags=None, times=None, timezone_offset=None, type=None, user_api_key=None, user_api_key_id=None, vc_should_ignore=None, version=None):  # noqa: E501
        """Report - a model defined in Swagger"""  # noqa: E501

        self._commit_message = None
        self._created_by = None
        self._cron = None
        self._cron_view = None
        self._dashboard = None
        self._decoder = None
        self._description = None
        self._disable_header = None
        self._ending_date = None
        self._ending_type = None
        self._human_cron = None
        self._id = None
        self._latest_report_name = None
        self._latest_report_time = None
        self._latest_report_username = None
        self._latest_scheduled_report_time = None
        self._locked = None
        self._modified = None
        self._name = None
        self._next_scheduled_time = None
        self._orientation = None
        self._paper_size = None
        self._prev_name = None
        self._prev_type = None
        self._recipients = None
        self._recurrent = None
        self._report_type = None
        self._run_once = None
        self._running_user = None
        self._scheduled = None
        self._sections = None
        self._sensitive = None
        self._should_commit = None
        self._sort_values = None
        self._start_date = None
        self._system = None
        self._tags = None
        self._times = None
        self._timezone_offset = None
        self._type = None
        self._user_api_key = None
        self._user_api_key_id = None
        self._vc_should_ignore = None
        self._version = None
        self.discriminator = None

        if commit_message is not None:
            self.commit_message = commit_message
        if created_by is not None:
            self.created_by = created_by
        if cron is not None:
            self.cron = cron
        if cron_view is not None:
            self.cron_view = cron_view
        if dashboard is not None:
            self.dashboard = dashboard
        if decoder is not None:
            self.decoder = decoder
        if description is not None:
            self.description = description
        if disable_header is not None:
            self.disable_header = disable_header
        if ending_date is not None:
            self.ending_date = ending_date
        if ending_type is not None:
            self.ending_type = ending_type
        if human_cron is not None:
            self.human_cron = human_cron
        if id is not None:
            self.id = id
        if latest_report_name is not None:
            self.latest_report_name = latest_report_name
        if latest_report_time is not None:
            self.latest_report_time = latest_report_time
        if latest_report_username is not None:
            self.latest_report_username = latest_report_username
        if latest_scheduled_report_time is not None:
            self.latest_scheduled_report_time = latest_scheduled_report_time
        if locked is not None:
            self.locked = locked
        if modified is not None:
            self.modified = modified
        if name is not None:
            self.name = name
        if next_scheduled_time is not None:
            self.next_scheduled_time = next_scheduled_time
        if orientation is not None:
            self.orientation = orientation
        if paper_size is not None:
            self.paper_size = paper_size
        if prev_name is not None:
            self.prev_name = prev_name
        if prev_type is not None:
            self.prev_type = prev_type
        if recipients is not None:
            self.recipients = recipients
        if recurrent is not None:
            self.recurrent = recurrent
        if report_type is not None:
            self.report_type = report_type
        if run_once is not None:
            self.run_once = run_once
        if running_user is not None:
            self.running_user = running_user
        if scheduled is not None:
            self.scheduled = scheduled
        if sections is not None:
            self.sections = sections
        if sensitive is not None:
            self.sensitive = sensitive
        if should_commit is not None:
            self.should_commit = should_commit
        if sort_values is not None:
            self.sort_values = sort_values
        if start_date is not None:
            self.start_date = start_date
        if system is not None:
            self.system = system
        if tags is not None:
            self.tags = tags
        if times is not None:
            self.times = times
        if timezone_offset is not None:
            self.timezone_offset = timezone_offset
        if type is not None:
            self.type = type
        if user_api_key is not None:
            self.user_api_key = user_api_key
        if user_api_key_id is not None:
            self.user_api_key_id = user_api_key_id
        if vc_should_ignore is not None:
            self.vc_should_ignore = vc_should_ignore
        if version is not None:
            self.version = version

    @property
    def commit_message(self):
        """Gets the commit_message of this Report.  # noqa: E501


        :return: The commit_message of this Report.  # noqa: E501
        :rtype: str
        """
        return self._commit_message

    @commit_message.setter
    def commit_message(self, commit_message):
        """Sets the commit_message of this Report.


        :param commit_message: The commit_message of this Report.  # noqa: E501
        :type: str
        """

        self._commit_message = commit_message

    @property
    def created_by(self):
        """Gets the created_by of this Report.  # noqa: E501


        :return: The created_by of this Report.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this Report.


        :param created_by: The created_by of this Report.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def cron(self):
        """Gets the cron of this Report.  # noqa: E501


        :return: The cron of this Report.  # noqa: E501
        :rtype: str
        """
        return self._cron

    @cron.setter
    def cron(self, cron):
        """Sets the cron of this Report.


        :param cron: The cron of this Report.  # noqa: E501
        :type: str
        """

        self._cron = cron

    @property
    def cron_view(self):
        """Gets the cron_view of this Report.  # noqa: E501


        :return: The cron_view of this Report.  # noqa: E501
        :rtype: bool
        """
        return self._cron_view

    @cron_view.setter
    def cron_view(self, cron_view):
        """Sets the cron_view of this Report.


        :param cron_view: The cron_view of this Report.  # noqa: E501
        :type: bool
        """

        self._cron_view = cron_view

    @property
    def dashboard(self):
        """Gets the dashboard of this Report.  # noqa: E501


        :return: The dashboard of this Report.  # noqa: E501
        :rtype: Dashboard
        """
        return self._dashboard

    @dashboard.setter
    def dashboard(self, dashboard):
        """Sets the dashboard of this Report.


        :param dashboard: The dashboard of this Report.  # noqa: E501
        :type: Dashboard
        """

        self._dashboard = dashboard

    @property
    def decoder(self):
        """Gets the decoder of this Report.  # noqa: E501


        :return: The decoder of this Report.  # noqa: E501
        :rtype: dict(str, ReportFieldsDecoder)
        """
        return self._decoder

    @decoder.setter
    def decoder(self, decoder):
        """Sets the decoder of this Report.


        :param decoder: The decoder of this Report.  # noqa: E501
        :type: dict(str, ReportFieldsDecoder)
        """

        self._decoder = decoder

    @property
    def description(self):
        """Gets the description of this Report.  # noqa: E501


        :return: The description of this Report.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Report.


        :param description: The description of this Report.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def disable_header(self):
        """Gets the disable_header of this Report.  # noqa: E501


        :return: The disable_header of this Report.  # noqa: E501
        :rtype: bool
        """
        return self._disable_header

    @disable_header.setter
    def disable_header(self, disable_header):
        """Sets the disable_header of this Report.


        :param disable_header: The disable_header of this Report.  # noqa: E501
        :type: bool
        """

        self._disable_header = disable_header

    @property
    def ending_date(self):
        """Gets the ending_date of this Report.  # noqa: E501


        :return: The ending_date of this Report.  # noqa: E501
        :rtype: datetime
        """
        return self._ending_date

    @ending_date.setter
    def ending_date(self, ending_date):
        """Sets the ending_date of this Report.


        :param ending_date: The ending_date of this Report.  # noqa: E501
        :type: datetime
        """

        self._ending_date = ending_date

    @property
    def ending_type(self):
        """Gets the ending_type of this Report.  # noqa: E501


        :return: The ending_type of this Report.  # noqa: E501
        :rtype: EndingType
        """
        return self._ending_type

    @ending_type.setter
    def ending_type(self, ending_type):
        """Sets the ending_type of this Report.


        :param ending_type: The ending_type of this Report.  # noqa: E501
        :type: EndingType
        """

        self._ending_type = ending_type

    @property
    def human_cron(self):
        """Gets the human_cron of this Report.  # noqa: E501


        :return: The human_cron of this Report.  # noqa: E501
        :rtype: HumanCron
        """
        return self._human_cron

    @human_cron.setter
    def human_cron(self, human_cron):
        """Sets the human_cron of this Report.


        :param human_cron: The human_cron of this Report.  # noqa: E501
        :type: HumanCron
        """

        self._human_cron = human_cron

    @property
    def id(self):
        """Gets the id of this Report.  # noqa: E501


        :return: The id of this Report.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Report.


        :param id: The id of this Report.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def latest_report_name(self):
        """Gets the latest_report_name of this Report.  # noqa: E501


        :return: The latest_report_name of this Report.  # noqa: E501
        :rtype: str
        """
        return self._latest_report_name

    @latest_report_name.setter
    def latest_report_name(self, latest_report_name):
        """Sets the latest_report_name of this Report.


        :param latest_report_name: The latest_report_name of this Report.  # noqa: E501
        :type: str
        """

        self._latest_report_name = latest_report_name

    @property
    def latest_report_time(self):
        """Gets the latest_report_time of this Report.  # noqa: E501


        :return: The latest_report_time of this Report.  # noqa: E501
        :rtype: datetime
        """
        return self._latest_report_time

    @latest_report_time.setter
    def latest_report_time(self, latest_report_time):
        """Sets the latest_report_time of this Report.


        :param latest_report_time: The latest_report_time of this Report.  # noqa: E501
        :type: datetime
        """

        self._latest_report_time = latest_report_time

    @property
    def latest_report_username(self):
        """Gets the latest_report_username of this Report.  # noqa: E501


        :return: The latest_report_username of this Report.  # noqa: E501
        :rtype: str
        """
        return self._latest_report_username

    @latest_report_username.setter
    def latest_report_username(self, latest_report_username):
        """Sets the latest_report_username of this Report.


        :param latest_report_username: The latest_report_username of this Report.  # noqa: E501
        :type: str
        """

        self._latest_report_username = latest_report_username

    @property
    def latest_scheduled_report_time(self):
        """Gets the latest_scheduled_report_time of this Report.  # noqa: E501


        :return: The latest_scheduled_report_time of this Report.  # noqa: E501
        :rtype: datetime
        """
        return self._latest_scheduled_report_time

    @latest_scheduled_report_time.setter
    def latest_scheduled_report_time(self, latest_scheduled_report_time):
        """Sets the latest_scheduled_report_time of this Report.


        :param latest_scheduled_report_time: The latest_scheduled_report_time of this Report.  # noqa: E501
        :type: datetime
        """

        self._latest_scheduled_report_time = latest_scheduled_report_time

    @property
    def locked(self):
        """Gets the locked of this Report.  # noqa: E501


        :return: The locked of this Report.  # noqa: E501
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """Sets the locked of this Report.


        :param locked: The locked of this Report.  # noqa: E501
        :type: bool
        """

        self._locked = locked

    @property
    def modified(self):
        """Gets the modified of this Report.  # noqa: E501


        :return: The modified of this Report.  # noqa: E501
        :rtype: datetime
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """Sets the modified of this Report.


        :param modified: The modified of this Report.  # noqa: E501
        :type: datetime
        """

        self._modified = modified

    @property
    def name(self):
        """Gets the name of this Report.  # noqa: E501


        :return: The name of this Report.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Report.


        :param name: The name of this Report.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def next_scheduled_time(self):
        """Gets the next_scheduled_time of this Report.  # noqa: E501


        :return: The next_scheduled_time of this Report.  # noqa: E501
        :rtype: datetime
        """
        return self._next_scheduled_time

    @next_scheduled_time.setter
    def next_scheduled_time(self, next_scheduled_time):
        """Sets the next_scheduled_time of this Report.


        :param next_scheduled_time: The next_scheduled_time of this Report.  # noqa: E501
        :type: datetime
        """

        self._next_scheduled_time = next_scheduled_time

    @property
    def orientation(self):
        """Gets the orientation of this Report.  # noqa: E501


        :return: The orientation of this Report.  # noqa: E501
        :rtype: str
        """
        return self._orientation

    @orientation.setter
    def orientation(self, orientation):
        """Sets the orientation of this Report.


        :param orientation: The orientation of this Report.  # noqa: E501
        :type: str
        """

        self._orientation = orientation

    @property
    def paper_size(self):
        """Gets the paper_size of this Report.  # noqa: E501


        :return: The paper_size of this Report.  # noqa: E501
        :rtype: str
        """
        return self._paper_size

    @paper_size.setter
    def paper_size(self, paper_size):
        """Sets the paper_size of this Report.


        :param paper_size: The paper_size of this Report.  # noqa: E501
        :type: str
        """

        self._paper_size = paper_size

    @property
    def prev_name(self):
        """Gets the prev_name of this Report.  # noqa: E501


        :return: The prev_name of this Report.  # noqa: E501
        :rtype: str
        """
        return self._prev_name

    @prev_name.setter
    def prev_name(self, prev_name):
        """Sets the prev_name of this Report.


        :param prev_name: The prev_name of this Report.  # noqa: E501
        :type: str
        """

        self._prev_name = prev_name

    @property
    def prev_type(self):
        """Gets the prev_type of this Report.  # noqa: E501


        :return: The prev_type of this Report.  # noqa: E501
        :rtype: str
        """
        return self._prev_type

    @prev_type.setter
    def prev_type(self, prev_type):
        """Sets the prev_type of this Report.


        :param prev_type: The prev_type of this Report.  # noqa: E501
        :type: str
        """

        self._prev_type = prev_type

    @property
    def recipients(self):
        """Gets the recipients of this Report.  # noqa: E501


        :return: The recipients of this Report.  # noqa: E501
        :rtype: list[str]
        """
        return self._recipients

    @recipients.setter
    def recipients(self, recipients):
        """Sets the recipients of this Report.


        :param recipients: The recipients of this Report.  # noqa: E501
        :type: list[str]
        """

        self._recipients = recipients

    @property
    def recurrent(self):
        """Gets the recurrent of this Report.  # noqa: E501


        :return: The recurrent of this Report.  # noqa: E501
        :rtype: bool
        """
        return self._recurrent

    @recurrent.setter
    def recurrent(self, recurrent):
        """Sets the recurrent of this Report.


        :param recurrent: The recurrent of this Report.  # noqa: E501
        :type: bool
        """

        self._recurrent = recurrent

    @property
    def report_type(self):
        """Gets the report_type of this Report.  # noqa: E501


        :return: The report_type of this Report.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this Report.


        :param report_type: The report_type of this Report.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def run_once(self):
        """Gets the run_once of this Report.  # noqa: E501


        :return: The run_once of this Report.  # noqa: E501
        :rtype: bool
        """
        return self._run_once

    @run_once.setter
    def run_once(self, run_once):
        """Sets the run_once of this Report.


        :param run_once: The run_once of this Report.  # noqa: E501
        :type: bool
        """

        self._run_once = run_once

    @property
    def running_user(self):
        """Gets the running_user of this Report.  # noqa: E501


        :return: The running_user of this Report.  # noqa: E501
        :rtype: str
        """
        return self._running_user

    @running_user.setter
    def running_user(self, running_user):
        """Sets the running_user of this Report.


        :param running_user: The running_user of this Report.  # noqa: E501
        :type: str
        """

        self._running_user = running_user

    @property
    def scheduled(self):
        """Gets the scheduled of this Report.  # noqa: E501

        is it scheduled  # noqa: E501

        :return: The scheduled of this Report.  # noqa: E501
        :rtype: bool
        """
        return self._scheduled

    @scheduled.setter
    def scheduled(self, scheduled):
        """Sets the scheduled of this Report.

        is it scheduled  # noqa: E501

        :param scheduled: The scheduled of this Report.  # noqa: E501
        :type: bool
        """

        self._scheduled = scheduled

    @property
    def sections(self):
        """Gets the sections of this Report.  # noqa: E501


        :return: The sections of this Report.  # noqa: E501
        :rtype: list[Section]
        """
        return self._sections

    @sections.setter
    def sections(self, sections):
        """Sets the sections of this Report.


        :param sections: The sections of this Report.  # noqa: E501
        :type: list[Section]
        """

        self._sections = sections

    @property
    def sensitive(self):
        """Gets the sensitive of this Report.  # noqa: E501


        :return: The sensitive of this Report.  # noqa: E501
        :rtype: bool
        """
        return self._sensitive

    @sensitive.setter
    def sensitive(self, sensitive):
        """Sets the sensitive of this Report.


        :param sensitive: The sensitive of this Report.  # noqa: E501
        :type: bool
        """

        self._sensitive = sensitive

    @property
    def should_commit(self):
        """Gets the should_commit of this Report.  # noqa: E501


        :return: The should_commit of this Report.  # noqa: E501
        :rtype: bool
        """
        return self._should_commit

    @should_commit.setter
    def should_commit(self, should_commit):
        """Sets the should_commit of this Report.


        :param should_commit: The should_commit of this Report.  # noqa: E501
        :type: bool
        """

        self._should_commit = should_commit

    @property
    def sort_values(self):
        """Gets the sort_values of this Report.  # noqa: E501


        :return: The sort_values of this Report.  # noqa: E501
        :rtype: list[str]
        """
        return self._sort_values

    @sort_values.setter
    def sort_values(self, sort_values):
        """Sets the sort_values of this Report.


        :param sort_values: The sort_values of this Report.  # noqa: E501
        :type: list[str]
        """

        self._sort_values = sort_values

    @property
    def start_date(self):
        """Gets the start_date of this Report.  # noqa: E501


        :return: The start_date of this Report.  # noqa: E501
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this Report.


        :param start_date: The start_date of this Report.  # noqa: E501
        :type: datetime
        """

        self._start_date = start_date

    @property
    def system(self):
        """Gets the system of this Report.  # noqa: E501


        :return: The system of this Report.  # noqa: E501
        :rtype: bool
        """
        return self._system

    @system.setter
    def system(self, system):
        """Sets the system of this Report.


        :param system: The system of this Report.  # noqa: E501
        :type: bool
        """

        self._system = system

    @property
    def tags(self):
        """Gets the tags of this Report.  # noqa: E501


        :return: The tags of this Report.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this Report.


        :param tags: The tags of this Report.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    @property
    def times(self):
        """Gets the times of this Report.  # noqa: E501


        :return: The times of this Report.  # noqa: E501
        :rtype: int
        """
        return self._times

    @times.setter
    def times(self, times):
        """Sets the times of this Report.


        :param times: The times of this Report.  # noqa: E501
        :type: int
        """

        self._times = times

    @property
    def timezone_offset(self):
        """Gets the timezone_offset of this Report.  # noqa: E501


        :return: The timezone_offset of this Report.  # noqa: E501
        :rtype: int
        """
        return self._timezone_offset

    @timezone_offset.setter
    def timezone_offset(self, timezone_offset):
        """Sets the timezone_offset of this Report.


        :param timezone_offset: The timezone_offset of this Report.  # noqa: E501
        :type: int
        """

        self._timezone_offset = timezone_offset

    @property
    def type(self):
        """Gets the type of this Report.  # noqa: E501


        :return: The type of this Report.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Report.


        :param type: The type of this Report.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def user_api_key(self):
        """Gets the user_api_key of this Report.  # noqa: E501


        :return: The user_api_key of this Report.  # noqa: E501
        :rtype: str
        """
        return self._user_api_key

    @user_api_key.setter
    def user_api_key(self, user_api_key):
        """Sets the user_api_key of this Report.


        :param user_api_key: The user_api_key of this Report.  # noqa: E501
        :type: str
        """

        self._user_api_key = user_api_key

    @property
    def user_api_key_id(self):
        """Gets the user_api_key_id of this Report.  # noqa: E501


        :return: The user_api_key_id of this Report.  # noqa: E501
        :rtype: str
        """
        return self._user_api_key_id

    @user_api_key_id.setter
    def user_api_key_id(self, user_api_key_id):
        """Sets the user_api_key_id of this Report.


        :param user_api_key_id: The user_api_key_id of this Report.  # noqa: E501
        :type: str
        """

        self._user_api_key_id = user_api_key_id

    @property
    def vc_should_ignore(self):
        """Gets the vc_should_ignore of this Report.  # noqa: E501


        :return: The vc_should_ignore of this Report.  # noqa: E501
        :rtype: bool
        """
        return self._vc_should_ignore

    @vc_should_ignore.setter
    def vc_should_ignore(self, vc_should_ignore):
        """Sets the vc_should_ignore of this Report.


        :param vc_should_ignore: The vc_should_ignore of this Report.  # noqa: E501
        :type: bool
        """

        self._vc_should_ignore = vc_should_ignore

    @property
    def version(self):
        """Gets the version of this Report.  # noqa: E501


        :return: The version of this Report.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Report.


        :param version: The version of this Report.  # noqa: E501
        :type: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Report, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Report):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
