<p align="center">
  <img src="media/brand/main_logo.png" width="450" title="starflow">
</p>
<p align="center"><i>Build amazing ideas, piece by piece.</i></p>
<p align="center">
  <a href="https://prochain-star-atlas.github.io/starflow-docs/docs/intro">
    <img alt="Docs" src="https://img.shields.io/badge/Documentation-docs?logo=readthedocs&logoColor=white&labelColor=gray&color=%231e4c94">
  </a>
  <a href="https://pypi.org/project/starflow-py">
    <img src="https://img.shields.io/pypi/v/starflow-py?color=%231BA331&label=PyPI&logo=python&logoColor=%23F7F991%20">
  </a>
  <a href="https://artifacthub.io/packages/helm/starflow/starflow">
    <img src="https://img.shields.io/endpoint?url=https://artifacthub.io/badge/repository/starflow">
  </a>
  <a href="https://codecov.io/gh/prochain-star-atlas/starflow" >
    <img src="https://codecov.io/gh/prochain-star-atlas/starflow/graph/badge.svg?token=WTJPH7FSNJ"/>
  </a>
  <a href="https://doi.org/10.5281/zenodo.10214754">
    <img src="https://zenodo.org/badge/DOI/10.5281/zenodo.10214754.svg" alt="DOI">
  </a>
  <a href="https://github.com/sponsors/prochain-star-atlas">
    <img src="https://img.shields.io/static/v1?label=Sponsor&message=%E2%9D%A4&logo=GitHub&color=%23fe8e86">
  </a>
</p>


<br>

![create-workflow](https://raw.githubusercontent.com/prochain-star-atlas/starflow-docs/main/static/img/intro/gif-example.gif)

# Table of contents
- [About](#about)
- [Quick start](#quick-start)
- [GUI](#gui)
- [Pieces](#pieces)
- [REST](#rest)
- [Credits](#credits)

<br>

# About
**starflow is an open source workflow management platform**, with:

- :desktop_computer: an intuitive [Graphical User Interface](#gui) that facilitates creating, editing and monitoring any type of Workflow, from data processing to machine learning
- :package: a standard way of writing and publishing functional [Pieces](#pieces), which follows good practices for data modeling, documentation and distribution
- :gear: a [REST API](#rest) that controls a running Apache Airflow instance


Creating Workflows in the GUI is as simple as dragging and dropping Pieces to the canvas, and connecting them. The user can schedule the Workflow to run periodically, at a specific date/time, or trigger it manually. The monitoring page shows the status of each Workflow Piece in real time, including the logs and results of each run.

Pieces are functional units that can be reused in multiple Workflows. Pieces can execute anything that can be written in Python, and can be easily distributed and installed directly from Github repositories to be used in starflow Workflows.

Every starflow Workflow corresponds to an Apache Airflow DAG, and each Piece corresponds to an Airflow task. starflow controls an Airflow instance, which is responsible for executing, scheduling and monitoring the Workflows (DAGs).

You can think of starflow as Airflow with superpowers:

- :desktop_computer: create highly complex Workflows with simple point-and-click and drag-and-drop operations, in an user-friendly GUI
- :package: make use of Pieces developed by other people, share and reuse your own Pieces
- :busts_in_silhouette: collaborate in groups to edit and monitor Workflows
- :chart_with_upwards_trend: experience a cleaner and more intuitive GUI for viewing Workflows results, including logs and richer reports with images and tables
- :minidisc: shared storage for tasks in the same workflow
- :arrows_counterclockwise: use gitSync to sync DAGs from files stored in a Git repository
- :wheel_of_dharma: scalable, Kubernetes-native platform
- :battery: powered by Apache Airflow for top-tier workflows scheduling and monitoring

<br>

# Quick start

Check out the quick start guide in the [documentation](https://docs.starflow-workflows.io/quickstart).

The starflow Python package can be installed via pip. We reccommend you install starflow in a separate Python environment.

```bash
pip install starflow-py[cli]
```

You can then use starflow command line interface to easily run the starflow platform locally (requires [Docker Compose V2](https://docs.docker.com/compose/)). Go to a new, empty directory and run the following command:

```bash
starflow platform run-compose
```

After all processes started successfully, navigate to `localhost:3000` to access the starflow frontend service. <br>
Obs.: the first time you run the platform, it may take a few minutes to download the Docker images.

Running the starflow platform locally with Docker compose is useful for development and testing purposes. For production environments, we recommend you deploy starflow and Airflow to a Kubernetes cluster. For other deployment modes, check out the instructions in the [documentation](https://docs.starflow-workflows.io/category/run-starflow).

<br>

# GUI
The starflow frontend service is a React application that provides the GUI for easily creating, editing and monitoring Workflows. Check out the [GUI documentation](https://docs.starflow-workflows.io/starflow_components/starflow_components_gui) for more details.

<details>
  <summary>
    <strong>Access authentication</strong>
  </summary>
  Sign up and login to use the starflow platform. <br></br>

  ![signup and login](https://raw.githubusercontent.com/prochain-star-atlas/starflow-docs/main/static/img/quickstart/signin.gif)

</details>

<details>
  <summary>
    <strong>Select or Create Workspaces</strong>
  </summary>
  Select an existing or create a new Workspace. <br></br>

  ![create workspace](https://raw.githubusercontent.com/prochain-star-atlas/starflow-docs/main/static/img/quickstart/select-workspace.png)

</details>

<details>
  <summary>
    <strong>Install Pieces repositories</strong>
  </summary>
  Install bundles of Pieces to your starflow Workspaces direclty from Github repositories, and use them in your Workflows. <br></br>

  ![install pieces](https://raw.githubusercontent.com/prochain-star-atlas/starflow-docs/main/static/img/pieces/install_repository.gif)

</details>

<details>
  <summary>
    <strong>Create Workflows</strong>
  </summary>
  Create Workflows by dragging and dropping Pieces to the canvas, and connecting them. <br></br>

  ![create-workflow](https://raw.githubusercontent.com/prochain-star-atlas/starflow-docs/main/static/img/quickstart/create_workflow.gif)

</details>

<details>
  <summary>
    <strong>Edit Pieces</strong>
  </summary>
  Edit Pieces by changing their input. Outputs from upstream Pieces are automatically available as inputs for downstream Pieces. Pieces can pass forward any type of data, from simple strings to heavy files, all automatically handled by starflow shared storage system. <br></br>

  ![edit pieces](https://raw.githubusercontent.com/prochain-star-atlas/starflow-docs/main/static/img/quickstart/edit_pieces.gif)

</details>

<details>
  <summary>
    <strong>Configure Workflows</strong>
  </summary>
  Configure and schedule Workflows to run periodically, at a specific date/time, or trigger them manually. <br></br>

  ![schedule workflows](https://raw.githubusercontent.com/prochain-star-atlas/starflow-docs/main/static/img/quickstart/workflow_settings.gif)

</details>

<details>
  <summary>
    <strong>Monitor Workflows</strong>
  </summary>
  Monitor Workflows in real time, including the status of each Piece, the logs and results of each run. <br></br>

  ![run-pieces7](https://raw.githubusercontent.com/prochain-star-atlas/starflow-docs/main/static/img/quickstart/monitoring_workflow.gif)

</details>

<br>

# Pieces

![Pieces](https://github.com/prochain-star-atlas/starflow/blob/gif/media/pieces_distribution.gif)

Pieces are the secret sauce of starflow, they are functional units that can be distributed and reused in multiple Workflows. starflow Pieces are special because they:

- :snake: can execute anything written in Python, heavy-weight (e.g. Machine Learning) as well as light-weight (e.g. sending emails) tasks
- :traffic_light: have well defined data models for inputs, outputs and secrets
- :package: run in self-contained and isolated execution environments (Docker containers)
- :gear: are immutable, guaranteeing reproducibility of your workflows
- :octocat: are organized in git repositories, for easy packaging, distribution and installation
- :bookmark_tabs: are properly versioned, tested and documented
- :zap: are plug-and-play and versatile, can be easily incorporated in any workflow

It is very easy to create and share your own Pieces:

1. write your Python function as a Piece <br>
2. define the data types, dependencies, metadata and tests <br>
3. publish in a git repository (public or private)

The [Pieces repository template](https://github.com/prochain-star-atlas/starflow_pieces_repository_template) provides the basic structure, example files and automatic actions for a seamless Pieces creation experience.

Read more in the [Pieces documentation](https://docs.starflow-workflows.io/pieces).


<br>

# REST
The Backend service is a REST API that controls a running Apache Airflow instance. It is responsible for:

- executing operations requested by the frontend service
- interacting with the Airflow instance, including triggering, creating, editing and deleting Workflows (DAGs)
- interacting with the starflow Database

The REST service is written in Python, using the FastAPI framework. Read more about it in the [REST documentation](https://docs.starflow-workflows.io/starflow_components/starflow_components_rest).

<br>

# Credits
starflow is developed and maintained by [Prochain].
