# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'ECXL2ConnectionActionArgs',
    'ECXL2ConnectionActionRequiredDataArgs',
    'ECXL2ConnectionAdditionalInfoArgs',
    'ECXL2ConnectionSecondaryConnectionArgs',
    'ECXL2ConnectionSecondaryConnectionActionArgs',
    'ECXL2ConnectionSecondaryConnectionActionRequiredDataArgs',
    'ECXL2ServiceprofileFeaturesArgs',
    'ECXL2ServiceprofilePortArgs',
    'ECXL2ServiceprofileSpeedBandArgs',
    'GetMetalFacilityCapacityArgs',
    'GetMetalMetroCapacityArgs',
    'GetMetalOrganizationAddressArgs',
    'GetMetalPlansFilterArgs',
    'GetMetalPlansSortArgs',
    'MetalConnectionPortArgs',
    'MetalConnectionServiceTokenArgs',
    'MetalDeviceIpAddressArgs',
    'MetalDeviceNetworkArgs',
    'MetalDevicePortArgs',
    'MetalDeviceReinstallArgs',
    'MetalOrganizationAddressArgs',
    'MetalProjectBgpConfigArgs',
    'MetalSpotMarketRequestInstanceParametersArgs',
    'NetworkACLTemplateDeviceDetailArgs',
    'NetworkACLTemplateInboundRuleArgs',
    'NetworkDeviceClusterDetailsArgs',
    'NetworkDeviceClusterDetailsNode0Args',
    'NetworkDeviceClusterDetailsNode0VendorConfigurationArgs',
    'NetworkDeviceClusterDetailsNode1Args',
    'NetworkDeviceClusterDetailsNode1VendorConfigurationArgs',
    'NetworkDeviceInterfaceArgs',
    'NetworkDeviceLinkDeviceArgs',
    'NetworkDeviceLinkLinkArgs',
    'NetworkDeviceSecondaryDeviceArgs',
    'NetworkDeviceSecondaryDeviceInterfaceArgs',
    'NetworkDeviceSecondaryDeviceSshKeyArgs',
    'NetworkDeviceSshKeyArgs',
]

@pulumi.input_type
class ECXL2ConnectionActionArgs:
    def __init__(__self__, *,
                 message: Optional[pulumi.Input[str]] = None,
                 operation_id: Optional[pulumi.Input[str]] = None,
                 required_datas: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionActionRequiredDataArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        if message is not None:
            pulumi.set(__self__, "message", message)
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if required_datas is not None:
            pulumi.set(__self__, "required_datas", required_datas)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "operation_id")

    @operation_id.setter
    def operation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation_id", value)

    @property
    @pulumi.getter(name="requiredDatas")
    def required_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionActionRequiredDataArgs']]]]:
        return pulumi.get(self, "required_datas")

    @required_datas.setter
    def required_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionActionRequiredDataArgs']]]]):
        pulumi.set(self, "required_datas", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ECXL2ConnectionActionRequiredDataArgs:
    def __init__(__self__, *,
                 editable: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 validation_pattern: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] value: additional information value
        """
        if editable is not None:
            pulumi.set(__self__, "editable", editable)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if validation_pattern is not None:
            pulumi.set(__self__, "validation_pattern", validation_pattern)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def editable(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "editable")

    @editable.setter
    def editable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "editable", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="validationPattern")
    def validation_pattern(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "validation_pattern")

    @validation_pattern.setter
    def validation_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validation_pattern", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        additional information value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ECXL2ConnectionAdditionalInfoArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: additional information key
        :param pulumi.Input[str] value: additional information value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        additional information key
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        additional information value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ECXL2ConnectionSecondaryConnectionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionSecondaryConnectionActionArgs']]]] = None,
                 authorization_key: Optional[pulumi.Input[str]] = None,
                 device_interface_id: Optional[pulumi.Input[int]] = None,
                 device_uuid: Optional[pulumi.Input[str]] = None,
                 port_uuid: Optional[pulumi.Input[str]] = None,
                 profile_uuid: Optional[pulumi.Input[str]] = None,
                 provider_status: Optional[pulumi.Input[str]] = None,
                 redundancy_group: Optional[pulumi.Input[str]] = None,
                 redundancy_type: Optional[pulumi.Input[str]] = None,
                 redundant_uuid: Optional[pulumi.Input[str]] = None,
                 seller_metro_code: Optional[pulumi.Input[str]] = None,
                 seller_region: Optional[pulumi.Input[str]] = None,
                 service_token: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[int]] = None,
                 speed_unit: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 vendor_token: Optional[pulumi.Input[str]] = None,
                 vlan_ctag: Optional[pulumi.Input[int]] = None,
                 vlan_stag: Optional[pulumi.Input[int]] = None,
                 zside_port_uuid: Optional[pulumi.Input[str]] = None,
                 zside_vlan_ctag: Optional[pulumi.Input[int]] = None,
                 zside_vlan_stag: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] name: secondary connection name
        :param pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionSecondaryConnectionActionArgs']]] actions: One or more pending actions to complete connection provisioning.
        :param pulumi.Input[str] authorization_key: Unique identifier authorizing Equinix to provision a connection
               towards a cloud service provider. If not specified primary `authorization_key` will be used. However,
               some service providers may require different keys for each connection. More information on
               [Equinix Fabric how to guide](https://developer.equinix.com/docs/ecx-how-to-guide).
        :param pulumi.Input[int] device_interface_id: Applicable with `device_uuid`, identifier of network interface
               on a given device. If not specified then first available interface will be selected.
        :param pulumi.Input[str] device_uuid: Applicable with primary `device_uuid`. Identifier of the Network Edge
               virtual device from which the secondary connection would originate. If not specified primary
               `device_uuid` will be used.
        :param pulumi.Input[str] port_uuid: Applicable with primary `port_uuid`. Identifier of the Equinix Fabric Port from
               which the secondary connection would originate. If not specified primary `port_uuid` will be used.
        :param pulumi.Input[str] profile_uuid: Unique identifier of the service provider's profile.
        :param pulumi.Input[str] provider_status: Connection provisioning status on service provider's side.
        :param pulumi.Input[str] redundancy_group: Unique identifier of group containing a primary and secondary connection.
        :param pulumi.Input[str] redundancy_type: Connection redundancy type, applicable for HA connections. Valid values are
               `PRIMARY`, `SECONDARY`.
        :param pulumi.Input[str] redundant_uuid: Unique identifier of the redundant connection, applicable for HA connections.
        :param pulumi.Input[str] seller_metro_code: The metro code that denotes the secondary connection’s
               destination (Z side). .
        :param pulumi.Input[str] seller_region: The region in which the seller port resides. If not specified
               primary `seller_region` will be used.
        :param pulumi.Input[str] service_token: Required with primary `service_token`. Unique Equinix Fabric key
               given by a provider that grants you authorization to enable connectivity from an Equinix Fabric Port or
               virtual device. Each connection (primary and secondary) requires a separate token.
               More details in [Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm).
        :param pulumi.Input[int] speed: Speed/Bandwidth to be allocated to the secondary connection. If not
               specified primary `speed` will be used.
        :param pulumi.Input[str] speed_unit: Unit of the speed/bandwidth to be allocated to the secondary
               connection. If not specified primary `speed_unit` will be used.
        :param pulumi.Input[str] status: Connection provisioning status on Equinix Fabric side.
        :param pulumi.Input[str] uuid: Unique identifier of the connection.
        :param pulumi.Input[str] vendor_token: The Equinix Fabric Token the connection was created with. Applicable if the
               connection was created with a `service_token` (a-side) or `zside_service_token` (z-side).
               * `secondary_connection`:
               * `zside_port_uuid`
               * `zside_vlan_stag`
               * `zside_vlan_ctag`
               * `redundancy_type`
               * `redundancy_group`
               * `vendor_token`
        :param pulumi.Input[int] vlan_ctag: Applicable with `port_uuid`. C-Tag/Inner-Tag of the secondary
               connection, a numeric character ranging from 2 - 4094.
        :param pulumi.Input[int] vlan_stag: S-Tag/Outer-Tag of the secondary connection, a
               numeric character ranging from 2 - 4094.
        :param pulumi.Input[str] zside_port_uuid: Unique identifier of the port on the remote/destination side
               (z-side). Allows you to connect between your own ports or virtual devices across your company's
               Equinix Fabric deployment, with no need for a private service profile.
        :param pulumi.Input[int] zside_vlan_ctag: C-Tag/Inner-Tag of the connection on the remote/destination
               side (z-side) - a numeric character ranging from 2 - 4094.
               `secondary_connection` is defined it will internally use same `zside_vlan_ctag` for the secondary
               connection.
        :param pulumi.Input[int] zside_vlan_stag: S-Tag/Outer-Tag of the connection on the remote/destination
               side (z-side) - a numeric character ranging from 2 - 4094.
        """
        pulumi.set(__self__, "name", name)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if device_interface_id is not None:
            pulumi.set(__self__, "device_interface_id", device_interface_id)
        if device_uuid is not None:
            pulumi.set(__self__, "device_uuid", device_uuid)
        if port_uuid is not None:
            pulumi.set(__self__, "port_uuid", port_uuid)
        if profile_uuid is not None:
            pulumi.set(__self__, "profile_uuid", profile_uuid)
        if provider_status is not None:
            pulumi.set(__self__, "provider_status", provider_status)
        if redundancy_group is not None:
            pulumi.set(__self__, "redundancy_group", redundancy_group)
        if redundancy_type is not None:
            pulumi.set(__self__, "redundancy_type", redundancy_type)
        if redundant_uuid is not None:
            warnings.warn("""SecondaryConnection.0.RedundantUUID will not be returned. Use UUID instead""", DeprecationWarning)
            pulumi.log.warn("""redundant_uuid is deprecated: SecondaryConnection.0.RedundantUUID will not be returned. Use UUID instead""")
        if redundant_uuid is not None:
            pulumi.set(__self__, "redundant_uuid", redundant_uuid)
        if seller_metro_code is not None:
            pulumi.set(__self__, "seller_metro_code", seller_metro_code)
        if seller_region is not None:
            pulumi.set(__self__, "seller_region", seller_region)
        if service_token is not None:
            pulumi.set(__self__, "service_token", service_token)
        if speed is not None:
            pulumi.set(__self__, "speed", speed)
        if speed_unit is not None:
            pulumi.set(__self__, "speed_unit", speed_unit)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if vendor_token is not None:
            pulumi.set(__self__, "vendor_token", vendor_token)
        if vlan_ctag is not None:
            pulumi.set(__self__, "vlan_ctag", vlan_ctag)
        if vlan_stag is not None:
            pulumi.set(__self__, "vlan_stag", vlan_stag)
        if zside_port_uuid is not None:
            pulumi.set(__self__, "zside_port_uuid", zside_port_uuid)
        if zside_vlan_ctag is not None:
            pulumi.set(__self__, "zside_vlan_ctag", zside_vlan_ctag)
        if zside_vlan_stag is not None:
            pulumi.set(__self__, "zside_vlan_stag", zside_vlan_stag)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        secondary connection name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionSecondaryConnectionActionArgs']]]]:
        """
        One or more pending actions to complete connection provisioning.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionSecondaryConnectionActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier authorizing Equinix to provision a connection
        towards a cloud service provider. If not specified primary `authorization_key` will be used. However,
        some service providers may require different keys for each connection. More information on
        [Equinix Fabric how to guide](https://developer.equinix.com/docs/ecx-how-to-guide).
        """
        return pulumi.get(self, "authorization_key")

    @authorization_key.setter
    def authorization_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_key", value)

    @property
    @pulumi.getter(name="deviceInterfaceId")
    def device_interface_id(self) -> Optional[pulumi.Input[int]]:
        """
        Applicable with `device_uuid`, identifier of network interface
        on a given device. If not specified then first available interface will be selected.
        """
        return pulumi.get(self, "device_interface_id")

    @device_interface_id.setter
    def device_interface_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "device_interface_id", value)

    @property
    @pulumi.getter(name="deviceUuid")
    def device_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Applicable with primary `device_uuid`. Identifier of the Network Edge
        virtual device from which the secondary connection would originate. If not specified primary
        `device_uuid` will be used.
        """
        return pulumi.get(self, "device_uuid")

    @device_uuid.setter
    def device_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_uuid", value)

    @property
    @pulumi.getter(name="portUuid")
    def port_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Applicable with primary `port_uuid`. Identifier of the Equinix Fabric Port from
        which the secondary connection would originate. If not specified primary `port_uuid` will be used.
        """
        return pulumi.get(self, "port_uuid")

    @port_uuid.setter
    def port_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_uuid", value)

    @property
    @pulumi.getter(name="profileUuid")
    def profile_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the service provider's profile.
        """
        return pulumi.get(self, "profile_uuid")

    @profile_uuid.setter
    def profile_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_uuid", value)

    @property
    @pulumi.getter(name="providerStatus")
    def provider_status(self) -> Optional[pulumi.Input[str]]:
        """
        Connection provisioning status on service provider's side.
        """
        return pulumi.get(self, "provider_status")

    @provider_status.setter
    def provider_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_status", value)

    @property
    @pulumi.getter(name="redundancyGroup")
    def redundancy_group(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of group containing a primary and secondary connection.
        """
        return pulumi.get(self, "redundancy_group")

    @redundancy_group.setter
    def redundancy_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundancy_group", value)

    @property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> Optional[pulumi.Input[str]]:
        """
        Connection redundancy type, applicable for HA connections. Valid values are
        `PRIMARY`, `SECONDARY`.
        """
        return pulumi.get(self, "redundancy_type")

    @redundancy_type.setter
    def redundancy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundancy_type", value)

    @property
    @pulumi.getter(name="redundantUuid")
    def redundant_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the redundant connection, applicable for HA connections.
        """
        return pulumi.get(self, "redundant_uuid")

    @redundant_uuid.setter
    def redundant_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundant_uuid", value)

    @property
    @pulumi.getter(name="sellerMetroCode")
    def seller_metro_code(self) -> Optional[pulumi.Input[str]]:
        """
        The metro code that denotes the secondary connection’s
        destination (Z side). .
        """
        return pulumi.get(self, "seller_metro_code")

    @seller_metro_code.setter
    def seller_metro_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "seller_metro_code", value)

    @property
    @pulumi.getter(name="sellerRegion")
    def seller_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which the seller port resides. If not specified
        primary `seller_region` will be used.
        """
        return pulumi.get(self, "seller_region")

    @seller_region.setter
    def seller_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "seller_region", value)

    @property
    @pulumi.getter(name="serviceToken")
    def service_token(self) -> Optional[pulumi.Input[str]]:
        """
        Required with primary `service_token`. Unique Equinix Fabric key
        given by a provider that grants you authorization to enable connectivity from an Equinix Fabric Port or
        virtual device. Each connection (primary and secondary) requires a separate token.
        More details in [Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm).
        """
        return pulumi.get(self, "service_token")

    @service_token.setter
    def service_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_token", value)

    @property
    @pulumi.getter
    def speed(self) -> Optional[pulumi.Input[int]]:
        """
        Speed/Bandwidth to be allocated to the secondary connection. If not
        specified primary `speed` will be used.
        """
        return pulumi.get(self, "speed")

    @speed.setter
    def speed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "speed", value)

    @property
    @pulumi.getter(name="speedUnit")
    def speed_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Unit of the speed/bandwidth to be allocated to the secondary
        connection. If not specified primary `speed_unit` will be used.
        """
        return pulumi.get(self, "speed_unit")

    @speed_unit.setter
    def speed_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "speed_unit", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Connection provisioning status on Equinix Fabric side.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the connection.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter(name="vendorToken")
    def vendor_token(self) -> Optional[pulumi.Input[str]]:
        """
        The Equinix Fabric Token the connection was created with. Applicable if the
        connection was created with a `service_token` (a-side) or `zside_service_token` (z-side).
        * `secondary_connection`:
        * `zside_port_uuid`
        * `zside_vlan_stag`
        * `zside_vlan_ctag`
        * `redundancy_type`
        * `redundancy_group`
        * `vendor_token`
        """
        return pulumi.get(self, "vendor_token")

    @vendor_token.setter
    def vendor_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor_token", value)

    @property
    @pulumi.getter(name="vlanCtag")
    def vlan_ctag(self) -> Optional[pulumi.Input[int]]:
        """
        Applicable with `port_uuid`. C-Tag/Inner-Tag of the secondary
        connection, a numeric character ranging from 2 - 4094.
        """
        return pulumi.get(self, "vlan_ctag")

    @vlan_ctag.setter
    def vlan_ctag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_ctag", value)

    @property
    @pulumi.getter(name="vlanStag")
    def vlan_stag(self) -> Optional[pulumi.Input[int]]:
        """
        S-Tag/Outer-Tag of the secondary connection, a
        numeric character ranging from 2 - 4094.
        """
        return pulumi.get(self, "vlan_stag")

    @vlan_stag.setter
    def vlan_stag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_stag", value)

    @property
    @pulumi.getter(name="zsidePortUuid")
    def zside_port_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the port on the remote/destination side
        (z-side). Allows you to connect between your own ports or virtual devices across your company's
        Equinix Fabric deployment, with no need for a private service profile.
        """
        return pulumi.get(self, "zside_port_uuid")

    @zside_port_uuid.setter
    def zside_port_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zside_port_uuid", value)

    @property
    @pulumi.getter(name="zsideVlanCtag")
    def zside_vlan_ctag(self) -> Optional[pulumi.Input[int]]:
        """
        C-Tag/Inner-Tag of the connection on the remote/destination
        side (z-side) - a numeric character ranging from 2 - 4094.
        `secondary_connection` is defined it will internally use same `zside_vlan_ctag` for the secondary
        connection.
        """
        return pulumi.get(self, "zside_vlan_ctag")

    @zside_vlan_ctag.setter
    def zside_vlan_ctag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zside_vlan_ctag", value)

    @property
    @pulumi.getter(name="zsideVlanStag")
    def zside_vlan_stag(self) -> Optional[pulumi.Input[int]]:
        """
        S-Tag/Outer-Tag of the connection on the remote/destination
        side (z-side) - a numeric character ranging from 2 - 4094.
        """
        return pulumi.get(self, "zside_vlan_stag")

    @zside_vlan_stag.setter
    def zside_vlan_stag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zside_vlan_stag", value)


@pulumi.input_type
class ECXL2ConnectionSecondaryConnectionActionArgs:
    def __init__(__self__, *,
                 message: Optional[pulumi.Input[str]] = None,
                 operation_id: Optional[pulumi.Input[str]] = None,
                 required_datas: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionSecondaryConnectionActionRequiredDataArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        if message is not None:
            pulumi.set(__self__, "message", message)
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if required_datas is not None:
            pulumi.set(__self__, "required_datas", required_datas)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "operation_id")

    @operation_id.setter
    def operation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation_id", value)

    @property
    @pulumi.getter(name="requiredDatas")
    def required_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionSecondaryConnectionActionRequiredDataArgs']]]]:
        return pulumi.get(self, "required_datas")

    @required_datas.setter
    def required_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionSecondaryConnectionActionRequiredDataArgs']]]]):
        pulumi.set(self, "required_datas", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ECXL2ConnectionSecondaryConnectionActionRequiredDataArgs:
    def __init__(__self__, *,
                 editable: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 validation_pattern: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] value: additional information value
        """
        if editable is not None:
            pulumi.set(__self__, "editable", editable)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if validation_pattern is not None:
            pulumi.set(__self__, "validation_pattern", validation_pattern)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def editable(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "editable")

    @editable.setter
    def editable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "editable", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="validationPattern")
    def validation_pattern(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "validation_pattern")

    @validation_pattern.setter
    def validation_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validation_pattern", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        additional information value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ECXL2ServiceprofileFeaturesArgs:
    def __init__(__self__, *,
                 allow_remote_connections: pulumi.Input[bool],
                 test_profile: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] allow_remote_connections: Indicates whether or not connections to this profile
               can be created from remote metro locations.
        :param pulumi.Input[bool] test_profile: Indicates whether or not this profile can be used for test
               connections.
        """
        pulumi.set(__self__, "allow_remote_connections", allow_remote_connections)
        if test_profile is not None:
            warnings.warn("""TestProfile is no longer required and will be removed in a future release""", DeprecationWarning)
            pulumi.log.warn("""test_profile is deprecated: TestProfile is no longer required and will be removed in a future release""")
        if test_profile is not None:
            pulumi.set(__self__, "test_profile", test_profile)

    @property
    @pulumi.getter(name="allowRemoteConnections")
    def allow_remote_connections(self) -> pulumi.Input[bool]:
        """
        Indicates whether or not connections to this profile
        can be created from remote metro locations.
        """
        return pulumi.get(self, "allow_remote_connections")

    @allow_remote_connections.setter
    def allow_remote_connections(self, value: pulumi.Input[bool]):
        pulumi.set(self, "allow_remote_connections", value)

    @property
    @pulumi.getter(name="testProfile")
    def test_profile(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not this profile can be used for test
        connections.
        """
        return pulumi.get(self, "test_profile")

    @test_profile.setter
    def test_profile(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "test_profile", value)


@pulumi.input_type
class ECXL2ServiceprofilePortArgs:
    def __init__(__self__, *,
                 metro_code: pulumi.Input[str],
                 uuid: pulumi.Input[str]):
        """
        :param pulumi.Input[str] metro_code: The metro code of location where the port resides.
        :param pulumi.Input[str] uuid: Unique identifier of the port.
        """
        pulumi.set(__self__, "metro_code", metro_code)
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="metroCode")
    def metro_code(self) -> pulumi.Input[str]:
        """
        The metro code of location where the port resides.
        """
        return pulumi.get(self, "metro_code")

    @metro_code.setter
    def metro_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "metro_code", value)

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Input[str]:
        """
        Unique identifier of the port.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: pulumi.Input[str]):
        pulumi.set(self, "uuid", value)


@pulumi.input_type
class ECXL2ServiceprofileSpeedBandArgs:
    def __init__(__self__, *,
                 speed: pulumi.Input[int],
                 speed_unit: pulumi.Input[str]):
        """
        :param pulumi.Input[int] speed: Speed/bandwidth supported by this service profile.
        :param pulumi.Input[str] speed_unit: Unit of the speed/bandwidth supported by this service profile. One of
               `MB`, `GB`.
        """
        pulumi.set(__self__, "speed", speed)
        pulumi.set(__self__, "speed_unit", speed_unit)

    @property
    @pulumi.getter
    def speed(self) -> pulumi.Input[int]:
        """
        Speed/bandwidth supported by this service profile.
        """
        return pulumi.get(self, "speed")

    @speed.setter
    def speed(self, value: pulumi.Input[int]):
        pulumi.set(self, "speed", value)

    @property
    @pulumi.getter(name="speedUnit")
    def speed_unit(self) -> pulumi.Input[str]:
        """
        Unit of the speed/bandwidth supported by this service profile. One of
        `MB`, `GB`.
        """
        return pulumi.get(self, "speed_unit")

    @speed_unit.setter
    def speed_unit(self, value: pulumi.Input[str]):
        pulumi.set(self, "speed_unit", value)


@pulumi.input_type
class GetMetalFacilityCapacityArgs:
    def __init__(__self__, *,
                 plan: str,
                 quantity: Optional[int] = None):
        """
        :param str plan: Device plan that must be available in selected location.
        :param int quantity: Minimun number of devices that must be available in selected location.
               Default is `1`.
        """
        pulumi.set(__self__, "plan", plan)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def plan(self) -> str:
        """
        Device plan that must be available in selected location.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: str):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[int]:
        """
        Minimun number of devices that must be available in selected location.
        Default is `1`.
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[int]):
        pulumi.set(self, "quantity", value)


@pulumi.input_type
class GetMetalMetroCapacityArgs:
    def __init__(__self__, *,
                 plan: str,
                 quantity: Optional[int] = None):
        """
        :param str plan: Device plan that must be available in selected location.
        :param int quantity: Minimun number of devices that must be available in selected location.
               Default is `1`.
        """
        pulumi.set(__self__, "plan", plan)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def plan(self) -> str:
        """
        Device plan that must be available in selected location.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: str):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[int]:
        """
        Minimun number of devices that must be available in selected location.
        Default is `1`.
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[int]):
        pulumi.set(self, "quantity", value)


@pulumi.input_type
class GetMetalOrganizationAddressArgs:
    def __init__(__self__, *,
                 address: str,
                 city: str,
                 country: str,
                 state: str,
                 zip_code: str):
        """
        :param str address: Postal address.
        :param str city: City name.
        :param str country: Two letter country code (ISO 3166-1 alpha-2), e.g. US.
        :param str state: State name.
        :param str zip_code: Zip Code.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Postal address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: str):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def city(self) -> str:
        """
        City name.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: str):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter
    def country(self) -> str:
        """
        Two letter country code (ISO 3166-1 alpha-2), e.g. US.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: str):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State name.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: str):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> str:
        """
        Zip Code.
        """
        return pulumi.get(self, "zip_code")

    @zip_code.setter
    def zip_code(self, value: str):
        pulumi.set(self, "zip_code", value)


@pulumi.input_type
class GetMetalPlansFilterArgs:
    def __init__(__self__, *,
                 attribute: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str attribute: The attribute used to filter. Filter attributes are case-sensitive
        :param Sequence[str] values: The filter values. Filter values are case-sensitive. If you specify multiple values for a filter, the values are joined with an OR by default, and the request returns all results that match any of the specified values
        :param bool all: If is set to true, the values are joined with an AND, and the requests returns only the results that match all specified values. Default is `false`.
        :param str match_by: The type of comparison to apply. One of: `in` , `re`, `substring`, `less_than`, `less_than_or_equal`, `greater_than`, `greater_than_or_equal`. Default is `in`.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The attribute used to filter. Filter attributes are case-sensitive
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: str):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The filter values. Filter values are case-sensitive. If you specify multiple values for a filter, the values are joined with an OR by default, and the request returns all results that match any of the specified values
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        If is set to true, the values are joined with an AND, and the requests returns only the results that match all specified values. Default is `false`.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[bool]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        The type of comparison to apply. One of: `in` , `re`, `substring`, `less_than`, `less_than_or_equal`, `greater_than`, `greater_than_or_equal`. Default is `in`.
        """
        return pulumi.get(self, "match_by")

    @match_by.setter
    def match_by(self, value: Optional[str]):
        pulumi.set(self, "match_by", value)


@pulumi.input_type
class GetMetalPlansSortArgs:
    def __init__(__self__, *,
                 attribute: str,
                 direction: Optional[str] = None):
        """
        :param str attribute: The attribute used to filter. Filter attributes are case-sensitive
        :param str direction: Sort results in ascending or descending order. Strings are sorted in alphabetical order. One of: asc, desc
        """
        pulumi.set(__self__, "attribute", attribute)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The attribute used to filter. Filter attributes are case-sensitive
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: str):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        Sort results in ascending or descending order. Strings are sorted in alphabetical order. One of: asc, desc
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[str]):
        pulumi.set(self, "direction", value)


@pulumi.input_type
class MetalConnectionPortArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 link_status: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 virtual_circuit_ids: Optional[pulumi.Input[Sequence[Any]]] = None):
        """
        :param pulumi.Input[str] name: Name of the connection resource
        :param pulumi.Input[int] speed: Connection speed - one of 50Mbps, 200Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps.
        :param pulumi.Input[str] status: Status of the connection resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if link_status is not None:
            pulumi.set(__self__, "link_status", link_status)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if speed is not None:
            pulumi.set(__self__, "speed", speed)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if virtual_circuit_ids is not None:
            pulumi.set(__self__, "virtual_circuit_ids", virtual_circuit_ids)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="linkStatus")
    def link_status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "link_status")

    @link_status.setter
    def link_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link_status", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the connection resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def speed(self) -> Optional[pulumi.Input[int]]:
        """
        Connection speed - one of 50Mbps, 200Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps.
        """
        return pulumi.get(self, "speed")

    @speed.setter
    def speed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "speed", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the connection resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="virtualCircuitIds")
    def virtual_circuit_ids(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        return pulumi.get(self, "virtual_circuit_ids")

    @virtual_circuit_ids.setter
    def virtual_circuit_ids(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "virtual_circuit_ids", value)


@pulumi.input_type
class MetalConnectionServiceTokenArgs:
    def __init__(__self__, *,
                 expires_at: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 max_allowed_speed: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Connection type - dedicated or shared.
        """
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if max_allowed_speed is not None:
            pulumi.set(__self__, "max_allowed_speed", max_allowed_speed)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expires_at", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="maxAllowedSpeed")
    def max_allowed_speed(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "max_allowed_speed")

    @max_allowed_speed.setter
    def max_allowed_speed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_allowed_speed", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Connection type - dedicated or shared.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MetalDeviceIpAddressArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 cidr: Optional[pulumi.Input[int]] = None,
                 reservation_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] type: One of `private_ipv4`, `public_ipv4`, `public_ipv6`.
        :param pulumi.Input[int] cidr: CIDR suffix for IP address block to be assigned, i.e. amount of addresses.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reservation_ids: List of UUIDs of IP block reservations
               from which the public IPv4 address should be taken.
        """
        pulumi.set(__self__, "type", type)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if reservation_ids is not None:
            pulumi.set(__self__, "reservation_ids", reservation_ids)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        One of `private_ipv4`, `public_ipv4`, `public_ipv6`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[int]]:
        """
        CIDR suffix for IP address block to be assigned, i.e. amount of addresses.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="reservationIds")
    def reservation_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of UUIDs of IP block reservations
        from which the public IPv4 address should be taken.
        """
        return pulumi.get(self, "reservation_ids")

    @reservation_ids.setter
    def reservation_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "reservation_ids", value)


@pulumi.input_type
class MetalDeviceNetworkArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 cidr: Optional[pulumi.Input[int]] = None,
                 family: Optional[pulumi.Input[int]] = None,
                 gateway: Optional[pulumi.Input[str]] = None,
                 public: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] address: IPv4 or IPv6 address string.
        :param pulumi.Input[int] cidr: CIDR suffix for IP address block to be assigned, i.e. amount of addresses.
        :param pulumi.Input[int] family: IP version. One of `4`, `6`.
        :param pulumi.Input[str] gateway: Address of router.
        :param pulumi.Input[bool] public: Whether the address is routable from the Internet.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if public is not None:
            pulumi.set(__self__, "public", public)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 or IPv6 address string.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[int]]:
        """
        CIDR suffix for IP address block to be assigned, i.e. amount of addresses.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[int]]:
        """
        IP version. One of `4`, `6`.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[str]]:
        """
        Address of router.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the address is routable from the Internet.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public", value)


@pulumi.input_type
class MetalDevicePortArgs:
    def __init__(__self__, *,
                 bonded: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 mac: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] bonded: Whether this port is part of a bond in bonded network setup.
        :param pulumi.Input[str] id: ID of the port.
        :param pulumi.Input[str] mac: MAC address assigned to the port.
        :param pulumi.Input[str] name: Name of the port (e.g. `eth0`, or `bond0`).
        :param pulumi.Input[str] type: One of `private_ipv4`, `public_ipv4`, `public_ipv6`.
        """
        if bonded is not None:
            pulumi.set(__self__, "bonded", bonded)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def bonded(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this port is part of a bond in bonded network setup.
        """
        return pulumi.get(self, "bonded")

    @bonded.setter
    def bonded(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bonded", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the port.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def mac(self) -> Optional[pulumi.Input[str]]:
        """
        MAC address assigned to the port.
        """
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the port (e.g. `eth0`, or `bond0`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        One of `private_ipv4`, `public_ipv4`, `public_ipv6`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MetalDeviceReinstallArgs:
    def __init__(__self__, *,
                 deprovision_fast: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 preserve_data: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] deprovision_fast: Whether the OS disk should be filled with `00h` bytes before reinstall.
               Defaults to `false`.
        :param pulumi.Input[bool] enabled: Whether the provider should favour reinstall over destroy and create. Defaults to
               `false`.
        :param pulumi.Input[bool] preserve_data: Whether the non-OS disks should be kept or wiped during reinstall.
               Defaults to `false`.
        """
        if deprovision_fast is not None:
            pulumi.set(__self__, "deprovision_fast", deprovision_fast)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if preserve_data is not None:
            pulumi.set(__self__, "preserve_data", preserve_data)

    @property
    @pulumi.getter(name="deprovisionFast")
    def deprovision_fast(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the OS disk should be filled with `00h` bytes before reinstall.
        Defaults to `false`.
        """
        return pulumi.get(self, "deprovision_fast")

    @deprovision_fast.setter
    def deprovision_fast(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deprovision_fast", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the provider should favour reinstall over destroy and create. Defaults to
        `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="preserveData")
    def preserve_data(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the non-OS disks should be kept or wiped during reinstall.
        Defaults to `false`.
        """
        return pulumi.get(self, "preserve_data")

    @preserve_data.setter
    def preserve_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_data", value)


@pulumi.input_type
class MetalOrganizationAddressArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 city: pulumi.Input[str],
                 country: pulumi.Input[str],
                 zip_code: pulumi.Input[str],
                 state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: Postal address.
        :param pulumi.Input[str] city: City name.
        :param pulumi.Input[str] country: Two letter country code (ISO 3166-1 alpha-2), e.g. US.
        :param pulumi.Input[str] zip_code: Zip Code.
        :param pulumi.Input[str] state: State name.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "zip_code", zip_code)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        Postal address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def city(self) -> pulumi.Input[str]:
        """
        City name.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: pulumi.Input[str]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter
    def country(self) -> pulumi.Input[str]:
        """
        Two letter country code (ISO 3166-1 alpha-2), e.g. US.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: pulumi.Input[str]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> pulumi.Input[str]:
        """
        Zip Code.
        """
        return pulumi.get(self, "zip_code")

    @zip_code.setter
    def zip_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "zip_code", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State name.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class MetalProjectBgpConfigArgs:
    def __init__(__self__, *,
                 asn: pulumi.Input[int],
                 deployment_type: pulumi.Input[str],
                 max_prefix: Optional[pulumi.Input[int]] = None,
                 md5: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] asn: Autonomous System Number for local BGP deployment.
        :param pulumi.Input[str] deployment_type: `private` or `public`, the `private` is likely to be usable immediately, the
               `public` will need to be reviewed by Equinix Metal engineers.
        :param pulumi.Input[int] max_prefix: The maximum number of route filters allowed per server.
        :param pulumi.Input[str] md5: Password for BGP session in plaintext (not a checksum).
        :param pulumi.Input[str] status: status of BGP configuration in the project.
        """
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "deployment_type", deployment_type)
        if max_prefix is not None:
            pulumi.set(__self__, "max_prefix", max_prefix)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def asn(self) -> pulumi.Input[int]:
        """
        Autonomous System Number for local BGP deployment.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: pulumi.Input[int]):
        pulumi.set(self, "asn", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[str]:
        """
        `private` or `public`, the `private` is likely to be usable immediately, the
        `public` will need to be reviewed by Equinix Metal engineers.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="maxPrefix")
    def max_prefix(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of route filters allowed per server.
        """
        return pulumi.get(self, "max_prefix")

    @max_prefix.setter
    def max_prefix(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_prefix", value)

    @property
    @pulumi.getter
    def md5(self) -> Optional[pulumi.Input[str]]:
        """
        Password for BGP session in plaintext (not a checksum).
        """
        return pulumi.get(self, "md5")

    @md5.setter
    def md5(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "md5", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        status of BGP configuration in the project.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class MetalSpotMarketRequestInstanceParametersArgs:
    def __init__(__self__, *,
                 billing_cycle: pulumi.Input[str],
                 hostname: pulumi.Input[str],
                 operating_system: pulumi.Input[str],
                 plan: pulumi.Input[str],
                 always_pxe: Optional[pulumi.Input[bool]] = None,
                 customdata: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipxe_script_url: Optional[pulumi.Input[str]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 project_ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termintation_time: Optional[pulumi.Input[str]] = None,
                 user_ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 userdata: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] locked: Blocks deletion of the SpotMarketRequest device until the lock is disabled.
        """
        pulumi.set(__self__, "billing_cycle", billing_cycle)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "operating_system", operating_system)
        pulumi.set(__self__, "plan", plan)
        if always_pxe is not None:
            pulumi.set(__self__, "always_pxe", always_pxe)
        if customdata is not None:
            pulumi.set(__self__, "customdata", customdata)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if ipxe_script_url is not None:
            pulumi.set(__self__, "ipxe_script_url", ipxe_script_url)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if project_ssh_keys is not None:
            pulumi.set(__self__, "project_ssh_keys", project_ssh_keys)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termintation_time is not None:
            pulumi.set(__self__, "termintation_time", termintation_time)
        if user_ssh_keys is not None:
            pulumi.set(__self__, "user_ssh_keys", user_ssh_keys)
        if userdata is not None:
            pulumi.set(__self__, "userdata", userdata)

    @property
    @pulumi.getter(name="billingCycle")
    def billing_cycle(self) -> pulumi.Input[str]:
        return pulumi.get(self, "billing_cycle")

    @billing_cycle.setter
    def billing_cycle(self, value: pulumi.Input[str]):
        pulumi.set(self, "billing_cycle", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> pulumi.Input[str]:
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: pulumi.Input[str]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Input[str]:
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="alwaysPxe")
    def always_pxe(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "always_pxe")

    @always_pxe.setter
    def always_pxe(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "always_pxe", value)

    @property
    @pulumi.getter
    def customdata(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "customdata")

    @customdata.setter
    def customdata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customdata", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="ipxeScriptUrl")
    def ipxe_script_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ipxe_script_url")

    @ipxe_script_url.setter
    def ipxe_script_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipxe_script_url", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[bool]]:
        """
        Blocks deletion of the SpotMarketRequest device until the lock is disabled.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter(name="projectSshKeys")
    def project_ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "project_ssh_keys")

    @project_ssh_keys.setter
    def project_ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "project_ssh_keys", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="termintationTime")
    def termintation_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "termintation_time")

    @termintation_time.setter
    def termintation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "termintation_time", value)

    @property
    @pulumi.getter(name="userSshKeys")
    def user_ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "user_ssh_keys")

    @user_ssh_keys.setter
    def user_ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_ssh_keys", value)

    @property
    @pulumi.getter
    def userdata(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "userdata")

    @userdata.setter
    def userdata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "userdata", value)


@pulumi.input_type
class NetworkACLTemplateDeviceDetailArgs:
    def __init__(__self__, *,
                 acl_status: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] acl_status: Device ACL provisioning status where template was applied. One of `PROVISIONING`,
               `PROVISIONED`.
        :param pulumi.Input[str] name: ACL template name.
        :param pulumi.Input[str] uuid: Device uuid.
        """
        if acl_status is not None:
            pulumi.set(__self__, "acl_status", acl_status)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="aclStatus")
    def acl_status(self) -> Optional[pulumi.Input[str]]:
        """
        Device ACL provisioning status where template was applied. One of `PROVISIONING`,
        `PROVISIONED`.
        """
        return pulumi.get(self, "acl_status")

    @acl_status.setter
    def acl_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_status", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        ACL template name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Device uuid.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)


@pulumi.input_type
class NetworkACLTemplateInboundRuleArgs:
    def __init__(__self__, *,
                 dst_port: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 src_port: pulumi.Input[str],
                 sequence_number: Optional[pulumi.Input[int]] = None,
                 source_type: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dst_port: Inbound traffic destination ports. Allowed values are a comma separated
               list of ports, e.g., `20,22,23`, port range, e.g., `1023-1040` or word `any`.
        :param pulumi.Input[str] protocol: Inbound traffic protocol. One of `IP`, `TCP`, `UDP`.
        :param pulumi.Input[str] src_port: Inbound traffic source ports. Allowed values are a comma separated list
               of ports, e.g., `20,22,23`, port range, e.g., `1023-1040` or word `any`.
        :param pulumi.Input[str] subnet: Inbound traffic source IP subnet in CIDR format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: Inbound traffic source IP subnets in CIDR format.
        """
        pulumi.set(__self__, "dst_port", dst_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "src_port", src_port)
        if sequence_number is not None:
            pulumi.set(__self__, "sequence_number", sequence_number)
        if source_type is not None:
            warnings.warn("""Source Type will not be returned""", DeprecationWarning)
            pulumi.log.warn("""source_type is deprecated: Source Type will not be returned""")
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if subnets is not None:
            warnings.warn("""Use Subnet instead""", DeprecationWarning)
            pulumi.log.warn("""subnets is deprecated: Use Subnet instead""")
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> pulumi.Input[str]:
        """
        Inbound traffic destination ports. Allowed values are a comma separated
        list of ports, e.g., `20,22,23`, port range, e.g., `1023-1040` or word `any`.
        """
        return pulumi.get(self, "dst_port")

    @dst_port.setter
    def dst_port(self, value: pulumi.Input[str]):
        pulumi.set(self, "dst_port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        Inbound traffic protocol. One of `IP`, `TCP`, `UDP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> pulumi.Input[str]:
        """
        Inbound traffic source ports. Allowed values are a comma separated list
        of ports, e.g., `20,22,23`, port range, e.g., `1023-1040` or word `any`.
        """
        return pulumi.get(self, "src_port")

    @src_port.setter
    def src_port(self, value: pulumi.Input[str]):
        pulumi.set(self, "src_port", value)

    @property
    @pulumi.getter(name="sequenceNumber")
    def sequence_number(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "sequence_number")

    @sequence_number.setter
    def sequence_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sequence_number", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Inbound traffic source IP subnet in CIDR format.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Inbound traffic source IP subnets in CIDR format.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnets", value)


@pulumi.input_type
class NetworkDeviceClusterDetailsArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[str],
                 node0: pulumi.Input['NetworkDeviceClusterDetailsNode0Args'],
                 node1: pulumi.Input['NetworkDeviceClusterDetailsNode1Args'],
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 num_of_nodes: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] cluster_name: The name of the cluster device
        :param pulumi.Input['NetworkDeviceClusterDetailsNode0Args'] node0: An object that has `node0` configuration.
               See Cluster Details - Nodes below for more details.
        :param pulumi.Input['NetworkDeviceClusterDetailsNode1Args'] node1: An object that has `node1` configuration.
               See Cluster Details - Nodes below for more details.
        :param pulumi.Input[str] cluster_id: The ID of the cluster.
        :param pulumi.Input[int] num_of_nodes: The number of nodes in the cluster.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "node0", node0)
        pulumi.set(__self__, "node1", node1)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if num_of_nodes is not None:
            pulumi.set(__self__, "num_of_nodes", num_of_nodes)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        The name of the cluster device
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def node0(self) -> pulumi.Input['NetworkDeviceClusterDetailsNode0Args']:
        """
        An object that has `node0` configuration.
        See Cluster Details - Nodes below for more details.
        """
        return pulumi.get(self, "node0")

    @node0.setter
    def node0(self, value: pulumi.Input['NetworkDeviceClusterDetailsNode0Args']):
        pulumi.set(self, "node0", value)

    @property
    @pulumi.getter
    def node1(self) -> pulumi.Input['NetworkDeviceClusterDetailsNode1Args']:
        """
        An object that has `node1` configuration.
        See Cluster Details - Nodes below for more details.
        """
        return pulumi.get(self, "node1")

    @node1.setter
    def node1(self, value: pulumi.Input['NetworkDeviceClusterDetailsNode1Args']):
        pulumi.set(self, "node1", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="numOfNodes")
    def num_of_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes in the cluster.
        """
        return pulumi.get(self, "num_of_nodes")

    @num_of_nodes.setter
    def num_of_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_of_nodes", value)


@pulumi.input_type
class NetworkDeviceClusterDetailsNode0Args:
    def __init__(__self__, *,
                 license_file_id: Optional[pulumi.Input[str]] = None,
                 license_token: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 vendor_configuration: Optional[pulumi.Input['NetworkDeviceClusterDetailsNode0VendorConfigurationArgs']] = None):
        """
        :param pulumi.Input[str] license_file_id: License file id. This is necessary for Fortinet and Juniper clusters.
        :param pulumi.Input[str] license_token: License token. This is necessary for Palo Alto clusters.
        :param pulumi.Input[str] name: Device name.
        :param pulumi.Input[str] uuid: Device unique identifier.
        :param pulumi.Input['NetworkDeviceClusterDetailsNode0VendorConfigurationArgs'] vendor_configuration: An object that has fields relevant to the vendor of the
               cluster device. See Cluster Details - Nodes - Vendor Configuration
               below for more details.
        """
        if license_file_id is not None:
            pulumi.set(__self__, "license_file_id", license_file_id)
        if license_token is not None:
            pulumi.set(__self__, "license_token", license_token)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if vendor_configuration is not None:
            pulumi.set(__self__, "vendor_configuration", vendor_configuration)

    @property
    @pulumi.getter(name="licenseFileId")
    def license_file_id(self) -> Optional[pulumi.Input[str]]:
        """
        License file id. This is necessary for Fortinet and Juniper clusters.
        """
        return pulumi.get(self, "license_file_id")

    @license_file_id.setter
    def license_file_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_file_id", value)

    @property
    @pulumi.getter(name="licenseToken")
    def license_token(self) -> Optional[pulumi.Input[str]]:
        """
        License token. This is necessary for Palo Alto clusters.
        """
        return pulumi.get(self, "license_token")

    @license_token.setter
    def license_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_token", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Device name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Device unique identifier.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter(name="vendorConfiguration")
    def vendor_configuration(self) -> Optional[pulumi.Input['NetworkDeviceClusterDetailsNode0VendorConfigurationArgs']]:
        """
        An object that has fields relevant to the vendor of the
        cluster device. See Cluster Details - Nodes - Vendor Configuration
        below for more details.
        """
        return pulumi.get(self, "vendor_configuration")

    @vendor_configuration.setter
    def vendor_configuration(self, value: Optional[pulumi.Input['NetworkDeviceClusterDetailsNode0VendorConfigurationArgs']]):
        pulumi.set(self, "vendor_configuration", value)


@pulumi.input_type
class NetworkDeviceClusterDetailsNode0VendorConfigurationArgs:
    def __init__(__self__, *,
                 activation_key: Optional[pulumi.Input[str]] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 controller1: Optional[pulumi.Input[str]] = None,
                 controller_fqdn: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 root_password: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] activation_key: Activation key. This is required for Velocloud clusters.
        :param pulumi.Input[str] admin_password: The administrative password of the device. You can use it to log in
               to the console. This field is not available for all device types.
        :param pulumi.Input[str] controller1: System IP Address. Mandatory for the Fortinet SDWAN cluster device.
        :param pulumi.Input[str] controller_fqdn: Controller fqdn. This is required for Velocloud clusters.
        :param pulumi.Input[str] hostname: Hostname. This is necessary for Palo Alto, Juniper, and Fortinet clusters.
        :param pulumi.Input[str] root_password: The CLI password of the device. This field is relevant only for the
               Velocloud SDWAN cluster.
        """
        if activation_key is not None:
            pulumi.set(__self__, "activation_key", activation_key)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if controller1 is not None:
            pulumi.set(__self__, "controller1", controller1)
        if controller_fqdn is not None:
            pulumi.set(__self__, "controller_fqdn", controller_fqdn)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> Optional[pulumi.Input[str]]:
        """
        Activation key. This is required for Velocloud clusters.
        """
        return pulumi.get(self, "activation_key")

    @activation_key.setter
    def activation_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_key", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        The administrative password of the device. You can use it to log in
        to the console. This field is not available for all device types.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter
    def controller1(self) -> Optional[pulumi.Input[str]]:
        """
        System IP Address. Mandatory for the Fortinet SDWAN cluster device.
        """
        return pulumi.get(self, "controller1")

    @controller1.setter
    def controller1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller1", value)

    @property
    @pulumi.getter(name="controllerFqdn")
    def controller_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Controller fqdn. This is required for Velocloud clusters.
        """
        return pulumi.get(self, "controller_fqdn")

    @controller_fqdn.setter
    def controller_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_fqdn", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname. This is necessary for Palo Alto, Juniper, and Fortinet clusters.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[str]]:
        """
        The CLI password of the device. This field is relevant only for the
        Velocloud SDWAN cluster.
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_password", value)


@pulumi.input_type
class NetworkDeviceClusterDetailsNode1Args:
    def __init__(__self__, *,
                 license_file_id: Optional[pulumi.Input[str]] = None,
                 license_token: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 vendor_configuration: Optional[pulumi.Input['NetworkDeviceClusterDetailsNode1VendorConfigurationArgs']] = None):
        """
        :param pulumi.Input[str] license_file_id: License file id. This is necessary for Fortinet and Juniper clusters.
        :param pulumi.Input[str] license_token: License token. This is necessary for Palo Alto clusters.
        :param pulumi.Input[str] name: Device name.
        :param pulumi.Input[str] uuid: Device unique identifier.
        :param pulumi.Input['NetworkDeviceClusterDetailsNode1VendorConfigurationArgs'] vendor_configuration: An object that has fields relevant to the vendor of the
               cluster device. See Cluster Details - Nodes - Vendor Configuration
               below for more details.
        """
        if license_file_id is not None:
            pulumi.set(__self__, "license_file_id", license_file_id)
        if license_token is not None:
            pulumi.set(__self__, "license_token", license_token)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if vendor_configuration is not None:
            pulumi.set(__self__, "vendor_configuration", vendor_configuration)

    @property
    @pulumi.getter(name="licenseFileId")
    def license_file_id(self) -> Optional[pulumi.Input[str]]:
        """
        License file id. This is necessary for Fortinet and Juniper clusters.
        """
        return pulumi.get(self, "license_file_id")

    @license_file_id.setter
    def license_file_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_file_id", value)

    @property
    @pulumi.getter(name="licenseToken")
    def license_token(self) -> Optional[pulumi.Input[str]]:
        """
        License token. This is necessary for Palo Alto clusters.
        """
        return pulumi.get(self, "license_token")

    @license_token.setter
    def license_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_token", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Device name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Device unique identifier.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter(name="vendorConfiguration")
    def vendor_configuration(self) -> Optional[pulumi.Input['NetworkDeviceClusterDetailsNode1VendorConfigurationArgs']]:
        """
        An object that has fields relevant to the vendor of the
        cluster device. See Cluster Details - Nodes - Vendor Configuration
        below for more details.
        """
        return pulumi.get(self, "vendor_configuration")

    @vendor_configuration.setter
    def vendor_configuration(self, value: Optional[pulumi.Input['NetworkDeviceClusterDetailsNode1VendorConfigurationArgs']]):
        pulumi.set(self, "vendor_configuration", value)


@pulumi.input_type
class NetworkDeviceClusterDetailsNode1VendorConfigurationArgs:
    def __init__(__self__, *,
                 activation_key: Optional[pulumi.Input[str]] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 controller1: Optional[pulumi.Input[str]] = None,
                 controller_fqdn: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 root_password: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] activation_key: Activation key. This is required for Velocloud clusters.
        :param pulumi.Input[str] admin_password: The administrative password of the device. You can use it to log in
               to the console. This field is not available for all device types.
        :param pulumi.Input[str] controller1: System IP Address. Mandatory for the Fortinet SDWAN cluster device.
        :param pulumi.Input[str] controller_fqdn: Controller fqdn. This is required for Velocloud clusters.
        :param pulumi.Input[str] hostname: Hostname. This is necessary for Palo Alto, Juniper, and Fortinet clusters.
        :param pulumi.Input[str] root_password: The CLI password of the device. This field is relevant only for the
               Velocloud SDWAN cluster.
        """
        if activation_key is not None:
            pulumi.set(__self__, "activation_key", activation_key)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if controller1 is not None:
            pulumi.set(__self__, "controller1", controller1)
        if controller_fqdn is not None:
            pulumi.set(__self__, "controller_fqdn", controller_fqdn)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> Optional[pulumi.Input[str]]:
        """
        Activation key. This is required for Velocloud clusters.
        """
        return pulumi.get(self, "activation_key")

    @activation_key.setter
    def activation_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_key", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        The administrative password of the device. You can use it to log in
        to the console. This field is not available for all device types.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter
    def controller1(self) -> Optional[pulumi.Input[str]]:
        """
        System IP Address. Mandatory for the Fortinet SDWAN cluster device.
        """
        return pulumi.get(self, "controller1")

    @controller1.setter
    def controller1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller1", value)

    @property
    @pulumi.getter(name="controllerFqdn")
    def controller_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Controller fqdn. This is required for Velocloud clusters.
        """
        return pulumi.get(self, "controller_fqdn")

    @controller_fqdn.setter
    def controller_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_fqdn", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname. This is necessary for Palo Alto, Juniper, and Fortinet clusters.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[str]]:
        """
        The CLI password of the device. This field is relevant only for the
        Velocloud SDWAN cluster.
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_password", value)


@pulumi.input_type
class NetworkDeviceInterfaceArgs:
    def __init__(__self__, *,
                 assigned_type: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[int]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operational_status: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] assigned_type: interface management type (Equinix Managed or empty).
        :param pulumi.Input[int] id: interface identifier.
        :param pulumi.Input[str] ip_address: interface IP address.
        :param pulumi.Input[str] mac_address: interface MAC address.
        :param pulumi.Input[str] name: Device name.
        :param pulumi.Input[str] operational_status: interface operational status. One of `up`, `down`.
        :param pulumi.Input[str] status: interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        :param pulumi.Input[str] type: interface type.
        """
        if assigned_type is not None:
            pulumi.set(__self__, "assigned_type", assigned_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operational_status is not None:
            pulumi.set(__self__, "operational_status", operational_status)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="assignedType")
    def assigned_type(self) -> Optional[pulumi.Input[str]]:
        """
        interface management type (Equinix Managed or empty).
        """
        return pulumi.get(self, "assigned_type")

    @assigned_type.setter
    def assigned_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assigned_type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[int]]:
        """
        interface identifier.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        interface IP address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        interface MAC address.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Device name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="operationalStatus")
    def operational_status(self) -> Optional[pulumi.Input[str]]:
        """
        interface operational status. One of `up`, `down`.
        """
        return pulumi.get(self, "operational_status")

    @operational_status.setter
    def operational_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operational_status", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        interface type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class NetworkDeviceLinkDeviceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 asn: Optional[pulumi.Input[int]] = None,
                 interface_id: Optional[pulumi.Input[int]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: Device identifier.
        :param pulumi.Input[int] asn: Device ASN number. Not required for self configured devices.
        :param pulumi.Input[int] interface_id: Device network interface identifier to use for device link
               connection.
        :param pulumi.Input[str] ip_address: IP address from device link subnet that was assigned to the device
        :param pulumi.Input[str] status: device link provisioning status on a given device. One of `PROVISIONING`,
               `PROVISIONED`, `DEPROVISIONING`, `DEPROVISIONED`, `FAILED`.
        """
        pulumi.set(__self__, "id", id)
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if interface_id is not None:
            pulumi.set(__self__, "interface_id", interface_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Device identifier.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[int]]:
        """
        Device ASN number. Not required for self configured devices.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "asn", value)

    @property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> Optional[pulumi.Input[int]]:
        """
        Device network interface identifier to use for device link
        connection.
        """
        return pulumi.get(self, "interface_id")

    @interface_id.setter
    def interface_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interface_id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address from device link subnet that was assigned to the device
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        device link provisioning status on a given device. One of `PROVISIONING`,
        `PROVISIONED`, `DEPROVISIONING`, `DEPROVISIONED`, `FAILED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class NetworkDeviceLinkLinkArgs:
    def __init__(__self__, *,
                 account_number: pulumi.Input[str],
                 dst_metro_code: pulumi.Input[str],
                 src_metro_code: pulumi.Input[str],
                 throughput: pulumi.Input[str],
                 throughput_unit: pulumi.Input[str],
                 dst_zone_code: Optional[pulumi.Input[str]] = None,
                 src_zone_code: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] account_number: billing account number to be used for
               connection charges
        :param pulumi.Input[str] dst_metro_code: connection destination metro code.
        :param pulumi.Input[str] src_metro_code: connection source metro code.
        :param pulumi.Input[str] throughput: connection throughput.
        :param pulumi.Input[str] throughput_unit: connection throughput unit (Mbps or Gbps).
        :param pulumi.Input[str] dst_zone_code: connection destination zone code is not required.
        :param pulumi.Input[str] src_zone_code: connection source zone code is not required.
        """
        pulumi.set(__self__, "account_number", account_number)
        pulumi.set(__self__, "dst_metro_code", dst_metro_code)
        pulumi.set(__self__, "src_metro_code", src_metro_code)
        pulumi.set(__self__, "throughput", throughput)
        pulumi.set(__self__, "throughput_unit", throughput_unit)
        if dst_zone_code is not None:
            warnings.warn("""DestinationZoneCode is not required""", DeprecationWarning)
            pulumi.log.warn("""dst_zone_code is deprecated: DestinationZoneCode is not required""")
        if dst_zone_code is not None:
            pulumi.set(__self__, "dst_zone_code", dst_zone_code)
        if src_zone_code is not None:
            warnings.warn("""SourceZoneCode is not required""", DeprecationWarning)
            pulumi.log.warn("""src_zone_code is deprecated: SourceZoneCode is not required""")
        if src_zone_code is not None:
            pulumi.set(__self__, "src_zone_code", src_zone_code)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> pulumi.Input[str]:
        """
        billing account number to be used for
        connection charges
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_number", value)

    @property
    @pulumi.getter(name="dstMetroCode")
    def dst_metro_code(self) -> pulumi.Input[str]:
        """
        connection destination metro code.
        """
        return pulumi.get(self, "dst_metro_code")

    @dst_metro_code.setter
    def dst_metro_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "dst_metro_code", value)

    @property
    @pulumi.getter(name="srcMetroCode")
    def src_metro_code(self) -> pulumi.Input[str]:
        """
        connection source metro code.
        """
        return pulumi.get(self, "src_metro_code")

    @src_metro_code.setter
    def src_metro_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "src_metro_code", value)

    @property
    @pulumi.getter
    def throughput(self) -> pulumi.Input[str]:
        """
        connection throughput.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: pulumi.Input[str]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="throughputUnit")
    def throughput_unit(self) -> pulumi.Input[str]:
        """
        connection throughput unit (Mbps or Gbps).
        """
        return pulumi.get(self, "throughput_unit")

    @throughput_unit.setter
    def throughput_unit(self, value: pulumi.Input[str]):
        pulumi.set(self, "throughput_unit", value)

    @property
    @pulumi.getter(name="dstZoneCode")
    def dst_zone_code(self) -> Optional[pulumi.Input[str]]:
        """
        connection destination zone code is not required.
        """
        return pulumi.get(self, "dst_zone_code")

    @dst_zone_code.setter
    def dst_zone_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_zone_code", value)

    @property
    @pulumi.getter(name="srcZoneCode")
    def src_zone_code(self) -> Optional[pulumi.Input[str]]:
        """
        connection source zone code is not required.
        """
        return pulumi.get(self, "src_zone_code")

    @src_zone_code.setter
    def src_zone_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_zone_code", value)


@pulumi.input_type
class NetworkDeviceSecondaryDeviceArgs:
    def __init__(__self__, *,
                 account_number: pulumi.Input[str],
                 metro_code: pulumi.Input[str],
                 name: pulumi.Input[str],
                 notifications: pulumi.Input[Sequence[pulumi.Input[str]]],
                 acl_template_id: Optional[pulumi.Input[str]] = None,
                 additional_bandwidth: Optional[pulumi.Input[int]] = None,
                 asn: Optional[pulumi.Input[int]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ibx: Optional[pulumi.Input[str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceSecondaryDeviceInterfaceArgs']]]] = None,
                 license_file: Optional[pulumi.Input[str]] = None,
                 license_file_id: Optional[pulumi.Input[str]] = None,
                 license_status: Optional[pulumi.Input[str]] = None,
                 license_token: Optional[pulumi.Input[str]] = None,
                 mgmt_acl_template_uuid: Optional[pulumi.Input[str]] = None,
                 redundancy_type: Optional[pulumi.Input[str]] = None,
                 redundant_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 ssh_ip_address: Optional[pulumi.Input[str]] = None,
                 ssh_ip_fqdn: Optional[pulumi.Input[str]] = None,
                 ssh_key: Optional[pulumi.Input['NetworkDeviceSecondaryDeviceSshKeyArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 vendor_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 wan_interface_id: Optional[pulumi.Input[str]] = None,
                 zone_code: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] account_number: Billing account number for secondary device.
        :param pulumi.Input[str] metro_code: Metro location of a secondary device.
        :param pulumi.Input[str] name: Secondary device name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: List of email addresses that will receive notifications about
               secondary device.
        :param pulumi.Input[str] acl_template_id: Identifier of a WAN interface ACL template that will be applied
               on a secondary device.
        :param pulumi.Input[int] additional_bandwidth: Additional Internet bandwidth, in Mbps, for a secondary
               device.
        :param pulumi.Input[int] asn: (Autonomous System Number) Unique identifier for a network on the internet.
        :param pulumi.Input[str] hostname: Secondary device hostname.
        :param pulumi.Input[str] ibx: Device location Equinix Business Exchange name.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkDeviceSecondaryDeviceInterfaceArgs']]] interfaces: List of device interfaces. See Interface Attribute below
               for more details.
        :param pulumi.Input[str] license_file: Path to the license file that will be uploaded and applied on a
               secondary device. Applicable for some devices types in BYOL licensing mode.
        :param pulumi.Input[str] license_file_id: License file id. This is necessary for Fortinet and Juniper clusters.
        :param pulumi.Input[str] license_status: Device license registration status. Possible values are `APPLYING_LICENSE`,
               `REGISTERED`, `APPLIED`, `WAITING_FOR_CLUSTER_SETUP`, `REGISTRATION_FAILED`.
        :param pulumi.Input[str] license_token: License Token can be provided for some device types o the device.
        :param pulumi.Input[str] mgmt_acl_template_uuid: Identifier of an MGMT interface ACL template that will be
               applied on the device.
               * `ssh-key` - (Optional) Up to one definition of SSH key that will be provisioned on a secondary
               device.
        :param pulumi.Input[str] redundancy_type: Device redundancy type applicable for HA devices, either
               primary or secondary.
        :param pulumi.Input[str] redundant_id: Unique identifier for a redundant device applicable for HA devices.
        :param pulumi.Input[str] region: Device location region.
        :param pulumi.Input[str] ssh_ip_address: IP address of SSH enabled interface on the device.
        :param pulumi.Input[str] ssh_ip_fqdn: FQDN of SSH enabled interface on the device.
        :param pulumi.Input[str] status: interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        :param pulumi.Input[str] uuid: Device unique identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] vendor_configuration: Key/Value pairs of vendor specific configuration parameters
               for a secondary device. Key values are `controller1`, `activationKey`, `managementType`, `siteId`,
               `systemIpAddress`.
        :param pulumi.Input[str] zone_code: Device location zone code.
        """
        pulumi.set(__self__, "account_number", account_number)
        pulumi.set(__self__, "metro_code", metro_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "notifications", notifications)
        if acl_template_id is not None:
            pulumi.set(__self__, "acl_template_id", acl_template_id)
        if additional_bandwidth is not None:
            pulumi.set(__self__, "additional_bandwidth", additional_bandwidth)
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ibx is not None:
            pulumi.set(__self__, "ibx", ibx)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if license_file is not None:
            pulumi.set(__self__, "license_file", license_file)
        if license_file_id is not None:
            pulumi.set(__self__, "license_file_id", license_file_id)
        if license_status is not None:
            pulumi.set(__self__, "license_status", license_status)
        if license_token is not None:
            pulumi.set(__self__, "license_token", license_token)
        if mgmt_acl_template_uuid is not None:
            pulumi.set(__self__, "mgmt_acl_template_uuid", mgmt_acl_template_uuid)
        if redundancy_type is not None:
            pulumi.set(__self__, "redundancy_type", redundancy_type)
        if redundant_id is not None:
            pulumi.set(__self__, "redundant_id", redundant_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if ssh_ip_address is not None:
            pulumi.set(__self__, "ssh_ip_address", ssh_ip_address)
        if ssh_ip_fqdn is not None:
            pulumi.set(__self__, "ssh_ip_fqdn", ssh_ip_fqdn)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if vendor_configuration is not None:
            pulumi.set(__self__, "vendor_configuration", vendor_configuration)
        if wan_interface_id is not None:
            pulumi.set(__self__, "wan_interface_id", wan_interface_id)
        if zone_code is not None:
            pulumi.set(__self__, "zone_code", zone_code)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> pulumi.Input[str]:
        """
        Billing account number for secondary device.
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_number", value)

    @property
    @pulumi.getter(name="metroCode")
    def metro_code(self) -> pulumi.Input[str]:
        """
        Metro location of a secondary device.
        """
        return pulumi.get(self, "metro_code")

    @metro_code.setter
    def metro_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "metro_code", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Secondary device name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notifications(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of email addresses that will receive notifications about
        secondary device.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter(name="aclTemplateId")
    def acl_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of a WAN interface ACL template that will be applied
        on a secondary device.
        """
        return pulumi.get(self, "acl_template_id")

    @acl_template_id.setter
    def acl_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_template_id", value)

    @property
    @pulumi.getter(name="additionalBandwidth")
    def additional_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Additional Internet bandwidth, in Mbps, for a secondary
        device.
        """
        return pulumi.get(self, "additional_bandwidth")

    @additional_bandwidth.setter
    def additional_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_bandwidth", value)

    @property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[int]]:
        """
        (Autonomous System Number) Unique identifier for a network on the internet.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "asn", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary device hostname.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ibx(self) -> Optional[pulumi.Input[str]]:
        """
        Device location Equinix Business Exchange name.
        """
        return pulumi.get(self, "ibx")

    @ibx.setter
    def ibx(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ibx", value)

    @property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceSecondaryDeviceInterfaceArgs']]]]:
        """
        List of device interfaces. See Interface Attribute below
        for more details.
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceSecondaryDeviceInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @property
    @pulumi.getter(name="licenseFile")
    def license_file(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the license file that will be uploaded and applied on a
        secondary device. Applicable for some devices types in BYOL licensing mode.
        """
        return pulumi.get(self, "license_file")

    @license_file.setter
    def license_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_file", value)

    @property
    @pulumi.getter(name="licenseFileId")
    def license_file_id(self) -> Optional[pulumi.Input[str]]:
        """
        License file id. This is necessary for Fortinet and Juniper clusters.
        """
        return pulumi.get(self, "license_file_id")

    @license_file_id.setter
    def license_file_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_file_id", value)

    @property
    @pulumi.getter(name="licenseStatus")
    def license_status(self) -> Optional[pulumi.Input[str]]:
        """
        Device license registration status. Possible values are `APPLYING_LICENSE`,
        `REGISTERED`, `APPLIED`, `WAITING_FOR_CLUSTER_SETUP`, `REGISTRATION_FAILED`.
        """
        return pulumi.get(self, "license_status")

    @license_status.setter
    def license_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_status", value)

    @property
    @pulumi.getter(name="licenseToken")
    def license_token(self) -> Optional[pulumi.Input[str]]:
        """
        License Token can be provided for some device types o the device.
        """
        return pulumi.get(self, "license_token")

    @license_token.setter
    def license_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_token", value)

    @property
    @pulumi.getter(name="mgmtAclTemplateUuid")
    def mgmt_acl_template_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of an MGMT interface ACL template that will be
        applied on the device.
        * `ssh-key` - (Optional) Up to one definition of SSH key that will be provisioned on a secondary
        device.
        """
        return pulumi.get(self, "mgmt_acl_template_uuid")

    @mgmt_acl_template_uuid.setter
    def mgmt_acl_template_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mgmt_acl_template_uuid", value)

    @property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> Optional[pulumi.Input[str]]:
        """
        Device redundancy type applicable for HA devices, either
        primary or secondary.
        """
        return pulumi.get(self, "redundancy_type")

    @redundancy_type.setter
    def redundancy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundancy_type", value)

    @property
    @pulumi.getter(name="redundantId")
    def redundant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for a redundant device applicable for HA devices.
        """
        return pulumi.get(self, "redundant_id")

    @redundant_id.setter
    def redundant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundant_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Device location region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sshIpAddress")
    def ssh_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of SSH enabled interface on the device.
        """
        return pulumi.get(self, "ssh_ip_address")

    @ssh_ip_address.setter
    def ssh_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_ip_address", value)

    @property
    @pulumi.getter(name="sshIpFqdn")
    def ssh_ip_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        FQDN of SSH enabled interface on the device.
        """
        return pulumi.get(self, "ssh_ip_fqdn")

    @ssh_ip_fqdn.setter
    def ssh_ip_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_ip_fqdn", value)

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input['NetworkDeviceSecondaryDeviceSshKeyArgs']]:
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input['NetworkDeviceSecondaryDeviceSshKeyArgs']]):
        pulumi.set(self, "ssh_key", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Device unique identifier.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter(name="vendorConfiguration")
    def vendor_configuration(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key/Value pairs of vendor specific configuration parameters
        for a secondary device. Key values are `controller1`, `activationKey`, `managementType`, `siteId`,
        `systemIpAddress`.
        """
        return pulumi.get(self, "vendor_configuration")

    @vendor_configuration.setter
    def vendor_configuration(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "vendor_configuration", value)

    @property
    @pulumi.getter(name="wanInterfaceId")
    def wan_interface_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "wan_interface_id")

    @wan_interface_id.setter
    def wan_interface_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_interface_id", value)

    @property
    @pulumi.getter(name="zoneCode")
    def zone_code(self) -> Optional[pulumi.Input[str]]:
        """
        Device location zone code.
        """
        return pulumi.get(self, "zone_code")

    @zone_code.setter
    def zone_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_code", value)


@pulumi.input_type
class NetworkDeviceSecondaryDeviceInterfaceArgs:
    def __init__(__self__, *,
                 assigned_type: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[int]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operational_status: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] assigned_type: interface management type (Equinix Managed or empty).
        :param pulumi.Input[int] id: interface identifier.
        :param pulumi.Input[str] ip_address: interface IP address.
        :param pulumi.Input[str] mac_address: interface MAC address.
        :param pulumi.Input[str] name: Device name.
        :param pulumi.Input[str] operational_status: interface operational status. One of `up`, `down`.
        :param pulumi.Input[str] status: interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        :param pulumi.Input[str] type: interface type.
        """
        if assigned_type is not None:
            pulumi.set(__self__, "assigned_type", assigned_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operational_status is not None:
            pulumi.set(__self__, "operational_status", operational_status)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="assignedType")
    def assigned_type(self) -> Optional[pulumi.Input[str]]:
        """
        interface management type (Equinix Managed or empty).
        """
        return pulumi.get(self, "assigned_type")

    @assigned_type.setter
    def assigned_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assigned_type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[int]]:
        """
        interface identifier.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        interface IP address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        interface MAC address.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Device name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="operationalStatus")
    def operational_status(self) -> Optional[pulumi.Input[str]]:
        """
        interface operational status. One of `up`, `down`.
        """
        return pulumi.get(self, "operational_status")

    @operational_status.setter
    def operational_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operational_status", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        interface type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class NetworkDeviceSecondaryDeviceSshKeyArgs:
    def __init__(__self__, *,
                 key_name: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] username: username associated with given key.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        username associated with given key.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class NetworkDeviceSshKeyArgs:
    def __init__(__self__, *,
                 key_name: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] username: username associated with given key.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        username associated with given key.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


