# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ECXL2ConnectionArgs', 'ECXL2Connection']

@pulumi.input_type
class ECXL2ConnectionArgs:
    def __init__(__self__, *,
                 notifications: pulumi.Input[Sequence[pulumi.Input[str]]],
                 speed: pulumi.Input[int],
                 speed_unit: pulumi.Input[str],
                 additional_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionAdditionalInfoArgs']]]] = None,
                 authorization_key: Optional[pulumi.Input[str]] = None,
                 device_interface_id: Optional[pulumi.Input[int]] = None,
                 device_uuid: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 named_tag: Optional[pulumi.Input[str]] = None,
                 port_uuid: Optional[pulumi.Input[str]] = None,
                 profile_uuid: Optional[pulumi.Input[str]] = None,
                 purchase_order_number: Optional[pulumi.Input[str]] = None,
                 secondary_connection: Optional[pulumi.Input['ECXL2ConnectionSecondaryConnectionArgs']] = None,
                 seller_metro_code: Optional[pulumi.Input[str]] = None,
                 seller_region: Optional[pulumi.Input[str]] = None,
                 service_token: Optional[pulumi.Input[str]] = None,
                 vlan_ctag: Optional[pulumi.Input[int]] = None,
                 vlan_stag: Optional[pulumi.Input[int]] = None,
                 zside_port_uuid: Optional[pulumi.Input[str]] = None,
                 zside_service_token: Optional[pulumi.Input[str]] = None,
                 zside_vlan_ctag: Optional[pulumi.Input[int]] = None,
                 zside_vlan_stag: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a ECXL2Connection resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: A list of email addresses used for sending connection update
               notifications.
        :param pulumi.Input[int] speed: Speed/Bandwidth to be allocated to the connection.
        :param pulumi.Input[str] speed_unit: Unit of the speed/bandwidth to be allocated to the connection.
        :param pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionAdditionalInfoArgs']]] additional_infos: one or more additional information key-value objects
        :param pulumi.Input[str] authorization_key: Unique identifier authorizing Equinix to provision a connection
               towards a cloud service provider. At Equinix, an `Authorization Key` is a generic term and is NOT
               encrypted on Equinix Fabric. Cloud Service Providers might use a different name to refer to this
               key such as `Service Key` or `Authentication Key`. Value depends on a provider service profile,
               more information on [Equinix Fabric how to guide](https://developer.equinix.com/docs/ecx-how-to-guide).
        :param pulumi.Input[int] device_interface_id: Applicable with `device_uuid`, identifier of network interface
               on a given device, used for a connection. If not specified then first available interface will be
               selected.
        :param pulumi.Input[str] device_uuid: Unique identifier of
               the Network Edge virtual device from which the connection would originate.
        :param pulumi.Input[str] name: additional information key
        :param pulumi.Input[str] named_tag: The type of peering to set up when connecting to Azure Express Route.
               Valid values: `PRIVATE`, `MICROSOFT`, `MANUAL`\*, `PUBLIC`\*.
        :param pulumi.Input[str] port_uuid: Unique identifier of
               the Equinix Fabric Port from which the connection would originate.
        :param pulumi.Input[str] profile_uuid: Unique identifier of the service provider's profile.
        :param pulumi.Input[str] purchase_order_number: Connection's purchase order number to reflect on the invoice
        :param pulumi.Input['ECXL2ConnectionSecondaryConnectionArgs'] secondary_connection: Definition of secondary connection for redundant, HA
               connectivity. See Secondary Connection below for more details.
        :param pulumi.Input[str] seller_metro_code: The metro code that denotes the connection’s remote/destination
               side (z-side).
        :param pulumi.Input[str] seller_region: The region in which the seller port resides.
        :param pulumi.Input[str] service_token: - A-side
               service tokens authorize you to create a connection from a customer port, which created the token
               for you, to a service profile or your own port.
               More details in [A-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=the%20service%20token.-,A%2DSide%20Service%20Tokens,-If%20you%20want).
        :param pulumi.Input[int] vlan_ctag: C-Tag/Inner-Tag of the connection - a numeric character ranging from 2
               \- 4094.
        :param pulumi.Input[int] vlan_stag: S-Tag/Outer-Tag of the connection - a numeric
               character ranging from 2 - 4094.
        :param pulumi.Input[str] zside_port_uuid: Unique identifier of the port on the remote/destination side
               (z-side). Allows you to connect between your own ports or virtual devices across your company's
               Equinix Fabric deployment, with no need for a private service profile.
        :param pulumi.Input[str] zside_service_token: - Z-side
               service tokens authorize you to create a connection from your port or virtual device to a customer
               port which created the token for you. `zside_service_token` cannot be used with `secondary_connection`.
               More details in [Z-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=requirements%20per%20provider.-,Z%2DSide%20Service%20Tokens,-If%20you%20want).
        :param pulumi.Input[int] zside_vlan_ctag: C-Tag/Inner-Tag of the connection on the remote/destination
               side (z-side) - a numeric character ranging from 2 - 4094.
               `secondary_connection` is defined it will internally use same `zside_vlan_ctag` for the secondary
               connection.
        :param pulumi.Input[int] zside_vlan_stag: S-Tag/Outer-Tag of the connection on the remote/destination
               side (z-side) - a numeric character ranging from 2 - 4094.
        """
        pulumi.set(__self__, "notifications", notifications)
        pulumi.set(__self__, "speed", speed)
        pulumi.set(__self__, "speed_unit", speed_unit)
        if additional_infos is not None:
            pulumi.set(__self__, "additional_infos", additional_infos)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if device_interface_id is not None:
            pulumi.set(__self__, "device_interface_id", device_interface_id)
        if device_uuid is not None:
            pulumi.set(__self__, "device_uuid", device_uuid)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if named_tag is not None:
            pulumi.set(__self__, "named_tag", named_tag)
        if port_uuid is not None:
            pulumi.set(__self__, "port_uuid", port_uuid)
        if profile_uuid is not None:
            pulumi.set(__self__, "profile_uuid", profile_uuid)
        if purchase_order_number is not None:
            pulumi.set(__self__, "purchase_order_number", purchase_order_number)
        if secondary_connection is not None:
            pulumi.set(__self__, "secondary_connection", secondary_connection)
        if seller_metro_code is not None:
            pulumi.set(__self__, "seller_metro_code", seller_metro_code)
        if seller_region is not None:
            pulumi.set(__self__, "seller_region", seller_region)
        if service_token is not None:
            pulumi.set(__self__, "service_token", service_token)
        if vlan_ctag is not None:
            pulumi.set(__self__, "vlan_ctag", vlan_ctag)
        if vlan_stag is not None:
            pulumi.set(__self__, "vlan_stag", vlan_stag)
        if zside_port_uuid is not None:
            pulumi.set(__self__, "zside_port_uuid", zside_port_uuid)
        if zside_service_token is not None:
            pulumi.set(__self__, "zside_service_token", zside_service_token)
        if zside_vlan_ctag is not None:
            pulumi.set(__self__, "zside_vlan_ctag", zside_vlan_ctag)
        if zside_vlan_stag is not None:
            pulumi.set(__self__, "zside_vlan_stag", zside_vlan_stag)

    @property
    @pulumi.getter
    def notifications(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of email addresses used for sending connection update
        notifications.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter
    def speed(self) -> pulumi.Input[int]:
        """
        Speed/Bandwidth to be allocated to the connection.
        """
        return pulumi.get(self, "speed")

    @speed.setter
    def speed(self, value: pulumi.Input[int]):
        pulumi.set(self, "speed", value)

    @property
    @pulumi.getter(name="speedUnit")
    def speed_unit(self) -> pulumi.Input[str]:
        """
        Unit of the speed/bandwidth to be allocated to the connection.
        """
        return pulumi.get(self, "speed_unit")

    @speed_unit.setter
    def speed_unit(self, value: pulumi.Input[str]):
        pulumi.set(self, "speed_unit", value)

    @property
    @pulumi.getter(name="additionalInfos")
    def additional_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionAdditionalInfoArgs']]]]:
        """
        one or more additional information key-value objects
        """
        return pulumi.get(self, "additional_infos")

    @additional_infos.setter
    def additional_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionAdditionalInfoArgs']]]]):
        pulumi.set(self, "additional_infos", value)

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier authorizing Equinix to provision a connection
        towards a cloud service provider. At Equinix, an `Authorization Key` is a generic term and is NOT
        encrypted on Equinix Fabric. Cloud Service Providers might use a different name to refer to this
        key such as `Service Key` or `Authentication Key`. Value depends on a provider service profile,
        more information on [Equinix Fabric how to guide](https://developer.equinix.com/docs/ecx-how-to-guide).
        """
        return pulumi.get(self, "authorization_key")

    @authorization_key.setter
    def authorization_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_key", value)

    @property
    @pulumi.getter(name="deviceInterfaceId")
    def device_interface_id(self) -> Optional[pulumi.Input[int]]:
        """
        Applicable with `device_uuid`, identifier of network interface
        on a given device, used for a connection. If not specified then first available interface will be
        selected.
        """
        return pulumi.get(self, "device_interface_id")

    @device_interface_id.setter
    def device_interface_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "device_interface_id", value)

    @property
    @pulumi.getter(name="deviceUuid")
    def device_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of
        the Network Edge virtual device from which the connection would originate.
        """
        return pulumi.get(self, "device_uuid")

    @device_uuid.setter
    def device_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_uuid", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        additional information key
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namedTag")
    def named_tag(self) -> Optional[pulumi.Input[str]]:
        """
        The type of peering to set up when connecting to Azure Express Route.
        Valid values: `PRIVATE`, `MICROSOFT`, `MANUAL`\*, `PUBLIC`\*.
        """
        return pulumi.get(self, "named_tag")

    @named_tag.setter
    def named_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "named_tag", value)

    @property
    @pulumi.getter(name="portUuid")
    def port_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of
        the Equinix Fabric Port from which the connection would originate.
        """
        return pulumi.get(self, "port_uuid")

    @port_uuid.setter
    def port_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_uuid", value)

    @property
    @pulumi.getter(name="profileUuid")
    def profile_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the service provider's profile.
        """
        return pulumi.get(self, "profile_uuid")

    @profile_uuid.setter
    def profile_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_uuid", value)

    @property
    @pulumi.getter(name="purchaseOrderNumber")
    def purchase_order_number(self) -> Optional[pulumi.Input[str]]:
        """
        Connection's purchase order number to reflect on the invoice
        """
        return pulumi.get(self, "purchase_order_number")

    @purchase_order_number.setter
    def purchase_order_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purchase_order_number", value)

    @property
    @pulumi.getter(name="secondaryConnection")
    def secondary_connection(self) -> Optional[pulumi.Input['ECXL2ConnectionSecondaryConnectionArgs']]:
        """
        Definition of secondary connection for redundant, HA
        connectivity. See Secondary Connection below for more details.
        """
        return pulumi.get(self, "secondary_connection")

    @secondary_connection.setter
    def secondary_connection(self, value: Optional[pulumi.Input['ECXL2ConnectionSecondaryConnectionArgs']]):
        pulumi.set(self, "secondary_connection", value)

    @property
    @pulumi.getter(name="sellerMetroCode")
    def seller_metro_code(self) -> Optional[pulumi.Input[str]]:
        """
        The metro code that denotes the connection’s remote/destination
        side (z-side).
        """
        return pulumi.get(self, "seller_metro_code")

    @seller_metro_code.setter
    def seller_metro_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "seller_metro_code", value)

    @property
    @pulumi.getter(name="sellerRegion")
    def seller_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which the seller port resides.
        """
        return pulumi.get(self, "seller_region")

    @seller_region.setter
    def seller_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "seller_region", value)

    @property
    @pulumi.getter(name="serviceToken")
    def service_token(self) -> Optional[pulumi.Input[str]]:
        """
        - A-side
        service tokens authorize you to create a connection from a customer port, which created the token
        for you, to a service profile or your own port.
        More details in [A-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=the%20service%20token.-,A%2DSide%20Service%20Tokens,-If%20you%20want).
        """
        return pulumi.get(self, "service_token")

    @service_token.setter
    def service_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_token", value)

    @property
    @pulumi.getter(name="vlanCtag")
    def vlan_ctag(self) -> Optional[pulumi.Input[int]]:
        """
        C-Tag/Inner-Tag of the connection - a numeric character ranging from 2
        \- 4094.
        """
        return pulumi.get(self, "vlan_ctag")

    @vlan_ctag.setter
    def vlan_ctag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_ctag", value)

    @property
    @pulumi.getter(name="vlanStag")
    def vlan_stag(self) -> Optional[pulumi.Input[int]]:
        """
        S-Tag/Outer-Tag of the connection - a numeric
        character ranging from 2 - 4094.
        """
        return pulumi.get(self, "vlan_stag")

    @vlan_stag.setter
    def vlan_stag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_stag", value)

    @property
    @pulumi.getter(name="zsidePortUuid")
    def zside_port_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the port on the remote/destination side
        (z-side). Allows you to connect between your own ports or virtual devices across your company's
        Equinix Fabric deployment, with no need for a private service profile.
        """
        return pulumi.get(self, "zside_port_uuid")

    @zside_port_uuid.setter
    def zside_port_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zside_port_uuid", value)

    @property
    @pulumi.getter(name="zsideServiceToken")
    def zside_service_token(self) -> Optional[pulumi.Input[str]]:
        """
        - Z-side
        service tokens authorize you to create a connection from your port or virtual device to a customer
        port which created the token for you. `zside_service_token` cannot be used with `secondary_connection`.
        More details in [Z-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=requirements%20per%20provider.-,Z%2DSide%20Service%20Tokens,-If%20you%20want).
        """
        return pulumi.get(self, "zside_service_token")

    @zside_service_token.setter
    def zside_service_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zside_service_token", value)

    @property
    @pulumi.getter(name="zsideVlanCtag")
    def zside_vlan_ctag(self) -> Optional[pulumi.Input[int]]:
        """
        C-Tag/Inner-Tag of the connection on the remote/destination
        side (z-side) - a numeric character ranging from 2 - 4094.
        `secondary_connection` is defined it will internally use same `zside_vlan_ctag` for the secondary
        connection.
        """
        return pulumi.get(self, "zside_vlan_ctag")

    @zside_vlan_ctag.setter
    def zside_vlan_ctag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zside_vlan_ctag", value)

    @property
    @pulumi.getter(name="zsideVlanStag")
    def zside_vlan_stag(self) -> Optional[pulumi.Input[int]]:
        """
        S-Tag/Outer-Tag of the connection on the remote/destination
        side (z-side) - a numeric character ranging from 2 - 4094.
        """
        return pulumi.get(self, "zside_vlan_stag")

    @zside_vlan_stag.setter
    def zside_vlan_stag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zside_vlan_stag", value)


@pulumi.input_type
class _ECXL2ConnectionState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionActionArgs']]]] = None,
                 additional_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionAdditionalInfoArgs']]]] = None,
                 authorization_key: Optional[pulumi.Input[str]] = None,
                 device_interface_id: Optional[pulumi.Input[int]] = None,
                 device_uuid: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 named_tag: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port_uuid: Optional[pulumi.Input[str]] = None,
                 profile_uuid: Optional[pulumi.Input[str]] = None,
                 provider_status: Optional[pulumi.Input[str]] = None,
                 purchase_order_number: Optional[pulumi.Input[str]] = None,
                 redundancy_group: Optional[pulumi.Input[str]] = None,
                 redundancy_type: Optional[pulumi.Input[str]] = None,
                 redundant_uuid: Optional[pulumi.Input[str]] = None,
                 secondary_connection: Optional[pulumi.Input['ECXL2ConnectionSecondaryConnectionArgs']] = None,
                 seller_metro_code: Optional[pulumi.Input[str]] = None,
                 seller_region: Optional[pulumi.Input[str]] = None,
                 service_token: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[int]] = None,
                 speed_unit: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 vendor_token: Optional[pulumi.Input[str]] = None,
                 vlan_ctag: Optional[pulumi.Input[int]] = None,
                 vlan_stag: Optional[pulumi.Input[int]] = None,
                 zside_port_uuid: Optional[pulumi.Input[str]] = None,
                 zside_service_token: Optional[pulumi.Input[str]] = None,
                 zside_vlan_ctag: Optional[pulumi.Input[int]] = None,
                 zside_vlan_stag: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ECXL2Connection resources.
        :param pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionActionArgs']]] actions: One or more pending actions to complete connection provisioning.
        :param pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionAdditionalInfoArgs']]] additional_infos: one or more additional information key-value objects
        :param pulumi.Input[str] authorization_key: Unique identifier authorizing Equinix to provision a connection
               towards a cloud service provider. At Equinix, an `Authorization Key` is a generic term and is NOT
               encrypted on Equinix Fabric. Cloud Service Providers might use a different name to refer to this
               key such as `Service Key` or `Authentication Key`. Value depends on a provider service profile,
               more information on [Equinix Fabric how to guide](https://developer.equinix.com/docs/ecx-how-to-guide).
        :param pulumi.Input[int] device_interface_id: Applicable with `device_uuid`, identifier of network interface
               on a given device, used for a connection. If not specified then first available interface will be
               selected.
        :param pulumi.Input[str] device_uuid: Unique identifier of
               the Network Edge virtual device from which the connection would originate.
        :param pulumi.Input[str] name: additional information key
        :param pulumi.Input[str] named_tag: The type of peering to set up when connecting to Azure Express Route.
               Valid values: `PRIVATE`, `MICROSOFT`, `MANUAL`\*, `PUBLIC`\*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: A list of email addresses used for sending connection update
               notifications.
        :param pulumi.Input[str] port_uuid: Unique identifier of
               the Equinix Fabric Port from which the connection would originate.
        :param pulumi.Input[str] profile_uuid: Unique identifier of the service provider's profile.
        :param pulumi.Input[str] provider_status: Connection provisioning status on service provider's side.
        :param pulumi.Input[str] purchase_order_number: Connection's purchase order number to reflect on the invoice
        :param pulumi.Input[str] redundancy_group: Unique identifier of group containing a primary and secondary connection.
        :param pulumi.Input[str] redundancy_type: Connection redundancy type, applicable for HA connections. Valid values are
               `PRIMARY`, `SECONDARY`.
        :param pulumi.Input[str] redundant_uuid: Unique identifier of the redundant connection, applicable for HA connections.
        :param pulumi.Input['ECXL2ConnectionSecondaryConnectionArgs'] secondary_connection: Definition of secondary connection for redundant, HA
               connectivity. See Secondary Connection below for more details.
        :param pulumi.Input[str] seller_metro_code: The metro code that denotes the connection’s remote/destination
               side (z-side).
        :param pulumi.Input[str] seller_region: The region in which the seller port resides.
        :param pulumi.Input[str] service_token: - A-side
               service tokens authorize you to create a connection from a customer port, which created the token
               for you, to a service profile or your own port.
               More details in [A-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=the%20service%20token.-,A%2DSide%20Service%20Tokens,-If%20you%20want).
        :param pulumi.Input[int] speed: Speed/Bandwidth to be allocated to the connection.
        :param pulumi.Input[str] speed_unit: Unit of the speed/bandwidth to be allocated to the connection.
        :param pulumi.Input[str] status: Connection provisioning status on Equinix Fabric side.
        :param pulumi.Input[str] uuid: Unique identifier of the connection.
        :param pulumi.Input[str] vendor_token: The Equinix Fabric Token the connection was created with. Applicable if the
               connection was created with a `service_token` (a-side) or `zside_service_token` (z-side).
               * `secondary_connection`:
               * `zside_port_uuid`
               * `zside_vlan_stag`
               * `zside_vlan_ctag`
               * `redundancy_type`
               * `redundancy_group`
               * `vendor_token`
        :param pulumi.Input[int] vlan_ctag: C-Tag/Inner-Tag of the connection - a numeric character ranging from 2
               \- 4094.
        :param pulumi.Input[int] vlan_stag: S-Tag/Outer-Tag of the connection - a numeric
               character ranging from 2 - 4094.
        :param pulumi.Input[str] zside_port_uuid: Unique identifier of the port on the remote/destination side
               (z-side). Allows you to connect between your own ports or virtual devices across your company's
               Equinix Fabric deployment, with no need for a private service profile.
        :param pulumi.Input[str] zside_service_token: - Z-side
               service tokens authorize you to create a connection from your port or virtual device to a customer
               port which created the token for you. `zside_service_token` cannot be used with `secondary_connection`.
               More details in [Z-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=requirements%20per%20provider.-,Z%2DSide%20Service%20Tokens,-If%20you%20want).
        :param pulumi.Input[int] zside_vlan_ctag: C-Tag/Inner-Tag of the connection on the remote/destination
               side (z-side) - a numeric character ranging from 2 - 4094.
               `secondary_connection` is defined it will internally use same `zside_vlan_ctag` for the secondary
               connection.
        :param pulumi.Input[int] zside_vlan_stag: S-Tag/Outer-Tag of the connection on the remote/destination
               side (z-side) - a numeric character ranging from 2 - 4094.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if additional_infos is not None:
            pulumi.set(__self__, "additional_infos", additional_infos)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if device_interface_id is not None:
            pulumi.set(__self__, "device_interface_id", device_interface_id)
        if device_uuid is not None:
            pulumi.set(__self__, "device_uuid", device_uuid)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if named_tag is not None:
            pulumi.set(__self__, "named_tag", named_tag)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if port_uuid is not None:
            pulumi.set(__self__, "port_uuid", port_uuid)
        if profile_uuid is not None:
            pulumi.set(__self__, "profile_uuid", profile_uuid)
        if provider_status is not None:
            pulumi.set(__self__, "provider_status", provider_status)
        if purchase_order_number is not None:
            pulumi.set(__self__, "purchase_order_number", purchase_order_number)
        if redundancy_group is not None:
            pulumi.set(__self__, "redundancy_group", redundancy_group)
        if redundancy_type is not None:
            pulumi.set(__self__, "redundancy_type", redundancy_type)
        if redundant_uuid is not None:
            pulumi.set(__self__, "redundant_uuid", redundant_uuid)
        if secondary_connection is not None:
            pulumi.set(__self__, "secondary_connection", secondary_connection)
        if seller_metro_code is not None:
            pulumi.set(__self__, "seller_metro_code", seller_metro_code)
        if seller_region is not None:
            pulumi.set(__self__, "seller_region", seller_region)
        if service_token is not None:
            pulumi.set(__self__, "service_token", service_token)
        if speed is not None:
            pulumi.set(__self__, "speed", speed)
        if speed_unit is not None:
            pulumi.set(__self__, "speed_unit", speed_unit)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if vendor_token is not None:
            pulumi.set(__self__, "vendor_token", vendor_token)
        if vlan_ctag is not None:
            pulumi.set(__self__, "vlan_ctag", vlan_ctag)
        if vlan_stag is not None:
            pulumi.set(__self__, "vlan_stag", vlan_stag)
        if zside_port_uuid is not None:
            pulumi.set(__self__, "zside_port_uuid", zside_port_uuid)
        if zside_service_token is not None:
            pulumi.set(__self__, "zside_service_token", zside_service_token)
        if zside_vlan_ctag is not None:
            pulumi.set(__self__, "zside_vlan_ctag", zside_vlan_ctag)
        if zside_vlan_stag is not None:
            pulumi.set(__self__, "zside_vlan_stag", zside_vlan_stag)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionActionArgs']]]]:
        """
        One or more pending actions to complete connection provisioning.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="additionalInfos")
    def additional_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionAdditionalInfoArgs']]]]:
        """
        one or more additional information key-value objects
        """
        return pulumi.get(self, "additional_infos")

    @additional_infos.setter
    def additional_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ConnectionAdditionalInfoArgs']]]]):
        pulumi.set(self, "additional_infos", value)

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier authorizing Equinix to provision a connection
        towards a cloud service provider. At Equinix, an `Authorization Key` is a generic term and is NOT
        encrypted on Equinix Fabric. Cloud Service Providers might use a different name to refer to this
        key such as `Service Key` or `Authentication Key`. Value depends on a provider service profile,
        more information on [Equinix Fabric how to guide](https://developer.equinix.com/docs/ecx-how-to-guide).
        """
        return pulumi.get(self, "authorization_key")

    @authorization_key.setter
    def authorization_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_key", value)

    @property
    @pulumi.getter(name="deviceInterfaceId")
    def device_interface_id(self) -> Optional[pulumi.Input[int]]:
        """
        Applicable with `device_uuid`, identifier of network interface
        on a given device, used for a connection. If not specified then first available interface will be
        selected.
        """
        return pulumi.get(self, "device_interface_id")

    @device_interface_id.setter
    def device_interface_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "device_interface_id", value)

    @property
    @pulumi.getter(name="deviceUuid")
    def device_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of
        the Network Edge virtual device from which the connection would originate.
        """
        return pulumi.get(self, "device_uuid")

    @device_uuid.setter
    def device_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_uuid", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        additional information key
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namedTag")
    def named_tag(self) -> Optional[pulumi.Input[str]]:
        """
        The type of peering to set up when connecting to Azure Express Route.
        Valid values: `PRIVATE`, `MICROSOFT`, `MANUAL`\*, `PUBLIC`\*.
        """
        return pulumi.get(self, "named_tag")

    @named_tag.setter
    def named_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "named_tag", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of email addresses used for sending connection update
        notifications.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter(name="portUuid")
    def port_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of
        the Equinix Fabric Port from which the connection would originate.
        """
        return pulumi.get(self, "port_uuid")

    @port_uuid.setter
    def port_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_uuid", value)

    @property
    @pulumi.getter(name="profileUuid")
    def profile_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the service provider's profile.
        """
        return pulumi.get(self, "profile_uuid")

    @profile_uuid.setter
    def profile_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_uuid", value)

    @property
    @pulumi.getter(name="providerStatus")
    def provider_status(self) -> Optional[pulumi.Input[str]]:
        """
        Connection provisioning status on service provider's side.
        """
        return pulumi.get(self, "provider_status")

    @provider_status.setter
    def provider_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_status", value)

    @property
    @pulumi.getter(name="purchaseOrderNumber")
    def purchase_order_number(self) -> Optional[pulumi.Input[str]]:
        """
        Connection's purchase order number to reflect on the invoice
        """
        return pulumi.get(self, "purchase_order_number")

    @purchase_order_number.setter
    def purchase_order_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purchase_order_number", value)

    @property
    @pulumi.getter(name="redundancyGroup")
    def redundancy_group(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of group containing a primary and secondary connection.
        """
        return pulumi.get(self, "redundancy_group")

    @redundancy_group.setter
    def redundancy_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundancy_group", value)

    @property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> Optional[pulumi.Input[str]]:
        """
        Connection redundancy type, applicable for HA connections. Valid values are
        `PRIMARY`, `SECONDARY`.
        """
        return pulumi.get(self, "redundancy_type")

    @redundancy_type.setter
    def redundancy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundancy_type", value)

    @property
    @pulumi.getter(name="redundantUuid")
    def redundant_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the redundant connection, applicable for HA connections.
        """
        return pulumi.get(self, "redundant_uuid")

    @redundant_uuid.setter
    def redundant_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundant_uuid", value)

    @property
    @pulumi.getter(name="secondaryConnection")
    def secondary_connection(self) -> Optional[pulumi.Input['ECXL2ConnectionSecondaryConnectionArgs']]:
        """
        Definition of secondary connection for redundant, HA
        connectivity. See Secondary Connection below for more details.
        """
        return pulumi.get(self, "secondary_connection")

    @secondary_connection.setter
    def secondary_connection(self, value: Optional[pulumi.Input['ECXL2ConnectionSecondaryConnectionArgs']]):
        pulumi.set(self, "secondary_connection", value)

    @property
    @pulumi.getter(name="sellerMetroCode")
    def seller_metro_code(self) -> Optional[pulumi.Input[str]]:
        """
        The metro code that denotes the connection’s remote/destination
        side (z-side).
        """
        return pulumi.get(self, "seller_metro_code")

    @seller_metro_code.setter
    def seller_metro_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "seller_metro_code", value)

    @property
    @pulumi.getter(name="sellerRegion")
    def seller_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which the seller port resides.
        """
        return pulumi.get(self, "seller_region")

    @seller_region.setter
    def seller_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "seller_region", value)

    @property
    @pulumi.getter(name="serviceToken")
    def service_token(self) -> Optional[pulumi.Input[str]]:
        """
        - A-side
        service tokens authorize you to create a connection from a customer port, which created the token
        for you, to a service profile or your own port.
        More details in [A-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=the%20service%20token.-,A%2DSide%20Service%20Tokens,-If%20you%20want).
        """
        return pulumi.get(self, "service_token")

    @service_token.setter
    def service_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_token", value)

    @property
    @pulumi.getter
    def speed(self) -> Optional[pulumi.Input[int]]:
        """
        Speed/Bandwidth to be allocated to the connection.
        """
        return pulumi.get(self, "speed")

    @speed.setter
    def speed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "speed", value)

    @property
    @pulumi.getter(name="speedUnit")
    def speed_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Unit of the speed/bandwidth to be allocated to the connection.
        """
        return pulumi.get(self, "speed_unit")

    @speed_unit.setter
    def speed_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "speed_unit", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Connection provisioning status on Equinix Fabric side.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the connection.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter(name="vendorToken")
    def vendor_token(self) -> Optional[pulumi.Input[str]]:
        """
        The Equinix Fabric Token the connection was created with. Applicable if the
        connection was created with a `service_token` (a-side) or `zside_service_token` (z-side).
        * `secondary_connection`:
        * `zside_port_uuid`
        * `zside_vlan_stag`
        * `zside_vlan_ctag`
        * `redundancy_type`
        * `redundancy_group`
        * `vendor_token`
        """
        return pulumi.get(self, "vendor_token")

    @vendor_token.setter
    def vendor_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor_token", value)

    @property
    @pulumi.getter(name="vlanCtag")
    def vlan_ctag(self) -> Optional[pulumi.Input[int]]:
        """
        C-Tag/Inner-Tag of the connection - a numeric character ranging from 2
        \- 4094.
        """
        return pulumi.get(self, "vlan_ctag")

    @vlan_ctag.setter
    def vlan_ctag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_ctag", value)

    @property
    @pulumi.getter(name="vlanStag")
    def vlan_stag(self) -> Optional[pulumi.Input[int]]:
        """
        S-Tag/Outer-Tag of the connection - a numeric
        character ranging from 2 - 4094.
        """
        return pulumi.get(self, "vlan_stag")

    @vlan_stag.setter
    def vlan_stag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_stag", value)

    @property
    @pulumi.getter(name="zsidePortUuid")
    def zside_port_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the port on the remote/destination side
        (z-side). Allows you to connect between your own ports or virtual devices across your company's
        Equinix Fabric deployment, with no need for a private service profile.
        """
        return pulumi.get(self, "zside_port_uuid")

    @zside_port_uuid.setter
    def zside_port_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zside_port_uuid", value)

    @property
    @pulumi.getter(name="zsideServiceToken")
    def zside_service_token(self) -> Optional[pulumi.Input[str]]:
        """
        - Z-side
        service tokens authorize you to create a connection from your port or virtual device to a customer
        port which created the token for you. `zside_service_token` cannot be used with `secondary_connection`.
        More details in [Z-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=requirements%20per%20provider.-,Z%2DSide%20Service%20Tokens,-If%20you%20want).
        """
        return pulumi.get(self, "zside_service_token")

    @zside_service_token.setter
    def zside_service_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zside_service_token", value)

    @property
    @pulumi.getter(name="zsideVlanCtag")
    def zside_vlan_ctag(self) -> Optional[pulumi.Input[int]]:
        """
        C-Tag/Inner-Tag of the connection on the remote/destination
        side (z-side) - a numeric character ranging from 2 - 4094.
        `secondary_connection` is defined it will internally use same `zside_vlan_ctag` for the secondary
        connection.
        """
        return pulumi.get(self, "zside_vlan_ctag")

    @zside_vlan_ctag.setter
    def zside_vlan_ctag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zside_vlan_ctag", value)

    @property
    @pulumi.getter(name="zsideVlanStag")
    def zside_vlan_stag(self) -> Optional[pulumi.Input[int]]:
        """
        S-Tag/Outer-Tag of the connection on the remote/destination
        side (z-side) - a numeric character ranging from 2 - 4094.
        """
        return pulumi.get(self, "zside_vlan_stag")

    @zside_vlan_stag.setter
    def zside_vlan_stag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zside_vlan_stag", value)


class ECXL2Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ConnectionAdditionalInfoArgs']]]]] = None,
                 authorization_key: Optional[pulumi.Input[str]] = None,
                 device_interface_id: Optional[pulumi.Input[int]] = None,
                 device_uuid: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 named_tag: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port_uuid: Optional[pulumi.Input[str]] = None,
                 profile_uuid: Optional[pulumi.Input[str]] = None,
                 purchase_order_number: Optional[pulumi.Input[str]] = None,
                 secondary_connection: Optional[pulumi.Input[pulumi.InputType['ECXL2ConnectionSecondaryConnectionArgs']]] = None,
                 seller_metro_code: Optional[pulumi.Input[str]] = None,
                 seller_region: Optional[pulumi.Input[str]] = None,
                 service_token: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[int]] = None,
                 speed_unit: Optional[pulumi.Input[str]] = None,
                 vlan_ctag: Optional[pulumi.Input[int]] = None,
                 vlan_stag: Optional[pulumi.Input[int]] = None,
                 zside_port_uuid: Optional[pulumi.Input[str]] = None,
                 zside_service_token: Optional[pulumi.Input[str]] = None,
                 zside_vlan_ctag: Optional[pulumi.Input[int]] = None,
                 zside_vlan_stag: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Resource `ECXL2Connection` allows creation and management of Equinix Fabric
        layer 2 connections.

        ## Example Usage
        ### Non-redundant Connection from own Equinix Fabric Port

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        aws = equinix.get_ecxl2_sellerprofile(name="AWS Direct Connect")
        sv_qinq_pri = equinix.get_ecx_port(name="CX-SV5-NL-Dot1q-BO-10G-PRI")
        port_2_aws = equinix.ECXL2Connection("port-2-aws",
            profile_uuid=aws.id,
            speed=200,
            speed_unit="MB",
            notifications=[
                "marry@equinix.com",
                "john@equinix.com",
            ],
            port_uuid=sv_qinq_pri.id,
            vlan_stag=777,
            vlan_ctag=1000,
            seller_region="us-west-1",
            seller_metro_code="SV",
            authorization_key="345742915919")
        ```
        ### Non-redundant Connection from Network Edge device

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        gcp_1 = equinix.get_ecxl2_sellerprofile(name="Google Cloud Partner Interconnect Zone 1")
        router_to_gcp = equinix.ECXL2Connection("router-to-gcp",
            profile_uuid=gcp_1.id,
            device_uuid=equinix_network_device["myrouter"]["id"],
            device_interface_id=5,
            speed=100,
            speed_unit="MB",
            notifications=[
                "john@equinix.com",
                "marry@equinix.com",
            ],
            seller_metro_code="SV",
            seller_region="us-west1",
            authorization_key="4d335adc-00fd-4a41-c9f3-782ca31ab3f7/us-west1/1")
        ```
        ### Non-redundant Connection from an Equinix customer port using A-Side Service token

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        gcp = equinix.get_ecxl2_sellerprofile(name="Google Cloud Partner Interconnect Zone 1")
        token_to_gcp = equinix.ECXL2Connection("token-to-gcp",
            profile_uuid=data["equinix_ecx_l2_sellerprofile"]["gcp-1"]["id"],
            service_token="e9c22453-d3a7-4d5d-9112-d50173531392",
            speed=100,
            speed_unit="MB",
            notifications=[
                "john@equinix.com",
                "marry@equinix.com",
            ],
            seller_metro_code="SV",
            seller_region="us-west1",
            authorization_key="4d335adc-00fd-4a41-c9f3-782ca31ab3f7/us-west1/1")
        ```
        ### Non-redundant Connection from own Equinix Fabric Port to an Equinix customer port using Z-Side Service token

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        sv_qinq_pri = equinix.get_ecx_port(name="CX-SV5-NL-Dot1q-BO-10G-PRI")
        port_to_token = equinix.ECXL2Connection("port-to-token",
            zside_service_token="e9c22453-d3a7-4d5d-9112-d50173531392",
            speed=200,
            speed_unit="MB",
            notifications=[
                "john@equinix.com",
                "marry@equinix.com",
            ],
            seller_metro_code="FR",
            port_uuid=sv_qinq_pri.id,
            vlan_stag=1000)
        ```

        > **NOTE:** See Equinix Fabric connecting to the cloud
        guide for more details on how to connect to a CSP.
        ## Update operation behavior

        Update of most arguments will force replacement of a connection (including related redundant
        connection in HA setup).

        Following arguments can be updated. **NOTE** that Equinix Fabric may still forbid updates depending
        on current connection state, used service provider or number of updates requested during the day.

        * `name`
        * `speed` and `speed_unit`

        ## Import

        into `vendor_token` but `service_token` and `zside_service_token` will remain empty. Equinix L2 connections can be imported using an existing `id`existing_connection_id='example-uuid-1'

        ```sh
         $ pulumi import equinix:index/eCXL2Connection:ECXL2Connection example ${existing_connection_id}
        ```

         (primary and secondary) into a single string separated by `:`. To import a redundant Equinix L2 connectionexisting_primary_connection_id='example-uuid-1' existing_secondary_connection_id='example-uuid-2'

        ```sh
         $ pulumi import equinix:index/eCXL2Connection:ECXL2Connection example ${existing_primary_connection_id}:${existing_secondary_connection_id}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ConnectionAdditionalInfoArgs']]]] additional_infos: one or more additional information key-value objects
        :param pulumi.Input[str] authorization_key: Unique identifier authorizing Equinix to provision a connection
               towards a cloud service provider. At Equinix, an `Authorization Key` is a generic term and is NOT
               encrypted on Equinix Fabric. Cloud Service Providers might use a different name to refer to this
               key such as `Service Key` or `Authentication Key`. Value depends on a provider service profile,
               more information on [Equinix Fabric how to guide](https://developer.equinix.com/docs/ecx-how-to-guide).
        :param pulumi.Input[int] device_interface_id: Applicable with `device_uuid`, identifier of network interface
               on a given device, used for a connection. If not specified then first available interface will be
               selected.
        :param pulumi.Input[str] device_uuid: Unique identifier of
               the Network Edge virtual device from which the connection would originate.
        :param pulumi.Input[str] name: additional information key
        :param pulumi.Input[str] named_tag: The type of peering to set up when connecting to Azure Express Route.
               Valid values: `PRIVATE`, `MICROSOFT`, `MANUAL`\*, `PUBLIC`\*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: A list of email addresses used for sending connection update
               notifications.
        :param pulumi.Input[str] port_uuid: Unique identifier of
               the Equinix Fabric Port from which the connection would originate.
        :param pulumi.Input[str] profile_uuid: Unique identifier of the service provider's profile.
        :param pulumi.Input[str] purchase_order_number: Connection's purchase order number to reflect on the invoice
        :param pulumi.Input[pulumi.InputType['ECXL2ConnectionSecondaryConnectionArgs']] secondary_connection: Definition of secondary connection for redundant, HA
               connectivity. See Secondary Connection below for more details.
        :param pulumi.Input[str] seller_metro_code: The metro code that denotes the connection’s remote/destination
               side (z-side).
        :param pulumi.Input[str] seller_region: The region in which the seller port resides.
        :param pulumi.Input[str] service_token: - A-side
               service tokens authorize you to create a connection from a customer port, which created the token
               for you, to a service profile or your own port.
               More details in [A-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=the%20service%20token.-,A%2DSide%20Service%20Tokens,-If%20you%20want).
        :param pulumi.Input[int] speed: Speed/Bandwidth to be allocated to the connection.
        :param pulumi.Input[str] speed_unit: Unit of the speed/bandwidth to be allocated to the connection.
        :param pulumi.Input[int] vlan_ctag: C-Tag/Inner-Tag of the connection - a numeric character ranging from 2
               \- 4094.
        :param pulumi.Input[int] vlan_stag: S-Tag/Outer-Tag of the connection - a numeric
               character ranging from 2 - 4094.
        :param pulumi.Input[str] zside_port_uuid: Unique identifier of the port on the remote/destination side
               (z-side). Allows you to connect between your own ports or virtual devices across your company's
               Equinix Fabric deployment, with no need for a private service profile.
        :param pulumi.Input[str] zside_service_token: - Z-side
               service tokens authorize you to create a connection from your port or virtual device to a customer
               port which created the token for you. `zside_service_token` cannot be used with `secondary_connection`.
               More details in [Z-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=requirements%20per%20provider.-,Z%2DSide%20Service%20Tokens,-If%20you%20want).
        :param pulumi.Input[int] zside_vlan_ctag: C-Tag/Inner-Tag of the connection on the remote/destination
               side (z-side) - a numeric character ranging from 2 - 4094.
               `secondary_connection` is defined it will internally use same `zside_vlan_ctag` for the secondary
               connection.
        :param pulumi.Input[int] zside_vlan_stag: S-Tag/Outer-Tag of the connection on the remote/destination
               side (z-side) - a numeric character ranging from 2 - 4094.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ECXL2ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource `ECXL2Connection` allows creation and management of Equinix Fabric
        layer 2 connections.

        ## Example Usage
        ### Non-redundant Connection from own Equinix Fabric Port

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        aws = equinix.get_ecxl2_sellerprofile(name="AWS Direct Connect")
        sv_qinq_pri = equinix.get_ecx_port(name="CX-SV5-NL-Dot1q-BO-10G-PRI")
        port_2_aws = equinix.ECXL2Connection("port-2-aws",
            profile_uuid=aws.id,
            speed=200,
            speed_unit="MB",
            notifications=[
                "marry@equinix.com",
                "john@equinix.com",
            ],
            port_uuid=sv_qinq_pri.id,
            vlan_stag=777,
            vlan_ctag=1000,
            seller_region="us-west-1",
            seller_metro_code="SV",
            authorization_key="345742915919")
        ```
        ### Non-redundant Connection from Network Edge device

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        gcp_1 = equinix.get_ecxl2_sellerprofile(name="Google Cloud Partner Interconnect Zone 1")
        router_to_gcp = equinix.ECXL2Connection("router-to-gcp",
            profile_uuid=gcp_1.id,
            device_uuid=equinix_network_device["myrouter"]["id"],
            device_interface_id=5,
            speed=100,
            speed_unit="MB",
            notifications=[
                "john@equinix.com",
                "marry@equinix.com",
            ],
            seller_metro_code="SV",
            seller_region="us-west1",
            authorization_key="4d335adc-00fd-4a41-c9f3-782ca31ab3f7/us-west1/1")
        ```
        ### Non-redundant Connection from an Equinix customer port using A-Side Service token

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        gcp = equinix.get_ecxl2_sellerprofile(name="Google Cloud Partner Interconnect Zone 1")
        token_to_gcp = equinix.ECXL2Connection("token-to-gcp",
            profile_uuid=data["equinix_ecx_l2_sellerprofile"]["gcp-1"]["id"],
            service_token="e9c22453-d3a7-4d5d-9112-d50173531392",
            speed=100,
            speed_unit="MB",
            notifications=[
                "john@equinix.com",
                "marry@equinix.com",
            ],
            seller_metro_code="SV",
            seller_region="us-west1",
            authorization_key="4d335adc-00fd-4a41-c9f3-782ca31ab3f7/us-west1/1")
        ```
        ### Non-redundant Connection from own Equinix Fabric Port to an Equinix customer port using Z-Side Service token

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        sv_qinq_pri = equinix.get_ecx_port(name="CX-SV5-NL-Dot1q-BO-10G-PRI")
        port_to_token = equinix.ECXL2Connection("port-to-token",
            zside_service_token="e9c22453-d3a7-4d5d-9112-d50173531392",
            speed=200,
            speed_unit="MB",
            notifications=[
                "john@equinix.com",
                "marry@equinix.com",
            ],
            seller_metro_code="FR",
            port_uuid=sv_qinq_pri.id,
            vlan_stag=1000)
        ```

        > **NOTE:** See Equinix Fabric connecting to the cloud
        guide for more details on how to connect to a CSP.
        ## Update operation behavior

        Update of most arguments will force replacement of a connection (including related redundant
        connection in HA setup).

        Following arguments can be updated. **NOTE** that Equinix Fabric may still forbid updates depending
        on current connection state, used service provider or number of updates requested during the day.

        * `name`
        * `speed` and `speed_unit`

        ## Import

        into `vendor_token` but `service_token` and `zside_service_token` will remain empty. Equinix L2 connections can be imported using an existing `id`existing_connection_id='example-uuid-1'

        ```sh
         $ pulumi import equinix:index/eCXL2Connection:ECXL2Connection example ${existing_connection_id}
        ```

         (primary and secondary) into a single string separated by `:`. To import a redundant Equinix L2 connectionexisting_primary_connection_id='example-uuid-1' existing_secondary_connection_id='example-uuid-2'

        ```sh
         $ pulumi import equinix:index/eCXL2Connection:ECXL2Connection example ${existing_primary_connection_id}:${existing_secondary_connection_id}
        ```

        :param str resource_name: The name of the resource.
        :param ECXL2ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ECXL2ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ConnectionAdditionalInfoArgs']]]]] = None,
                 authorization_key: Optional[pulumi.Input[str]] = None,
                 device_interface_id: Optional[pulumi.Input[int]] = None,
                 device_uuid: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 named_tag: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port_uuid: Optional[pulumi.Input[str]] = None,
                 profile_uuid: Optional[pulumi.Input[str]] = None,
                 purchase_order_number: Optional[pulumi.Input[str]] = None,
                 secondary_connection: Optional[pulumi.Input[pulumi.InputType['ECXL2ConnectionSecondaryConnectionArgs']]] = None,
                 seller_metro_code: Optional[pulumi.Input[str]] = None,
                 seller_region: Optional[pulumi.Input[str]] = None,
                 service_token: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[int]] = None,
                 speed_unit: Optional[pulumi.Input[str]] = None,
                 vlan_ctag: Optional[pulumi.Input[int]] = None,
                 vlan_stag: Optional[pulumi.Input[int]] = None,
                 zside_port_uuid: Optional[pulumi.Input[str]] = None,
                 zside_service_token: Optional[pulumi.Input[str]] = None,
                 zside_vlan_ctag: Optional[pulumi.Input[int]] = None,
                 zside_vlan_stag: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ECXL2ConnectionArgs.__new__(ECXL2ConnectionArgs)

            __props__.__dict__["additional_infos"] = additional_infos
            __props__.__dict__["authorization_key"] = authorization_key
            __props__.__dict__["device_interface_id"] = device_interface_id
            __props__.__dict__["device_uuid"] = device_uuid
            __props__.__dict__["name"] = name
            __props__.__dict__["named_tag"] = named_tag
            if notifications is None and not opts.urn:
                raise TypeError("Missing required property 'notifications'")
            __props__.__dict__["notifications"] = notifications
            __props__.__dict__["port_uuid"] = port_uuid
            __props__.__dict__["profile_uuid"] = profile_uuid
            __props__.__dict__["purchase_order_number"] = purchase_order_number
            __props__.__dict__["secondary_connection"] = secondary_connection
            __props__.__dict__["seller_metro_code"] = seller_metro_code
            __props__.__dict__["seller_region"] = seller_region
            __props__.__dict__["service_token"] = service_token
            if speed is None and not opts.urn:
                raise TypeError("Missing required property 'speed'")
            __props__.__dict__["speed"] = speed
            if speed_unit is None and not opts.urn:
                raise TypeError("Missing required property 'speed_unit'")
            __props__.__dict__["speed_unit"] = speed_unit
            __props__.__dict__["vlan_ctag"] = vlan_ctag
            __props__.__dict__["vlan_stag"] = vlan_stag
            __props__.__dict__["zside_port_uuid"] = zside_port_uuid
            __props__.__dict__["zside_service_token"] = zside_service_token
            __props__.__dict__["zside_vlan_ctag"] = zside_vlan_ctag
            __props__.__dict__["zside_vlan_stag"] = zside_vlan_stag
            __props__.__dict__["actions"] = None
            __props__.__dict__["provider_status"] = None
            __props__.__dict__["redundancy_group"] = None
            __props__.__dict__["redundancy_type"] = None
            __props__.__dict__["redundant_uuid"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["uuid"] = None
            __props__.__dict__["vendor_token"] = None
        super(ECXL2Connection, __self__).__init__(
            'equinix:index/eCXL2Connection:ECXL2Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ConnectionActionArgs']]]]] = None,
            additional_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ConnectionAdditionalInfoArgs']]]]] = None,
            authorization_key: Optional[pulumi.Input[str]] = None,
            device_interface_id: Optional[pulumi.Input[int]] = None,
            device_uuid: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            named_tag: Optional[pulumi.Input[str]] = None,
            notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            port_uuid: Optional[pulumi.Input[str]] = None,
            profile_uuid: Optional[pulumi.Input[str]] = None,
            provider_status: Optional[pulumi.Input[str]] = None,
            purchase_order_number: Optional[pulumi.Input[str]] = None,
            redundancy_group: Optional[pulumi.Input[str]] = None,
            redundancy_type: Optional[pulumi.Input[str]] = None,
            redundant_uuid: Optional[pulumi.Input[str]] = None,
            secondary_connection: Optional[pulumi.Input[pulumi.InputType['ECXL2ConnectionSecondaryConnectionArgs']]] = None,
            seller_metro_code: Optional[pulumi.Input[str]] = None,
            seller_region: Optional[pulumi.Input[str]] = None,
            service_token: Optional[pulumi.Input[str]] = None,
            speed: Optional[pulumi.Input[int]] = None,
            speed_unit: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            uuid: Optional[pulumi.Input[str]] = None,
            vendor_token: Optional[pulumi.Input[str]] = None,
            vlan_ctag: Optional[pulumi.Input[int]] = None,
            vlan_stag: Optional[pulumi.Input[int]] = None,
            zside_port_uuid: Optional[pulumi.Input[str]] = None,
            zside_service_token: Optional[pulumi.Input[str]] = None,
            zside_vlan_ctag: Optional[pulumi.Input[int]] = None,
            zside_vlan_stag: Optional[pulumi.Input[int]] = None) -> 'ECXL2Connection':
        """
        Get an existing ECXL2Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ConnectionActionArgs']]]] actions: One or more pending actions to complete connection provisioning.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ConnectionAdditionalInfoArgs']]]] additional_infos: one or more additional information key-value objects
        :param pulumi.Input[str] authorization_key: Unique identifier authorizing Equinix to provision a connection
               towards a cloud service provider. At Equinix, an `Authorization Key` is a generic term and is NOT
               encrypted on Equinix Fabric. Cloud Service Providers might use a different name to refer to this
               key such as `Service Key` or `Authentication Key`. Value depends on a provider service profile,
               more information on [Equinix Fabric how to guide](https://developer.equinix.com/docs/ecx-how-to-guide).
        :param pulumi.Input[int] device_interface_id: Applicable with `device_uuid`, identifier of network interface
               on a given device, used for a connection. If not specified then first available interface will be
               selected.
        :param pulumi.Input[str] device_uuid: Unique identifier of
               the Network Edge virtual device from which the connection would originate.
        :param pulumi.Input[str] name: additional information key
        :param pulumi.Input[str] named_tag: The type of peering to set up when connecting to Azure Express Route.
               Valid values: `PRIVATE`, `MICROSOFT`, `MANUAL`\*, `PUBLIC`\*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: A list of email addresses used for sending connection update
               notifications.
        :param pulumi.Input[str] port_uuid: Unique identifier of
               the Equinix Fabric Port from which the connection would originate.
        :param pulumi.Input[str] profile_uuid: Unique identifier of the service provider's profile.
        :param pulumi.Input[str] provider_status: Connection provisioning status on service provider's side.
        :param pulumi.Input[str] purchase_order_number: Connection's purchase order number to reflect on the invoice
        :param pulumi.Input[str] redundancy_group: Unique identifier of group containing a primary and secondary connection.
        :param pulumi.Input[str] redundancy_type: Connection redundancy type, applicable for HA connections. Valid values are
               `PRIMARY`, `SECONDARY`.
        :param pulumi.Input[str] redundant_uuid: Unique identifier of the redundant connection, applicable for HA connections.
        :param pulumi.Input[pulumi.InputType['ECXL2ConnectionSecondaryConnectionArgs']] secondary_connection: Definition of secondary connection for redundant, HA
               connectivity. See Secondary Connection below for more details.
        :param pulumi.Input[str] seller_metro_code: The metro code that denotes the connection’s remote/destination
               side (z-side).
        :param pulumi.Input[str] seller_region: The region in which the seller port resides.
        :param pulumi.Input[str] service_token: - A-side
               service tokens authorize you to create a connection from a customer port, which created the token
               for you, to a service profile or your own port.
               More details in [A-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=the%20service%20token.-,A%2DSide%20Service%20Tokens,-If%20you%20want).
        :param pulumi.Input[int] speed: Speed/Bandwidth to be allocated to the connection.
        :param pulumi.Input[str] speed_unit: Unit of the speed/bandwidth to be allocated to the connection.
        :param pulumi.Input[str] status: Connection provisioning status on Equinix Fabric side.
        :param pulumi.Input[str] uuid: Unique identifier of the connection.
        :param pulumi.Input[str] vendor_token: The Equinix Fabric Token the connection was created with. Applicable if the
               connection was created with a `service_token` (a-side) or `zside_service_token` (z-side).
               * `secondary_connection`:
               * `zside_port_uuid`
               * `zside_vlan_stag`
               * `zside_vlan_ctag`
               * `redundancy_type`
               * `redundancy_group`
               * `vendor_token`
        :param pulumi.Input[int] vlan_ctag: C-Tag/Inner-Tag of the connection - a numeric character ranging from 2
               \- 4094.
        :param pulumi.Input[int] vlan_stag: S-Tag/Outer-Tag of the connection - a numeric
               character ranging from 2 - 4094.
        :param pulumi.Input[str] zside_port_uuid: Unique identifier of the port on the remote/destination side
               (z-side). Allows you to connect between your own ports or virtual devices across your company's
               Equinix Fabric deployment, with no need for a private service profile.
        :param pulumi.Input[str] zside_service_token: - Z-side
               service tokens authorize you to create a connection from your port or virtual device to a customer
               port which created the token for you. `zside_service_token` cannot be used with `secondary_connection`.
               More details in [Z-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=requirements%20per%20provider.-,Z%2DSide%20Service%20Tokens,-If%20you%20want).
        :param pulumi.Input[int] zside_vlan_ctag: C-Tag/Inner-Tag of the connection on the remote/destination
               side (z-side) - a numeric character ranging from 2 - 4094.
               `secondary_connection` is defined it will internally use same `zside_vlan_ctag` for the secondary
               connection.
        :param pulumi.Input[int] zside_vlan_stag: S-Tag/Outer-Tag of the connection on the remote/destination
               side (z-side) - a numeric character ranging from 2 - 4094.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ECXL2ConnectionState.__new__(_ECXL2ConnectionState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["additional_infos"] = additional_infos
        __props__.__dict__["authorization_key"] = authorization_key
        __props__.__dict__["device_interface_id"] = device_interface_id
        __props__.__dict__["device_uuid"] = device_uuid
        __props__.__dict__["name"] = name
        __props__.__dict__["named_tag"] = named_tag
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["port_uuid"] = port_uuid
        __props__.__dict__["profile_uuid"] = profile_uuid
        __props__.__dict__["provider_status"] = provider_status
        __props__.__dict__["purchase_order_number"] = purchase_order_number
        __props__.__dict__["redundancy_group"] = redundancy_group
        __props__.__dict__["redundancy_type"] = redundancy_type
        __props__.__dict__["redundant_uuid"] = redundant_uuid
        __props__.__dict__["secondary_connection"] = secondary_connection
        __props__.__dict__["seller_metro_code"] = seller_metro_code
        __props__.__dict__["seller_region"] = seller_region
        __props__.__dict__["service_token"] = service_token
        __props__.__dict__["speed"] = speed
        __props__.__dict__["speed_unit"] = speed_unit
        __props__.__dict__["status"] = status
        __props__.__dict__["uuid"] = uuid
        __props__.__dict__["vendor_token"] = vendor_token
        __props__.__dict__["vlan_ctag"] = vlan_ctag
        __props__.__dict__["vlan_stag"] = vlan_stag
        __props__.__dict__["zside_port_uuid"] = zside_port_uuid
        __props__.__dict__["zside_service_token"] = zside_service_token
        __props__.__dict__["zside_vlan_ctag"] = zside_vlan_ctag
        __props__.__dict__["zside_vlan_stag"] = zside_vlan_stag
        return ECXL2Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.ECXL2ConnectionAction']]:
        """
        One or more pending actions to complete connection provisioning.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="additionalInfos")
    def additional_infos(self) -> pulumi.Output[Optional[Sequence['outputs.ECXL2ConnectionAdditionalInfo']]]:
        """
        one or more additional information key-value objects
        """
        return pulumi.get(self, "additional_infos")

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> pulumi.Output[str]:
        """
        Unique identifier authorizing Equinix to provision a connection
        towards a cloud service provider. At Equinix, an `Authorization Key` is a generic term and is NOT
        encrypted on Equinix Fabric. Cloud Service Providers might use a different name to refer to this
        key such as `Service Key` or `Authentication Key`. Value depends on a provider service profile,
        more information on [Equinix Fabric how to guide](https://developer.equinix.com/docs/ecx-how-to-guide).
        """
        return pulumi.get(self, "authorization_key")

    @property
    @pulumi.getter(name="deviceInterfaceId")
    def device_interface_id(self) -> pulumi.Output[Optional[int]]:
        """
        Applicable with `device_uuid`, identifier of network interface
        on a given device, used for a connection. If not specified then first available interface will be
        selected.
        """
        return pulumi.get(self, "device_interface_id")

    @property
    @pulumi.getter(name="deviceUuid")
    def device_uuid(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier of
        the Network Edge virtual device from which the connection would originate.
        """
        return pulumi.get(self, "device_uuid")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        additional information key
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namedTag")
    def named_tag(self) -> pulumi.Output[Optional[str]]:
        """
        The type of peering to set up when connecting to Azure Express Route.
        Valid values: `PRIVATE`, `MICROSOFT`, `MANUAL`\*, `PUBLIC`\*.
        """
        return pulumi.get(self, "named_tag")

    @property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of email addresses used for sending connection update
        notifications.
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter(name="portUuid")
    def port_uuid(self) -> pulumi.Output[str]:
        """
        Unique identifier of
        the Equinix Fabric Port from which the connection would originate.
        """
        return pulumi.get(self, "port_uuid")

    @property
    @pulumi.getter(name="profileUuid")
    def profile_uuid(self) -> pulumi.Output[str]:
        """
        Unique identifier of the service provider's profile.
        """
        return pulumi.get(self, "profile_uuid")

    @property
    @pulumi.getter(name="providerStatus")
    def provider_status(self) -> pulumi.Output[str]:
        """
        Connection provisioning status on service provider's side.
        """
        return pulumi.get(self, "provider_status")

    @property
    @pulumi.getter(name="purchaseOrderNumber")
    def purchase_order_number(self) -> pulumi.Output[Optional[str]]:
        """
        Connection's purchase order number to reflect on the invoice
        """
        return pulumi.get(self, "purchase_order_number")

    @property
    @pulumi.getter(name="redundancyGroup")
    def redundancy_group(self) -> pulumi.Output[str]:
        """
        Unique identifier of group containing a primary and secondary connection.
        """
        return pulumi.get(self, "redundancy_group")

    @property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> pulumi.Output[str]:
        """
        Connection redundancy type, applicable for HA connections. Valid values are
        `PRIMARY`, `SECONDARY`.
        """
        return pulumi.get(self, "redundancy_type")

    @property
    @pulumi.getter(name="redundantUuid")
    def redundant_uuid(self) -> pulumi.Output[str]:
        """
        Unique identifier of the redundant connection, applicable for HA connections.
        """
        return pulumi.get(self, "redundant_uuid")

    @property
    @pulumi.getter(name="secondaryConnection")
    def secondary_connection(self) -> pulumi.Output[Optional['outputs.ECXL2ConnectionSecondaryConnection']]:
        """
        Definition of secondary connection for redundant, HA
        connectivity. See Secondary Connection below for more details.
        """
        return pulumi.get(self, "secondary_connection")

    @property
    @pulumi.getter(name="sellerMetroCode")
    def seller_metro_code(self) -> pulumi.Output[str]:
        """
        The metro code that denotes the connection’s remote/destination
        side (z-side).
        """
        return pulumi.get(self, "seller_metro_code")

    @property
    @pulumi.getter(name="sellerRegion")
    def seller_region(self) -> pulumi.Output[Optional[str]]:
        """
        The region in which the seller port resides.
        """
        return pulumi.get(self, "seller_region")

    @property
    @pulumi.getter(name="serviceToken")
    def service_token(self) -> pulumi.Output[Optional[str]]:
        """
        - A-side
        service tokens authorize you to create a connection from a customer port, which created the token
        for you, to a service profile or your own port.
        More details in [A-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=the%20service%20token.-,A%2DSide%20Service%20Tokens,-If%20you%20want).
        """
        return pulumi.get(self, "service_token")

    @property
    @pulumi.getter
    def speed(self) -> pulumi.Output[int]:
        """
        Speed/Bandwidth to be allocated to the connection.
        """
        return pulumi.get(self, "speed")

    @property
    @pulumi.getter(name="speedUnit")
    def speed_unit(self) -> pulumi.Output[str]:
        """
        Unit of the speed/bandwidth to be allocated to the connection.
        """
        return pulumi.get(self, "speed_unit")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Connection provisioning status on Equinix Fabric side.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[str]:
        """
        Unique identifier of the connection.
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="vendorToken")
    def vendor_token(self) -> pulumi.Output[str]:
        """
        The Equinix Fabric Token the connection was created with. Applicable if the
        connection was created with a `service_token` (a-side) or `zside_service_token` (z-side).
        * `secondary_connection`:
        * `zside_port_uuid`
        * `zside_vlan_stag`
        * `zside_vlan_ctag`
        * `redundancy_type`
        * `redundancy_group`
        * `vendor_token`
        """
        return pulumi.get(self, "vendor_token")

    @property
    @pulumi.getter(name="vlanCtag")
    def vlan_ctag(self) -> pulumi.Output[Optional[int]]:
        """
        C-Tag/Inner-Tag of the connection - a numeric character ranging from 2
        \- 4094.
        """
        return pulumi.get(self, "vlan_ctag")

    @property
    @pulumi.getter(name="vlanStag")
    def vlan_stag(self) -> pulumi.Output[int]:
        """
        S-Tag/Outer-Tag of the connection - a numeric
        character ranging from 2 - 4094.
        """
        return pulumi.get(self, "vlan_stag")

    @property
    @pulumi.getter(name="zsidePortUuid")
    def zside_port_uuid(self) -> pulumi.Output[str]:
        """
        Unique identifier of the port on the remote/destination side
        (z-side). Allows you to connect between your own ports or virtual devices across your company's
        Equinix Fabric deployment, with no need for a private service profile.
        """
        return pulumi.get(self, "zside_port_uuid")

    @property
    @pulumi.getter(name="zsideServiceToken")
    def zside_service_token(self) -> pulumi.Output[Optional[str]]:
        """
        - Z-side
        service tokens authorize you to create a connection from your port or virtual device to a customer
        port which created the token for you. `zside_service_token` cannot be used with `secondary_connection`.
        More details in [Z-Side Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm#:~:text=requirements%20per%20provider.-,Z%2DSide%20Service%20Tokens,-If%20you%20want).
        """
        return pulumi.get(self, "zside_service_token")

    @property
    @pulumi.getter(name="zsideVlanCtag")
    def zside_vlan_ctag(self) -> pulumi.Output[int]:
        """
        C-Tag/Inner-Tag of the connection on the remote/destination
        side (z-side) - a numeric character ranging from 2 - 4094.
        `secondary_connection` is defined it will internally use same `zside_vlan_ctag` for the secondary
        connection.
        """
        return pulumi.get(self, "zside_vlan_ctag")

    @property
    @pulumi.getter(name="zsideVlanStag")
    def zside_vlan_stag(self) -> pulumi.Output[int]:
        """
        S-Tag/Outer-Tag of the connection on the remote/destination
        side (z-side) - a numeric character ranging from 2 - 4094.
        """
        return pulumi.get(self, "zside_vlan_stag")

