# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ECXL2ServiceprofileArgs', 'ECXL2Serviceprofile']

@pulumi.input_type
class ECXL2ServiceprofileArgs:
    def __init__(__self__, *,
                 bandwidth_threshold_notifications: pulumi.Input[Sequence[pulumi.Input[str]]],
                 features: pulumi.Input['ECXL2ServiceprofileFeaturesArgs'],
                 ports: pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofilePortArgs']]],
                 profile_statuschange_notifications: pulumi.Input[Sequence[pulumi.Input[str]]],
                 vc_statuschange_notifications: pulumi.Input[Sequence[pulumi.Input[str]]],
                 api_integration: Optional[pulumi.Input[bool]] = None,
                 authkey_label: Optional[pulumi.Input[str]] = None,
                 bandwidth_alert_threshold: Optional[pulumi.Input[float]] = None,
                 connection_name_label: Optional[pulumi.Input[str]] = None,
                 ctag_label: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 equinix_managed_port_vlan: Optional[pulumi.Input[bool]] = None,
                 integration_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oversubscription: Optional[pulumi.Input[str]] = None,
                 oversubscription_allowed: Optional[pulumi.Input[bool]] = None,
                 private: Optional[pulumi.Input[bool]] = None,
                 private_user_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 redundancy_required: Optional[pulumi.Input[bool]] = None,
                 secondary_vlan_from_primary: Optional[pulumi.Input[bool]] = None,
                 servicekey_autogenerated: Optional[pulumi.Input[bool]] = None,
                 speed_bands: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofileSpeedBandArgs']]]] = None,
                 speed_customization_allowed: Optional[pulumi.Input[bool]] = None,
                 speed_from_api: Optional[pulumi.Input[bool]] = None,
                 tag_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ECXL2Serviceprofile resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bandwidth_threshold_notifications: A list of email addresses that will receive
               notifications about bandwidth thresholds.
        :param pulumi.Input['ECXL2ServiceprofileFeaturesArgs'] features: Block of profile features configuration. See Features below
               for more details.
        :param pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofilePortArgs']]] ports: One or more definitions of ports residing in locations, from which your
               customers will be able to access services using this service profile. See Port below for
               more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] profile_statuschange_notifications: A list of email addresses that will receive
               notifications about profile status changes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vc_statuschange_notifications: A list of email addresses that will receive
               notifications about connections approvals and rejections.
        :param pulumi.Input[bool] api_integration: Boolean value that determines if API integration is enabled. It
               allows you to complete connection provisioning in less than five minutes. Without API Integration,
               additional manual steps will be required and the provisioning will likely take longer.
        :param pulumi.Input[str] authkey_label: Name of the authentication key label to be used by the
               Authentication Key service. It allows Service Providers with QinQ ports to accept groups of
               connections or VLANs from Dot1q customers. This is similar to S-Tag/C-Tag capabilities.
        :param pulumi.Input[float] bandwidth_alert_threshold: Specifies the port bandwidth threshold percentage. If
               the bandwidth limit is met or exceeded, an alert is sent to the seller.
        :param pulumi.Input[str] connection_name_label: Custom name used for calling a connections
               e.g. `circuit`. Defaults to `Connection`.
        :param pulumi.Input[str] ctag_label: C-Tag/Inner-Tag label name for the connections.
        :param pulumi.Input[str] description: Description of the service profile.
        :param pulumi.Input[bool] equinix_managed_port_vlan: Applicable when `api_integration` is set to `true`. It
               indicates whether the port and VLAN details are managed by Equinix.
        :param pulumi.Input[str] integration_id: Specifies the API integration ID that was provided to the customer
               during onboarding. You can validate your API integration ID using the validateIntegrationId API.
        :param pulumi.Input[str] name: Name of the service profile. An alpha-numeric 50 characters string which can
               include only hyphens and underscores.
        :param pulumi.Input[str] oversubscription: You can set an alert for when a percentage of your profile has
               been sold. Service providers like to use this functionality to alert them when they need to add
               more ports or when they need to create a new service profile. Required with
               `oversubscription_allowed`, defaults to `1x`.
        :param pulumi.Input[bool] oversubscription_allowed: Boolean value that determines if, regardless of the
               utilization, Equinix Fabric will continue to add connections to your links until we reach the
               oversubscription limit. By selecting this service, you acknowledge that you will manage decisions
               on when to increase capacity on these link.
        :param pulumi.Input[bool] private: Boolean value that indicates whether or not this is a private profile,
               i.e. not public like AWS/Azure/Oracle/Google, etc. If private, it can only be available for
               creating connections if correct permissions are granted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_user_emails: An array of users email ids who have permission to access this
               service profile. Argument is required when profile is set as private.
        :param pulumi.Input[bool] redundancy_required: Boolean value that determines if your connections will require
               redundancy. if yes, then users need to create a secondary redundant connection.
        :param pulumi.Input[bool] secondary_vlan_from_primary: Indicates whether the VLAN ID of. the secondary
               connection is the same as the primary connection.
        :param pulumi.Input[bool] servicekey_autogenerated: Boolean value that indicates whether multiple connections
               can be created with the same authorization key to connect to this service profile after the first
               connection has been approved by the seller.
        :param pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofileSpeedBandArgs']]] speed_bands: One or more definitions of supported speed/bandwidth. Argument is
               required when `speed_from_api` is set to `false`. See Speed Band below for more
               details.
        :param pulumi.Input[bool] speed_customization_allowed: Boolean value that determines if customer is allowed
               to enter a custom connection speed.
        :param pulumi.Input[bool] speed_from_api: Boolean valuta that determines if connection speed will be derived
               from an API call. Argument has to be specified when `api_integration` is enabled.
        :param pulumi.Input[str] tag_type: Specifies additional tagging information required by the seller profile
               for Dot1Q to QinQ translation. See [Enhance Dot1q to QinQ translation support](https://docs.equinix.com/es/Content/Interconnection/Fabric/layer-2/Fabric-Create-Layer2-Service-Profile.htm#:~:text=Enhance%20Dot1q%20to%20QinQ%20translation%20support)
               for additional information. Valid values are:
        """
        pulumi.set(__self__, "bandwidth_threshold_notifications", bandwidth_threshold_notifications)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "profile_statuschange_notifications", profile_statuschange_notifications)
        pulumi.set(__self__, "vc_statuschange_notifications", vc_statuschange_notifications)
        if api_integration is not None:
            pulumi.set(__self__, "api_integration", api_integration)
        if authkey_label is not None:
            pulumi.set(__self__, "authkey_label", authkey_label)
        if bandwidth_alert_threshold is not None:
            pulumi.set(__self__, "bandwidth_alert_threshold", bandwidth_alert_threshold)
        if connection_name_label is not None:
            pulumi.set(__self__, "connection_name_label", connection_name_label)
        if ctag_label is not None:
            pulumi.set(__self__, "ctag_label", ctag_label)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if equinix_managed_port_vlan is not None:
            pulumi.set(__self__, "equinix_managed_port_vlan", equinix_managed_port_vlan)
        if integration_id is not None:
            pulumi.set(__self__, "integration_id", integration_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oversubscription is not None:
            pulumi.set(__self__, "oversubscription", oversubscription)
        if oversubscription_allowed is not None:
            pulumi.set(__self__, "oversubscription_allowed", oversubscription_allowed)
        if private is not None:
            pulumi.set(__self__, "private", private)
        if private_user_emails is not None:
            pulumi.set(__self__, "private_user_emails", private_user_emails)
        if redundancy_required is not None:
            pulumi.set(__self__, "redundancy_required", redundancy_required)
        if secondary_vlan_from_primary is not None:
            pulumi.set(__self__, "secondary_vlan_from_primary", secondary_vlan_from_primary)
        if servicekey_autogenerated is not None:
            pulumi.set(__self__, "servicekey_autogenerated", servicekey_autogenerated)
        if speed_bands is not None:
            pulumi.set(__self__, "speed_bands", speed_bands)
        if speed_customization_allowed is not None:
            pulumi.set(__self__, "speed_customization_allowed", speed_customization_allowed)
        if speed_from_api is not None:
            pulumi.set(__self__, "speed_from_api", speed_from_api)
        if tag_type is not None:
            pulumi.set(__self__, "tag_type", tag_type)

    @property
    @pulumi.getter(name="bandwidthThresholdNotifications")
    def bandwidth_threshold_notifications(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of email addresses that will receive
        notifications about bandwidth thresholds.
        """
        return pulumi.get(self, "bandwidth_threshold_notifications")

    @bandwidth_threshold_notifications.setter
    def bandwidth_threshold_notifications(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "bandwidth_threshold_notifications", value)

    @property
    @pulumi.getter
    def features(self) -> pulumi.Input['ECXL2ServiceprofileFeaturesArgs']:
        """
        Block of profile features configuration. See Features below
        for more details.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: pulumi.Input['ECXL2ServiceprofileFeaturesArgs']):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofilePortArgs']]]:
        """
        One or more definitions of ports residing in locations, from which your
        customers will be able to access services using this service profile. See Port below for
        more details.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofilePortArgs']]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="profileStatuschangeNotifications")
    def profile_statuschange_notifications(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of email addresses that will receive
        notifications about profile status changes.
        """
        return pulumi.get(self, "profile_statuschange_notifications")

    @profile_statuschange_notifications.setter
    def profile_statuschange_notifications(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "profile_statuschange_notifications", value)

    @property
    @pulumi.getter(name="vcStatuschangeNotifications")
    def vc_statuschange_notifications(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of email addresses that will receive
        notifications about connections approvals and rejections.
        """
        return pulumi.get(self, "vc_statuschange_notifications")

    @vc_statuschange_notifications.setter
    def vc_statuschange_notifications(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "vc_statuschange_notifications", value)

    @property
    @pulumi.getter(name="apiIntegration")
    def api_integration(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that determines if API integration is enabled. It
        allows you to complete connection provisioning in less than five minutes. Without API Integration,
        additional manual steps will be required and the provisioning will likely take longer.
        """
        return pulumi.get(self, "api_integration")

    @api_integration.setter
    def api_integration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "api_integration", value)

    @property
    @pulumi.getter(name="authkeyLabel")
    def authkey_label(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the authentication key label to be used by the
        Authentication Key service. It allows Service Providers with QinQ ports to accept groups of
        connections or VLANs from Dot1q customers. This is similar to S-Tag/C-Tag capabilities.
        """
        return pulumi.get(self, "authkey_label")

    @authkey_label.setter
    def authkey_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authkey_label", value)

    @property
    @pulumi.getter(name="bandwidthAlertThreshold")
    def bandwidth_alert_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the port bandwidth threshold percentage. If
        the bandwidth limit is met or exceeded, an alert is sent to the seller.
        """
        return pulumi.get(self, "bandwidth_alert_threshold")

    @bandwidth_alert_threshold.setter
    def bandwidth_alert_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "bandwidth_alert_threshold", value)

    @property
    @pulumi.getter(name="connectionNameLabel")
    def connection_name_label(self) -> Optional[pulumi.Input[str]]:
        """
        Custom name used for calling a connections
        e.g. `circuit`. Defaults to `Connection`.
        """
        return pulumi.get(self, "connection_name_label")

    @connection_name_label.setter
    def connection_name_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name_label", value)

    @property
    @pulumi.getter(name="ctagLabel")
    def ctag_label(self) -> Optional[pulumi.Input[str]]:
        """
        C-Tag/Inner-Tag label name for the connections.
        """
        return pulumi.get(self, "ctag_label")

    @ctag_label.setter
    def ctag_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ctag_label", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the service profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="equinixManagedPortVlan")
    def equinix_managed_port_vlan(self) -> Optional[pulumi.Input[bool]]:
        """
        Applicable when `api_integration` is set to `true`. It
        indicates whether the port and VLAN details are managed by Equinix.
        """
        return pulumi.get(self, "equinix_managed_port_vlan")

    @equinix_managed_port_vlan.setter
    def equinix_managed_port_vlan(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "equinix_managed_port_vlan", value)

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the API integration ID that was provided to the customer
        during onboarding. You can validate your API integration ID using the validateIntegrationId API.
        """
        return pulumi.get(self, "integration_id")

    @integration_id.setter
    def integration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integration_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the service profile. An alpha-numeric 50 characters string which can
        include only hyphens and underscores.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def oversubscription(self) -> Optional[pulumi.Input[str]]:
        """
        You can set an alert for when a percentage of your profile has
        been sold. Service providers like to use this functionality to alert them when they need to add
        more ports or when they need to create a new service profile. Required with
        `oversubscription_allowed`, defaults to `1x`.
        """
        return pulumi.get(self, "oversubscription")

    @oversubscription.setter
    def oversubscription(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oversubscription", value)

    @property
    @pulumi.getter(name="oversubscriptionAllowed")
    def oversubscription_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that determines if, regardless of the
        utilization, Equinix Fabric will continue to add connections to your links until we reach the
        oversubscription limit. By selecting this service, you acknowledge that you will manage decisions
        on when to increase capacity on these link.
        """
        return pulumi.get(self, "oversubscription_allowed")

    @oversubscription_allowed.setter
    def oversubscription_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "oversubscription_allowed", value)

    @property
    @pulumi.getter
    def private(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that indicates whether or not this is a private profile,
        i.e. not public like AWS/Azure/Oracle/Google, etc. If private, it can only be available for
        creating connections if correct permissions are granted.
        """
        return pulumi.get(self, "private")

    @private.setter
    def private(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private", value)

    @property
    @pulumi.getter(name="privateUserEmails")
    def private_user_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of users email ids who have permission to access this
        service profile. Argument is required when profile is set as private.
        """
        return pulumi.get(self, "private_user_emails")

    @private_user_emails.setter
    def private_user_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_user_emails", value)

    @property
    @pulumi.getter(name="redundancyRequired")
    def redundancy_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that determines if your connections will require
        redundancy. if yes, then users need to create a secondary redundant connection.
        """
        return pulumi.get(self, "redundancy_required")

    @redundancy_required.setter
    def redundancy_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "redundancy_required", value)

    @property
    @pulumi.getter(name="secondaryVlanFromPrimary")
    def secondary_vlan_from_primary(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the VLAN ID of. the secondary
        connection is the same as the primary connection.
        """
        return pulumi.get(self, "secondary_vlan_from_primary")

    @secondary_vlan_from_primary.setter
    def secondary_vlan_from_primary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "secondary_vlan_from_primary", value)

    @property
    @pulumi.getter(name="servicekeyAutogenerated")
    def servicekey_autogenerated(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that indicates whether multiple connections
        can be created with the same authorization key to connect to this service profile after the first
        connection has been approved by the seller.
        """
        return pulumi.get(self, "servicekey_autogenerated")

    @servicekey_autogenerated.setter
    def servicekey_autogenerated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "servicekey_autogenerated", value)

    @property
    @pulumi.getter(name="speedBands")
    def speed_bands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofileSpeedBandArgs']]]]:
        """
        One or more definitions of supported speed/bandwidth. Argument is
        required when `speed_from_api` is set to `false`. See Speed Band below for more
        details.
        """
        return pulumi.get(self, "speed_bands")

    @speed_bands.setter
    def speed_bands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofileSpeedBandArgs']]]]):
        pulumi.set(self, "speed_bands", value)

    @property
    @pulumi.getter(name="speedCustomizationAllowed")
    def speed_customization_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that determines if customer is allowed
        to enter a custom connection speed.
        """
        return pulumi.get(self, "speed_customization_allowed")

    @speed_customization_allowed.setter
    def speed_customization_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "speed_customization_allowed", value)

    @property
    @pulumi.getter(name="speedFromApi")
    def speed_from_api(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean valuta that determines if connection speed will be derived
        from an API call. Argument has to be specified when `api_integration` is enabled.
        """
        return pulumi.get(self, "speed_from_api")

    @speed_from_api.setter
    def speed_from_api(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "speed_from_api", value)

    @property
    @pulumi.getter(name="tagType")
    def tag_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies additional tagging information required by the seller profile
        for Dot1Q to QinQ translation. See [Enhance Dot1q to QinQ translation support](https://docs.equinix.com/es/Content/Interconnection/Fabric/layer-2/Fabric-Create-Layer2-Service-Profile.htm#:~:text=Enhance%20Dot1q%20to%20QinQ%20translation%20support)
        for additional information. Valid values are:
        """
        return pulumi.get(self, "tag_type")

    @tag_type.setter
    def tag_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_type", value)


@pulumi.input_type
class _ECXL2ServiceprofileState:
    def __init__(__self__, *,
                 api_integration: Optional[pulumi.Input[bool]] = None,
                 authkey_label: Optional[pulumi.Input[str]] = None,
                 bandwidth_alert_threshold: Optional[pulumi.Input[float]] = None,
                 bandwidth_threshold_notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 connection_name_label: Optional[pulumi.Input[str]] = None,
                 ctag_label: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 equinix_managed_port_vlan: Optional[pulumi.Input[bool]] = None,
                 features: Optional[pulumi.Input['ECXL2ServiceprofileFeaturesArgs']] = None,
                 integration_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oversubscription: Optional[pulumi.Input[str]] = None,
                 oversubscription_allowed: Optional[pulumi.Input[bool]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofilePortArgs']]]] = None,
                 private: Optional[pulumi.Input[bool]] = None,
                 private_user_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 profile_statuschange_notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 redundancy_required: Optional[pulumi.Input[bool]] = None,
                 secondary_vlan_from_primary: Optional[pulumi.Input[bool]] = None,
                 servicekey_autogenerated: Optional[pulumi.Input[bool]] = None,
                 speed_bands: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofileSpeedBandArgs']]]] = None,
                 speed_customization_allowed: Optional[pulumi.Input[bool]] = None,
                 speed_from_api: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tag_type: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 vc_statuschange_notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ECXL2Serviceprofile resources.
        :param pulumi.Input[bool] api_integration: Boolean value that determines if API integration is enabled. It
               allows you to complete connection provisioning in less than five minutes. Without API Integration,
               additional manual steps will be required and the provisioning will likely take longer.
        :param pulumi.Input[str] authkey_label: Name of the authentication key label to be used by the
               Authentication Key service. It allows Service Providers with QinQ ports to accept groups of
               connections or VLANs from Dot1q customers. This is similar to S-Tag/C-Tag capabilities.
        :param pulumi.Input[float] bandwidth_alert_threshold: Specifies the port bandwidth threshold percentage. If
               the bandwidth limit is met or exceeded, an alert is sent to the seller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bandwidth_threshold_notifications: A list of email addresses that will receive
               notifications about bandwidth thresholds.
        :param pulumi.Input[str] connection_name_label: Custom name used for calling a connections
               e.g. `circuit`. Defaults to `Connection`.
        :param pulumi.Input[str] ctag_label: C-Tag/Inner-Tag label name for the connections.
        :param pulumi.Input[str] description: Description of the service profile.
        :param pulumi.Input[bool] equinix_managed_port_vlan: Applicable when `api_integration` is set to `true`. It
               indicates whether the port and VLAN details are managed by Equinix.
        :param pulumi.Input['ECXL2ServiceprofileFeaturesArgs'] features: Block of profile features configuration. See Features below
               for more details.
        :param pulumi.Input[str] integration_id: Specifies the API integration ID that was provided to the customer
               during onboarding. You can validate your API integration ID using the validateIntegrationId API.
        :param pulumi.Input[str] name: Name of the service profile. An alpha-numeric 50 characters string which can
               include only hyphens and underscores.
        :param pulumi.Input[str] oversubscription: You can set an alert for when a percentage of your profile has
               been sold. Service providers like to use this functionality to alert them when they need to add
               more ports or when they need to create a new service profile. Required with
               `oversubscription_allowed`, defaults to `1x`.
        :param pulumi.Input[bool] oversubscription_allowed: Boolean value that determines if, regardless of the
               utilization, Equinix Fabric will continue to add connections to your links until we reach the
               oversubscription limit. By selecting this service, you acknowledge that you will manage decisions
               on when to increase capacity on these link.
        :param pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofilePortArgs']]] ports: One or more definitions of ports residing in locations, from which your
               customers will be able to access services using this service profile. See Port below for
               more details.
        :param pulumi.Input[bool] private: Boolean value that indicates whether or not this is a private profile,
               i.e. not public like AWS/Azure/Oracle/Google, etc. If private, it can only be available for
               creating connections if correct permissions are granted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_user_emails: An array of users email ids who have permission to access this
               service profile. Argument is required when profile is set as private.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] profile_statuschange_notifications: A list of email addresses that will receive
               notifications about profile status changes.
        :param pulumi.Input[bool] redundancy_required: Boolean value that determines if your connections will require
               redundancy. if yes, then users need to create a secondary redundant connection.
        :param pulumi.Input[bool] secondary_vlan_from_primary: Indicates whether the VLAN ID of. the secondary
               connection is the same as the primary connection.
        :param pulumi.Input[bool] servicekey_autogenerated: Boolean value that indicates whether multiple connections
               can be created with the same authorization key to connect to this service profile after the first
               connection has been approved by the seller.
        :param pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofileSpeedBandArgs']]] speed_bands: One or more definitions of supported speed/bandwidth. Argument is
               required when `speed_from_api` is set to `false`. See Speed Band below for more
               details.
        :param pulumi.Input[bool] speed_customization_allowed: Boolean value that determines if customer is allowed
               to enter a custom connection speed.
        :param pulumi.Input[bool] speed_from_api: Boolean valuta that determines if connection speed will be derived
               from an API call. Argument has to be specified when `api_integration` is enabled.
        :param pulumi.Input[str] state: Service profile provisioning status.
        :param pulumi.Input[str] tag_type: Specifies additional tagging information required by the seller profile
               for Dot1Q to QinQ translation. See [Enhance Dot1q to QinQ translation support](https://docs.equinix.com/es/Content/Interconnection/Fabric/layer-2/Fabric-Create-Layer2-Service-Profile.htm#:~:text=Enhance%20Dot1q%20to%20QinQ%20translation%20support)
               for additional information. Valid values are:
        :param pulumi.Input[str] uuid: Unique identifier of the port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vc_statuschange_notifications: A list of email addresses that will receive
               notifications about connections approvals and rejections.
        """
        if api_integration is not None:
            pulumi.set(__self__, "api_integration", api_integration)
        if authkey_label is not None:
            pulumi.set(__self__, "authkey_label", authkey_label)
        if bandwidth_alert_threshold is not None:
            pulumi.set(__self__, "bandwidth_alert_threshold", bandwidth_alert_threshold)
        if bandwidth_threshold_notifications is not None:
            pulumi.set(__self__, "bandwidth_threshold_notifications", bandwidth_threshold_notifications)
        if connection_name_label is not None:
            pulumi.set(__self__, "connection_name_label", connection_name_label)
        if ctag_label is not None:
            pulumi.set(__self__, "ctag_label", ctag_label)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if equinix_managed_port_vlan is not None:
            pulumi.set(__self__, "equinix_managed_port_vlan", equinix_managed_port_vlan)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if integration_id is not None:
            pulumi.set(__self__, "integration_id", integration_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oversubscription is not None:
            pulumi.set(__self__, "oversubscription", oversubscription)
        if oversubscription_allowed is not None:
            pulumi.set(__self__, "oversubscription_allowed", oversubscription_allowed)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if private is not None:
            pulumi.set(__self__, "private", private)
        if private_user_emails is not None:
            pulumi.set(__self__, "private_user_emails", private_user_emails)
        if profile_statuschange_notifications is not None:
            pulumi.set(__self__, "profile_statuschange_notifications", profile_statuschange_notifications)
        if redundancy_required is not None:
            pulumi.set(__self__, "redundancy_required", redundancy_required)
        if secondary_vlan_from_primary is not None:
            pulumi.set(__self__, "secondary_vlan_from_primary", secondary_vlan_from_primary)
        if servicekey_autogenerated is not None:
            pulumi.set(__self__, "servicekey_autogenerated", servicekey_autogenerated)
        if speed_bands is not None:
            pulumi.set(__self__, "speed_bands", speed_bands)
        if speed_customization_allowed is not None:
            pulumi.set(__self__, "speed_customization_allowed", speed_customization_allowed)
        if speed_from_api is not None:
            pulumi.set(__self__, "speed_from_api", speed_from_api)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tag_type is not None:
            pulumi.set(__self__, "tag_type", tag_type)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if vc_statuschange_notifications is not None:
            pulumi.set(__self__, "vc_statuschange_notifications", vc_statuschange_notifications)

    @property
    @pulumi.getter(name="apiIntegration")
    def api_integration(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that determines if API integration is enabled. It
        allows you to complete connection provisioning in less than five minutes. Without API Integration,
        additional manual steps will be required and the provisioning will likely take longer.
        """
        return pulumi.get(self, "api_integration")

    @api_integration.setter
    def api_integration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "api_integration", value)

    @property
    @pulumi.getter(name="authkeyLabel")
    def authkey_label(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the authentication key label to be used by the
        Authentication Key service. It allows Service Providers with QinQ ports to accept groups of
        connections or VLANs from Dot1q customers. This is similar to S-Tag/C-Tag capabilities.
        """
        return pulumi.get(self, "authkey_label")

    @authkey_label.setter
    def authkey_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authkey_label", value)

    @property
    @pulumi.getter(name="bandwidthAlertThreshold")
    def bandwidth_alert_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the port bandwidth threshold percentage. If
        the bandwidth limit is met or exceeded, an alert is sent to the seller.
        """
        return pulumi.get(self, "bandwidth_alert_threshold")

    @bandwidth_alert_threshold.setter
    def bandwidth_alert_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "bandwidth_alert_threshold", value)

    @property
    @pulumi.getter(name="bandwidthThresholdNotifications")
    def bandwidth_threshold_notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of email addresses that will receive
        notifications about bandwidth thresholds.
        """
        return pulumi.get(self, "bandwidth_threshold_notifications")

    @bandwidth_threshold_notifications.setter
    def bandwidth_threshold_notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "bandwidth_threshold_notifications", value)

    @property
    @pulumi.getter(name="connectionNameLabel")
    def connection_name_label(self) -> Optional[pulumi.Input[str]]:
        """
        Custom name used for calling a connections
        e.g. `circuit`. Defaults to `Connection`.
        """
        return pulumi.get(self, "connection_name_label")

    @connection_name_label.setter
    def connection_name_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name_label", value)

    @property
    @pulumi.getter(name="ctagLabel")
    def ctag_label(self) -> Optional[pulumi.Input[str]]:
        """
        C-Tag/Inner-Tag label name for the connections.
        """
        return pulumi.get(self, "ctag_label")

    @ctag_label.setter
    def ctag_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ctag_label", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the service profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="equinixManagedPortVlan")
    def equinix_managed_port_vlan(self) -> Optional[pulumi.Input[bool]]:
        """
        Applicable when `api_integration` is set to `true`. It
        indicates whether the port and VLAN details are managed by Equinix.
        """
        return pulumi.get(self, "equinix_managed_port_vlan")

    @equinix_managed_port_vlan.setter
    def equinix_managed_port_vlan(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "equinix_managed_port_vlan", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input['ECXL2ServiceprofileFeaturesArgs']]:
        """
        Block of profile features configuration. See Features below
        for more details.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input['ECXL2ServiceprofileFeaturesArgs']]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the API integration ID that was provided to the customer
        during onboarding. You can validate your API integration ID using the validateIntegrationId API.
        """
        return pulumi.get(self, "integration_id")

    @integration_id.setter
    def integration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integration_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the service profile. An alpha-numeric 50 characters string which can
        include only hyphens and underscores.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def oversubscription(self) -> Optional[pulumi.Input[str]]:
        """
        You can set an alert for when a percentage of your profile has
        been sold. Service providers like to use this functionality to alert them when they need to add
        more ports or when they need to create a new service profile. Required with
        `oversubscription_allowed`, defaults to `1x`.
        """
        return pulumi.get(self, "oversubscription")

    @oversubscription.setter
    def oversubscription(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oversubscription", value)

    @property
    @pulumi.getter(name="oversubscriptionAllowed")
    def oversubscription_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that determines if, regardless of the
        utilization, Equinix Fabric will continue to add connections to your links until we reach the
        oversubscription limit. By selecting this service, you acknowledge that you will manage decisions
        on when to increase capacity on these link.
        """
        return pulumi.get(self, "oversubscription_allowed")

    @oversubscription_allowed.setter
    def oversubscription_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "oversubscription_allowed", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofilePortArgs']]]]:
        """
        One or more definitions of ports residing in locations, from which your
        customers will be able to access services using this service profile. See Port below for
        more details.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofilePortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def private(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that indicates whether or not this is a private profile,
        i.e. not public like AWS/Azure/Oracle/Google, etc. If private, it can only be available for
        creating connections if correct permissions are granted.
        """
        return pulumi.get(self, "private")

    @private.setter
    def private(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private", value)

    @property
    @pulumi.getter(name="privateUserEmails")
    def private_user_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of users email ids who have permission to access this
        service profile. Argument is required when profile is set as private.
        """
        return pulumi.get(self, "private_user_emails")

    @private_user_emails.setter
    def private_user_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_user_emails", value)

    @property
    @pulumi.getter(name="profileStatuschangeNotifications")
    def profile_statuschange_notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of email addresses that will receive
        notifications about profile status changes.
        """
        return pulumi.get(self, "profile_statuschange_notifications")

    @profile_statuschange_notifications.setter
    def profile_statuschange_notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "profile_statuschange_notifications", value)

    @property
    @pulumi.getter(name="redundancyRequired")
    def redundancy_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that determines if your connections will require
        redundancy. if yes, then users need to create a secondary redundant connection.
        """
        return pulumi.get(self, "redundancy_required")

    @redundancy_required.setter
    def redundancy_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "redundancy_required", value)

    @property
    @pulumi.getter(name="secondaryVlanFromPrimary")
    def secondary_vlan_from_primary(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the VLAN ID of. the secondary
        connection is the same as the primary connection.
        """
        return pulumi.get(self, "secondary_vlan_from_primary")

    @secondary_vlan_from_primary.setter
    def secondary_vlan_from_primary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "secondary_vlan_from_primary", value)

    @property
    @pulumi.getter(name="servicekeyAutogenerated")
    def servicekey_autogenerated(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that indicates whether multiple connections
        can be created with the same authorization key to connect to this service profile after the first
        connection has been approved by the seller.
        """
        return pulumi.get(self, "servicekey_autogenerated")

    @servicekey_autogenerated.setter
    def servicekey_autogenerated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "servicekey_autogenerated", value)

    @property
    @pulumi.getter(name="speedBands")
    def speed_bands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofileSpeedBandArgs']]]]:
        """
        One or more definitions of supported speed/bandwidth. Argument is
        required when `speed_from_api` is set to `false`. See Speed Band below for more
        details.
        """
        return pulumi.get(self, "speed_bands")

    @speed_bands.setter
    def speed_bands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ECXL2ServiceprofileSpeedBandArgs']]]]):
        pulumi.set(self, "speed_bands", value)

    @property
    @pulumi.getter(name="speedCustomizationAllowed")
    def speed_customization_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that determines if customer is allowed
        to enter a custom connection speed.
        """
        return pulumi.get(self, "speed_customization_allowed")

    @speed_customization_allowed.setter
    def speed_customization_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "speed_customization_allowed", value)

    @property
    @pulumi.getter(name="speedFromApi")
    def speed_from_api(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean valuta that determines if connection speed will be derived
        from an API call. Argument has to be specified when `api_integration` is enabled.
        """
        return pulumi.get(self, "speed_from_api")

    @speed_from_api.setter
    def speed_from_api(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "speed_from_api", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Service profile provisioning status.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="tagType")
    def tag_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies additional tagging information required by the seller profile
        for Dot1Q to QinQ translation. See [Enhance Dot1q to QinQ translation support](https://docs.equinix.com/es/Content/Interconnection/Fabric/layer-2/Fabric-Create-Layer2-Service-Profile.htm#:~:text=Enhance%20Dot1q%20to%20QinQ%20translation%20support)
        for additional information. Valid values are:
        """
        return pulumi.get(self, "tag_type")

    @tag_type.setter
    def tag_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_type", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the port.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter(name="vcStatuschangeNotifications")
    def vc_statuschange_notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of email addresses that will receive
        notifications about connections approvals and rejections.
        """
        return pulumi.get(self, "vc_statuschange_notifications")

    @vc_statuschange_notifications.setter
    def vc_statuschange_notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vc_statuschange_notifications", value)


class ECXL2Serviceprofile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_integration: Optional[pulumi.Input[bool]] = None,
                 authkey_label: Optional[pulumi.Input[str]] = None,
                 bandwidth_alert_threshold: Optional[pulumi.Input[float]] = None,
                 bandwidth_threshold_notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 connection_name_label: Optional[pulumi.Input[str]] = None,
                 ctag_label: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 equinix_managed_port_vlan: Optional[pulumi.Input[bool]] = None,
                 features: Optional[pulumi.Input[pulumi.InputType['ECXL2ServiceprofileFeaturesArgs']]] = None,
                 integration_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oversubscription: Optional[pulumi.Input[str]] = None,
                 oversubscription_allowed: Optional[pulumi.Input[bool]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ServiceprofilePortArgs']]]]] = None,
                 private: Optional[pulumi.Input[bool]] = None,
                 private_user_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 profile_statuschange_notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 redundancy_required: Optional[pulumi.Input[bool]] = None,
                 secondary_vlan_from_primary: Optional[pulumi.Input[bool]] = None,
                 servicekey_autogenerated: Optional[pulumi.Input[bool]] = None,
                 speed_bands: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ServiceprofileSpeedBandArgs']]]]] = None,
                 speed_customization_allowed: Optional[pulumi.Input[bool]] = None,
                 speed_from_api: Optional[pulumi.Input[bool]] = None,
                 tag_type: Optional[pulumi.Input[str]] = None,
                 vc_statuschange_notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource `ECXL2Serviceprofile` is used to manage layer 2 service profiles
        in Equinix Fabric.

        This resource relies on the Equinix Fabric API. The parameters
        and attributes available map to the fields described at
        <https://developer.equinix.com/catalog/sellerv3#operation/getProfileByIdOrNameUsingGET>.

        ## Example Usage

        ```python
        import pulumi
        import cuemby_equinix as equinix

        private_profile = equinix.ECXL2Serviceprofile("private-profile",
            bandwidth_threshold_notifications=[
                "John.Doe@example.com",
                "Marry.Doe@example.com",
            ],
            connection_name_label="Connection",
            description="my private profile",
            features=equinix.ECXL2ServiceprofileFeaturesArgs(
                allow_remote_connections=True,
                test_profile=False,
            ),
            ports=[
                equinix.ECXL2ServiceprofilePortArgs(
                    metro_code="NY",
                    uuid="a867f685-422f-22f7-6de0-320a5c00abdd",
                ),
                equinix.ECXL2ServiceprofilePortArgs(
                    metro_code="NY",
                    uuid="a867f685-4231-2317-6de0-320a5c00abdd",
                ),
            ],
            private=True,
            private_user_emails=[
                "John.Doe@example.com",
                "Marry.Doe@example.com",
            ],
            profile_statuschange_notifications=[
                "John.Doe@example.com",
                "Marry.Doe@example.com",
            ],
            speed_bands=[
                equinix.ECXL2ServiceprofileSpeedBandArgs(
                    speed=1000,
                    speed_unit="MB",
                ),
                equinix.ECXL2ServiceprofileSpeedBandArgs(
                    speed=500,
                    speed_unit="MB",
                ),
                equinix.ECXL2ServiceprofileSpeedBandArgs(
                    speed=100,
                    speed_unit="MB",
                ),
            ],
            vc_statuschange_notifications=[
                "John.Doe@example.com",
                "Marry.Doe@example.com",
            ])
        ```

        ## Import

        This resource can be imported using an existing ID

        ```sh
         $ pulumi import equinix:index/eCXL2Serviceprofile:ECXL2Serviceprofile example {existing_id}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] api_integration: Boolean value that determines if API integration is enabled. It
               allows you to complete connection provisioning in less than five minutes. Without API Integration,
               additional manual steps will be required and the provisioning will likely take longer.
        :param pulumi.Input[str] authkey_label: Name of the authentication key label to be used by the
               Authentication Key service. It allows Service Providers with QinQ ports to accept groups of
               connections or VLANs from Dot1q customers. This is similar to S-Tag/C-Tag capabilities.
        :param pulumi.Input[float] bandwidth_alert_threshold: Specifies the port bandwidth threshold percentage. If
               the bandwidth limit is met or exceeded, an alert is sent to the seller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bandwidth_threshold_notifications: A list of email addresses that will receive
               notifications about bandwidth thresholds.
        :param pulumi.Input[str] connection_name_label: Custom name used for calling a connections
               e.g. `circuit`. Defaults to `Connection`.
        :param pulumi.Input[str] ctag_label: C-Tag/Inner-Tag label name for the connections.
        :param pulumi.Input[str] description: Description of the service profile.
        :param pulumi.Input[bool] equinix_managed_port_vlan: Applicable when `api_integration` is set to `true`. It
               indicates whether the port and VLAN details are managed by Equinix.
        :param pulumi.Input[pulumi.InputType['ECXL2ServiceprofileFeaturesArgs']] features: Block of profile features configuration. See Features below
               for more details.
        :param pulumi.Input[str] integration_id: Specifies the API integration ID that was provided to the customer
               during onboarding. You can validate your API integration ID using the validateIntegrationId API.
        :param pulumi.Input[str] name: Name of the service profile. An alpha-numeric 50 characters string which can
               include only hyphens and underscores.
        :param pulumi.Input[str] oversubscription: You can set an alert for when a percentage of your profile has
               been sold. Service providers like to use this functionality to alert them when they need to add
               more ports or when they need to create a new service profile. Required with
               `oversubscription_allowed`, defaults to `1x`.
        :param pulumi.Input[bool] oversubscription_allowed: Boolean value that determines if, regardless of the
               utilization, Equinix Fabric will continue to add connections to your links until we reach the
               oversubscription limit. By selecting this service, you acknowledge that you will manage decisions
               on when to increase capacity on these link.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ServiceprofilePortArgs']]]] ports: One or more definitions of ports residing in locations, from which your
               customers will be able to access services using this service profile. See Port below for
               more details.
        :param pulumi.Input[bool] private: Boolean value that indicates whether or not this is a private profile,
               i.e. not public like AWS/Azure/Oracle/Google, etc. If private, it can only be available for
               creating connections if correct permissions are granted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_user_emails: An array of users email ids who have permission to access this
               service profile. Argument is required when profile is set as private.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] profile_statuschange_notifications: A list of email addresses that will receive
               notifications about profile status changes.
        :param pulumi.Input[bool] redundancy_required: Boolean value that determines if your connections will require
               redundancy. if yes, then users need to create a secondary redundant connection.
        :param pulumi.Input[bool] secondary_vlan_from_primary: Indicates whether the VLAN ID of. the secondary
               connection is the same as the primary connection.
        :param pulumi.Input[bool] servicekey_autogenerated: Boolean value that indicates whether multiple connections
               can be created with the same authorization key to connect to this service profile after the first
               connection has been approved by the seller.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ServiceprofileSpeedBandArgs']]]] speed_bands: One or more definitions of supported speed/bandwidth. Argument is
               required when `speed_from_api` is set to `false`. See Speed Band below for more
               details.
        :param pulumi.Input[bool] speed_customization_allowed: Boolean value that determines if customer is allowed
               to enter a custom connection speed.
        :param pulumi.Input[bool] speed_from_api: Boolean valuta that determines if connection speed will be derived
               from an API call. Argument has to be specified when `api_integration` is enabled.
        :param pulumi.Input[str] tag_type: Specifies additional tagging information required by the seller profile
               for Dot1Q to QinQ translation. See [Enhance Dot1q to QinQ translation support](https://docs.equinix.com/es/Content/Interconnection/Fabric/layer-2/Fabric-Create-Layer2-Service-Profile.htm#:~:text=Enhance%20Dot1q%20to%20QinQ%20translation%20support)
               for additional information. Valid values are:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vc_statuschange_notifications: A list of email addresses that will receive
               notifications about connections approvals and rejections.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ECXL2ServiceprofileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource `ECXL2Serviceprofile` is used to manage layer 2 service profiles
        in Equinix Fabric.

        This resource relies on the Equinix Fabric API. The parameters
        and attributes available map to the fields described at
        <https://developer.equinix.com/catalog/sellerv3#operation/getProfileByIdOrNameUsingGET>.

        ## Example Usage

        ```python
        import pulumi
        import cuemby_equinix as equinix

        private_profile = equinix.ECXL2Serviceprofile("private-profile",
            bandwidth_threshold_notifications=[
                "John.Doe@example.com",
                "Marry.Doe@example.com",
            ],
            connection_name_label="Connection",
            description="my private profile",
            features=equinix.ECXL2ServiceprofileFeaturesArgs(
                allow_remote_connections=True,
                test_profile=False,
            ),
            ports=[
                equinix.ECXL2ServiceprofilePortArgs(
                    metro_code="NY",
                    uuid="a867f685-422f-22f7-6de0-320a5c00abdd",
                ),
                equinix.ECXL2ServiceprofilePortArgs(
                    metro_code="NY",
                    uuid="a867f685-4231-2317-6de0-320a5c00abdd",
                ),
            ],
            private=True,
            private_user_emails=[
                "John.Doe@example.com",
                "Marry.Doe@example.com",
            ],
            profile_statuschange_notifications=[
                "John.Doe@example.com",
                "Marry.Doe@example.com",
            ],
            speed_bands=[
                equinix.ECXL2ServiceprofileSpeedBandArgs(
                    speed=1000,
                    speed_unit="MB",
                ),
                equinix.ECXL2ServiceprofileSpeedBandArgs(
                    speed=500,
                    speed_unit="MB",
                ),
                equinix.ECXL2ServiceprofileSpeedBandArgs(
                    speed=100,
                    speed_unit="MB",
                ),
            ],
            vc_statuschange_notifications=[
                "John.Doe@example.com",
                "Marry.Doe@example.com",
            ])
        ```

        ## Import

        This resource can be imported using an existing ID

        ```sh
         $ pulumi import equinix:index/eCXL2Serviceprofile:ECXL2Serviceprofile example {existing_id}
        ```

        :param str resource_name: The name of the resource.
        :param ECXL2ServiceprofileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ECXL2ServiceprofileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_integration: Optional[pulumi.Input[bool]] = None,
                 authkey_label: Optional[pulumi.Input[str]] = None,
                 bandwidth_alert_threshold: Optional[pulumi.Input[float]] = None,
                 bandwidth_threshold_notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 connection_name_label: Optional[pulumi.Input[str]] = None,
                 ctag_label: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 equinix_managed_port_vlan: Optional[pulumi.Input[bool]] = None,
                 features: Optional[pulumi.Input[pulumi.InputType['ECXL2ServiceprofileFeaturesArgs']]] = None,
                 integration_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oversubscription: Optional[pulumi.Input[str]] = None,
                 oversubscription_allowed: Optional[pulumi.Input[bool]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ServiceprofilePortArgs']]]]] = None,
                 private: Optional[pulumi.Input[bool]] = None,
                 private_user_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 profile_statuschange_notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 redundancy_required: Optional[pulumi.Input[bool]] = None,
                 secondary_vlan_from_primary: Optional[pulumi.Input[bool]] = None,
                 servicekey_autogenerated: Optional[pulumi.Input[bool]] = None,
                 speed_bands: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ServiceprofileSpeedBandArgs']]]]] = None,
                 speed_customization_allowed: Optional[pulumi.Input[bool]] = None,
                 speed_from_api: Optional[pulumi.Input[bool]] = None,
                 tag_type: Optional[pulumi.Input[str]] = None,
                 vc_statuschange_notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ECXL2ServiceprofileArgs.__new__(ECXL2ServiceprofileArgs)

            __props__.__dict__["api_integration"] = api_integration
            __props__.__dict__["authkey_label"] = authkey_label
            __props__.__dict__["bandwidth_alert_threshold"] = bandwidth_alert_threshold
            if bandwidth_threshold_notifications is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth_threshold_notifications'")
            __props__.__dict__["bandwidth_threshold_notifications"] = bandwidth_threshold_notifications
            __props__.__dict__["connection_name_label"] = connection_name_label
            __props__.__dict__["ctag_label"] = ctag_label
            __props__.__dict__["description"] = description
            __props__.__dict__["equinix_managed_port_vlan"] = equinix_managed_port_vlan
            if features is None and not opts.urn:
                raise TypeError("Missing required property 'features'")
            __props__.__dict__["features"] = features
            __props__.__dict__["integration_id"] = integration_id
            __props__.__dict__["name"] = name
            __props__.__dict__["oversubscription"] = oversubscription
            __props__.__dict__["oversubscription_allowed"] = oversubscription_allowed
            if ports is None and not opts.urn:
                raise TypeError("Missing required property 'ports'")
            __props__.__dict__["ports"] = ports
            __props__.__dict__["private"] = private
            __props__.__dict__["private_user_emails"] = private_user_emails
            if profile_statuschange_notifications is None and not opts.urn:
                raise TypeError("Missing required property 'profile_statuschange_notifications'")
            __props__.__dict__["profile_statuschange_notifications"] = profile_statuschange_notifications
            __props__.__dict__["redundancy_required"] = redundancy_required
            __props__.__dict__["secondary_vlan_from_primary"] = secondary_vlan_from_primary
            __props__.__dict__["servicekey_autogenerated"] = servicekey_autogenerated
            __props__.__dict__["speed_bands"] = speed_bands
            __props__.__dict__["speed_customization_allowed"] = speed_customization_allowed
            __props__.__dict__["speed_from_api"] = speed_from_api
            __props__.__dict__["tag_type"] = tag_type
            if vc_statuschange_notifications is None and not opts.urn:
                raise TypeError("Missing required property 'vc_statuschange_notifications'")
            __props__.__dict__["vc_statuschange_notifications"] = vc_statuschange_notifications
            __props__.__dict__["state"] = None
            __props__.__dict__["uuid"] = None
        super(ECXL2Serviceprofile, __self__).__init__(
            'equinix:index/eCXL2Serviceprofile:ECXL2Serviceprofile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_integration: Optional[pulumi.Input[bool]] = None,
            authkey_label: Optional[pulumi.Input[str]] = None,
            bandwidth_alert_threshold: Optional[pulumi.Input[float]] = None,
            bandwidth_threshold_notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            connection_name_label: Optional[pulumi.Input[str]] = None,
            ctag_label: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            equinix_managed_port_vlan: Optional[pulumi.Input[bool]] = None,
            features: Optional[pulumi.Input[pulumi.InputType['ECXL2ServiceprofileFeaturesArgs']]] = None,
            integration_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            oversubscription: Optional[pulumi.Input[str]] = None,
            oversubscription_allowed: Optional[pulumi.Input[bool]] = None,
            ports: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ServiceprofilePortArgs']]]]] = None,
            private: Optional[pulumi.Input[bool]] = None,
            private_user_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            profile_statuschange_notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            redundancy_required: Optional[pulumi.Input[bool]] = None,
            secondary_vlan_from_primary: Optional[pulumi.Input[bool]] = None,
            servicekey_autogenerated: Optional[pulumi.Input[bool]] = None,
            speed_bands: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ServiceprofileSpeedBandArgs']]]]] = None,
            speed_customization_allowed: Optional[pulumi.Input[bool]] = None,
            speed_from_api: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tag_type: Optional[pulumi.Input[str]] = None,
            uuid: Optional[pulumi.Input[str]] = None,
            vc_statuschange_notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'ECXL2Serviceprofile':
        """
        Get an existing ECXL2Serviceprofile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] api_integration: Boolean value that determines if API integration is enabled. It
               allows you to complete connection provisioning in less than five minutes. Without API Integration,
               additional manual steps will be required and the provisioning will likely take longer.
        :param pulumi.Input[str] authkey_label: Name of the authentication key label to be used by the
               Authentication Key service. It allows Service Providers with QinQ ports to accept groups of
               connections or VLANs from Dot1q customers. This is similar to S-Tag/C-Tag capabilities.
        :param pulumi.Input[float] bandwidth_alert_threshold: Specifies the port bandwidth threshold percentage. If
               the bandwidth limit is met or exceeded, an alert is sent to the seller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bandwidth_threshold_notifications: A list of email addresses that will receive
               notifications about bandwidth thresholds.
        :param pulumi.Input[str] connection_name_label: Custom name used for calling a connections
               e.g. `circuit`. Defaults to `Connection`.
        :param pulumi.Input[str] ctag_label: C-Tag/Inner-Tag label name for the connections.
        :param pulumi.Input[str] description: Description of the service profile.
        :param pulumi.Input[bool] equinix_managed_port_vlan: Applicable when `api_integration` is set to `true`. It
               indicates whether the port and VLAN details are managed by Equinix.
        :param pulumi.Input[pulumi.InputType['ECXL2ServiceprofileFeaturesArgs']] features: Block of profile features configuration. See Features below
               for more details.
        :param pulumi.Input[str] integration_id: Specifies the API integration ID that was provided to the customer
               during onboarding. You can validate your API integration ID using the validateIntegrationId API.
        :param pulumi.Input[str] name: Name of the service profile. An alpha-numeric 50 characters string which can
               include only hyphens and underscores.
        :param pulumi.Input[str] oversubscription: You can set an alert for when a percentage of your profile has
               been sold. Service providers like to use this functionality to alert them when they need to add
               more ports or when they need to create a new service profile. Required with
               `oversubscription_allowed`, defaults to `1x`.
        :param pulumi.Input[bool] oversubscription_allowed: Boolean value that determines if, regardless of the
               utilization, Equinix Fabric will continue to add connections to your links until we reach the
               oversubscription limit. By selecting this service, you acknowledge that you will manage decisions
               on when to increase capacity on these link.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ServiceprofilePortArgs']]]] ports: One or more definitions of ports residing in locations, from which your
               customers will be able to access services using this service profile. See Port below for
               more details.
        :param pulumi.Input[bool] private: Boolean value that indicates whether or not this is a private profile,
               i.e. not public like AWS/Azure/Oracle/Google, etc. If private, it can only be available for
               creating connections if correct permissions are granted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_user_emails: An array of users email ids who have permission to access this
               service profile. Argument is required when profile is set as private.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] profile_statuschange_notifications: A list of email addresses that will receive
               notifications about profile status changes.
        :param pulumi.Input[bool] redundancy_required: Boolean value that determines if your connections will require
               redundancy. if yes, then users need to create a secondary redundant connection.
        :param pulumi.Input[bool] secondary_vlan_from_primary: Indicates whether the VLAN ID of. the secondary
               connection is the same as the primary connection.
        :param pulumi.Input[bool] servicekey_autogenerated: Boolean value that indicates whether multiple connections
               can be created with the same authorization key to connect to this service profile after the first
               connection has been approved by the seller.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ECXL2ServiceprofileSpeedBandArgs']]]] speed_bands: One or more definitions of supported speed/bandwidth. Argument is
               required when `speed_from_api` is set to `false`. See Speed Band below for more
               details.
        :param pulumi.Input[bool] speed_customization_allowed: Boolean value that determines if customer is allowed
               to enter a custom connection speed.
        :param pulumi.Input[bool] speed_from_api: Boolean valuta that determines if connection speed will be derived
               from an API call. Argument has to be specified when `api_integration` is enabled.
        :param pulumi.Input[str] state: Service profile provisioning status.
        :param pulumi.Input[str] tag_type: Specifies additional tagging information required by the seller profile
               for Dot1Q to QinQ translation. See [Enhance Dot1q to QinQ translation support](https://docs.equinix.com/es/Content/Interconnection/Fabric/layer-2/Fabric-Create-Layer2-Service-Profile.htm#:~:text=Enhance%20Dot1q%20to%20QinQ%20translation%20support)
               for additional information. Valid values are:
        :param pulumi.Input[str] uuid: Unique identifier of the port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vc_statuschange_notifications: A list of email addresses that will receive
               notifications about connections approvals and rejections.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ECXL2ServiceprofileState.__new__(_ECXL2ServiceprofileState)

        __props__.__dict__["api_integration"] = api_integration
        __props__.__dict__["authkey_label"] = authkey_label
        __props__.__dict__["bandwidth_alert_threshold"] = bandwidth_alert_threshold
        __props__.__dict__["bandwidth_threshold_notifications"] = bandwidth_threshold_notifications
        __props__.__dict__["connection_name_label"] = connection_name_label
        __props__.__dict__["ctag_label"] = ctag_label
        __props__.__dict__["description"] = description
        __props__.__dict__["equinix_managed_port_vlan"] = equinix_managed_port_vlan
        __props__.__dict__["features"] = features
        __props__.__dict__["integration_id"] = integration_id
        __props__.__dict__["name"] = name
        __props__.__dict__["oversubscription"] = oversubscription
        __props__.__dict__["oversubscription_allowed"] = oversubscription_allowed
        __props__.__dict__["ports"] = ports
        __props__.__dict__["private"] = private
        __props__.__dict__["private_user_emails"] = private_user_emails
        __props__.__dict__["profile_statuschange_notifications"] = profile_statuschange_notifications
        __props__.__dict__["redundancy_required"] = redundancy_required
        __props__.__dict__["secondary_vlan_from_primary"] = secondary_vlan_from_primary
        __props__.__dict__["servicekey_autogenerated"] = servicekey_autogenerated
        __props__.__dict__["speed_bands"] = speed_bands
        __props__.__dict__["speed_customization_allowed"] = speed_customization_allowed
        __props__.__dict__["speed_from_api"] = speed_from_api
        __props__.__dict__["state"] = state
        __props__.__dict__["tag_type"] = tag_type
        __props__.__dict__["uuid"] = uuid
        __props__.__dict__["vc_statuschange_notifications"] = vc_statuschange_notifications
        return ECXL2Serviceprofile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiIntegration")
    def api_integration(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value that determines if API integration is enabled. It
        allows you to complete connection provisioning in less than five minutes. Without API Integration,
        additional manual steps will be required and the provisioning will likely take longer.
        """
        return pulumi.get(self, "api_integration")

    @property
    @pulumi.getter(name="authkeyLabel")
    def authkey_label(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the authentication key label to be used by the
        Authentication Key service. It allows Service Providers with QinQ ports to accept groups of
        connections or VLANs from Dot1q customers. This is similar to S-Tag/C-Tag capabilities.
        """
        return pulumi.get(self, "authkey_label")

    @property
    @pulumi.getter(name="bandwidthAlertThreshold")
    def bandwidth_alert_threshold(self) -> pulumi.Output[Optional[float]]:
        """
        Specifies the port bandwidth threshold percentage. If
        the bandwidth limit is met or exceeded, an alert is sent to the seller.
        """
        return pulumi.get(self, "bandwidth_alert_threshold")

    @property
    @pulumi.getter(name="bandwidthThresholdNotifications")
    def bandwidth_threshold_notifications(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of email addresses that will receive
        notifications about bandwidth thresholds.
        """
        return pulumi.get(self, "bandwidth_threshold_notifications")

    @property
    @pulumi.getter(name="connectionNameLabel")
    def connection_name_label(self) -> pulumi.Output[Optional[str]]:
        """
        Custom name used for calling a connections
        e.g. `circuit`. Defaults to `Connection`.
        """
        return pulumi.get(self, "connection_name_label")

    @property
    @pulumi.getter(name="ctagLabel")
    def ctag_label(self) -> pulumi.Output[Optional[str]]:
        """
        C-Tag/Inner-Tag label name for the connections.
        """
        return pulumi.get(self, "ctag_label")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the service profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="equinixManagedPortVlan")
    def equinix_managed_port_vlan(self) -> pulumi.Output[Optional[bool]]:
        """
        Applicable when `api_integration` is set to `true`. It
        indicates whether the port and VLAN details are managed by Equinix.
        """
        return pulumi.get(self, "equinix_managed_port_vlan")

    @property
    @pulumi.getter
    def features(self) -> pulumi.Output['outputs.ECXL2ServiceprofileFeatures']:
        """
        Block of profile features configuration. See Features below
        for more details.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the API integration ID that was provided to the customer
        during onboarding. You can validate your API integration ID using the validateIntegrationId API.
        """
        return pulumi.get(self, "integration_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the service profile. An alpha-numeric 50 characters string which can
        include only hyphens and underscores.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def oversubscription(self) -> pulumi.Output[Optional[str]]:
        """
        You can set an alert for when a percentage of your profile has
        been sold. Service providers like to use this functionality to alert them when they need to add
        more ports or when they need to create a new service profile. Required with
        `oversubscription_allowed`, defaults to `1x`.
        """
        return pulumi.get(self, "oversubscription")

    @property
    @pulumi.getter(name="oversubscriptionAllowed")
    def oversubscription_allowed(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value that determines if, regardless of the
        utilization, Equinix Fabric will continue to add connections to your links until we reach the
        oversubscription limit. By selecting this service, you acknowledge that you will manage decisions
        on when to increase capacity on these link.
        """
        return pulumi.get(self, "oversubscription_allowed")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[Sequence['outputs.ECXL2ServiceprofilePort']]:
        """
        One or more definitions of ports residing in locations, from which your
        customers will be able to access services using this service profile. See Port below for
        more details.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def private(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value that indicates whether or not this is a private profile,
        i.e. not public like AWS/Azure/Oracle/Google, etc. If private, it can only be available for
        creating connections if correct permissions are granted.
        """
        return pulumi.get(self, "private")

    @property
    @pulumi.getter(name="privateUserEmails")
    def private_user_emails(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of users email ids who have permission to access this
        service profile. Argument is required when profile is set as private.
        """
        return pulumi.get(self, "private_user_emails")

    @property
    @pulumi.getter(name="profileStatuschangeNotifications")
    def profile_statuschange_notifications(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of email addresses that will receive
        notifications about profile status changes.
        """
        return pulumi.get(self, "profile_statuschange_notifications")

    @property
    @pulumi.getter(name="redundancyRequired")
    def redundancy_required(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value that determines if your connections will require
        redundancy. if yes, then users need to create a secondary redundant connection.
        """
        return pulumi.get(self, "redundancy_required")

    @property
    @pulumi.getter(name="secondaryVlanFromPrimary")
    def secondary_vlan_from_primary(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the VLAN ID of. the secondary
        connection is the same as the primary connection.
        """
        return pulumi.get(self, "secondary_vlan_from_primary")

    @property
    @pulumi.getter(name="servicekeyAutogenerated")
    def servicekey_autogenerated(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value that indicates whether multiple connections
        can be created with the same authorization key to connect to this service profile after the first
        connection has been approved by the seller.
        """
        return pulumi.get(self, "servicekey_autogenerated")

    @property
    @pulumi.getter(name="speedBands")
    def speed_bands(self) -> pulumi.Output[Optional[Sequence['outputs.ECXL2ServiceprofileSpeedBand']]]:
        """
        One or more definitions of supported speed/bandwidth. Argument is
        required when `speed_from_api` is set to `false`. See Speed Band below for more
        details.
        """
        return pulumi.get(self, "speed_bands")

    @property
    @pulumi.getter(name="speedCustomizationAllowed")
    def speed_customization_allowed(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value that determines if customer is allowed
        to enter a custom connection speed.
        """
        return pulumi.get(self, "speed_customization_allowed")

    @property
    @pulumi.getter(name="speedFromApi")
    def speed_from_api(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean valuta that determines if connection speed will be derived
        from an API call. Argument has to be specified when `api_integration` is enabled.
        """
        return pulumi.get(self, "speed_from_api")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Service profile provisioning status.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tagType")
    def tag_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies additional tagging information required by the seller profile
        for Dot1Q to QinQ translation. See [Enhance Dot1q to QinQ translation support](https://docs.equinix.com/es/Content/Interconnection/Fabric/layer-2/Fabric-Create-Layer2-Service-Profile.htm#:~:text=Enhance%20Dot1q%20to%20QinQ%20translation%20support)
        for additional information. Valid values are:
        """
        return pulumi.get(self, "tag_type")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[str]:
        """
        Unique identifier of the port.
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="vcStatuschangeNotifications")
    def vc_statuschange_notifications(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of email addresses that will receive
        notifications about connections approvals and rejections.
        """
        return pulumi.get(self, "vc_statuschange_notifications")

