# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetECXL2SellerprofileResult',
    'AwaitableGetECXL2SellerprofileResult',
    'get_ecxl2_sellerprofile',
    'get_ecxl2_sellerprofile_output',
]

@pulumi.output_type
class GetECXL2SellerprofileResult:
    """
    A collection of values returned by GetECXL2Sellerprofile.
    """
    def __init__(__self__, additional_infos=None, description=None, encapsulation=None, id=None, metros=None, name=None, organization_global_name=None, organization_name=None, redundancy_required=None, speed_bands=None, speed_customization_allowed=None, speed_from_api=None, uuid=None):
        if additional_infos and not isinstance(additional_infos, list):
            raise TypeError("Expected argument 'additional_infos' to be a list")
        pulumi.set(__self__, "additional_infos", additional_infos)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if encapsulation and not isinstance(encapsulation, str):
            raise TypeError("Expected argument 'encapsulation' to be a str")
        pulumi.set(__self__, "encapsulation", encapsulation)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metros and not isinstance(metros, list):
            raise TypeError("Expected argument 'metros' to be a list")
        pulumi.set(__self__, "metros", metros)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_global_name and not isinstance(organization_global_name, str):
            raise TypeError("Expected argument 'organization_global_name' to be a str")
        pulumi.set(__self__, "organization_global_name", organization_global_name)
        if organization_name and not isinstance(organization_name, str):
            raise TypeError("Expected argument 'organization_name' to be a str")
        pulumi.set(__self__, "organization_name", organization_name)
        if redundancy_required and not isinstance(redundancy_required, bool):
            raise TypeError("Expected argument 'redundancy_required' to be a bool")
        pulumi.set(__self__, "redundancy_required", redundancy_required)
        if speed_bands and not isinstance(speed_bands, list):
            raise TypeError("Expected argument 'speed_bands' to be a list")
        pulumi.set(__self__, "speed_bands", speed_bands)
        if speed_customization_allowed and not isinstance(speed_customization_allowed, bool):
            raise TypeError("Expected argument 'speed_customization_allowed' to be a bool")
        pulumi.set(__self__, "speed_customization_allowed", speed_customization_allowed)
        if speed_from_api and not isinstance(speed_from_api, bool):
            raise TypeError("Expected argument 'speed_from_api' to be a bool")
        pulumi.set(__self__, "speed_from_api", speed_from_api)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="additionalInfos")
    def additional_infos(self) -> Sequence['outputs.GetECXL2SellerprofileAdditionalInfoResult']:
        """
        One or more specifications of additional buyer information attributes that
        can be provided in connection definition that uses given seller profile.
        See Additional Info Attribute below for more details.
        """
        return pulumi.get(self, "additional_infos")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Textual description of additional information attribute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def encapsulation(self) -> str:
        """
        Seller profile's encapsulation (either Dot1q or QinQ).
        """
        return pulumi.get(self, "encapsulation")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metros(self) -> Sequence['outputs.GetECXL2SellerprofileMetroResult']:
        """
        One or more specifications of metro locations supported by seller profile.
        See Metro Attribute below for more details.
        """
        return pulumi.get(self, "metros")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of additional information attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationGlobalName")
    def organization_global_name(self) -> str:
        return pulumi.get(self, "organization_global_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> str:
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="redundancyRequired")
    def redundancy_required(self) -> bool:
        """
        Boolean that indicate if seller requires connections to be redundant
        """
        return pulumi.get(self, "redundancy_required")

    @property
    @pulumi.getter(name="speedBands")
    def speed_bands(self) -> Sequence['outputs.GetECXL2SellerprofileSpeedBandResult']:
        """
        One or more specifications of speed/bandwidth supported by given seller profile.
        See Speed Band Attribute below for more details.
        """
        return pulumi.get(self, "speed_bands")

    @property
    @pulumi.getter(name="speedCustomizationAllowed")
    def speed_customization_allowed(self) -> bool:
        """
        Boolean that indicates if seller allows customer to enter a
        custom connection speed.
        """
        return pulumi.get(self, "speed_customization_allowed")

    @property
    @pulumi.getter(name="speedFromApi")
    def speed_from_api(self) -> bool:
        """
        Boolean that indicates if seller is deriving connection speed from an API call.
        """
        return pulumi.get(self, "speed_from_api")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        Unique identifier of the seller profile.
        """
        return pulumi.get(self, "uuid")


class AwaitableGetECXL2SellerprofileResult(GetECXL2SellerprofileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetECXL2SellerprofileResult(
            additional_infos=self.additional_infos,
            description=self.description,
            encapsulation=self.encapsulation,
            id=self.id,
            metros=self.metros,
            name=self.name,
            organization_global_name=self.organization_global_name,
            organization_name=self.organization_name,
            redundancy_required=self.redundancy_required,
            speed_bands=self.speed_bands,
            speed_customization_allowed=self.speed_customization_allowed,
            speed_from_api=self.speed_from_api,
            uuid=self.uuid)


def get_ecxl2_sellerprofile(name: Optional[str] = None,
                            organization_global_name: Optional[str] = None,
                            organization_name: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetECXL2SellerprofileResult:
    """
    Use this data source to get details of Equinix Fabric layer 2 seller profile with a given name
    and / or organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_equinix as equinix

    aws = equinix.get_ecxl2_sellerprofile(name="AWS Direct Connect")
    pulumi.export("id", aws.id)
    ```


    :param str name: Name of the seller profile.
    :param str organization_global_name: Name of seller's global organization.
    :param str organization_name: Name of seller's organization.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['organizationGlobalName'] = organization_global_name
    __args__['organizationName'] = organization_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
    __ret__ = pulumi.runtime.invoke('equinix:index/getECXL2Sellerprofile:GetECXL2Sellerprofile', __args__, opts=opts, typ=GetECXL2SellerprofileResult).value

    return AwaitableGetECXL2SellerprofileResult(
        additional_infos=__ret__.additional_infos,
        description=__ret__.description,
        encapsulation=__ret__.encapsulation,
        id=__ret__.id,
        metros=__ret__.metros,
        name=__ret__.name,
        organization_global_name=__ret__.organization_global_name,
        organization_name=__ret__.organization_name,
        redundancy_required=__ret__.redundancy_required,
        speed_bands=__ret__.speed_bands,
        speed_customization_allowed=__ret__.speed_customization_allowed,
        speed_from_api=__ret__.speed_from_api,
        uuid=__ret__.uuid)


@_utilities.lift_output_func(get_ecxl2_sellerprofile)
def get_ecxl2_sellerprofile_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                                   organization_global_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   organization_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetECXL2SellerprofileResult]:
    """
    Use this data source to get details of Equinix Fabric layer 2 seller profile with a given name
    and / or organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_equinix as equinix

    aws = equinix.get_ecxl2_sellerprofile(name="AWS Direct Connect")
    pulumi.export("id", aws.id)
    ```


    :param str name: Name of the seller profile.
    :param str organization_global_name: Name of seller's global organization.
    :param str organization_name: Name of seller's organization.
    """
    ...
