# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetECXL2SellerprofilesResult',
    'AwaitableGetECXL2SellerprofilesResult',
    'get_ecxl2_sellerprofiles',
    'get_ecxl2_sellerprofiles_output',
]

@pulumi.output_type
class GetECXL2SellerprofilesResult:
    """
    A collection of values returned by GetECXL2Sellerprofiles.
    """
    def __init__(__self__, id=None, metro_codes=None, name_regex=None, organization_global_name=None, organization_name=None, profiles=None, speed_bands=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metro_codes and not isinstance(metro_codes, list):
            raise TypeError("Expected argument 'metro_codes' to be a list")
        pulumi.set(__self__, "metro_codes", metro_codes)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if organization_global_name and not isinstance(organization_global_name, str):
            raise TypeError("Expected argument 'organization_global_name' to be a str")
        pulumi.set(__self__, "organization_global_name", organization_global_name)
        if organization_name and not isinstance(organization_name, str):
            raise TypeError("Expected argument 'organization_name' to be a str")
        pulumi.set(__self__, "organization_name", organization_name)
        if profiles and not isinstance(profiles, list):
            raise TypeError("Expected argument 'profiles' to be a list")
        pulumi.set(__self__, "profiles", profiles)
        if speed_bands and not isinstance(speed_bands, list):
            raise TypeError("Expected argument 'speed_bands' to be a list")
        pulumi.set(__self__, "speed_bands", speed_bands)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="metroCodes")
    def metro_codes(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "metro_codes")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="organizationGlobalName")
    def organization_global_name(self) -> Optional[str]:
        return pulumi.get(self, "organization_global_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[str]:
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter
    def profiles(self) -> Sequence['outputs.GetECXL2SellerprofilesProfileResult']:
        """
        List of resulting profiles. Each element in the `profiles` list exports all
        Service Profile Attributes.
        """
        return pulumi.get(self, "profiles")

    @property
    @pulumi.getter(name="speedBands")
    def speed_bands(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "speed_bands")


class AwaitableGetECXL2SellerprofilesResult(GetECXL2SellerprofilesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetECXL2SellerprofilesResult(
            id=self.id,
            metro_codes=self.metro_codes,
            name_regex=self.name_regex,
            organization_global_name=self.organization_global_name,
            organization_name=self.organization_name,
            profiles=self.profiles,
            speed_bands=self.speed_bands)


def get_ecxl2_sellerprofiles(metro_codes: Optional[Sequence[str]] = None,
                             name_regex: Optional[str] = None,
                             organization_global_name: Optional[str] = None,
                             organization_name: Optional[str] = None,
                             speed_bands: Optional[Sequence[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetECXL2SellerprofilesResult:
    """
    Use this data source to get details of available Equinix Fabric layer 2 seller profiles. It is
    possible to apply filtering criteria for returned list of profiles.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_equinix as equinix

    aws = equinix.get_ecxl2_sellerprofiles(metro_codes=[
            "SV",
            "DC",
        ],
        organization_global_name="AWS",
        speed_bands=[
            "1GB",
            "500MB",
        ])
    ```


    :param Sequence[str] metro_codes: List of metro codes of locations that should be served by resulting
           profiles.
    :param str name_regex: A regex string to apply on returned seller profile names and filter
           search results.
    :param str organization_global_name: Name of seller's global organization.
    :param str organization_name: Name of seller's organization.
    :param Sequence[str] speed_bands: List of speed bands that should be supported by resulting profiles.
    """
    __args__ = dict()
    __args__['metroCodes'] = metro_codes
    __args__['nameRegex'] = name_regex
    __args__['organizationGlobalName'] = organization_global_name
    __args__['organizationName'] = organization_name
    __args__['speedBands'] = speed_bands
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
    __ret__ = pulumi.runtime.invoke('equinix:index/getECXL2Sellerprofiles:GetECXL2Sellerprofiles', __args__, opts=opts, typ=GetECXL2SellerprofilesResult).value

    return AwaitableGetECXL2SellerprofilesResult(
        id=__ret__.id,
        metro_codes=__ret__.metro_codes,
        name_regex=__ret__.name_regex,
        organization_global_name=__ret__.organization_global_name,
        organization_name=__ret__.organization_name,
        profiles=__ret__.profiles,
        speed_bands=__ret__.speed_bands)


@_utilities.lift_output_func(get_ecxl2_sellerprofiles)
def get_ecxl2_sellerprofiles_output(metro_codes: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                    name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                    organization_global_name: Optional[pulumi.Input[Optional[str]]] = None,
                                    organization_name: Optional[pulumi.Input[Optional[str]]] = None,
                                    speed_bands: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetECXL2SellerprofilesResult]:
    """
    Use this data source to get details of available Equinix Fabric layer 2 seller profiles. It is
    possible to apply filtering criteria for returned list of profiles.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_equinix as equinix

    aws = equinix.get_ecxl2_sellerprofiles(metro_codes=[
            "SV",
            "DC",
        ],
        organization_global_name="AWS",
        speed_bands=[
            "1GB",
            "500MB",
        ])
    ```


    :param Sequence[str] metro_codes: List of metro codes of locations that should be served by resulting
           profiles.
    :param str name_regex: A regex string to apply on returned seller profile names and filter
           search results.
    :param str organization_global_name: Name of seller's global organization.
    :param str organization_name: Name of seller's organization.
    :param Sequence[str] speed_bands: List of speed bands that should be supported by resulting profiles.
    """
    ...
