# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetMetalDeviceBGPNeighborsResult',
    'AwaitableGetMetalDeviceBGPNeighborsResult',
    'get_metal_device_bgp_neighbors',
    'get_metal_device_bgp_neighbors_output',
]

@pulumi.output_type
class GetMetalDeviceBGPNeighborsResult:
    """
    A collection of values returned by GetMetalDeviceBGPNeighbors.
    """
    def __init__(__self__, bgp_neighbors=None, device_id=None, id=None):
        if bgp_neighbors and not isinstance(bgp_neighbors, list):
            raise TypeError("Expected argument 'bgp_neighbors' to be a list")
        pulumi.set(__self__, "bgp_neighbors", bgp_neighbors)
        if device_id and not isinstance(device_id, str):
            raise TypeError("Expected argument 'device_id' to be a str")
        pulumi.set(__self__, "device_id", device_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="bgpNeighbors")
    def bgp_neighbors(self) -> Sequence['outputs.GetMetalDeviceBGPNeighborsBgpNeighborResult']:
        """
        array of BGP neighbor records with attributes:
        """
        return pulumi.get(self, "bgp_neighbors")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> str:
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetMetalDeviceBGPNeighborsResult(GetMetalDeviceBGPNeighborsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetalDeviceBGPNeighborsResult(
            bgp_neighbors=self.bgp_neighbors,
            device_id=self.device_id,
            id=self.id)


def get_metal_device_bgp_neighbors(device_id: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetalDeviceBGPNeighborsResult:
    """
    Use this datasource to retrieve list of BGP neighbors of a device in the Equinix Metal host.

    To have any BGP neighbors listed, the device must be in BGP-enabled project
    and have a BGP session assigned.

    To learn more about using BGP in Equinix Metal, see the
    MetalBGPSession resource documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_equinix as equinix

    test = equinix.get_metal_device_bgp_neighbors(device_id="4c641195-25e5-4c3c-b2b7-4cd7a42c7b40")
    pulumi.export("bgpNeighborsListing", test.bgp_neighbors)
    ```


    :param str device_id: UUID of BGP-enabled device whose neighbors to list.
    """
    __args__ = dict()
    __args__['deviceId'] = device_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
    __ret__ = pulumi.runtime.invoke('equinix:index/getMetalDeviceBGPNeighbors:GetMetalDeviceBGPNeighbors', __args__, opts=opts, typ=GetMetalDeviceBGPNeighborsResult).value

    return AwaitableGetMetalDeviceBGPNeighborsResult(
        bgp_neighbors=__ret__.bgp_neighbors,
        device_id=__ret__.device_id,
        id=__ret__.id)


@_utilities.lift_output_func(get_metal_device_bgp_neighbors)
def get_metal_device_bgp_neighbors_output(device_id: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMetalDeviceBGPNeighborsResult]:
    """
    Use this datasource to retrieve list of BGP neighbors of a device in the Equinix Metal host.

    To have any BGP neighbors listed, the device must be in BGP-enabled project
    and have a BGP session assigned.

    To learn more about using BGP in Equinix Metal, see the
    MetalBGPSession resource documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_equinix as equinix

    test = equinix.get_metal_device_bgp_neighbors(device_id="4c641195-25e5-4c3c-b2b7-4cd7a42c7b40")
    pulumi.export("bgpNeighborsListing", test.bgp_neighbors)
    ```


    :param str device_id: UUID of BGP-enabled device whose neighbors to list.
    """
    ...
