# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetMetalIPBlockRangesResult',
    'AwaitableGetMetalIPBlockRangesResult',
    'get_metal_ip_block_ranges',
    'get_metal_ip_block_ranges_output',
]

@pulumi.output_type
class GetMetalIPBlockRangesResult:
    """
    A collection of values returned by GetMetalIPBlockRanges.
    """
    def __init__(__self__, facility=None, global_ipv4s=None, id=None, ipv6s=None, metro=None, private_ipv4s=None, project_id=None, public_ipv4s=None):
        if facility and not isinstance(facility, str):
            raise TypeError("Expected argument 'facility' to be a str")
        pulumi.set(__self__, "facility", facility)
        if global_ipv4s and not isinstance(global_ipv4s, list):
            raise TypeError("Expected argument 'global_ipv4s' to be a list")
        pulumi.set(__self__, "global_ipv4s", global_ipv4s)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv6s and not isinstance(ipv6s, list):
            raise TypeError("Expected argument 'ipv6s' to be a list")
        pulumi.set(__self__, "ipv6s", ipv6s)
        if metro and not isinstance(metro, str):
            raise TypeError("Expected argument 'metro' to be a str")
        pulumi.set(__self__, "metro", metro)
        if private_ipv4s and not isinstance(private_ipv4s, list):
            raise TypeError("Expected argument 'private_ipv4s' to be a list")
        pulumi.set(__self__, "private_ipv4s", private_ipv4s)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if public_ipv4s and not isinstance(public_ipv4s, list):
            raise TypeError("Expected argument 'public_ipv4s' to be a list")
        pulumi.set(__self__, "public_ipv4s", public_ipv4s)

    @property
    @pulumi.getter
    def facility(self) -> Optional[str]:
        return pulumi.get(self, "facility")

    @property
    @pulumi.getter(name="globalIpv4s")
    def global_ipv4s(self) -> Sequence[str]:
        """
        list of CIDR expressions for Global IPv4 blocks in the project.
        """
        return pulumi.get(self, "global_ipv4s")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ipv6s(self) -> Sequence[str]:
        """
        list of CIDR expressions for IPv6 blocks in the project.
        """
        return pulumi.get(self, "ipv6s")

    @property
    @pulumi.getter
    def metro(self) -> Optional[str]:
        return pulumi.get(self, "metro")

    @property
    @pulumi.getter(name="privateIpv4s")
    def private_ipv4s(self) -> Sequence[str]:
        """
        list of CIDR expressions for Private IPv4 blocks in the project.
        """
        return pulumi.get(self, "private_ipv4s")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicIpv4s")
    def public_ipv4s(self) -> Sequence[str]:
        """
        list of CIDR expressions for Public IPv4 blocks in the project.
        """
        return pulumi.get(self, "public_ipv4s")


class AwaitableGetMetalIPBlockRangesResult(GetMetalIPBlockRangesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetalIPBlockRangesResult(
            facility=self.facility,
            global_ipv4s=self.global_ipv4s,
            id=self.id,
            ipv6s=self.ipv6s,
            metro=self.metro,
            private_ipv4s=self.private_ipv4s,
            project_id=self.project_id,
            public_ipv4s=self.public_ipv4s)


def get_metal_ip_block_ranges(facility: Optional[str] = None,
                              metro: Optional[str] = None,
                              project_id: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetalIPBlockRangesResult:
    """
    Use this datasource to get CIDR expressions for allocated IP blocks of all the types in a project, optionally filtered by facility or metro.

    There are four types of IP blocks in Equinix: equinix_metal_global IPv4, public IPv4, private IPv4 and IPv6. Both global and public IPv4 are routable from the Internet. Public IPv4 blocks are allocated in a facility or metro, and addresses from it can only be assigned to devices in that location. Addresses from Global IPv4 block can be assigned to a device in any metro.

    The datasource has 4 list attributes: `global_ipv4`, `public_ipv4`, `private_ipv4` and `ipv6`, each listing CIDR notation (`<network>/<mask>`) of respective blocks from the project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_equinix as equinix

    project_id = "<UUID_of_your_project>"
    test = equinix.get_metal_ip_block_ranges(project_id=project_id)
    pulumi.export("out", test)
    ```


    :param str facility: Facility code filtering the IP blocks. Global IPv4 blcoks will be listed
           anyway. If you omit this and metro, all the block from the project will be listed.
    :param str metro: Metro code filtering the IP blocks. Global IPv4 blcoks will be listed
           anyway. If you omit this and facility, all the block from the project will be listed.
    :param str project_id: ID of the project from which to list the blocks.
    """
    __args__ = dict()
    __args__['facility'] = facility
    __args__['metro'] = metro
    __args__['projectId'] = project_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
    __ret__ = pulumi.runtime.invoke('equinix:index/getMetalIPBlockRanges:GetMetalIPBlockRanges', __args__, opts=opts, typ=GetMetalIPBlockRangesResult).value

    return AwaitableGetMetalIPBlockRangesResult(
        facility=__ret__.facility,
        global_ipv4s=__ret__.global_ipv4s,
        id=__ret__.id,
        ipv6s=__ret__.ipv6s,
        metro=__ret__.metro,
        private_ipv4s=__ret__.private_ipv4s,
        project_id=__ret__.project_id,
        public_ipv4s=__ret__.public_ipv4s)


@_utilities.lift_output_func(get_metal_ip_block_ranges)
def get_metal_ip_block_ranges_output(facility: Optional[pulumi.Input[Optional[str]]] = None,
                                     metro: Optional[pulumi.Input[Optional[str]]] = None,
                                     project_id: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMetalIPBlockRangesResult]:
    """
    Use this datasource to get CIDR expressions for allocated IP blocks of all the types in a project, optionally filtered by facility or metro.

    There are four types of IP blocks in Equinix: equinix_metal_global IPv4, public IPv4, private IPv4 and IPv6. Both global and public IPv4 are routable from the Internet. Public IPv4 blocks are allocated in a facility or metro, and addresses from it can only be assigned to devices in that location. Addresses from Global IPv4 block can be assigned to a device in any metro.

    The datasource has 4 list attributes: `global_ipv4`, `public_ipv4`, `private_ipv4` and `ipv6`, each listing CIDR notation (`<network>/<mask>`) of respective blocks from the project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_equinix as equinix

    project_id = "<UUID_of_your_project>"
    test = equinix.get_metal_ip_block_ranges(project_id=project_id)
    pulumi.export("out", test)
    ```


    :param str facility: Facility code filtering the IP blocks. Global IPv4 blcoks will be listed
           anyway. If you omit this and metro, all the block from the project will be listed.
    :param str metro: Metro code filtering the IP blocks. Global IPv4 blcoks will be listed
           anyway. If you omit this and facility, all the block from the project will be listed.
    :param str project_id: ID of the project from which to list the blocks.
    """
    ...
