# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMetalMetroResult',
    'AwaitableGetMetalMetroResult',
    'get_metal_metro',
    'get_metal_metro_output',
]

@pulumi.output_type
class GetMetalMetroResult:
    """
    A collection of values returned by GetMetalMetro.
    """
    def __init__(__self__, capacities=None, code=None, country=None, id=None, name=None):
        if capacities and not isinstance(capacities, list):
            raise TypeError("Expected argument 'capacities' to be a list")
        pulumi.set(__self__, "capacities", capacities)
        if code and not isinstance(code, str):
            raise TypeError("Expected argument 'code' to be a str")
        pulumi.set(__self__, "code", code)
        if country and not isinstance(country, str):
            raise TypeError("Expected argument 'country' to be a str")
        pulumi.set(__self__, "country", country)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def capacities(self) -> Optional[Sequence['outputs.GetMetalMetroCapacityResult']]:
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter
    def code(self) -> str:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def country(self) -> str:
        """
        The country of the metro.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the metro.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the metro.
        """
        return pulumi.get(self, "name")


class AwaitableGetMetalMetroResult(GetMetalMetroResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetalMetroResult(
            capacities=self.capacities,
            code=self.code,
            country=self.country,
            id=self.id,
            name=self.name)


def get_metal_metro(capacities: Optional[Sequence[pulumi.InputType['GetMetalMetroCapacityArgs']]] = None,
                    code: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetalMetroResult:
    """
    Provides an Equinix Metal metro datasource.


    :param Sequence[pulumi.InputType['GetMetalMetroCapacityArgs']] capacities: One or more device plans for which the facility must have capacity.
    :param str code: The facility code to search for facilities.
    """
    __args__ = dict()
    __args__['capacities'] = capacities
    __args__['code'] = code
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
    __ret__ = pulumi.runtime.invoke('equinix:index/getMetalMetro:GetMetalMetro', __args__, opts=opts, typ=GetMetalMetroResult).value

    return AwaitableGetMetalMetroResult(
        capacities=__ret__.capacities,
        code=__ret__.code,
        country=__ret__.country,
        id=__ret__.id,
        name=__ret__.name)


@_utilities.lift_output_func(get_metal_metro)
def get_metal_metro_output(capacities: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetMetalMetroCapacityArgs']]]]] = None,
                           code: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMetalMetroResult]:
    """
    Provides an Equinix Metal metro datasource.


    :param Sequence[pulumi.InputType['GetMetalMetroCapacityArgs']] capacities: One or more device plans for which the facility must have capacity.
    :param str code: The facility code to search for facilities.
    """
    ...
