# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMetalOrganizationResult',
    'AwaitableGetMetalOrganizationResult',
    'get_metal_organization',
    'get_metal_organization_output',
]

@pulumi.output_type
class GetMetalOrganizationResult:
    """
    A collection of values returned by GetMetalOrganization.
    """
    def __init__(__self__, addresses=None, description=None, id=None, logo=None, name=None, organization_id=None, project_ids=None, twitter=None, website=None):
        if addresses and not isinstance(addresses, list):
            raise TypeError("Expected argument 'addresses' to be a list")
        pulumi.set(__self__, "addresses", addresses)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if logo and not isinstance(logo, str):
            raise TypeError("Expected argument 'logo' to be a str")
        pulumi.set(__self__, "logo", logo)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if project_ids and not isinstance(project_ids, list):
            raise TypeError("Expected argument 'project_ids' to be a list")
        pulumi.set(__self__, "project_ids", project_ids)
        if twitter and not isinstance(twitter, str):
            raise TypeError("Expected argument 'twitter' to be a str")
        pulumi.set(__self__, "twitter", twitter)
        if website and not isinstance(website, str):
            raise TypeError("Expected argument 'website' to be a str")
        pulumi.set(__self__, "website", website)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence['outputs.GetMetalOrganizationAddressResult']:
        """
        Postal address.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description string.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def logo(self) -> str:
        """
        Logo URL.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> Sequence[str]:
        """
        UUIDs of project resources which belong to this organization.
        """
        return pulumi.get(self, "project_ids")

    @property
    @pulumi.getter
    def twitter(self) -> str:
        """
        Twitter handle.
        """
        return pulumi.get(self, "twitter")

    @property
    @pulumi.getter
    def website(self) -> str:
        """
        Website link.
        """
        return pulumi.get(self, "website")


class AwaitableGetMetalOrganizationResult(GetMetalOrganizationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetalOrganizationResult(
            addresses=self.addresses,
            description=self.description,
            id=self.id,
            logo=self.logo,
            name=self.name,
            organization_id=self.organization_id,
            project_ids=self.project_ids,
            twitter=self.twitter,
            website=self.website)


def get_metal_organization(addresses: Optional[Sequence[pulumi.InputType['GetMetalOrganizationAddressArgs']]] = None,
                           name: Optional[str] = None,
                           organization_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetalOrganizationResult:
    """
    Provides an Equinix Metal organization datasource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_equinix as equinix

    test = equinix.get_metal_organization(organization_id=local["org_id"])
    pulumi.export("projectsInTheOrg", test.project_ids)
    ```


    :param Sequence[pulumi.InputType['GetMetalOrganizationAddressArgs']] addresses: Postal address.
    :param str name: The organization name.
    :param str organization_id: The UUID of the organization resource.
    """
    __args__ = dict()
    __args__['addresses'] = addresses
    __args__['name'] = name
    __args__['organizationId'] = organization_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
    __ret__ = pulumi.runtime.invoke('equinix:index/getMetalOrganization:GetMetalOrganization', __args__, opts=opts, typ=GetMetalOrganizationResult).value

    return AwaitableGetMetalOrganizationResult(
        addresses=__ret__.addresses,
        description=__ret__.description,
        id=__ret__.id,
        logo=__ret__.logo,
        name=__ret__.name,
        organization_id=__ret__.organization_id,
        project_ids=__ret__.project_ids,
        twitter=__ret__.twitter,
        website=__ret__.website)


@_utilities.lift_output_func(get_metal_organization)
def get_metal_organization_output(addresses: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetMetalOrganizationAddressArgs']]]]] = None,
                                  name: Optional[pulumi.Input[Optional[str]]] = None,
                                  organization_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMetalOrganizationResult]:
    """
    Provides an Equinix Metal organization datasource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_equinix as equinix

    test = equinix.get_metal_organization(organization_id=local["org_id"])
    pulumi.export("projectsInTheOrg", test.project_ids)
    ```


    :param Sequence[pulumi.InputType['GetMetalOrganizationAddressArgs']] addresses: Postal address.
    :param str name: The organization name.
    :param str organization_id: The UUID of the organization resource.
    """
    ...
