# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetalConnectionArgs', 'MetalConnection']

@pulumi.input_type
class MetalConnectionArgs:
    def __init__(__self__, *,
                 redundancy: pulumi.Input[str],
                 speed: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 facility: Optional[pulumi.Input[str]] = None,
                 metro: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 service_token_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        The set of arguments for constructing a MetalConnection resource.
        :param pulumi.Input[str] redundancy: Connection redundancy - redundant or primary.
        :param pulumi.Input[str] speed: Connection speed - one of 50Mbps, 200Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps.
        :param pulumi.Input[str] type: Connection type - dedicated or shared.
        :param pulumi.Input[str] description: Description for the connection resource.
        :param pulumi.Input[str] facility: Facility where the connection will be created.
        :param pulumi.Input[str] metro: Metro where the connection will be created.
        :param pulumi.Input[str] mode: Mode for connections in IBX facilities with the dedicated type - standard or tunnel. Default is standard.
        :param pulumi.Input[str] name: Name of the connection resource
        :param pulumi.Input[str] organization_id: ID of the organization where the connection is scoped to.
        :param pulumi.Input[str] project_id: ID of the project where the connection is scoped to, must be set for.
        :param pulumi.Input[str] service_token_type: Only used with shared connection. Type of service token to use for the connection, a_side or z_side.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: String list of tags.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] vlans: Only used with shared connection. Vlans to attach. Pass one vlan for Primary/Single connection and two vlans for Redundant connection.
        """
        pulumi.set(__self__, "redundancy", redundancy)
        pulumi.set(__self__, "speed", speed)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if facility is not None:
            pulumi.set(__self__, "facility", facility)
        if metro is not None:
            pulumi.set(__self__, "metro", metro)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if service_token_type is not None:
            pulumi.set(__self__, "service_token_type", service_token_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vlans is not None:
            pulumi.set(__self__, "vlans", vlans)

    @property
    @pulumi.getter
    def redundancy(self) -> pulumi.Input[str]:
        """
        Connection redundancy - redundant or primary.
        """
        return pulumi.get(self, "redundancy")

    @redundancy.setter
    def redundancy(self, value: pulumi.Input[str]):
        pulumi.set(self, "redundancy", value)

    @property
    @pulumi.getter
    def speed(self) -> pulumi.Input[str]:
        """
        Connection speed - one of 50Mbps, 200Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps.
        """
        return pulumi.get(self, "speed")

    @speed.setter
    def speed(self, value: pulumi.Input[str]):
        pulumi.set(self, "speed", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Connection type - dedicated or shared.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the connection resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def facility(self) -> Optional[pulumi.Input[str]]:
        """
        Facility where the connection will be created.
        """
        return pulumi.get(self, "facility")

    @facility.setter
    def facility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "facility", value)

    @property
    @pulumi.getter
    def metro(self) -> Optional[pulumi.Input[str]]:
        """
        Metro where the connection will be created.
        """
        return pulumi.get(self, "metro")

    @metro.setter
    def metro(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metro", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Mode for connections in IBX facilities with the dedicated type - standard or tunnel. Default is standard.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the connection resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization where the connection is scoped to.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project where the connection is scoped to, must be set for.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serviceTokenType")
    def service_token_type(self) -> Optional[pulumi.Input[str]]:
        """
        Only used with shared connection. Type of service token to use for the connection, a_side or z_side.
        """
        return pulumi.get(self, "service_token_type")

    @service_token_type.setter
    def service_token_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_token_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        String list of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def vlans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Only used with shared connection. Vlans to attach. Pass one vlan for Primary/Single connection and two vlans for Redundant connection.
        """
        return pulumi.get(self, "vlans")

    @vlans.setter
    def vlans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "vlans", value)


@pulumi.input_type
class _MetalConnectionState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 facility: Optional[pulumi.Input[str]] = None,
                 metro: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['MetalConnectionPortArgs']]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 redundancy: Optional[pulumi.Input[str]] = None,
                 service_token_type: Optional[pulumi.Input[str]] = None,
                 service_tokens: Optional[pulumi.Input[Sequence[pulumi.Input['MetalConnectionServiceTokenArgs']]]] = None,
                 speed: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Input properties used for looking up and filtering MetalConnection resources.
        :param pulumi.Input[str] description: Description for the connection resource.
        :param pulumi.Input[str] facility: Facility where the connection will be created.
        :param pulumi.Input[str] metro: Metro where the connection will be created.
        :param pulumi.Input[str] mode: Mode for connections in IBX facilities with the dedicated type - standard or tunnel. Default is standard.
        :param pulumi.Input[str] name: Name of the connection resource
        :param pulumi.Input[str] organization_id: ID of the organization where the connection is scoped to.
        :param pulumi.Input[Sequence[pulumi.Input['MetalConnectionPortArgs']]] ports: List of connection ports - primary (`ports[0]`) and secondary (`ports[1]`). Schema of
               port is described in documentation of the
               MetalConnection datasource.
        :param pulumi.Input[str] project_id: ID of the project where the connection is scoped to, must be set for.
        :param pulumi.Input[str] redundancy: Connection redundancy - redundant or primary.
        :param pulumi.Input[str] service_token_type: Only used with shared connection. Type of service token to use for the connection, a_side or z_side.
        :param pulumi.Input[Sequence[pulumi.Input['MetalConnectionServiceTokenArgs']]] service_tokens: List of connection service tokens with attributes. Scehma of service_token is described in documentation of the MetalConnection datasource.
        :param pulumi.Input[str] speed: Connection speed - one of 50Mbps, 200Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps.
        :param pulumi.Input[str] status: Status of the connection resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: String list of tags.
        :param pulumi.Input[str] token: Fabric Token from the [Equinix Fabric Portal](https://ecxfabric.equinix.com/dashboard)
        :param pulumi.Input[str] type: Connection type - dedicated or shared.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] vlans: Only used with shared connection. Vlans to attach. Pass one vlan for Primary/Single connection and two vlans for Redundant connection.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if facility is not None:
            pulumi.set(__self__, "facility", facility)
        if metro is not None:
            pulumi.set(__self__, "metro", metro)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if redundancy is not None:
            pulumi.set(__self__, "redundancy", redundancy)
        if service_token_type is not None:
            pulumi.set(__self__, "service_token_type", service_token_type)
        if service_tokens is not None:
            pulumi.set(__self__, "service_tokens", service_tokens)
        if speed is not None:
            pulumi.set(__self__, "speed", speed)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if token is not None:
            warnings.warn("""token is deprecated. Use service_tokens instead""", DeprecationWarning)
            pulumi.log.warn("""token is deprecated: token is deprecated. Use service_tokens instead""")
        if token is not None:
            pulumi.set(__self__, "token", token)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vlans is not None:
            pulumi.set(__self__, "vlans", vlans)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the connection resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def facility(self) -> Optional[pulumi.Input[str]]:
        """
        Facility where the connection will be created.
        """
        return pulumi.get(self, "facility")

    @facility.setter
    def facility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "facility", value)

    @property
    @pulumi.getter
    def metro(self) -> Optional[pulumi.Input[str]]:
        """
        Metro where the connection will be created.
        """
        return pulumi.get(self, "metro")

    @metro.setter
    def metro(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metro", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Mode for connections in IBX facilities with the dedicated type - standard or tunnel. Default is standard.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the connection resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization where the connection is scoped to.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetalConnectionPortArgs']]]]:
        """
        List of connection ports - primary (`ports[0]`) and secondary (`ports[1]`). Schema of
        port is described in documentation of the
        MetalConnection datasource.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetalConnectionPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project where the connection is scoped to, must be set for.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def redundancy(self) -> Optional[pulumi.Input[str]]:
        """
        Connection redundancy - redundant or primary.
        """
        return pulumi.get(self, "redundancy")

    @redundancy.setter
    def redundancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundancy", value)

    @property
    @pulumi.getter(name="serviceTokenType")
    def service_token_type(self) -> Optional[pulumi.Input[str]]:
        """
        Only used with shared connection. Type of service token to use for the connection, a_side or z_side.
        """
        return pulumi.get(self, "service_token_type")

    @service_token_type.setter
    def service_token_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_token_type", value)

    @property
    @pulumi.getter(name="serviceTokens")
    def service_tokens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetalConnectionServiceTokenArgs']]]]:
        """
        List of connection service tokens with attributes. Scehma of service_token is described in documentation of the MetalConnection datasource.
        """
        return pulumi.get(self, "service_tokens")

    @service_tokens.setter
    def service_tokens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetalConnectionServiceTokenArgs']]]]):
        pulumi.set(self, "service_tokens", value)

    @property
    @pulumi.getter
    def speed(self) -> Optional[pulumi.Input[str]]:
        """
        Connection speed - one of 50Mbps, 200Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps.
        """
        return pulumi.get(self, "speed")

    @speed.setter
    def speed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "speed", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the connection resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        String list of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Fabric Token from the [Equinix Fabric Portal](https://ecxfabric.equinix.com/dashboard)
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Connection type - dedicated or shared.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def vlans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Only used with shared connection. Vlans to attach. Pass one vlan for Primary/Single connection and two vlans for Redundant connection.
        """
        return pulumi.get(self, "vlans")

    @vlans.setter
    def vlans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "vlans", value)


class MetalConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 facility: Optional[pulumi.Input[str]] = None,
                 metro: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 redundancy: Optional[pulumi.Input[str]] = None,
                 service_token_type: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        """
        Use this resource to request the creation an Interconnection asset to connect with other parties using [Equinix Fabric - software-defined interconnections](https://metal.equinix.com/developers/docs/networking/fabric/).

        > Equinix Metal connection with service_token_type `a_side` is not generally available and may not be enabled yet for your organization.

        ## Example Usage
        ### Shared Connection with z_side token - Non-redundant Connection from your own Equinix Fabric Port to Equinix Metal

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        example_metal_connection = equinix.MetalConnection("exampleMetalConnection",
            project_id=local["project_id"],
            type="shared",
            redundancy="primary",
            metro="FR",
            speed="200Mbps",
            service_token_type="z_side")
        example_get_ecx_port = equinix.get_ecx_port(name="CX-FR5-NL-Dot1q-BO-1G-PRI")
        example_ecxl2_connection = equinix.ECXL2Connection("exampleECXL2Connection",
            zside_service_token=example_metal_connection.service_tokens[0].id,
            speed=200,
            speed_unit="MB",
            notifications=["example@equinix.com"],
            seller_metro_code="FR",
            port_uuid=example_get_ecx_port.id,
            vlan_stag=1020)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description for the connection resource.
        :param pulumi.Input[str] facility: Facility where the connection will be created.
        :param pulumi.Input[str] metro: Metro where the connection will be created.
        :param pulumi.Input[str] mode: Mode for connections in IBX facilities with the dedicated type - standard or tunnel. Default is standard.
        :param pulumi.Input[str] name: Name of the connection resource
        :param pulumi.Input[str] organization_id: ID of the organization where the connection is scoped to.
        :param pulumi.Input[str] project_id: ID of the project where the connection is scoped to, must be set for.
        :param pulumi.Input[str] redundancy: Connection redundancy - redundant or primary.
        :param pulumi.Input[str] service_token_type: Only used with shared connection. Type of service token to use for the connection, a_side or z_side.
        :param pulumi.Input[str] speed: Connection speed - one of 50Mbps, 200Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: String list of tags.
        :param pulumi.Input[str] type: Connection type - dedicated or shared.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] vlans: Only used with shared connection. Vlans to attach. Pass one vlan for Primary/Single connection and two vlans for Redundant connection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetalConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to request the creation an Interconnection asset to connect with other parties using [Equinix Fabric - software-defined interconnections](https://metal.equinix.com/developers/docs/networking/fabric/).

        > Equinix Metal connection with service_token_type `a_side` is not generally available and may not be enabled yet for your organization.

        ## Example Usage
        ### Shared Connection with z_side token - Non-redundant Connection from your own Equinix Fabric Port to Equinix Metal

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        example_metal_connection = equinix.MetalConnection("exampleMetalConnection",
            project_id=local["project_id"],
            type="shared",
            redundancy="primary",
            metro="FR",
            speed="200Mbps",
            service_token_type="z_side")
        example_get_ecx_port = equinix.get_ecx_port(name="CX-FR5-NL-Dot1q-BO-1G-PRI")
        example_ecxl2_connection = equinix.ECXL2Connection("exampleECXL2Connection",
            zside_service_token=example_metal_connection.service_tokens[0].id,
            speed=200,
            speed_unit="MB",
            notifications=["example@equinix.com"],
            seller_metro_code="FR",
            port_uuid=example_get_ecx_port.id,
            vlan_stag=1020)
        ```

        :param str resource_name: The name of the resource.
        :param MetalConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetalConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 facility: Optional[pulumi.Input[str]] = None,
                 metro: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 redundancy: Optional[pulumi.Input[str]] = None,
                 service_token_type: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetalConnectionArgs.__new__(MetalConnectionArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["facility"] = facility
            __props__.__dict__["metro"] = metro
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["project_id"] = project_id
            if redundancy is None and not opts.urn:
                raise TypeError("Missing required property 'redundancy'")
            __props__.__dict__["redundancy"] = redundancy
            __props__.__dict__["service_token_type"] = service_token_type
            if speed is None and not opts.urn:
                raise TypeError("Missing required property 'speed'")
            __props__.__dict__["speed"] = speed
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["vlans"] = vlans
            __props__.__dict__["ports"] = None
            __props__.__dict__["service_tokens"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["token"] = None
        super(MetalConnection, __self__).__init__(
            'equinix:index/metalConnection:MetalConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            facility: Optional[pulumi.Input[str]] = None,
            metro: Optional[pulumi.Input[str]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            ports: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetalConnectionPortArgs']]]]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            redundancy: Optional[pulumi.Input[str]] = None,
            service_token_type: Optional[pulumi.Input[str]] = None,
            service_tokens: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetalConnectionServiceTokenArgs']]]]] = None,
            speed: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            token: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vlans: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None) -> 'MetalConnection':
        """
        Get an existing MetalConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description for the connection resource.
        :param pulumi.Input[str] facility: Facility where the connection will be created.
        :param pulumi.Input[str] metro: Metro where the connection will be created.
        :param pulumi.Input[str] mode: Mode for connections in IBX facilities with the dedicated type - standard or tunnel. Default is standard.
        :param pulumi.Input[str] name: Name of the connection resource
        :param pulumi.Input[str] organization_id: ID of the organization where the connection is scoped to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetalConnectionPortArgs']]]] ports: List of connection ports - primary (`ports[0]`) and secondary (`ports[1]`). Schema of
               port is described in documentation of the
               MetalConnection datasource.
        :param pulumi.Input[str] project_id: ID of the project where the connection is scoped to, must be set for.
        :param pulumi.Input[str] redundancy: Connection redundancy - redundant or primary.
        :param pulumi.Input[str] service_token_type: Only used with shared connection. Type of service token to use for the connection, a_side or z_side.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetalConnectionServiceTokenArgs']]]] service_tokens: List of connection service tokens with attributes. Scehma of service_token is described in documentation of the MetalConnection datasource.
        :param pulumi.Input[str] speed: Connection speed - one of 50Mbps, 200Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps.
        :param pulumi.Input[str] status: Status of the connection resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: String list of tags.
        :param pulumi.Input[str] token: Fabric Token from the [Equinix Fabric Portal](https://ecxfabric.equinix.com/dashboard)
        :param pulumi.Input[str] type: Connection type - dedicated or shared.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] vlans: Only used with shared connection. Vlans to attach. Pass one vlan for Primary/Single connection and two vlans for Redundant connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetalConnectionState.__new__(_MetalConnectionState)

        __props__.__dict__["description"] = description
        __props__.__dict__["facility"] = facility
        __props__.__dict__["metro"] = metro
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["ports"] = ports
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["redundancy"] = redundancy
        __props__.__dict__["service_token_type"] = service_token_type
        __props__.__dict__["service_tokens"] = service_tokens
        __props__.__dict__["speed"] = speed
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["token"] = token
        __props__.__dict__["type"] = type
        __props__.__dict__["vlans"] = vlans
        return MetalConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description for the connection resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def facility(self) -> pulumi.Output[str]:
        """
        Facility where the connection will be created.
        """
        return pulumi.get(self, "facility")

    @property
    @pulumi.getter
    def metro(self) -> pulumi.Output[str]:
        """
        Metro where the connection will be created.
        """
        return pulumi.get(self, "metro")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[str]]:
        """
        Mode for connections in IBX facilities with the dedicated type - standard or tunnel. Default is standard.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the connection resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        ID of the organization where the connection is scoped to.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[Sequence['outputs.MetalConnectionPort']]:
        """
        List of connection ports - primary (`ports[0]`) and secondary (`ports[1]`). Schema of
        port is described in documentation of the
        MetalConnection datasource.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the project where the connection is scoped to, must be set for.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def redundancy(self) -> pulumi.Output[str]:
        """
        Connection redundancy - redundant or primary.
        """
        return pulumi.get(self, "redundancy")

    @property
    @pulumi.getter(name="serviceTokenType")
    def service_token_type(self) -> pulumi.Output[Optional[str]]:
        """
        Only used with shared connection. Type of service token to use for the connection, a_side or z_side.
        """
        return pulumi.get(self, "service_token_type")

    @property
    @pulumi.getter(name="serviceTokens")
    def service_tokens(self) -> pulumi.Output[Sequence['outputs.MetalConnectionServiceToken']]:
        """
        List of connection service tokens with attributes. Scehma of service_token is described in documentation of the MetalConnection datasource.
        """
        return pulumi.get(self, "service_tokens")

    @property
    @pulumi.getter
    def speed(self) -> pulumi.Output[str]:
        """
        Connection speed - one of 50Mbps, 200Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps.
        """
        return pulumi.get(self, "speed")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the connection resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        String list of tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        Fabric Token from the [Equinix Fabric Portal](https://ecxfabric.equinix.com/dashboard)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Connection type - dedicated or shared.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def vlans(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        Only used with shared connection. Vlans to attach. Pass one vlan for Primary/Single connection and two vlans for Redundant connection.
        """
        return pulumi.get(self, "vlans")

