# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetalDeviceArgs', 'MetalDevice']

@pulumi.input_type
class MetalDeviceArgs:
    def __init__(__self__, *,
                 operating_system: pulumi.Input[str],
                 plan: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 always_pxe: Optional[pulumi.Input[bool]] = None,
                 billing_cycle: Optional[pulumi.Input[str]] = None,
                 custom_data: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 facilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_detach_volumes: Optional[pulumi.Input[bool]] = None,
                 hardware_reservation_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['MetalDeviceIpAddressArgs']]]] = None,
                 ipxe_script_url: Optional[pulumi.Input[str]] = None,
                 metro: Optional[pulumi.Input[str]] = None,
                 project_ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reinstall: Optional[pulumi.Input['MetalDeviceReinstallArgs']] = None,
                 storage: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_time: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 user_ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_for_reservation_deprovision: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a MetalDevice resource.
        :param pulumi.Input[str] operating_system: The operating system slug. To find the slug, or visit
               [Operating Systems API docs](https://metal.equinix.com/developers/api/operatingsystems), set your
               API auth token in the top of the page and see JSON from the API response.
        :param pulumi.Input[str] plan: The device plan slug. To find the plan slug, visit
               [Device plans API docs](https://metal.equinix.com/developers/api/plans), set your auth token in the
               top of the page and see JSON from the API response.
        :param pulumi.Input[str] project_id: The ID of the project in which to create the device
        :param pulumi.Input[bool] always_pxe: If true, a device with OS `custom_ipxe` will continue to boot via iPXE
               on reboots.
        :param pulumi.Input[str] billing_cycle: monthly or hourly
        :param pulumi.Input[str] custom_data: A string of the desired Custom Data for the device.
        :param pulumi.Input[str] description: The device description.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] facilities: List of facility codes with deployment preferences. Equinix Metal API will go
               through the list and will deploy your device to first facility with free capacity. List items must
               be facility codes or `any` (a wildcard). To find the facility code, visit
               [Facilities API docs](https://metal.equinix.com/developers/api/facilities/), set your API auth
               token in the top of the page and see JSON from the API response. Conflicts with `metro`.
        :param pulumi.Input[bool] force_detach_volumes: Delete device even if it has volumes attached. Only applies
               for destroy action.
        :param pulumi.Input[str] hardware_reservation_id: The UUID of the hardware reservation where you want this device deployed, or next-available if you want to pick your
               next available reservation automatically
        :param pulumi.Input[str] hostname: The device hostname used in deployments taking advantage of Layer3 DHCP
               or metadata service configuration.
        :param pulumi.Input[Sequence[pulumi.Input['MetalDeviceIpAddressArgs']]] ip_addresses: A list of IP address types for the device. See
               IP address below for more details.
        :param pulumi.Input[str] ipxe_script_url: URL pointing to a hosted iPXE script. More information is in the
               [Custom iPXE](https://metal.equinix.com/developers/docs/servers/custom-ipxe/) doc.
        :param pulumi.Input[str] metro: Metro area for the new device. Conflicts with `facilities`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] project_ssh_key_ids: Array of IDs of the project SSH keys which should be added to the device.
               If you omit this, SSH keys of all the members of the parent project will be added to the device. If
               you specify this array, only the listed project SSH keys will be added. Project SSH keys can be
               created with the MetalProjectSSHKey resource.
        :param pulumi.Input['MetalDeviceReinstallArgs'] reinstall: Whether the device should be reinstalled instead of destroyed when
               modifying user_data, custom_data, or operating system. See Reinstall below for more
               details.
        :param pulumi.Input[str] storage: JSON for custom partitioning. Only usable on reserved hardware. More
               information in in the
               [Custom Partitioning and RAID](https://metal.equinix.com/developers/docs/servers/custom-partitioning-raid/)
               doc. Please note that the disks.partitions.size attribute must be a string, not an integer. It can
               be a number string, or size notation string, e.g. "4G" or "8M" (for gigabytes and megabytes).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags attached to the device.
        :param pulumi.Input[str] termination_time: Timestamp for device termination. For example `2021-09-03T16:32:00+03:00`.
               If you don't supply timezone info, timestamp is assumed to be in UTC.
        :param pulumi.Input[str] user_data: A string of the desired User Data for the device.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_ssh_key_ids: Array of IDs of the user SSH keys which should be added to the device. If you omit this, SSH keys of all the members of the parent project will be added to the device. If you specify this array, only the listed user SSH keys (and any project_ssh_key_ids) will be added. User SSH keys can be created with the MetalSSHKey resource
        :param pulumi.Input[bool] wait_for_reservation_deprovision: Only used for devices in reserved hardware. If
               set, the deletion of this device will block until the hardware reservation is marked provisionable
               (about 4 minutes in August 2019).
        """
        pulumi.set(__self__, "operating_system", operating_system)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "project_id", project_id)
        if always_pxe is not None:
            pulumi.set(__self__, "always_pxe", always_pxe)
        if billing_cycle is not None:
            pulumi.set(__self__, "billing_cycle", billing_cycle)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if facilities is not None:
            pulumi.set(__self__, "facilities", facilities)
        if force_detach_volumes is not None:
            pulumi.set(__self__, "force_detach_volumes", force_detach_volumes)
        if hardware_reservation_id is not None:
            pulumi.set(__self__, "hardware_reservation_id", hardware_reservation_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if ipxe_script_url is not None:
            pulumi.set(__self__, "ipxe_script_url", ipxe_script_url)
        if metro is not None:
            pulumi.set(__self__, "metro", metro)
        if project_ssh_key_ids is not None:
            pulumi.set(__self__, "project_ssh_key_ids", project_ssh_key_ids)
        if reinstall is not None:
            pulumi.set(__self__, "reinstall", reinstall)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_time is not None:
            pulumi.set(__self__, "termination_time", termination_time)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_ssh_key_ids is not None:
            pulumi.set(__self__, "user_ssh_key_ids", user_ssh_key_ids)
        if wait_for_reservation_deprovision is not None:
            pulumi.set(__self__, "wait_for_reservation_deprovision", wait_for_reservation_deprovision)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> pulumi.Input[str]:
        """
        The operating system slug. To find the slug, or visit
        [Operating Systems API docs](https://metal.equinix.com/developers/api/operatingsystems), set your
        API auth token in the top of the page and see JSON from the API response.
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: pulumi.Input[str]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Input[str]:
        """
        The device plan slug. To find the plan slug, visit
        [Device plans API docs](https://metal.equinix.com/developers/api/plans), set your auth token in the
        top of the page and see JSON from the API response.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of the project in which to create the device
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="alwaysPxe")
    def always_pxe(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, a device with OS `custom_ipxe` will continue to boot via iPXE
        on reboots.
        """
        return pulumi.get(self, "always_pxe")

    @always_pxe.setter
    def always_pxe(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "always_pxe", value)

    @property
    @pulumi.getter(name="billingCycle")
    def billing_cycle(self) -> Optional[pulumi.Input[str]]:
        """
        monthly or hourly
        """
        return pulumi.get(self, "billing_cycle")

    @billing_cycle.setter
    def billing_cycle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_cycle", value)

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[pulumi.Input[str]]:
        """
        A string of the desired Custom Data for the device.
        """
        return pulumi.get(self, "custom_data")

    @custom_data.setter
    def custom_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_data", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The device description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def facilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of facility codes with deployment preferences. Equinix Metal API will go
        through the list and will deploy your device to first facility with free capacity. List items must
        be facility codes or `any` (a wildcard). To find the facility code, visit
        [Facilities API docs](https://metal.equinix.com/developers/api/facilities/), set your API auth
        token in the top of the page and see JSON from the API response. Conflicts with `metro`.
        """
        return pulumi.get(self, "facilities")

    @facilities.setter
    def facilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "facilities", value)

    @property
    @pulumi.getter(name="forceDetachVolumes")
    def force_detach_volumes(self) -> Optional[pulumi.Input[bool]]:
        """
        Delete device even if it has volumes attached. Only applies
        for destroy action.
        """
        return pulumi.get(self, "force_detach_volumes")

    @force_detach_volumes.setter
    def force_detach_volumes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_detach_volumes", value)

    @property
    @pulumi.getter(name="hardwareReservationId")
    def hardware_reservation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the hardware reservation where you want this device deployed, or next-available if you want to pick your
        next available reservation automatically
        """
        return pulumi.get(self, "hardware_reservation_id")

    @hardware_reservation_id.setter
    def hardware_reservation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hardware_reservation_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The device hostname used in deployments taking advantage of Layer3 DHCP
        or metadata service configuration.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetalDeviceIpAddressArgs']]]]:
        """
        A list of IP address types for the device. See
        IP address below for more details.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetalDeviceIpAddressArgs']]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter(name="ipxeScriptUrl")
    def ipxe_script_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL pointing to a hosted iPXE script. More information is in the
        [Custom iPXE](https://metal.equinix.com/developers/docs/servers/custom-ipxe/) doc.
        """
        return pulumi.get(self, "ipxe_script_url")

    @ipxe_script_url.setter
    def ipxe_script_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipxe_script_url", value)

    @property
    @pulumi.getter
    def metro(self) -> Optional[pulumi.Input[str]]:
        """
        Metro area for the new device. Conflicts with `facilities`.
        """
        return pulumi.get(self, "metro")

    @metro.setter
    def metro(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metro", value)

    @property
    @pulumi.getter(name="projectSshKeyIds")
    def project_ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of IDs of the project SSH keys which should be added to the device.
        If you omit this, SSH keys of all the members of the parent project will be added to the device. If
        you specify this array, only the listed project SSH keys will be added. Project SSH keys can be
        created with the MetalProjectSSHKey resource.
        """
        return pulumi.get(self, "project_ssh_key_ids")

    @project_ssh_key_ids.setter
    def project_ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "project_ssh_key_ids", value)

    @property
    @pulumi.getter
    def reinstall(self) -> Optional[pulumi.Input['MetalDeviceReinstallArgs']]:
        """
        Whether the device should be reinstalled instead of destroyed when
        modifying user_data, custom_data, or operating system. See Reinstall below for more
        details.
        """
        return pulumi.get(self, "reinstall")

    @reinstall.setter
    def reinstall(self, value: Optional[pulumi.Input['MetalDeviceReinstallArgs']]):
        pulumi.set(self, "reinstall", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input[str]]:
        """
        JSON for custom partitioning. Only usable on reserved hardware. More
        information in in the
        [Custom Partitioning and RAID](https://metal.equinix.com/developers/docs/servers/custom-partitioning-raid/)
        doc. Please note that the disks.partitions.size attribute must be a string, not an integer. It can
        be a number string, or size notation string, e.g. "4G" or "8M" (for gigabytes and megabytes).
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags attached to the device.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="terminationTime")
    def termination_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp for device termination. For example `2021-09-03T16:32:00+03:00`.
        If you don't supply timezone info, timestamp is assumed to be in UTC.
        """
        return pulumi.get(self, "termination_time")

    @termination_time.setter
    def termination_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "termination_time", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        A string of the desired User Data for the device.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="userSshKeyIds")
    def user_ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of IDs of the user SSH keys which should be added to the device. If you omit this, SSH keys of all the members of the parent project will be added to the device. If you specify this array, only the listed user SSH keys (and any project_ssh_key_ids) will be added. User SSH keys can be created with the MetalSSHKey resource
        """
        return pulumi.get(self, "user_ssh_key_ids")

    @user_ssh_key_ids.setter
    def user_ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_ssh_key_ids", value)

    @property
    @pulumi.getter(name="waitForReservationDeprovision")
    def wait_for_reservation_deprovision(self) -> Optional[pulumi.Input[bool]]:
        """
        Only used for devices in reserved hardware. If
        set, the deletion of this device will block until the hardware reservation is marked provisionable
        (about 4 minutes in August 2019).
        """
        return pulumi.get(self, "wait_for_reservation_deprovision")

    @wait_for_reservation_deprovision.setter
    def wait_for_reservation_deprovision(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_reservation_deprovision", value)


@pulumi.input_type
class _MetalDeviceState:
    def __init__(__self__, *,
                 access_private_ipv4: Optional[pulumi.Input[str]] = None,
                 access_public_ipv4: Optional[pulumi.Input[str]] = None,
                 access_public_ipv6: Optional[pulumi.Input[str]] = None,
                 always_pxe: Optional[pulumi.Input[bool]] = None,
                 billing_cycle: Optional[pulumi.Input[str]] = None,
                 created: Optional[pulumi.Input[str]] = None,
                 custom_data: Optional[pulumi.Input[str]] = None,
                 deployed_facility: Optional[pulumi.Input[str]] = None,
                 deployed_hardware_reservation_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 facilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_detach_volumes: Optional[pulumi.Input[bool]] = None,
                 hardware_reservation_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['MetalDeviceIpAddressArgs']]]] = None,
                 ipxe_script_url: Optional[pulumi.Input[str]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 metro: Optional[pulumi.Input[str]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['MetalDeviceNetworkArgs']]]] = None,
                 operating_system: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['MetalDevicePortArgs']]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 project_ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reinstall: Optional[pulumi.Input['MetalDeviceReinstallArgs']] = None,
                 root_password: Optional[pulumi.Input[str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_time: Optional[pulumi.Input[str]] = None,
                 updated: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 user_ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_for_reservation_deprovision: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering MetalDevice resources.
        :param pulumi.Input[str] access_private_ipv4: The ipv4 private IP assigned to the device.
        :param pulumi.Input[str] access_public_ipv4: The ipv4 maintenance IP assigned to the device.
        :param pulumi.Input[str] access_public_ipv6: The ipv6 maintenance IP assigned to the device.
        :param pulumi.Input[bool] always_pxe: If true, a device with OS `custom_ipxe` will continue to boot via iPXE
               on reboots.
        :param pulumi.Input[str] billing_cycle: monthly or hourly
        :param pulumi.Input[str] created: The timestamp for when the device was created.
        :param pulumi.Input[str] custom_data: A string of the desired Custom Data for the device.
        :param pulumi.Input[str] deployed_facility: The facility where the device is deployed.
        :param pulumi.Input[str] deployed_hardware_reservation_id: ID of hardware reservation where this device was deployed.
               It is useful when using the `next-available` hardware reservation.
        :param pulumi.Input[str] description: The device description.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] facilities: List of facility codes with deployment preferences. Equinix Metal API will go
               through the list and will deploy your device to first facility with free capacity. List items must
               be facility codes or `any` (a wildcard). To find the facility code, visit
               [Facilities API docs](https://metal.equinix.com/developers/api/facilities/), set your API auth
               token in the top of the page and see JSON from the API response. Conflicts with `metro`.
        :param pulumi.Input[bool] force_detach_volumes: Delete device even if it has volumes attached. Only applies
               for destroy action.
        :param pulumi.Input[str] hardware_reservation_id: The UUID of the hardware reservation where you want this device deployed, or next-available if you want to pick your
               next available reservation automatically
        :param pulumi.Input[str] hostname: The device hostname used in deployments taking advantage of Layer3 DHCP
               or metadata service configuration.
        :param pulumi.Input[Sequence[pulumi.Input['MetalDeviceIpAddressArgs']]] ip_addresses: A list of IP address types for the device. See
               IP address below for more details.
        :param pulumi.Input[str] ipxe_script_url: URL pointing to a hosted iPXE script. More information is in the
               [Custom iPXE](https://metal.equinix.com/developers/docs/servers/custom-ipxe/) doc.
        :param pulumi.Input[bool] locked: Whether the device is locked.
        :param pulumi.Input[str] metro: Metro area for the new device. Conflicts with `facilities`.
        :param pulumi.Input[str] network_type: (Deprecated) Network type of a device, used in
               [Layer 2 networking](https://metal.equinix.com/developers/docs/networking/layer2/). Since this
               attribute is deprecated you should handle Network Type with one of
               equinix_metal_port,
               MetalDeviceNetworkType resources or
               MetalPort datasource.
               See network_types guide for more info.
        :param pulumi.Input[Sequence[pulumi.Input['MetalDeviceNetworkArgs']]] networks: The device's private and public IP (v4 and v6) network details. See
               Network Attribute below for more details.
        :param pulumi.Input[str] operating_system: The operating system slug. To find the slug, or visit
               [Operating Systems API docs](https://metal.equinix.com/developers/api/operatingsystems), set your
               API auth token in the top of the page and see JSON from the API response.
        :param pulumi.Input[str] plan: The device plan slug. To find the plan slug, visit
               [Device plans API docs](https://metal.equinix.com/developers/api/plans), set your auth token in the
               top of the page and see JSON from the API response.
        :param pulumi.Input[Sequence[pulumi.Input['MetalDevicePortArgs']]] ports: List of ports assigned to the device. See Ports Attribute below for
               more details.
        :param pulumi.Input[str] project_id: The ID of the project in which to create the device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] project_ssh_key_ids: Array of IDs of the project SSH keys which should be added to the device.
               If you omit this, SSH keys of all the members of the parent project will be added to the device. If
               you specify this array, only the listed project SSH keys will be added. Project SSH keys can be
               created with the MetalProjectSSHKey resource.
        :param pulumi.Input['MetalDeviceReinstallArgs'] reinstall: Whether the device should be reinstalled instead of destroyed when
               modifying user_data, custom_data, or operating system. See Reinstall below for more
               details.
        :param pulumi.Input[str] root_password: Root password to the server (disabled after 24 hours).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: List of IDs of SSH keys deployed in the device, can be both user and project SSH keys.
        :param pulumi.Input[str] state: The status of the device.
        :param pulumi.Input[str] storage: JSON for custom partitioning. Only usable on reserved hardware. More
               information in in the
               [Custom Partitioning and RAID](https://metal.equinix.com/developers/docs/servers/custom-partitioning-raid/)
               doc. Please note that the disks.partitions.size attribute must be a string, not an integer. It can
               be a number string, or size notation string, e.g. "4G" or "8M" (for gigabytes and megabytes).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags attached to the device.
        :param pulumi.Input[str] termination_time: Timestamp for device termination. For example `2021-09-03T16:32:00+03:00`.
               If you don't supply timezone info, timestamp is assumed to be in UTC.
        :param pulumi.Input[str] updated: The timestamp for the last time the device was updated.
        :param pulumi.Input[str] user_data: A string of the desired User Data for the device.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_ssh_key_ids: Array of IDs of the user SSH keys which should be added to the device. If you omit this, SSH keys of all the members of the parent project will be added to the device. If you specify this array, only the listed user SSH keys (and any project_ssh_key_ids) will be added. User SSH keys can be created with the MetalSSHKey resource
        :param pulumi.Input[bool] wait_for_reservation_deprovision: Only used for devices in reserved hardware. If
               set, the deletion of this device will block until the hardware reservation is marked provisionable
               (about 4 minutes in August 2019).
        """
        if access_private_ipv4 is not None:
            pulumi.set(__self__, "access_private_ipv4", access_private_ipv4)
        if access_public_ipv4 is not None:
            pulumi.set(__self__, "access_public_ipv4", access_public_ipv4)
        if access_public_ipv6 is not None:
            pulumi.set(__self__, "access_public_ipv6", access_public_ipv6)
        if always_pxe is not None:
            pulumi.set(__self__, "always_pxe", always_pxe)
        if billing_cycle is not None:
            pulumi.set(__self__, "billing_cycle", billing_cycle)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if deployed_facility is not None:
            pulumi.set(__self__, "deployed_facility", deployed_facility)
        if deployed_hardware_reservation_id is not None:
            pulumi.set(__self__, "deployed_hardware_reservation_id", deployed_hardware_reservation_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if facilities is not None:
            pulumi.set(__self__, "facilities", facilities)
        if force_detach_volumes is not None:
            pulumi.set(__self__, "force_detach_volumes", force_detach_volumes)
        if hardware_reservation_id is not None:
            pulumi.set(__self__, "hardware_reservation_id", hardware_reservation_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if ipxe_script_url is not None:
            pulumi.set(__self__, "ipxe_script_url", ipxe_script_url)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if metro is not None:
            pulumi.set(__self__, "metro", metro)
        if network_type is not None:
            warnings.warn("""You should handle Network Type with one of 'equinix_metal_port' or 'equinix_metal_device_network_type' resources. See section 'Guides' for more info""", DeprecationWarning)
            pulumi.log.warn("""network_type is deprecated: You should handle Network Type with one of 'equinix_metal_port' or 'equinix_metal_device_network_type' resources. See section 'Guides' for more info""")
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if project_ssh_key_ids is not None:
            pulumi.set(__self__, "project_ssh_key_ids", project_ssh_key_ids)
        if reinstall is not None:
            pulumi.set(__self__, "reinstall", reinstall)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)
        if ssh_key_ids is not None:
            pulumi.set(__self__, "ssh_key_ids", ssh_key_ids)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_time is not None:
            pulumi.set(__self__, "termination_time", termination_time)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_ssh_key_ids is not None:
            pulumi.set(__self__, "user_ssh_key_ids", user_ssh_key_ids)
        if wait_for_reservation_deprovision is not None:
            pulumi.set(__self__, "wait_for_reservation_deprovision", wait_for_reservation_deprovision)

    @property
    @pulumi.getter(name="accessPrivateIpv4")
    def access_private_ipv4(self) -> Optional[pulumi.Input[str]]:
        """
        The ipv4 private IP assigned to the device.
        """
        return pulumi.get(self, "access_private_ipv4")

    @access_private_ipv4.setter
    def access_private_ipv4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_private_ipv4", value)

    @property
    @pulumi.getter(name="accessPublicIpv4")
    def access_public_ipv4(self) -> Optional[pulumi.Input[str]]:
        """
        The ipv4 maintenance IP assigned to the device.
        """
        return pulumi.get(self, "access_public_ipv4")

    @access_public_ipv4.setter
    def access_public_ipv4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_public_ipv4", value)

    @property
    @pulumi.getter(name="accessPublicIpv6")
    def access_public_ipv6(self) -> Optional[pulumi.Input[str]]:
        """
        The ipv6 maintenance IP assigned to the device.
        """
        return pulumi.get(self, "access_public_ipv6")

    @access_public_ipv6.setter
    def access_public_ipv6(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_public_ipv6", value)

    @property
    @pulumi.getter(name="alwaysPxe")
    def always_pxe(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, a device with OS `custom_ipxe` will continue to boot via iPXE
        on reboots.
        """
        return pulumi.get(self, "always_pxe")

    @always_pxe.setter
    def always_pxe(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "always_pxe", value)

    @property
    @pulumi.getter(name="billingCycle")
    def billing_cycle(self) -> Optional[pulumi.Input[str]]:
        """
        monthly or hourly
        """
        return pulumi.get(self, "billing_cycle")

    @billing_cycle.setter
    def billing_cycle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_cycle", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp for when the device was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[pulumi.Input[str]]:
        """
        A string of the desired Custom Data for the device.
        """
        return pulumi.get(self, "custom_data")

    @custom_data.setter
    def custom_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_data", value)

    @property
    @pulumi.getter(name="deployedFacility")
    def deployed_facility(self) -> Optional[pulumi.Input[str]]:
        """
        The facility where the device is deployed.
        """
        return pulumi.get(self, "deployed_facility")

    @deployed_facility.setter
    def deployed_facility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployed_facility", value)

    @property
    @pulumi.getter(name="deployedHardwareReservationId")
    def deployed_hardware_reservation_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of hardware reservation where this device was deployed.
        It is useful when using the `next-available` hardware reservation.
        """
        return pulumi.get(self, "deployed_hardware_reservation_id")

    @deployed_hardware_reservation_id.setter
    def deployed_hardware_reservation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployed_hardware_reservation_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The device description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def facilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of facility codes with deployment preferences. Equinix Metal API will go
        through the list and will deploy your device to first facility with free capacity. List items must
        be facility codes or `any` (a wildcard). To find the facility code, visit
        [Facilities API docs](https://metal.equinix.com/developers/api/facilities/), set your API auth
        token in the top of the page and see JSON from the API response. Conflicts with `metro`.
        """
        return pulumi.get(self, "facilities")

    @facilities.setter
    def facilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "facilities", value)

    @property
    @pulumi.getter(name="forceDetachVolumes")
    def force_detach_volumes(self) -> Optional[pulumi.Input[bool]]:
        """
        Delete device even if it has volumes attached. Only applies
        for destroy action.
        """
        return pulumi.get(self, "force_detach_volumes")

    @force_detach_volumes.setter
    def force_detach_volumes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_detach_volumes", value)

    @property
    @pulumi.getter(name="hardwareReservationId")
    def hardware_reservation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the hardware reservation where you want this device deployed, or next-available if you want to pick your
        next available reservation automatically
        """
        return pulumi.get(self, "hardware_reservation_id")

    @hardware_reservation_id.setter
    def hardware_reservation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hardware_reservation_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The device hostname used in deployments taking advantage of Layer3 DHCP
        or metadata service configuration.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetalDeviceIpAddressArgs']]]]:
        """
        A list of IP address types for the device. See
        IP address below for more details.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetalDeviceIpAddressArgs']]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter(name="ipxeScriptUrl")
    def ipxe_script_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL pointing to a hosted iPXE script. More information is in the
        [Custom iPXE](https://metal.equinix.com/developers/docs/servers/custom-ipxe/) doc.
        """
        return pulumi.get(self, "ipxe_script_url")

    @ipxe_script_url.setter
    def ipxe_script_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipxe_script_url", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the device is locked.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter
    def metro(self) -> Optional[pulumi.Input[str]]:
        """
        Metro area for the new device. Conflicts with `facilities`.
        """
        return pulumi.get(self, "metro")

    @metro.setter
    def metro(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metro", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Deprecated) Network type of a device, used in
        [Layer 2 networking](https://metal.equinix.com/developers/docs/networking/layer2/). Since this
        attribute is deprecated you should handle Network Type with one of
        equinix_metal_port,
        MetalDeviceNetworkType resources or
        MetalPort datasource.
        See network_types guide for more info.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetalDeviceNetworkArgs']]]]:
        """
        The device's private and public IP (v4 and v6) network details. See
        Network Attribute below for more details.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetalDeviceNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system slug. To find the slug, or visit
        [Operating Systems API docs](https://metal.equinix.com/developers/api/operatingsystems), set your
        API auth token in the top of the page and see JSON from the API response.
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        The device plan slug. To find the plan slug, visit
        [Device plans API docs](https://metal.equinix.com/developers/api/plans), set your auth token in the
        top of the page and see JSON from the API response.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetalDevicePortArgs']]]]:
        """
        List of ports assigned to the device. See Ports Attribute below for
        more details.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetalDevicePortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which to create the device
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="projectSshKeyIds")
    def project_ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of IDs of the project SSH keys which should be added to the device.
        If you omit this, SSH keys of all the members of the parent project will be added to the device. If
        you specify this array, only the listed project SSH keys will be added. Project SSH keys can be
        created with the MetalProjectSSHKey resource.
        """
        return pulumi.get(self, "project_ssh_key_ids")

    @project_ssh_key_ids.setter
    def project_ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "project_ssh_key_ids", value)

    @property
    @pulumi.getter
    def reinstall(self) -> Optional[pulumi.Input['MetalDeviceReinstallArgs']]:
        """
        Whether the device should be reinstalled instead of destroyed when
        modifying user_data, custom_data, or operating system. See Reinstall below for more
        details.
        """
        return pulumi.get(self, "reinstall")

    @reinstall.setter
    def reinstall(self, value: Optional[pulumi.Input['MetalDeviceReinstallArgs']]):
        pulumi.set(self, "reinstall", value)

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[str]]:
        """
        Root password to the server (disabled after 24 hours).
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_password", value)

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IDs of SSH keys deployed in the device, can be both user and project SSH keys.
        """
        return pulumi.get(self, "ssh_key_ids")

    @ssh_key_ids.setter
    def ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_key_ids", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the device.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input[str]]:
        """
        JSON for custom partitioning. Only usable on reserved hardware. More
        information in in the
        [Custom Partitioning and RAID](https://metal.equinix.com/developers/docs/servers/custom-partitioning-raid/)
        doc. Please note that the disks.partitions.size attribute must be a string, not an integer. It can
        be a number string, or size notation string, e.g. "4G" or "8M" (for gigabytes and megabytes).
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags attached to the device.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="terminationTime")
    def termination_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp for device termination. For example `2021-09-03T16:32:00+03:00`.
        If you don't supply timezone info, timestamp is assumed to be in UTC.
        """
        return pulumi.get(self, "termination_time")

    @termination_time.setter
    def termination_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "termination_time", value)

    @property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp for the last time the device was updated.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        A string of the desired User Data for the device.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="userSshKeyIds")
    def user_ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of IDs of the user SSH keys which should be added to the device. If you omit this, SSH keys of all the members of the parent project will be added to the device. If you specify this array, only the listed user SSH keys (and any project_ssh_key_ids) will be added. User SSH keys can be created with the MetalSSHKey resource
        """
        return pulumi.get(self, "user_ssh_key_ids")

    @user_ssh_key_ids.setter
    def user_ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_ssh_key_ids", value)

    @property
    @pulumi.getter(name="waitForReservationDeprovision")
    def wait_for_reservation_deprovision(self) -> Optional[pulumi.Input[bool]]:
        """
        Only used for devices in reserved hardware. If
        set, the deletion of this device will block until the hardware reservation is marked provisionable
        (about 4 minutes in August 2019).
        """
        return pulumi.get(self, "wait_for_reservation_deprovision")

    @wait_for_reservation_deprovision.setter
    def wait_for_reservation_deprovision(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_reservation_deprovision", value)


class MetalDevice(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_pxe: Optional[pulumi.Input[bool]] = None,
                 billing_cycle: Optional[pulumi.Input[str]] = None,
                 custom_data: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 facilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_detach_volumes: Optional[pulumi.Input[bool]] = None,
                 hardware_reservation_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetalDeviceIpAddressArgs']]]]] = None,
                 ipxe_script_url: Optional[pulumi.Input[str]] = None,
                 metro: Optional[pulumi.Input[str]] = None,
                 operating_system: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 project_ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reinstall: Optional[pulumi.Input[pulumi.InputType['MetalDeviceReinstallArgs']]] = None,
                 storage: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_time: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 user_ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_for_reservation_deprovision: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Provides an Equinix Metal device resource. This can be used to create,
        modify, and delete devices.

        > **NOTE:** All arguments including the `root_password` and `user_data` will be stored in
         the raw state as plain-text.
        [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).

        ## Example Usage

        Create a device and add it to cool_project

        ```python
        import pulumi
        import cuemby_equinix as equinix

        web1 = equinix.MetalDevice("web1",
            hostname="tf.coreos2",
            plan="c3.small.x86",
            metro="sv",
            operating_system="ubuntu_20_04",
            billing_cycle="hourly",
            project_id=local["project_id"])
        ```

        Same as above, but boot via iPXE initially, using the Ignition Provider for provisioning

        ```python
        import pulumi
        import cuemby_equinix as equinix

        pxe1 = equinix.MetalDevice("pxe1",
            hostname="tf.coreos2-pxe",
            plan="c3.small.x86",
            metro="sv",
            operating_system="custom_ipxe",
            billing_cycle="hourly",
            project_id=local["project_id"],
            ipxe_script_url="https://rawgit.com/cloudnativelabs/pxe/master/metal/coreos-stable-metal.ipxe",
            always_pxe=False,
            user_data=data["ignition_config"]["example"]["rendered"])
        ```

        Create a device without a public IP address in facility ny5, with only a /30 private IPv4 subnet (4 IP addresses)

        ```python
        import pulumi
        import cuemby_equinix as equinix

        web1 = equinix.MetalDevice("web1",
            hostname="tf.coreos2",
            plan="c3.small.x86",
            facilities=["ny5"],
            operating_system="ubuntu_20_04",
            billing_cycle="hourly",
            project_id=local["project_id"],
            ip_addresses=[equinix.MetalDeviceIpAddressArgs(
                type="private_ipv4",
                cidr=30,
            )])
        ```

        Deploy device on next-available reserved hardware and do custom partitioning.

        ```python
        import pulumi
        import cuemby_equinix as equinix

        web1 = equinix.MetalDevice("web1",
            hostname="tftest",
            plan="c3.small.x86",
            facilities=["ny5"],
            operating_system="ubuntu_20_04",
            billing_cycle="hourly",
            project_id=local["project_id"],
            hardware_reservation_id="next-available",
            storage=\"\"\"{
          "disks": [
            {
              "device": "/dev/sda",
              "wipeTable": true,
              "partitions": [
                {
                  "label": "BIOS",
                  "number": 1,
                  "size": "4096"
                },
                {
                  "label": "SWAP",
                  "number": 2,
                  "size": "3993600"
                },
                {
                  "label": "ROOT",
                  "number": 3,
                  "size": "0"
                }
              ]
            }
          ],
          "filesystems": [
            {
              "mount": {
                "device": "/dev/sda3",
                "format": "ext4",
                "point": "/",
                "create": {
                  "options": [
                    "-L",
                    "ROOT"
                  ]
                }
              }
            },
            {
              "mount": {
                "device": "/dev/sda2",
                "format": "swap",
                "point": "none",
                "create": {
                  "options": [
                    "-L",
                    "SWAP"
                  ]
                }
              }
            }
          ]
        }
        \"\"\")
        ```

        ## Import

        This resource can be imported using an existing device ID

        ```sh
         $ pulumi import equinix:index/metalDevice:MetalDevice equinix_metal_device {existing_device_id}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] always_pxe: If true, a device with OS `custom_ipxe` will continue to boot via iPXE
               on reboots.
        :param pulumi.Input[str] billing_cycle: monthly or hourly
        :param pulumi.Input[str] custom_data: A string of the desired Custom Data for the device.
        :param pulumi.Input[str] description: The device description.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] facilities: List of facility codes with deployment preferences. Equinix Metal API will go
               through the list and will deploy your device to first facility with free capacity. List items must
               be facility codes or `any` (a wildcard). To find the facility code, visit
               [Facilities API docs](https://metal.equinix.com/developers/api/facilities/), set your API auth
               token in the top of the page and see JSON from the API response. Conflicts with `metro`.
        :param pulumi.Input[bool] force_detach_volumes: Delete device even if it has volumes attached. Only applies
               for destroy action.
        :param pulumi.Input[str] hardware_reservation_id: The UUID of the hardware reservation where you want this device deployed, or next-available if you want to pick your
               next available reservation automatically
        :param pulumi.Input[str] hostname: The device hostname used in deployments taking advantage of Layer3 DHCP
               or metadata service configuration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetalDeviceIpAddressArgs']]]] ip_addresses: A list of IP address types for the device. See
               IP address below for more details.
        :param pulumi.Input[str] ipxe_script_url: URL pointing to a hosted iPXE script. More information is in the
               [Custom iPXE](https://metal.equinix.com/developers/docs/servers/custom-ipxe/) doc.
        :param pulumi.Input[str] metro: Metro area for the new device. Conflicts with `facilities`.
        :param pulumi.Input[str] operating_system: The operating system slug. To find the slug, or visit
               [Operating Systems API docs](https://metal.equinix.com/developers/api/operatingsystems), set your
               API auth token in the top of the page and see JSON from the API response.
        :param pulumi.Input[str] plan: The device plan slug. To find the plan slug, visit
               [Device plans API docs](https://metal.equinix.com/developers/api/plans), set your auth token in the
               top of the page and see JSON from the API response.
        :param pulumi.Input[str] project_id: The ID of the project in which to create the device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] project_ssh_key_ids: Array of IDs of the project SSH keys which should be added to the device.
               If you omit this, SSH keys of all the members of the parent project will be added to the device. If
               you specify this array, only the listed project SSH keys will be added. Project SSH keys can be
               created with the MetalProjectSSHKey resource.
        :param pulumi.Input[pulumi.InputType['MetalDeviceReinstallArgs']] reinstall: Whether the device should be reinstalled instead of destroyed when
               modifying user_data, custom_data, or operating system. See Reinstall below for more
               details.
        :param pulumi.Input[str] storage: JSON for custom partitioning. Only usable on reserved hardware. More
               information in in the
               [Custom Partitioning and RAID](https://metal.equinix.com/developers/docs/servers/custom-partitioning-raid/)
               doc. Please note that the disks.partitions.size attribute must be a string, not an integer. It can
               be a number string, or size notation string, e.g. "4G" or "8M" (for gigabytes and megabytes).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags attached to the device.
        :param pulumi.Input[str] termination_time: Timestamp for device termination. For example `2021-09-03T16:32:00+03:00`.
               If you don't supply timezone info, timestamp is assumed to be in UTC.
        :param pulumi.Input[str] user_data: A string of the desired User Data for the device.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_ssh_key_ids: Array of IDs of the user SSH keys which should be added to the device. If you omit this, SSH keys of all the members of the parent project will be added to the device. If you specify this array, only the listed user SSH keys (and any project_ssh_key_ids) will be added. User SSH keys can be created with the MetalSSHKey resource
        :param pulumi.Input[bool] wait_for_reservation_deprovision: Only used for devices in reserved hardware. If
               set, the deletion of this device will block until the hardware reservation is marked provisionable
               (about 4 minutes in August 2019).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetalDeviceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Equinix Metal device resource. This can be used to create,
        modify, and delete devices.

        > **NOTE:** All arguments including the `root_password` and `user_data` will be stored in
         the raw state as plain-text.
        [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).

        ## Example Usage

        Create a device and add it to cool_project

        ```python
        import pulumi
        import cuemby_equinix as equinix

        web1 = equinix.MetalDevice("web1",
            hostname="tf.coreos2",
            plan="c3.small.x86",
            metro="sv",
            operating_system="ubuntu_20_04",
            billing_cycle="hourly",
            project_id=local["project_id"])
        ```

        Same as above, but boot via iPXE initially, using the Ignition Provider for provisioning

        ```python
        import pulumi
        import cuemby_equinix as equinix

        pxe1 = equinix.MetalDevice("pxe1",
            hostname="tf.coreos2-pxe",
            plan="c3.small.x86",
            metro="sv",
            operating_system="custom_ipxe",
            billing_cycle="hourly",
            project_id=local["project_id"],
            ipxe_script_url="https://rawgit.com/cloudnativelabs/pxe/master/metal/coreos-stable-metal.ipxe",
            always_pxe=False,
            user_data=data["ignition_config"]["example"]["rendered"])
        ```

        Create a device without a public IP address in facility ny5, with only a /30 private IPv4 subnet (4 IP addresses)

        ```python
        import pulumi
        import cuemby_equinix as equinix

        web1 = equinix.MetalDevice("web1",
            hostname="tf.coreos2",
            plan="c3.small.x86",
            facilities=["ny5"],
            operating_system="ubuntu_20_04",
            billing_cycle="hourly",
            project_id=local["project_id"],
            ip_addresses=[equinix.MetalDeviceIpAddressArgs(
                type="private_ipv4",
                cidr=30,
            )])
        ```

        Deploy device on next-available reserved hardware and do custom partitioning.

        ```python
        import pulumi
        import cuemby_equinix as equinix

        web1 = equinix.MetalDevice("web1",
            hostname="tftest",
            plan="c3.small.x86",
            facilities=["ny5"],
            operating_system="ubuntu_20_04",
            billing_cycle="hourly",
            project_id=local["project_id"],
            hardware_reservation_id="next-available",
            storage=\"\"\"{
          "disks": [
            {
              "device": "/dev/sda",
              "wipeTable": true,
              "partitions": [
                {
                  "label": "BIOS",
                  "number": 1,
                  "size": "4096"
                },
                {
                  "label": "SWAP",
                  "number": 2,
                  "size": "3993600"
                },
                {
                  "label": "ROOT",
                  "number": 3,
                  "size": "0"
                }
              ]
            }
          ],
          "filesystems": [
            {
              "mount": {
                "device": "/dev/sda3",
                "format": "ext4",
                "point": "/",
                "create": {
                  "options": [
                    "-L",
                    "ROOT"
                  ]
                }
              }
            },
            {
              "mount": {
                "device": "/dev/sda2",
                "format": "swap",
                "point": "none",
                "create": {
                  "options": [
                    "-L",
                    "SWAP"
                  ]
                }
              }
            }
          ]
        }
        \"\"\")
        ```

        ## Import

        This resource can be imported using an existing device ID

        ```sh
         $ pulumi import equinix:index/metalDevice:MetalDevice equinix_metal_device {existing_device_id}
        ```

        :param str resource_name: The name of the resource.
        :param MetalDeviceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetalDeviceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_pxe: Optional[pulumi.Input[bool]] = None,
                 billing_cycle: Optional[pulumi.Input[str]] = None,
                 custom_data: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 facilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_detach_volumes: Optional[pulumi.Input[bool]] = None,
                 hardware_reservation_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetalDeviceIpAddressArgs']]]]] = None,
                 ipxe_script_url: Optional[pulumi.Input[str]] = None,
                 metro: Optional[pulumi.Input[str]] = None,
                 operating_system: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 project_ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reinstall: Optional[pulumi.Input[pulumi.InputType['MetalDeviceReinstallArgs']]] = None,
                 storage: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_time: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 user_ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_for_reservation_deprovision: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetalDeviceArgs.__new__(MetalDeviceArgs)

            __props__.__dict__["always_pxe"] = always_pxe
            __props__.__dict__["billing_cycle"] = billing_cycle
            __props__.__dict__["custom_data"] = custom_data
            __props__.__dict__["description"] = description
            __props__.__dict__["facilities"] = facilities
            __props__.__dict__["force_detach_volumes"] = force_detach_volumes
            __props__.__dict__["hardware_reservation_id"] = hardware_reservation_id
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["ip_addresses"] = ip_addresses
            __props__.__dict__["ipxe_script_url"] = ipxe_script_url
            __props__.__dict__["metro"] = metro
            if operating_system is None and not opts.urn:
                raise TypeError("Missing required property 'operating_system'")
            __props__.__dict__["operating_system"] = operating_system
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["project_ssh_key_ids"] = project_ssh_key_ids
            __props__.__dict__["reinstall"] = reinstall
            __props__.__dict__["storage"] = storage
            __props__.__dict__["tags"] = tags
            __props__.__dict__["termination_time"] = termination_time
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["user_ssh_key_ids"] = user_ssh_key_ids
            __props__.__dict__["wait_for_reservation_deprovision"] = wait_for_reservation_deprovision
            __props__.__dict__["access_private_ipv4"] = None
            __props__.__dict__["access_public_ipv4"] = None
            __props__.__dict__["access_public_ipv6"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["deployed_facility"] = None
            __props__.__dict__["deployed_hardware_reservation_id"] = None
            __props__.__dict__["locked"] = None
            __props__.__dict__["network_type"] = None
            __props__.__dict__["networks"] = None
            __props__.__dict__["ports"] = None
            __props__.__dict__["root_password"] = None
            __props__.__dict__["ssh_key_ids"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["updated"] = None
        super(MetalDevice, __self__).__init__(
            'equinix:index/metalDevice:MetalDevice',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_private_ipv4: Optional[pulumi.Input[str]] = None,
            access_public_ipv4: Optional[pulumi.Input[str]] = None,
            access_public_ipv6: Optional[pulumi.Input[str]] = None,
            always_pxe: Optional[pulumi.Input[bool]] = None,
            billing_cycle: Optional[pulumi.Input[str]] = None,
            created: Optional[pulumi.Input[str]] = None,
            custom_data: Optional[pulumi.Input[str]] = None,
            deployed_facility: Optional[pulumi.Input[str]] = None,
            deployed_hardware_reservation_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            facilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            force_detach_volumes: Optional[pulumi.Input[bool]] = None,
            hardware_reservation_id: Optional[pulumi.Input[str]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetalDeviceIpAddressArgs']]]]] = None,
            ipxe_script_url: Optional[pulumi.Input[str]] = None,
            locked: Optional[pulumi.Input[bool]] = None,
            metro: Optional[pulumi.Input[str]] = None,
            network_type: Optional[pulumi.Input[str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetalDeviceNetworkArgs']]]]] = None,
            operating_system: Optional[pulumi.Input[str]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            ports: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetalDevicePortArgs']]]]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            project_ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            reinstall: Optional[pulumi.Input[pulumi.InputType['MetalDeviceReinstallArgs']]] = None,
            root_password: Optional[pulumi.Input[str]] = None,
            ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            termination_time: Optional[pulumi.Input[str]] = None,
            updated: Optional[pulumi.Input[str]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            user_ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            wait_for_reservation_deprovision: Optional[pulumi.Input[bool]] = None) -> 'MetalDevice':
        """
        Get an existing MetalDevice resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_private_ipv4: The ipv4 private IP assigned to the device.
        :param pulumi.Input[str] access_public_ipv4: The ipv4 maintenance IP assigned to the device.
        :param pulumi.Input[str] access_public_ipv6: The ipv6 maintenance IP assigned to the device.
        :param pulumi.Input[bool] always_pxe: If true, a device with OS `custom_ipxe` will continue to boot via iPXE
               on reboots.
        :param pulumi.Input[str] billing_cycle: monthly or hourly
        :param pulumi.Input[str] created: The timestamp for when the device was created.
        :param pulumi.Input[str] custom_data: A string of the desired Custom Data for the device.
        :param pulumi.Input[str] deployed_facility: The facility where the device is deployed.
        :param pulumi.Input[str] deployed_hardware_reservation_id: ID of hardware reservation where this device was deployed.
               It is useful when using the `next-available` hardware reservation.
        :param pulumi.Input[str] description: The device description.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] facilities: List of facility codes with deployment preferences. Equinix Metal API will go
               through the list and will deploy your device to first facility with free capacity. List items must
               be facility codes or `any` (a wildcard). To find the facility code, visit
               [Facilities API docs](https://metal.equinix.com/developers/api/facilities/), set your API auth
               token in the top of the page and see JSON from the API response. Conflicts with `metro`.
        :param pulumi.Input[bool] force_detach_volumes: Delete device even if it has volumes attached. Only applies
               for destroy action.
        :param pulumi.Input[str] hardware_reservation_id: The UUID of the hardware reservation where you want this device deployed, or next-available if you want to pick your
               next available reservation automatically
        :param pulumi.Input[str] hostname: The device hostname used in deployments taking advantage of Layer3 DHCP
               or metadata service configuration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetalDeviceIpAddressArgs']]]] ip_addresses: A list of IP address types for the device. See
               IP address below for more details.
        :param pulumi.Input[str] ipxe_script_url: URL pointing to a hosted iPXE script. More information is in the
               [Custom iPXE](https://metal.equinix.com/developers/docs/servers/custom-ipxe/) doc.
        :param pulumi.Input[bool] locked: Whether the device is locked.
        :param pulumi.Input[str] metro: Metro area for the new device. Conflicts with `facilities`.
        :param pulumi.Input[str] network_type: (Deprecated) Network type of a device, used in
               [Layer 2 networking](https://metal.equinix.com/developers/docs/networking/layer2/). Since this
               attribute is deprecated you should handle Network Type with one of
               equinix_metal_port,
               MetalDeviceNetworkType resources or
               MetalPort datasource.
               See network_types guide for more info.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetalDeviceNetworkArgs']]]] networks: The device's private and public IP (v4 and v6) network details. See
               Network Attribute below for more details.
        :param pulumi.Input[str] operating_system: The operating system slug. To find the slug, or visit
               [Operating Systems API docs](https://metal.equinix.com/developers/api/operatingsystems), set your
               API auth token in the top of the page and see JSON from the API response.
        :param pulumi.Input[str] plan: The device plan slug. To find the plan slug, visit
               [Device plans API docs](https://metal.equinix.com/developers/api/plans), set your auth token in the
               top of the page and see JSON from the API response.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetalDevicePortArgs']]]] ports: List of ports assigned to the device. See Ports Attribute below for
               more details.
        :param pulumi.Input[str] project_id: The ID of the project in which to create the device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] project_ssh_key_ids: Array of IDs of the project SSH keys which should be added to the device.
               If you omit this, SSH keys of all the members of the parent project will be added to the device. If
               you specify this array, only the listed project SSH keys will be added. Project SSH keys can be
               created with the MetalProjectSSHKey resource.
        :param pulumi.Input[pulumi.InputType['MetalDeviceReinstallArgs']] reinstall: Whether the device should be reinstalled instead of destroyed when
               modifying user_data, custom_data, or operating system. See Reinstall below for more
               details.
        :param pulumi.Input[str] root_password: Root password to the server (disabled after 24 hours).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: List of IDs of SSH keys deployed in the device, can be both user and project SSH keys.
        :param pulumi.Input[str] state: The status of the device.
        :param pulumi.Input[str] storage: JSON for custom partitioning. Only usable on reserved hardware. More
               information in in the
               [Custom Partitioning and RAID](https://metal.equinix.com/developers/docs/servers/custom-partitioning-raid/)
               doc. Please note that the disks.partitions.size attribute must be a string, not an integer. It can
               be a number string, or size notation string, e.g. "4G" or "8M" (for gigabytes and megabytes).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags attached to the device.
        :param pulumi.Input[str] termination_time: Timestamp for device termination. For example `2021-09-03T16:32:00+03:00`.
               If you don't supply timezone info, timestamp is assumed to be in UTC.
        :param pulumi.Input[str] updated: The timestamp for the last time the device was updated.
        :param pulumi.Input[str] user_data: A string of the desired User Data for the device.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_ssh_key_ids: Array of IDs of the user SSH keys which should be added to the device. If you omit this, SSH keys of all the members of the parent project will be added to the device. If you specify this array, only the listed user SSH keys (and any project_ssh_key_ids) will be added. User SSH keys can be created with the MetalSSHKey resource
        :param pulumi.Input[bool] wait_for_reservation_deprovision: Only used for devices in reserved hardware. If
               set, the deletion of this device will block until the hardware reservation is marked provisionable
               (about 4 minutes in August 2019).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetalDeviceState.__new__(_MetalDeviceState)

        __props__.__dict__["access_private_ipv4"] = access_private_ipv4
        __props__.__dict__["access_public_ipv4"] = access_public_ipv4
        __props__.__dict__["access_public_ipv6"] = access_public_ipv6
        __props__.__dict__["always_pxe"] = always_pxe
        __props__.__dict__["billing_cycle"] = billing_cycle
        __props__.__dict__["created"] = created
        __props__.__dict__["custom_data"] = custom_data
        __props__.__dict__["deployed_facility"] = deployed_facility
        __props__.__dict__["deployed_hardware_reservation_id"] = deployed_hardware_reservation_id
        __props__.__dict__["description"] = description
        __props__.__dict__["facilities"] = facilities
        __props__.__dict__["force_detach_volumes"] = force_detach_volumes
        __props__.__dict__["hardware_reservation_id"] = hardware_reservation_id
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["ip_addresses"] = ip_addresses
        __props__.__dict__["ipxe_script_url"] = ipxe_script_url
        __props__.__dict__["locked"] = locked
        __props__.__dict__["metro"] = metro
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["networks"] = networks
        __props__.__dict__["operating_system"] = operating_system
        __props__.__dict__["plan"] = plan
        __props__.__dict__["ports"] = ports
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["project_ssh_key_ids"] = project_ssh_key_ids
        __props__.__dict__["reinstall"] = reinstall
        __props__.__dict__["root_password"] = root_password
        __props__.__dict__["ssh_key_ids"] = ssh_key_ids
        __props__.__dict__["state"] = state
        __props__.__dict__["storage"] = storage
        __props__.__dict__["tags"] = tags
        __props__.__dict__["termination_time"] = termination_time
        __props__.__dict__["updated"] = updated
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["user_ssh_key_ids"] = user_ssh_key_ids
        __props__.__dict__["wait_for_reservation_deprovision"] = wait_for_reservation_deprovision
        return MetalDevice(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPrivateIpv4")
    def access_private_ipv4(self) -> pulumi.Output[str]:
        """
        The ipv4 private IP assigned to the device.
        """
        return pulumi.get(self, "access_private_ipv4")

    @property
    @pulumi.getter(name="accessPublicIpv4")
    def access_public_ipv4(self) -> pulumi.Output[str]:
        """
        The ipv4 maintenance IP assigned to the device.
        """
        return pulumi.get(self, "access_public_ipv4")

    @property
    @pulumi.getter(name="accessPublicIpv6")
    def access_public_ipv6(self) -> pulumi.Output[str]:
        """
        The ipv6 maintenance IP assigned to the device.
        """
        return pulumi.get(self, "access_public_ipv6")

    @property
    @pulumi.getter(name="alwaysPxe")
    def always_pxe(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, a device with OS `custom_ipxe` will continue to boot via iPXE
        on reboots.
        """
        return pulumi.get(self, "always_pxe")

    @property
    @pulumi.getter(name="billingCycle")
    def billing_cycle(self) -> pulumi.Output[str]:
        """
        monthly or hourly
        """
        return pulumi.get(self, "billing_cycle")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        The timestamp for when the device was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> pulumi.Output[Optional[str]]:
        """
        A string of the desired Custom Data for the device.
        """
        return pulumi.get(self, "custom_data")

    @property
    @pulumi.getter(name="deployedFacility")
    def deployed_facility(self) -> pulumi.Output[str]:
        """
        The facility where the device is deployed.
        """
        return pulumi.get(self, "deployed_facility")

    @property
    @pulumi.getter(name="deployedHardwareReservationId")
    def deployed_hardware_reservation_id(self) -> pulumi.Output[str]:
        """
        ID of hardware reservation where this device was deployed.
        It is useful when using the `next-available` hardware reservation.
        """
        return pulumi.get(self, "deployed_hardware_reservation_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The device description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def facilities(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of facility codes with deployment preferences. Equinix Metal API will go
        through the list and will deploy your device to first facility with free capacity. List items must
        be facility codes or `any` (a wildcard). To find the facility code, visit
        [Facilities API docs](https://metal.equinix.com/developers/api/facilities/), set your API auth
        token in the top of the page and see JSON from the API response. Conflicts with `metro`.
        """
        return pulumi.get(self, "facilities")

    @property
    @pulumi.getter(name="forceDetachVolumes")
    def force_detach_volumes(self) -> pulumi.Output[Optional[bool]]:
        """
        Delete device even if it has volumes attached. Only applies
        for destroy action.
        """
        return pulumi.get(self, "force_detach_volumes")

    @property
    @pulumi.getter(name="hardwareReservationId")
    def hardware_reservation_id(self) -> pulumi.Output[Optional[str]]:
        """
        The UUID of the hardware reservation where you want this device deployed, or next-available if you want to pick your
        next available reservation automatically
        """
        return pulumi.get(self, "hardware_reservation_id")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        The device hostname used in deployments taking advantage of Layer3 DHCP
        or metadata service configuration.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Output[Optional[Sequence['outputs.MetalDeviceIpAddress']]]:
        """
        A list of IP address types for the device. See
        IP address below for more details.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="ipxeScriptUrl")
    def ipxe_script_url(self) -> pulumi.Output[Optional[str]]:
        """
        URL pointing to a hosted iPXE script. More information is in the
        [Custom iPXE](https://metal.equinix.com/developers/docs/servers/custom-ipxe/) doc.
        """
        return pulumi.get(self, "ipxe_script_url")

    @property
    @pulumi.getter
    def locked(self) -> pulumi.Output[bool]:
        """
        Whether the device is locked.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def metro(self) -> pulumi.Output[Optional[str]]:
        """
        Metro area for the new device. Conflicts with `facilities`.
        """
        return pulumi.get(self, "metro")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[str]:
        """
        (Deprecated) Network type of a device, used in
        [Layer 2 networking](https://metal.equinix.com/developers/docs/networking/layer2/). Since this
        attribute is deprecated you should handle Network Type with one of
        equinix_metal_port,
        MetalDeviceNetworkType resources or
        MetalPort datasource.
        See network_types guide for more info.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.MetalDeviceNetwork']]:
        """
        The device's private and public IP (v4 and v6) network details. See
        Network Attribute below for more details.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> pulumi.Output[str]:
        """
        The operating system slug. To find the slug, or visit
        [Operating Systems API docs](https://metal.equinix.com/developers/api/operatingsystems), set your
        API auth token in the top of the page and see JSON from the API response.
        """
        return pulumi.get(self, "operating_system")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[str]:
        """
        The device plan slug. To find the plan slug, visit
        [Device plans API docs](https://metal.equinix.com/developers/api/plans), set your auth token in the
        top of the page and see JSON from the API response.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[Sequence['outputs.MetalDevicePort']]:
        """
        List of ports assigned to the device. See Ports Attribute below for
        more details.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the project in which to create the device
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="projectSshKeyIds")
    def project_ssh_key_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Array of IDs of the project SSH keys which should be added to the device.
        If you omit this, SSH keys of all the members of the parent project will be added to the device. If
        you specify this array, only the listed project SSH keys will be added. Project SSH keys can be
        created with the MetalProjectSSHKey resource.
        """
        return pulumi.get(self, "project_ssh_key_ids")

    @property
    @pulumi.getter
    def reinstall(self) -> pulumi.Output[Optional['outputs.MetalDeviceReinstall']]:
        """
        Whether the device should be reinstalled instead of destroyed when
        modifying user_data, custom_data, or operating system. See Reinstall below for more
        details.
        """
        return pulumi.get(self, "reinstall")

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> pulumi.Output[str]:
        """
        Root password to the server (disabled after 24 hours).
        """
        return pulumi.get(self, "root_password")

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        List of IDs of SSH keys deployed in the device, can be both user and project SSH keys.
        """
        return pulumi.get(self, "ssh_key_ids")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The status of the device.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def storage(self) -> pulumi.Output[Optional[str]]:
        """
        JSON for custom partitioning. Only usable on reserved hardware. More
        information in in the
        [Custom Partitioning and RAID](https://metal.equinix.com/developers/docs/servers/custom-partitioning-raid/)
        doc. Please note that the disks.partitions.size attribute must be a string, not an integer. It can
        be a number string, or size notation string, e.g. "4G" or "8M" (for gigabytes and megabytes).
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags attached to the device.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="terminationTime")
    def termination_time(self) -> pulumi.Output[Optional[str]]:
        """
        Timestamp for device termination. For example `2021-09-03T16:32:00+03:00`.
        If you don't supply timezone info, timestamp is assumed to be in UTC.
        """
        return pulumi.get(self, "termination_time")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[str]:
        """
        The timestamp for the last time the device was updated.
        """
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        A string of the desired User Data for the device.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="userSshKeyIds")
    def user_ssh_key_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Array of IDs of the user SSH keys which should be added to the device. If you omit this, SSH keys of all the members of the parent project will be added to the device. If you specify this array, only the listed user SSH keys (and any project_ssh_key_ids) will be added. User SSH keys can be created with the MetalSSHKey resource
        """
        return pulumi.get(self, "user_ssh_key_ids")

    @property
    @pulumi.getter(name="waitForReservationDeprovision")
    def wait_for_reservation_deprovision(self) -> pulumi.Output[Optional[bool]]:
        """
        Only used for devices in reserved hardware. If
        set, the deletion of this device will block until the hardware reservation is marked provisionable
        (about 4 minutes in August 2019).
        """
        return pulumi.get(self, "wait_for_reservation_deprovision")

