# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetalOrganizationArgs', 'MetalOrganization']

@pulumi.input_type
class MetalOrganizationArgs:
    def __init__(__self__, *,
                 address: pulumi.Input['MetalOrganizationAddressArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 twitter: Optional[pulumi.Input[str]] = None,
                 website: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MetalOrganization resource.
        :param pulumi.Input['MetalOrganizationAddressArgs'] address: Postal address.
        :param pulumi.Input[str] description: Description string.
        :param pulumi.Input[str] logo: Logo URL.
        :param pulumi.Input[str] name: The name of the Organization.
        :param pulumi.Input[str] twitter: Twitter handle.
        :param pulumi.Input[str] website: Website link.
        """
        pulumi.set(__self__, "address", address)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if twitter is not None:
            pulumi.set(__self__, "twitter", twitter)
        if website is not None:
            pulumi.set(__self__, "website", website)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input['MetalOrganizationAddressArgs']:
        """
        Postal address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input['MetalOrganizationAddressArgs']):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description string.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[str]]:
        """
        Logo URL.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Organization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def twitter(self) -> Optional[pulumi.Input[str]]:
        """
        Twitter handle.
        """
        return pulumi.get(self, "twitter")

    @twitter.setter
    def twitter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "twitter", value)

    @property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input[str]]:
        """
        Website link.
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "website", value)


@pulumi.input_type
class _MetalOrganizationState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input['MetalOrganizationAddressArgs']] = None,
                 created: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 twitter: Optional[pulumi.Input[str]] = None,
                 updated: Optional[pulumi.Input[str]] = None,
                 website: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MetalOrganization resources.
        :param pulumi.Input['MetalOrganizationAddressArgs'] address: Postal address.
        :param pulumi.Input[str] created: The timestamp for when the organization was created.
        :param pulumi.Input[str] description: Description string.
        :param pulumi.Input[str] logo: Logo URL.
        :param pulumi.Input[str] name: The name of the Organization.
        :param pulumi.Input[str] twitter: Twitter handle.
        :param pulumi.Input[str] updated: The timestamp for the last time the organization was updated.
        :param pulumi.Input[str] website: Website link.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if twitter is not None:
            pulumi.set(__self__, "twitter", twitter)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if website is not None:
            pulumi.set(__self__, "website", website)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input['MetalOrganizationAddressArgs']]:
        """
        Postal address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input['MetalOrganizationAddressArgs']]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp for when the organization was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description string.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[str]]:
        """
        Logo URL.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Organization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def twitter(self) -> Optional[pulumi.Input[str]]:
        """
        Twitter handle.
        """
        return pulumi.get(self, "twitter")

    @twitter.setter
    def twitter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "twitter", value)

    @property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp for the last time the organization was updated.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated", value)

    @property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input[str]]:
        """
        Website link.
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "website", value)


class MetalOrganization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[pulumi.InputType['MetalOrganizationAddressArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 twitter: Optional[pulumi.Input[str]] = None,
                 website: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage organization resource in Equinix Metal.

        ## Example Usage

        ```python
        import pulumi
        import cuemby_equinix as equinix

        # Create a new Organization
        tf_organization1 = equinix.MetalOrganization("tfOrganization1", description="quux")
        ```

        ## Import

        This resource can be imported using an existing organization ID

        ```sh
         $ pulumi import equinix:index/metalOrganization:MetalOrganization equinix_metal_organization {existing_organization_id}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['MetalOrganizationAddressArgs']] address: Postal address.
        :param pulumi.Input[str] description: Description string.
        :param pulumi.Input[str] logo: Logo URL.
        :param pulumi.Input[str] name: The name of the Organization.
        :param pulumi.Input[str] twitter: Twitter handle.
        :param pulumi.Input[str] website: Website link.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetalOrganizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage organization resource in Equinix Metal.

        ## Example Usage

        ```python
        import pulumi
        import cuemby_equinix as equinix

        # Create a new Organization
        tf_organization1 = equinix.MetalOrganization("tfOrganization1", description="quux")
        ```

        ## Import

        This resource can be imported using an existing organization ID

        ```sh
         $ pulumi import equinix:index/metalOrganization:MetalOrganization equinix_metal_organization {existing_organization_id}
        ```

        :param str resource_name: The name of the resource.
        :param MetalOrganizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetalOrganizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[pulumi.InputType['MetalOrganizationAddressArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 twitter: Optional[pulumi.Input[str]] = None,
                 website: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetalOrganizationArgs.__new__(MetalOrganizationArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            __props__.__dict__["description"] = description
            __props__.__dict__["logo"] = logo
            __props__.__dict__["name"] = name
            __props__.__dict__["twitter"] = twitter
            __props__.__dict__["website"] = website
            __props__.__dict__["created"] = None
            __props__.__dict__["updated"] = None
        super(MetalOrganization, __self__).__init__(
            'equinix:index/metalOrganization:MetalOrganization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[pulumi.InputType['MetalOrganizationAddressArgs']]] = None,
            created: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            logo: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            twitter: Optional[pulumi.Input[str]] = None,
            updated: Optional[pulumi.Input[str]] = None,
            website: Optional[pulumi.Input[str]] = None) -> 'MetalOrganization':
        """
        Get an existing MetalOrganization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['MetalOrganizationAddressArgs']] address: Postal address.
        :param pulumi.Input[str] created: The timestamp for when the organization was created.
        :param pulumi.Input[str] description: Description string.
        :param pulumi.Input[str] logo: Logo URL.
        :param pulumi.Input[str] name: The name of the Organization.
        :param pulumi.Input[str] twitter: Twitter handle.
        :param pulumi.Input[str] updated: The timestamp for the last time the organization was updated.
        :param pulumi.Input[str] website: Website link.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetalOrganizationState.__new__(_MetalOrganizationState)

        __props__.__dict__["address"] = address
        __props__.__dict__["created"] = created
        __props__.__dict__["description"] = description
        __props__.__dict__["logo"] = logo
        __props__.__dict__["name"] = name
        __props__.__dict__["twitter"] = twitter
        __props__.__dict__["updated"] = updated
        __props__.__dict__["website"] = website
        return MetalOrganization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output['outputs.MetalOrganizationAddress']:
        """
        Postal address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        The timestamp for when the organization was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description string.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def logo(self) -> pulumi.Output[Optional[str]]:
        """
        Logo URL.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Organization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def twitter(self) -> pulumi.Output[Optional[str]]:
        """
        Twitter handle.
        """
        return pulumi.get(self, "twitter")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[str]:
        """
        The timestamp for the last time the organization was updated.
        """
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter
    def website(self) -> pulumi.Output[Optional[str]]:
        """
        Website link.
        """
        return pulumi.get(self, "website")

