# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['MetalSSHKeyArgs', 'MetalSSHKey']

@pulumi.input_type
class MetalSSHKeyArgs:
    def __init__(__self__, *,
                 public_key: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MetalSSHKey resource.
        :param pulumi.Input[str] public_key: The public key. If this is a file, it
               can be read using the file interpolation function
        :param pulumi.Input[str] name: The name of the SSH key for identification
        """
        pulumi.set(__self__, "public_key", public_key)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Input[str]:
        """
        The public key. If this is a file, it
        can be read using the file interpolation function
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SSH key for identification
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MetalSSHKeyState:
    def __init__(__self__, *,
                 created: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MetalSSHKey resources.
        :param pulumi.Input[str] created: The timestamp for when the SSH key was created.
        :param pulumi.Input[str] fingerprint: The fingerprint of the SSH key.
        :param pulumi.Input[str] name: The name of the SSH key for identification
        :param pulumi.Input[str] owner_id: The UUID of the Equinix Metal API User who owns this key.
        :param pulumi.Input[str] public_key: The public key. If this is a file, it
               can be read using the file interpolation function
        :param pulumi.Input[str] updated: The timestamp for the last time the SSH key was updated.
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp for when the SSH key was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        The fingerprint of the SSH key.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SSH key for identification
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the Equinix Metal API User who owns this key.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        The public key. If this is a file, it
        can be read using the file interpolation function
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp for the last time the SSH key was updated.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated", value)


class MetalSSHKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage User SSH keys on your Equinix Metal user account. If you create a new device in a project, all the keys of the project's collaborators will be injected to the device.

        The link between User SSH key and device is implicit. If you want to make sure that a key will be copied to a device, you must ensure that the device resource `depends_on` the key resource.

        ## Example Usage

        ```python
        import pulumi
        import cuemby_equinix as equinix

        # Create a new SSH key
        key1 = equinix.MetalSSHKey("key1", public_key=(lambda path: open(path).read())("/home/terraform/.ssh/id_rsa.pub"))
        # Create new device with "key1" included. The device resource "depends_on" the
        # key, in order to make sure the key is created before the device.
        test = equinix.MetalDevice("test",
            hostname="test-device",
            plan="c3.small.x86",
            metro="sv",
            operating_system="ubuntu_20_04",
            billing_cycle="hourly",
            project_id=local["project_id"],
            opts=pulumi.ResourceOptions(depends_on=["equinix_metal_ssh_key.key1"]))
        ```

        ## Import

        This resource can be imported using an existing SSH Key ID

        ```sh
         $ pulumi import equinix:index/metalSSHKey:MetalSSHKey equinix_metal_ssh_key {existing_sshkey_id}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the SSH key for identification
        :param pulumi.Input[str] public_key: The public key. If this is a file, it
               can be read using the file interpolation function
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetalSSHKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage User SSH keys on your Equinix Metal user account. If you create a new device in a project, all the keys of the project's collaborators will be injected to the device.

        The link between User SSH key and device is implicit. If you want to make sure that a key will be copied to a device, you must ensure that the device resource `depends_on` the key resource.

        ## Example Usage

        ```python
        import pulumi
        import cuemby_equinix as equinix

        # Create a new SSH key
        key1 = equinix.MetalSSHKey("key1", public_key=(lambda path: open(path).read())("/home/terraform/.ssh/id_rsa.pub"))
        # Create new device with "key1" included. The device resource "depends_on" the
        # key, in order to make sure the key is created before the device.
        test = equinix.MetalDevice("test",
            hostname="test-device",
            plan="c3.small.x86",
            metro="sv",
            operating_system="ubuntu_20_04",
            billing_cycle="hourly",
            project_id=local["project_id"],
            opts=pulumi.ResourceOptions(depends_on=["equinix_metal_ssh_key.key1"]))
        ```

        ## Import

        This resource can be imported using an existing SSH Key ID

        ```sh
         $ pulumi import equinix:index/metalSSHKey:MetalSSHKey equinix_metal_ssh_key {existing_sshkey_id}
        ```

        :param str resource_name: The name of the resource.
        :param MetalSSHKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetalSSHKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetalSSHKeyArgs.__new__(MetalSSHKeyArgs)

            __props__.__dict__["name"] = name
            if public_key is None and not opts.urn:
                raise TypeError("Missing required property 'public_key'")
            __props__.__dict__["public_key"] = public_key
            __props__.__dict__["created"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["updated"] = None
        super(MetalSSHKey, __self__).__init__(
            'equinix:index/metalSSHKey:MetalSSHKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created: Optional[pulumi.Input[str]] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            public_key: Optional[pulumi.Input[str]] = None,
            updated: Optional[pulumi.Input[str]] = None) -> 'MetalSSHKey':
        """
        Get an existing MetalSSHKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created: The timestamp for when the SSH key was created.
        :param pulumi.Input[str] fingerprint: The fingerprint of the SSH key.
        :param pulumi.Input[str] name: The name of the SSH key for identification
        :param pulumi.Input[str] owner_id: The UUID of the Equinix Metal API User who owns this key.
        :param pulumi.Input[str] public_key: The public key. If this is a file, it
               can be read using the file interpolation function
        :param pulumi.Input[str] updated: The timestamp for the last time the SSH key was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetalSSHKeyState.__new__(_MetalSSHKeyState)

        __props__.__dict__["created"] = created
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["updated"] = updated
        return MetalSSHKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        The timestamp for when the SSH key was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        The fingerprint of the SSH key.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the SSH key for identification
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        The UUID of the Equinix Metal API User who owns this key.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[str]:
        """
        The public key. If this is a file, it
        can be read using the file interpolation function
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[str]:
        """
        The timestamp for the last time the SSH key was updated.
        """
        return pulumi.get(self, "updated")

