# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['MetalVirtualCircuitArgs', 'MetalVirtualCircuit']

@pulumi.input_type
class MetalVirtualCircuitArgs:
    def __init__(__self__, *,
                 connection_id: pulumi.Input[str],
                 port_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 customer_ip: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 md5: Optional[pulumi.Input[str]] = None,
                 metal_ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nni_vlan: Optional[pulumi.Input[int]] = None,
                 peer_asn: Optional[pulumi.Input[int]] = None,
                 speed: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vlan_id: Optional[pulumi.Input[str]] = None,
                 vrf_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MetalVirtualCircuit resource.
        :param pulumi.Input[str] connection_id: UUID of Connection where the VC is scoped to.
        :param pulumi.Input[str] port_id: UUID of the Connection Port where the VC is scoped to.
        :param pulumi.Input[str] project_id: UUID of the Project where the VC is scoped to.
        :param pulumi.Input[str] customer_ip: The Customer IP address which the CSR switch will peer with. Will default to the other usable IP in the subnet.
        :param pulumi.Input[str] description: Description for the Virtual Circuit resource.
        :param pulumi.Input[str] md5: The password that can be set for the VRF BGP peer
        :param pulumi.Input[str] metal_ip: The Metal IP address for the SVI (Switch Virtual Interface) of the VirtualCircuit. Will default to the first usable IP in the subnet.
        :param pulumi.Input[str] name: Name of the Virtual Circuit resource.
        :param pulumi.Input[int] nni_vlan: Equinix Metal network-to-network VLAN ID.
        :param pulumi.Input[int] peer_asn: The BGP ASN of the peer. The same ASN may be the used across several VCs, but it cannot be the same as the local_asn of the VRF.
        :param pulumi.Input[str] speed: Speed of the Virtual Circuit resource.
        :param pulumi.Input[str] subnet: A subnet from one of the IP
               blocks associated with the VRF that we will help create an IP reservation for. Can only be either a /30 or /31.
               * For a /31 block, it will only have two IP addresses, which will be used for
               the metal_ip and customer_ip.
               * For a /30 block, it will have four IP addresses, but the first and last IP addresses are not usable. We will default to the first usable IP address for the metal_ip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for the Virtual Circuit resource.
        :param pulumi.Input[str] vlan_id: UUID of the VLAN to associate.
        :param pulumi.Input[str] vrf_id: UUID of the VRF to associate.
        """
        pulumi.set(__self__, "connection_id", connection_id)
        pulumi.set(__self__, "port_id", port_id)
        pulumi.set(__self__, "project_id", project_id)
        if customer_ip is not None:
            pulumi.set(__self__, "customer_ip", customer_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)
        if metal_ip is not None:
            pulumi.set(__self__, "metal_ip", metal_ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nni_vlan is not None:
            pulumi.set(__self__, "nni_vlan", nni_vlan)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if speed is not None:
            pulumi.set(__self__, "speed", speed)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vrf_id is not None:
            pulumi.set(__self__, "vrf_id", vrf_id)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Input[str]:
        """
        UUID of Connection where the VC is scoped to.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Input[str]:
        """
        UUID of the Connection Port where the VC is scoped to.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        UUID of the Project where the VC is scoped to.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="customerIp")
    def customer_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The Customer IP address which the CSR switch will peer with. Will default to the other usable IP in the subnet.
        """
        return pulumi.get(self, "customer_ip")

    @customer_ip.setter
    def customer_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the Virtual Circuit resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def md5(self) -> Optional[pulumi.Input[str]]:
        """
        The password that can be set for the VRF BGP peer
        """
        return pulumi.get(self, "md5")

    @md5.setter
    def md5(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "md5", value)

    @property
    @pulumi.getter(name="metalIp")
    def metal_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The Metal IP address for the SVI (Switch Virtual Interface) of the VirtualCircuit. Will default to the first usable IP in the subnet.
        """
        return pulumi.get(self, "metal_ip")

    @metal_ip.setter
    def metal_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metal_ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Virtual Circuit resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nniVlan")
    def nni_vlan(self) -> Optional[pulumi.Input[int]]:
        """
        Equinix Metal network-to-network VLAN ID.
        """
        return pulumi.get(self, "nni_vlan")

    @nni_vlan.setter
    def nni_vlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nni_vlan", value)

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[int]]:
        """
        The BGP ASN of the peer. The same ASN may be the used across several VCs, but it cannot be the same as the local_asn of the VRF.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "peer_asn", value)

    @property
    @pulumi.getter
    def speed(self) -> Optional[pulumi.Input[str]]:
        """
        Speed of the Virtual Circuit resource.
        """
        return pulumi.get(self, "speed")

    @speed.setter
    def speed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "speed", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        A subnet from one of the IP
        blocks associated with the VRF that we will help create an IP reservation for. Can only be either a /30 or /31.
        * For a /31 block, it will only have two IP addresses, which will be used for
        the metal_ip and customer_ip.
        * For a /30 block, it will have four IP addresses, but the first and last IP addresses are not usable. We will default to the first usable IP address for the metal_ip.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags for the Virtual Circuit resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        UUID of the VLAN to associate.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="vrfId")
    def vrf_id(self) -> Optional[pulumi.Input[str]]:
        """
        UUID of the VRF to associate.
        """
        return pulumi.get(self, "vrf_id")

    @vrf_id.setter
    def vrf_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vrf_id", value)


@pulumi.input_type
class _MetalVirtualCircuitState:
    def __init__(__self__, *,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 customer_ip: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 md5: Optional[pulumi.Input[str]] = None,
                 metal_ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nni_vlan: Optional[pulumi.Input[int]] = None,
                 nni_vnid: Optional[pulumi.Input[int]] = None,
                 peer_asn: Optional[pulumi.Input[int]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vlan_id: Optional[pulumi.Input[str]] = None,
                 vnid: Optional[pulumi.Input[int]] = None,
                 vrf_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MetalVirtualCircuit resources.
        :param pulumi.Input[str] connection_id: UUID of Connection where the VC is scoped to.
        :param pulumi.Input[str] customer_ip: The Customer IP address which the CSR switch will peer with. Will default to the other usable IP in the subnet.
        :param pulumi.Input[str] description: Description for the Virtual Circuit resource.
        :param pulumi.Input[str] md5: The password that can be set for the VRF BGP peer
        :param pulumi.Input[str] metal_ip: The Metal IP address for the SVI (Switch Virtual Interface) of the VirtualCircuit. Will default to the first usable IP in the subnet.
        :param pulumi.Input[str] name: Name of the Virtual Circuit resource.
        :param pulumi.Input[int] nni_vlan: Equinix Metal network-to-network VLAN ID.
        :param pulumi.Input[int] nni_vnid: NNI VLAN parameters, see the [documentation for Equinix Fabric](https://metal.equinix.com/developers/docs/networking/fabric/).
        :param pulumi.Input[int] peer_asn: The BGP ASN of the peer. The same ASN may be the used across several VCs, but it cannot be the same as the local_asn of the VRF.
        :param pulumi.Input[str] port_id: UUID of the Connection Port where the VC is scoped to.
        :param pulumi.Input[str] project_id: UUID of the Project where the VC is scoped to.
        :param pulumi.Input[str] speed: Speed of the Virtual Circuit resource.
        :param pulumi.Input[str] status: Status of the virtal circuit.
        :param pulumi.Input[str] subnet: A subnet from one of the IP
               blocks associated with the VRF that we will help create an IP reservation for. Can only be either a /30 or /31.
               * For a /31 block, it will only have two IP addresses, which will be used for
               the metal_ip and customer_ip.
               * For a /30 block, it will have four IP addresses, but the first and last IP addresses are not usable. We will default to the first usable IP address for the metal_ip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for the Virtual Circuit resource.
        :param pulumi.Input[str] vlan_id: UUID of the VLAN to associate.
        :param pulumi.Input[int] vnid: VNID VLAN parameter, see the [documentation for Equinix Fabric](https://metal.equinix.com/developers/docs/networking/fabric/).
        :param pulumi.Input[str] vrf_id: UUID of the VRF to associate.
        """
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if customer_ip is not None:
            pulumi.set(__self__, "customer_ip", customer_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)
        if metal_ip is not None:
            pulumi.set(__self__, "metal_ip", metal_ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nni_vlan is not None:
            pulumi.set(__self__, "nni_vlan", nni_vlan)
        if nni_vnid is not None:
            pulumi.set(__self__, "nni_vnid", nni_vnid)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if speed is not None:
            pulumi.set(__self__, "speed", speed)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vnid is not None:
            pulumi.set(__self__, "vnid", vnid)
        if vrf_id is not None:
            pulumi.set(__self__, "vrf_id", vrf_id)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        UUID of Connection where the VC is scoped to.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter(name="customerIp")
    def customer_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The Customer IP address which the CSR switch will peer with. Will default to the other usable IP in the subnet.
        """
        return pulumi.get(self, "customer_ip")

    @customer_ip.setter
    def customer_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the Virtual Circuit resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def md5(self) -> Optional[pulumi.Input[str]]:
        """
        The password that can be set for the VRF BGP peer
        """
        return pulumi.get(self, "md5")

    @md5.setter
    def md5(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "md5", value)

    @property
    @pulumi.getter(name="metalIp")
    def metal_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The Metal IP address for the SVI (Switch Virtual Interface) of the VirtualCircuit. Will default to the first usable IP in the subnet.
        """
        return pulumi.get(self, "metal_ip")

    @metal_ip.setter
    def metal_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metal_ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Virtual Circuit resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nniVlan")
    def nni_vlan(self) -> Optional[pulumi.Input[int]]:
        """
        Equinix Metal network-to-network VLAN ID.
        """
        return pulumi.get(self, "nni_vlan")

    @nni_vlan.setter
    def nni_vlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nni_vlan", value)

    @property
    @pulumi.getter(name="nniVnid")
    def nni_vnid(self) -> Optional[pulumi.Input[int]]:
        """
        NNI VLAN parameters, see the [documentation for Equinix Fabric](https://metal.equinix.com/developers/docs/networking/fabric/).
        """
        return pulumi.get(self, "nni_vnid")

    @nni_vnid.setter
    def nni_vnid(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nni_vnid", value)

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[int]]:
        """
        The BGP ASN of the peer. The same ASN may be the used across several VCs, but it cannot be the same as the local_asn of the VRF.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "peer_asn", value)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[str]]:
        """
        UUID of the Connection Port where the VC is scoped to.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        UUID of the Project where the VC is scoped to.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def speed(self) -> Optional[pulumi.Input[str]]:
        """
        Speed of the Virtual Circuit resource.
        """
        return pulumi.get(self, "speed")

    @speed.setter
    def speed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "speed", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the virtal circuit.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        A subnet from one of the IP
        blocks associated with the VRF that we will help create an IP reservation for. Can only be either a /30 or /31.
        * For a /31 block, it will only have two IP addresses, which will be used for
        the metal_ip and customer_ip.
        * For a /30 block, it will have four IP addresses, but the first and last IP addresses are not usable. We will default to the first usable IP address for the metal_ip.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags for the Virtual Circuit resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        UUID of the VLAN to associate.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter
    def vnid(self) -> Optional[pulumi.Input[int]]:
        """
        VNID VLAN parameter, see the [documentation for Equinix Fabric](https://metal.equinix.com/developers/docs/networking/fabric/).
        """
        return pulumi.get(self, "vnid")

    @vnid.setter
    def vnid(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vnid", value)

    @property
    @pulumi.getter(name="vrfId")
    def vrf_id(self) -> Optional[pulumi.Input[str]]:
        """
        UUID of the VRF to associate.
        """
        return pulumi.get(self, "vrf_id")

    @vrf_id.setter
    def vrf_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vrf_id", value)


class MetalVirtualCircuit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 customer_ip: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 md5: Optional[pulumi.Input[str]] = None,
                 metal_ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nni_vlan: Optional[pulumi.Input[int]] = None,
                 peer_asn: Optional[pulumi.Input[int]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vlan_id: Optional[pulumi.Input[str]] = None,
                 vrf_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Use this resource to associate VLAN with a Dedicated Port from
        [Equinix Fabric - software-defined interconnections](https://metal.equinix.com/developers/docs/networking/fabric/#associating-a-vlan-with-a-dedicated-port).

        > VRF features are not generally available. The interfaces related to VRF resources may change ahead of general availability.

        ## Example Usage

        Pick an existing Project and Connection, create a VLAN and use `MetalVirtualCircuit`
        to associate it with a Primary Port of the Connection.

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        project_id = "52000fb2-ee46-4673-93a8-de2c2bdba33c"
        conn_id = "73f12f29-3e19-43a0-8e90-ae81580db1e0"
        test_get_metal_connection = equinix.get_metal_connection(connection_id=conn_id)
        test_metal_vlan = equinix.MetalVlan("testMetalVlan",
            project_id=project_id,
            metro=test_get_metal_connection.metro)
        test_metal_virtual_circuit = equinix.MetalVirtualCircuit("testMetalVirtualCircuit",
            connection_id=conn_id,
            project_id=project_id,
            port_id=test_get_metal_connection.ports[0].id,
            vlan_id=test_metal_vlan.id,
            nni_vlan=1056)
        ```

        ## Import

        This resource can be imported using an existing Virtual Circuit ID

        ```sh
         $ pulumi import equinix:index/metalVirtualCircuit:MetalVirtualCircuit equinix_metal_virtual_circuit {existing_id}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_id: UUID of Connection where the VC is scoped to.
        :param pulumi.Input[str] customer_ip: The Customer IP address which the CSR switch will peer with. Will default to the other usable IP in the subnet.
        :param pulumi.Input[str] description: Description for the Virtual Circuit resource.
        :param pulumi.Input[str] md5: The password that can be set for the VRF BGP peer
        :param pulumi.Input[str] metal_ip: The Metal IP address for the SVI (Switch Virtual Interface) of the VirtualCircuit. Will default to the first usable IP in the subnet.
        :param pulumi.Input[str] name: Name of the Virtual Circuit resource.
        :param pulumi.Input[int] nni_vlan: Equinix Metal network-to-network VLAN ID.
        :param pulumi.Input[int] peer_asn: The BGP ASN of the peer. The same ASN may be the used across several VCs, but it cannot be the same as the local_asn of the VRF.
        :param pulumi.Input[str] port_id: UUID of the Connection Port where the VC is scoped to.
        :param pulumi.Input[str] project_id: UUID of the Project where the VC is scoped to.
        :param pulumi.Input[str] speed: Speed of the Virtual Circuit resource.
        :param pulumi.Input[str] subnet: A subnet from one of the IP
               blocks associated with the VRF that we will help create an IP reservation for. Can only be either a /30 or /31.
               * For a /31 block, it will only have two IP addresses, which will be used for
               the metal_ip and customer_ip.
               * For a /30 block, it will have four IP addresses, but the first and last IP addresses are not usable. We will default to the first usable IP address for the metal_ip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for the Virtual Circuit resource.
        :param pulumi.Input[str] vlan_id: UUID of the VLAN to associate.
        :param pulumi.Input[str] vrf_id: UUID of the VRF to associate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetalVirtualCircuitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to associate VLAN with a Dedicated Port from
        [Equinix Fabric - software-defined interconnections](https://metal.equinix.com/developers/docs/networking/fabric/#associating-a-vlan-with-a-dedicated-port).

        > VRF features are not generally available. The interfaces related to VRF resources may change ahead of general availability.

        ## Example Usage

        Pick an existing Project and Connection, create a VLAN and use `MetalVirtualCircuit`
        to associate it with a Primary Port of the Connection.

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        project_id = "52000fb2-ee46-4673-93a8-de2c2bdba33c"
        conn_id = "73f12f29-3e19-43a0-8e90-ae81580db1e0"
        test_get_metal_connection = equinix.get_metal_connection(connection_id=conn_id)
        test_metal_vlan = equinix.MetalVlan("testMetalVlan",
            project_id=project_id,
            metro=test_get_metal_connection.metro)
        test_metal_virtual_circuit = equinix.MetalVirtualCircuit("testMetalVirtualCircuit",
            connection_id=conn_id,
            project_id=project_id,
            port_id=test_get_metal_connection.ports[0].id,
            vlan_id=test_metal_vlan.id,
            nni_vlan=1056)
        ```

        ## Import

        This resource can be imported using an existing Virtual Circuit ID

        ```sh
         $ pulumi import equinix:index/metalVirtualCircuit:MetalVirtualCircuit equinix_metal_virtual_circuit {existing_id}
        ```

        :param str resource_name: The name of the resource.
        :param MetalVirtualCircuitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetalVirtualCircuitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 customer_ip: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 md5: Optional[pulumi.Input[str]] = None,
                 metal_ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nni_vlan: Optional[pulumi.Input[int]] = None,
                 peer_asn: Optional[pulumi.Input[int]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vlan_id: Optional[pulumi.Input[str]] = None,
                 vrf_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetalVirtualCircuitArgs.__new__(MetalVirtualCircuitArgs)

            if connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'connection_id'")
            __props__.__dict__["connection_id"] = connection_id
            __props__.__dict__["customer_ip"] = customer_ip
            __props__.__dict__["description"] = description
            __props__.__dict__["md5"] = md5
            __props__.__dict__["metal_ip"] = metal_ip
            __props__.__dict__["name"] = name
            __props__.__dict__["nni_vlan"] = nni_vlan
            __props__.__dict__["peer_asn"] = peer_asn
            if port_id is None and not opts.urn:
                raise TypeError("Missing required property 'port_id'")
            __props__.__dict__["port_id"] = port_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["speed"] = speed
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vlan_id"] = vlan_id
            __props__.__dict__["vrf_id"] = vrf_id
            __props__.__dict__["nni_vnid"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vnid"] = None
        super(MetalVirtualCircuit, __self__).__init__(
            'equinix:index/metalVirtualCircuit:MetalVirtualCircuit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_id: Optional[pulumi.Input[str]] = None,
            customer_ip: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            md5: Optional[pulumi.Input[str]] = None,
            metal_ip: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nni_vlan: Optional[pulumi.Input[int]] = None,
            nni_vnid: Optional[pulumi.Input[int]] = None,
            peer_asn: Optional[pulumi.Input[int]] = None,
            port_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            speed: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vlan_id: Optional[pulumi.Input[str]] = None,
            vnid: Optional[pulumi.Input[int]] = None,
            vrf_id: Optional[pulumi.Input[str]] = None) -> 'MetalVirtualCircuit':
        """
        Get an existing MetalVirtualCircuit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_id: UUID of Connection where the VC is scoped to.
        :param pulumi.Input[str] customer_ip: The Customer IP address which the CSR switch will peer with. Will default to the other usable IP in the subnet.
        :param pulumi.Input[str] description: Description for the Virtual Circuit resource.
        :param pulumi.Input[str] md5: The password that can be set for the VRF BGP peer
        :param pulumi.Input[str] metal_ip: The Metal IP address for the SVI (Switch Virtual Interface) of the VirtualCircuit. Will default to the first usable IP in the subnet.
        :param pulumi.Input[str] name: Name of the Virtual Circuit resource.
        :param pulumi.Input[int] nni_vlan: Equinix Metal network-to-network VLAN ID.
        :param pulumi.Input[int] nni_vnid: NNI VLAN parameters, see the [documentation for Equinix Fabric](https://metal.equinix.com/developers/docs/networking/fabric/).
        :param pulumi.Input[int] peer_asn: The BGP ASN of the peer. The same ASN may be the used across several VCs, but it cannot be the same as the local_asn of the VRF.
        :param pulumi.Input[str] port_id: UUID of the Connection Port where the VC is scoped to.
        :param pulumi.Input[str] project_id: UUID of the Project where the VC is scoped to.
        :param pulumi.Input[str] speed: Speed of the Virtual Circuit resource.
        :param pulumi.Input[str] status: Status of the virtal circuit.
        :param pulumi.Input[str] subnet: A subnet from one of the IP
               blocks associated with the VRF that we will help create an IP reservation for. Can only be either a /30 or /31.
               * For a /31 block, it will only have two IP addresses, which will be used for
               the metal_ip and customer_ip.
               * For a /30 block, it will have four IP addresses, but the first and last IP addresses are not usable. We will default to the first usable IP address for the metal_ip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for the Virtual Circuit resource.
        :param pulumi.Input[str] vlan_id: UUID of the VLAN to associate.
        :param pulumi.Input[int] vnid: VNID VLAN parameter, see the [documentation for Equinix Fabric](https://metal.equinix.com/developers/docs/networking/fabric/).
        :param pulumi.Input[str] vrf_id: UUID of the VRF to associate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetalVirtualCircuitState.__new__(_MetalVirtualCircuitState)

        __props__.__dict__["connection_id"] = connection_id
        __props__.__dict__["customer_ip"] = customer_ip
        __props__.__dict__["description"] = description
        __props__.__dict__["md5"] = md5
        __props__.__dict__["metal_ip"] = metal_ip
        __props__.__dict__["name"] = name
        __props__.__dict__["nni_vlan"] = nni_vlan
        __props__.__dict__["nni_vnid"] = nni_vnid
        __props__.__dict__["peer_asn"] = peer_asn
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["speed"] = speed
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vlan_id"] = vlan_id
        __props__.__dict__["vnid"] = vnid
        __props__.__dict__["vrf_id"] = vrf_id
        return MetalVirtualCircuit(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Output[str]:
        """
        UUID of Connection where the VC is scoped to.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="customerIp")
    def customer_ip(self) -> pulumi.Output[Optional[str]]:
        """
        The Customer IP address which the CSR switch will peer with. Will default to the other usable IP in the subnet.
        """
        return pulumi.get(self, "customer_ip")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description for the Virtual Circuit resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def md5(self) -> pulumi.Output[Optional[str]]:
        """
        The password that can be set for the VRF BGP peer
        """
        return pulumi.get(self, "md5")

    @property
    @pulumi.getter(name="metalIp")
    def metal_ip(self) -> pulumi.Output[Optional[str]]:
        """
        The Metal IP address for the SVI (Switch Virtual Interface) of the VirtualCircuit. Will default to the first usable IP in the subnet.
        """
        return pulumi.get(self, "metal_ip")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Virtual Circuit resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nniVlan")
    def nni_vlan(self) -> pulumi.Output[Optional[int]]:
        """
        Equinix Metal network-to-network VLAN ID.
        """
        return pulumi.get(self, "nni_vlan")

    @property
    @pulumi.getter(name="nniVnid")
    def nni_vnid(self) -> pulumi.Output[int]:
        """
        NNI VLAN parameters, see the [documentation for Equinix Fabric](https://metal.equinix.com/developers/docs/networking/fabric/).
        """
        return pulumi.get(self, "nni_vnid")

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> pulumi.Output[Optional[int]]:
        """
        The BGP ASN of the peer. The same ASN may be the used across several VCs, but it cannot be the same as the local_asn of the VRF.
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[str]:
        """
        UUID of the Connection Port where the VC is scoped to.
        """
        return pulumi.get(self, "port_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        UUID of the Project where the VC is scoped to.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def speed(self) -> pulumi.Output[str]:
        """
        Speed of the Virtual Circuit resource.
        """
        return pulumi.get(self, "speed")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the virtal circuit.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[Optional[str]]:
        """
        A subnet from one of the IP
        blocks associated with the VRF that we will help create an IP reservation for. Can only be either a /30 or /31.
        * For a /31 block, it will only have two IP addresses, which will be used for
        the metal_ip and customer_ip.
        * For a /30 block, it will have four IP addresses, but the first and last IP addresses are not usable. We will default to the first usable IP address for the metal_ip.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags for the Virtual Circuit resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[Optional[str]]:
        """
        UUID of the VLAN to associate.
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter
    def vnid(self) -> pulumi.Output[int]:
        """
        VNID VLAN parameter, see the [documentation for Equinix Fabric](https://metal.equinix.com/developers/docs/networking/fabric/).
        """
        return pulumi.get(self, "vnid")

    @property
    @pulumi.getter(name="vrfId")
    def vrf_id(self) -> pulumi.Output[Optional[str]]:
        """
        UUID of the VRF to associate.
        """
        return pulumi.get(self, "vrf_id")

