# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['MetalVlanArgs', 'MetalVlan']

@pulumi.input_type
class MetalVlanArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 facility: Optional[pulumi.Input[str]] = None,
                 metro: Optional[pulumi.Input[str]] = None,
                 vxlan: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a MetalVlan resource.
        :param pulumi.Input[str] project_id: ID of parent project.
        :param pulumi.Input[str] description: Description string.
        :param pulumi.Input[str] facility: Facility where to create the VLAN.
        :param pulumi.Input[int] vxlan: VLAN ID, must be unique in metro.
        """
        pulumi.set(__self__, "project_id", project_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if facility is not None:
            pulumi.set(__self__, "facility", facility)
        if metro is not None:
            pulumi.set(__self__, "metro", metro)
        if vxlan is not None:
            pulumi.set(__self__, "vxlan", vxlan)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        ID of parent project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description string.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def facility(self) -> Optional[pulumi.Input[str]]:
        """
        Facility where to create the VLAN.
        """
        return pulumi.get(self, "facility")

    @facility.setter
    def facility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "facility", value)

    @property
    @pulumi.getter
    def metro(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "metro")

    @metro.setter
    def metro(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metro", value)

    @property
    @pulumi.getter
    def vxlan(self) -> Optional[pulumi.Input[int]]:
        """
        VLAN ID, must be unique in metro.
        """
        return pulumi.get(self, "vxlan")

    @vxlan.setter
    def vxlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vxlan", value)


@pulumi.input_type
class _MetalVlanState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 facility: Optional[pulumi.Input[str]] = None,
                 metro: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 vxlan: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering MetalVlan resources.
        :param pulumi.Input[str] description: Description string.
        :param pulumi.Input[str] facility: Facility where to create the VLAN.
        :param pulumi.Input[str] project_id: ID of parent project.
        :param pulumi.Input[int] vxlan: VLAN ID, must be unique in metro.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if facility is not None:
            pulumi.set(__self__, "facility", facility)
        if metro is not None:
            pulumi.set(__self__, "metro", metro)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if vxlan is not None:
            pulumi.set(__self__, "vxlan", vxlan)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description string.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def facility(self) -> Optional[pulumi.Input[str]]:
        """
        Facility where to create the VLAN.
        """
        return pulumi.get(self, "facility")

    @facility.setter
    def facility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "facility", value)

    @property
    @pulumi.getter
    def metro(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "metro")

    @metro.setter
    def metro(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metro", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of parent project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def vxlan(self) -> Optional[pulumi.Input[int]]:
        """
        VLAN ID, must be unique in metro.
        """
        return pulumi.get(self, "vxlan")

    @vxlan.setter
    def vxlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vxlan", value)


class MetalVlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 facility: Optional[pulumi.Input[str]] = None,
                 metro: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 vxlan: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a resource to allow users to manage Virtual Networks in their projects.

        To learn more about Layer 2 networking in Equinix Metal, refer to

        * <https://metal.equinix.com/developers/docs/networking/layer2/>
        * <https://metal.equinix.com/developers/docs/networking/layer2-configs/>

        ## Example Usage

        ```python
        import pulumi
        import cuemby_equinix as equinix

        # Create a new VLAN in facility "sv15"
        vlan1_metal_vlan = equinix.MetalVlan("vlan1MetalVlan",
            description="VLAN in New Jersey",
            facility="sv15",
            project_id=local["project_id"])
        # Create a new VLAN in metro "esv"
        vlan1_index_metal_vlan_metal_vlan = equinix.MetalVlan("vlan1Index/metalVlanMetalVlan",
            description="VLAN in New Jersey",
            metro="sv",
            project_id=local["project_id"],
            vxlan=1040)
        ```

        ## Import

        This resource can be imported using an existing VLAN ID (UUID)

        ```sh
         $ pulumi import equinix:index/metalVlan:MetalVlan equinix_metal_vlan {existing_vlan_id}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description string.
        :param pulumi.Input[str] facility: Facility where to create the VLAN.
        :param pulumi.Input[str] project_id: ID of parent project.
        :param pulumi.Input[int] vxlan: VLAN ID, must be unique in metro.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetalVlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to allow users to manage Virtual Networks in their projects.

        To learn more about Layer 2 networking in Equinix Metal, refer to

        * <https://metal.equinix.com/developers/docs/networking/layer2/>
        * <https://metal.equinix.com/developers/docs/networking/layer2-configs/>

        ## Example Usage

        ```python
        import pulumi
        import cuemby_equinix as equinix

        # Create a new VLAN in facility "sv15"
        vlan1_metal_vlan = equinix.MetalVlan("vlan1MetalVlan",
            description="VLAN in New Jersey",
            facility="sv15",
            project_id=local["project_id"])
        # Create a new VLAN in metro "esv"
        vlan1_index_metal_vlan_metal_vlan = equinix.MetalVlan("vlan1Index/metalVlanMetalVlan",
            description="VLAN in New Jersey",
            metro="sv",
            project_id=local["project_id"],
            vxlan=1040)
        ```

        ## Import

        This resource can be imported using an existing VLAN ID (UUID)

        ```sh
         $ pulumi import equinix:index/metalVlan:MetalVlan equinix_metal_vlan {existing_vlan_id}
        ```

        :param str resource_name: The name of the resource.
        :param MetalVlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetalVlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 facility: Optional[pulumi.Input[str]] = None,
                 metro: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 vxlan: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetalVlanArgs.__new__(MetalVlanArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["facility"] = facility
            __props__.__dict__["metro"] = metro
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["vxlan"] = vxlan
        super(MetalVlan, __self__).__init__(
            'equinix:index/metalVlan:MetalVlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            facility: Optional[pulumi.Input[str]] = None,
            metro: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            vxlan: Optional[pulumi.Input[int]] = None) -> 'MetalVlan':
        """
        Get an existing MetalVlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description string.
        :param pulumi.Input[str] facility: Facility where to create the VLAN.
        :param pulumi.Input[str] project_id: ID of parent project.
        :param pulumi.Input[int] vxlan: VLAN ID, must be unique in metro.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetalVlanState.__new__(_MetalVlanState)

        __props__.__dict__["description"] = description
        __props__.__dict__["facility"] = facility
        __props__.__dict__["metro"] = metro
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["vxlan"] = vxlan
        return MetalVlan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description string.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def facility(self) -> pulumi.Output[Optional[str]]:
        """
        Facility where to create the VLAN.
        """
        return pulumi.get(self, "facility")

    @property
    @pulumi.getter
    def metro(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "metro")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        ID of parent project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def vxlan(self) -> pulumi.Output[int]:
        """
        VLAN ID, must be unique in metro.
        """
        return pulumi.get(self, "vxlan")

