# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkDeviceArgs', 'NetworkDevice']

@pulumi.input_type
class NetworkDeviceArgs:
    def __init__(__self__, *,
                 account_number: pulumi.Input[str],
                 core_count: pulumi.Input[int],
                 metro_code: pulumi.Input[str],
                 notifications: pulumi.Input[Sequence[pulumi.Input[str]]],
                 package_code: pulumi.Input[str],
                 term_length: pulumi.Input[int],
                 type_code: pulumi.Input[str],
                 version: pulumi.Input[str],
                 acl_template_id: Optional[pulumi.Input[str]] = None,
                 additional_bandwidth: Optional[pulumi.Input[int]] = None,
                 byol: Optional[pulumi.Input[bool]] = None,
                 cluster_details: Optional[pulumi.Input['NetworkDeviceClusterDetailsArgs']] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 interface_count: Optional[pulumi.Input[int]] = None,
                 license_file: Optional[pulumi.Input[str]] = None,
                 license_token: Optional[pulumi.Input[str]] = None,
                 mgmt_acl_template_uuid: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 order_reference: Optional[pulumi.Input[str]] = None,
                 purchase_order_number: Optional[pulumi.Input[str]] = None,
                 secondary_device: Optional[pulumi.Input['NetworkDeviceSecondaryDeviceArgs']] = None,
                 self_managed: Optional[pulumi.Input[bool]] = None,
                 ssh_key: Optional[pulumi.Input['NetworkDeviceSshKeyArgs']] = None,
                 throughput: Optional[pulumi.Input[int]] = None,
                 throughput_unit: Optional[pulumi.Input[str]] = None,
                 vendor_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 wan_interface_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NetworkDevice resource.
        :param pulumi.Input[str] account_number: Billing account number for a device.
        :param pulumi.Input[int] core_count: Number of CPU cores used by device.
        :param pulumi.Input[str] metro_code: Device location metro code.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: List of email addresses that will receive device status
               notifications.
        :param pulumi.Input[str] package_code: Device software package code.
        :param pulumi.Input[int] term_length: Device term length.
        :param pulumi.Input[str] type_code: Device type code.
        :param pulumi.Input[str] version: Device software software version.
        :param pulumi.Input[str] acl_template_id: Identifier of an ACL template that will be applied on the device.
        :param pulumi.Input[int] additional_bandwidth: Additional Internet bandwidth, in Mbps, that will be
               allocated to the device (in addition to default 15Mbps).
        :param pulumi.Input[bool] byol: Boolean value that determines device licensing mode, i.e.,
               `bring your own license` or `subscription` (default).
        :param pulumi.Input['NetworkDeviceClusterDetailsArgs'] cluster_details: An object that has the cluster details. See
               Cluster Details below for more details.
        :param pulumi.Input[str] hostname: Device hostname prefix.
        :param pulumi.Input[int] interface_count: Number of network interfaces on a device. If not specified,
               default number for a given device type will be used.
        :param pulumi.Input[str] license_file: Path to the license file that will be uploaded and applied on a
               device. Applicable for some devices types in BYOL licensing mode.
        :param pulumi.Input[str] license_token: License token. This is necessary for Palo Alto clusters.
        :param pulumi.Input[str] mgmt_acl_template_uuid: Identifier of an MGMT interface ACL template that will be
               applied on the device.
        :param pulumi.Input[str] name: Device name.
        :param pulumi.Input[str] order_reference: Name/number used to identify device order on the invoice.
        :param pulumi.Input[str] purchase_order_number: Purchase order number associated with a device order.
        :param pulumi.Input['NetworkDeviceSecondaryDeviceArgs'] secondary_device: Definition of secondary device for redundant
               device configurations. See Secondary Device below for more details.
        :param pulumi.Input[bool] self_managed: Boolean value that determines device management mode, i.e.,
               `self-managed` or `Equinix managed` (default).
        :param pulumi.Input['NetworkDeviceSshKeyArgs'] ssh_key: Definition of SSH key that will be provisioned on a device
        :param pulumi.Input[int] throughput: Device license throughput.
        :param pulumi.Input[str] throughput_unit: License throughput unit. One of `Mbps` or `Gbps`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] vendor_configuration: An object that has fields relevant to the vendor of the
               cluster device. See Cluster Details - Nodes - Vendor Configuration
               below for more details.
        :param pulumi.Input[str] wan_interface_id: device interface id picked for WAN
        """
        pulumi.set(__self__, "account_number", account_number)
        pulumi.set(__self__, "core_count", core_count)
        pulumi.set(__self__, "metro_code", metro_code)
        pulumi.set(__self__, "notifications", notifications)
        pulumi.set(__self__, "package_code", package_code)
        pulumi.set(__self__, "term_length", term_length)
        pulumi.set(__self__, "type_code", type_code)
        pulumi.set(__self__, "version", version)
        if acl_template_id is not None:
            pulumi.set(__self__, "acl_template_id", acl_template_id)
        if additional_bandwidth is not None:
            pulumi.set(__self__, "additional_bandwidth", additional_bandwidth)
        if byol is not None:
            pulumi.set(__self__, "byol", byol)
        if cluster_details is not None:
            pulumi.set(__self__, "cluster_details", cluster_details)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if interface_count is not None:
            pulumi.set(__self__, "interface_count", interface_count)
        if license_file is not None:
            pulumi.set(__self__, "license_file", license_file)
        if license_token is not None:
            pulumi.set(__self__, "license_token", license_token)
        if mgmt_acl_template_uuid is not None:
            pulumi.set(__self__, "mgmt_acl_template_uuid", mgmt_acl_template_uuid)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order_reference is not None:
            pulumi.set(__self__, "order_reference", order_reference)
        if purchase_order_number is not None:
            pulumi.set(__self__, "purchase_order_number", purchase_order_number)
        if secondary_device is not None:
            pulumi.set(__self__, "secondary_device", secondary_device)
        if self_managed is not None:
            pulumi.set(__self__, "self_managed", self_managed)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if throughput_unit is not None:
            pulumi.set(__self__, "throughput_unit", throughput_unit)
        if vendor_configuration is not None:
            pulumi.set(__self__, "vendor_configuration", vendor_configuration)
        if wan_interface_id is not None:
            pulumi.set(__self__, "wan_interface_id", wan_interface_id)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> pulumi.Input[str]:
        """
        Billing account number for a device.
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_number", value)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> pulumi.Input[int]:
        """
        Number of CPU cores used by device.
        """
        return pulumi.get(self, "core_count")

    @core_count.setter
    def core_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "core_count", value)

    @property
    @pulumi.getter(name="metroCode")
    def metro_code(self) -> pulumi.Input[str]:
        """
        Device location metro code.
        """
        return pulumi.get(self, "metro_code")

    @metro_code.setter
    def metro_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "metro_code", value)

    @property
    @pulumi.getter
    def notifications(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of email addresses that will receive device status
        notifications.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter(name="packageCode")
    def package_code(self) -> pulumi.Input[str]:
        """
        Device software package code.
        """
        return pulumi.get(self, "package_code")

    @package_code.setter
    def package_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "package_code", value)

    @property
    @pulumi.getter(name="termLength")
    def term_length(self) -> pulumi.Input[int]:
        """
        Device term length.
        """
        return pulumi.get(self, "term_length")

    @term_length.setter
    def term_length(self, value: pulumi.Input[int]):
        pulumi.set(self, "term_length", value)

    @property
    @pulumi.getter(name="typeCode")
    def type_code(self) -> pulumi.Input[str]:
        """
        Device type code.
        """
        return pulumi.get(self, "type_code")

    @type_code.setter
    def type_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "type_code", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Device software software version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="aclTemplateId")
    def acl_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of an ACL template that will be applied on the device.
        """
        return pulumi.get(self, "acl_template_id")

    @acl_template_id.setter
    def acl_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_template_id", value)

    @property
    @pulumi.getter(name="additionalBandwidth")
    def additional_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Additional Internet bandwidth, in Mbps, that will be
        allocated to the device (in addition to default 15Mbps).
        """
        return pulumi.get(self, "additional_bandwidth")

    @additional_bandwidth.setter
    def additional_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_bandwidth", value)

    @property
    @pulumi.getter
    def byol(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that determines device licensing mode, i.e.,
        `bring your own license` or `subscription` (default).
        """
        return pulumi.get(self, "byol")

    @byol.setter
    def byol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "byol", value)

    @property
    @pulumi.getter(name="clusterDetails")
    def cluster_details(self) -> Optional[pulumi.Input['NetworkDeviceClusterDetailsArgs']]:
        """
        An object that has the cluster details. See
        Cluster Details below for more details.
        """
        return pulumi.get(self, "cluster_details")

    @cluster_details.setter
    def cluster_details(self, value: Optional[pulumi.Input['NetworkDeviceClusterDetailsArgs']]):
        pulumi.set(self, "cluster_details", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Device hostname prefix.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="interfaceCount")
    def interface_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of network interfaces on a device. If not specified,
        default number for a given device type will be used.
        """
        return pulumi.get(self, "interface_count")

    @interface_count.setter
    def interface_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interface_count", value)

    @property
    @pulumi.getter(name="licenseFile")
    def license_file(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the license file that will be uploaded and applied on a
        device. Applicable for some devices types in BYOL licensing mode.
        """
        return pulumi.get(self, "license_file")

    @license_file.setter
    def license_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_file", value)

    @property
    @pulumi.getter(name="licenseToken")
    def license_token(self) -> Optional[pulumi.Input[str]]:
        """
        License token. This is necessary for Palo Alto clusters.
        """
        return pulumi.get(self, "license_token")

    @license_token.setter
    def license_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_token", value)

    @property
    @pulumi.getter(name="mgmtAclTemplateUuid")
    def mgmt_acl_template_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of an MGMT interface ACL template that will be
        applied on the device.
        """
        return pulumi.get(self, "mgmt_acl_template_uuid")

    @mgmt_acl_template_uuid.setter
    def mgmt_acl_template_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mgmt_acl_template_uuid", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Device name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orderReference")
    def order_reference(self) -> Optional[pulumi.Input[str]]:
        """
        Name/number used to identify device order on the invoice.
        """
        return pulumi.get(self, "order_reference")

    @order_reference.setter
    def order_reference(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order_reference", value)

    @property
    @pulumi.getter(name="purchaseOrderNumber")
    def purchase_order_number(self) -> Optional[pulumi.Input[str]]:
        """
        Purchase order number associated with a device order.
        """
        return pulumi.get(self, "purchase_order_number")

    @purchase_order_number.setter
    def purchase_order_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purchase_order_number", value)

    @property
    @pulumi.getter(name="secondaryDevice")
    def secondary_device(self) -> Optional[pulumi.Input['NetworkDeviceSecondaryDeviceArgs']]:
        """
        Definition of secondary device for redundant
        device configurations. See Secondary Device below for more details.
        """
        return pulumi.get(self, "secondary_device")

    @secondary_device.setter
    def secondary_device(self, value: Optional[pulumi.Input['NetworkDeviceSecondaryDeviceArgs']]):
        pulumi.set(self, "secondary_device", value)

    @property
    @pulumi.getter(name="selfManaged")
    def self_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that determines device management mode, i.e.,
        `self-managed` or `Equinix managed` (default).
        """
        return pulumi.get(self, "self_managed")

    @self_managed.setter
    def self_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "self_managed", value)

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input['NetworkDeviceSshKeyArgs']]:
        """
        Definition of SSH key that will be provisioned on a device
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input['NetworkDeviceSshKeyArgs']]):
        pulumi.set(self, "ssh_key", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[int]]:
        """
        Device license throughput.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="throughputUnit")
    def throughput_unit(self) -> Optional[pulumi.Input[str]]:
        """
        License throughput unit. One of `Mbps` or `Gbps`.
        """
        return pulumi.get(self, "throughput_unit")

    @throughput_unit.setter
    def throughput_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "throughput_unit", value)

    @property
    @pulumi.getter(name="vendorConfiguration")
    def vendor_configuration(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An object that has fields relevant to the vendor of the
        cluster device. See Cluster Details - Nodes - Vendor Configuration
        below for more details.
        """
        return pulumi.get(self, "vendor_configuration")

    @vendor_configuration.setter
    def vendor_configuration(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "vendor_configuration", value)

    @property
    @pulumi.getter(name="wanInterfaceId")
    def wan_interface_id(self) -> Optional[pulumi.Input[str]]:
        """
        device interface id picked for WAN
        """
        return pulumi.get(self, "wan_interface_id")

    @wan_interface_id.setter
    def wan_interface_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_interface_id", value)


@pulumi.input_type
class _NetworkDeviceState:
    def __init__(__self__, *,
                 account_number: Optional[pulumi.Input[str]] = None,
                 acl_template_id: Optional[pulumi.Input[str]] = None,
                 additional_bandwidth: Optional[pulumi.Input[int]] = None,
                 asn: Optional[pulumi.Input[int]] = None,
                 byol: Optional[pulumi.Input[bool]] = None,
                 cluster_details: Optional[pulumi.Input['NetworkDeviceClusterDetailsArgs']] = None,
                 core_count: Optional[pulumi.Input[int]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ibx: Optional[pulumi.Input[str]] = None,
                 interface_count: Optional[pulumi.Input[int]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceInterfaceArgs']]]] = None,
                 license_file: Optional[pulumi.Input[str]] = None,
                 license_file_id: Optional[pulumi.Input[str]] = None,
                 license_status: Optional[pulumi.Input[str]] = None,
                 license_token: Optional[pulumi.Input[str]] = None,
                 metro_code: Optional[pulumi.Input[str]] = None,
                 mgmt_acl_template_uuid: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 order_reference: Optional[pulumi.Input[str]] = None,
                 package_code: Optional[pulumi.Input[str]] = None,
                 purchase_order_number: Optional[pulumi.Input[str]] = None,
                 redundancy_type: Optional[pulumi.Input[str]] = None,
                 redundant_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secondary_device: Optional[pulumi.Input['NetworkDeviceSecondaryDeviceArgs']] = None,
                 self_managed: Optional[pulumi.Input[bool]] = None,
                 ssh_ip_address: Optional[pulumi.Input[str]] = None,
                 ssh_ip_fqdn: Optional[pulumi.Input[str]] = None,
                 ssh_key: Optional[pulumi.Input['NetworkDeviceSshKeyArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 term_length: Optional[pulumi.Input[int]] = None,
                 throughput: Optional[pulumi.Input[int]] = None,
                 throughput_unit: Optional[pulumi.Input[str]] = None,
                 type_code: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 vendor_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wan_interface_id: Optional[pulumi.Input[str]] = None,
                 zone_code: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NetworkDevice resources.
        :param pulumi.Input[str] account_number: Billing account number for a device.
        :param pulumi.Input[str] acl_template_id: Identifier of an ACL template that will be applied on the device.
        :param pulumi.Input[int] additional_bandwidth: Additional Internet bandwidth, in Mbps, that will be
               allocated to the device (in addition to default 15Mbps).
        :param pulumi.Input[int] asn: (Autonomous System Number) Unique identifier for a network on the internet.
        :param pulumi.Input[bool] byol: Boolean value that determines device licensing mode, i.e.,
               `bring your own license` or `subscription` (default).
        :param pulumi.Input['NetworkDeviceClusterDetailsArgs'] cluster_details: An object that has the cluster details. See
               Cluster Details below for more details.
        :param pulumi.Input[int] core_count: Number of CPU cores used by device.
        :param pulumi.Input[str] hostname: Device hostname prefix.
        :param pulumi.Input[str] ibx: Device location Equinix Business Exchange name.
        :param pulumi.Input[int] interface_count: Number of network interfaces on a device. If not specified,
               default number for a given device type will be used.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkDeviceInterfaceArgs']]] interfaces: List of device interfaces. See Interface Attribute below
               for more details.
        :param pulumi.Input[str] license_file: Path to the license file that will be uploaded and applied on a
               device. Applicable for some devices types in BYOL licensing mode.
        :param pulumi.Input[str] license_file_id: License file id. This is necessary for Fortinet and Juniper clusters.
        :param pulumi.Input[str] license_status: Device license registration status. Possible values are `APPLYING_LICENSE`,
               `REGISTERED`, `APPLIED`, `WAITING_FOR_CLUSTER_SETUP`, `REGISTRATION_FAILED`.
        :param pulumi.Input[str] license_token: License token. This is necessary for Palo Alto clusters.
        :param pulumi.Input[str] metro_code: Device location metro code.
        :param pulumi.Input[str] mgmt_acl_template_uuid: Identifier of an MGMT interface ACL template that will be
               applied on the device.
        :param pulumi.Input[str] name: Device name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: List of email addresses that will receive device status
               notifications.
        :param pulumi.Input[str] order_reference: Name/number used to identify device order on the invoice.
        :param pulumi.Input[str] package_code: Device software package code.
        :param pulumi.Input[str] purchase_order_number: Purchase order number associated with a device order.
        :param pulumi.Input[str] redundancy_type: Device redundancy type applicable for HA devices, either
               primary or secondary.
        :param pulumi.Input[str] redundant_id: Unique identifier for a redundant device applicable for HA devices.
        :param pulumi.Input[str] region: Device location region.
        :param pulumi.Input['NetworkDeviceSecondaryDeviceArgs'] secondary_device: Definition of secondary device for redundant
               device configurations. See Secondary Device below for more details.
        :param pulumi.Input[bool] self_managed: Boolean value that determines device management mode, i.e.,
               `self-managed` or `Equinix managed` (default).
        :param pulumi.Input[str] ssh_ip_address: IP address of SSH enabled interface on the device.
        :param pulumi.Input[str] ssh_ip_fqdn: FQDN of SSH enabled interface on the device.
        :param pulumi.Input['NetworkDeviceSshKeyArgs'] ssh_key: Definition of SSH key that will be provisioned on a device
        :param pulumi.Input[str] status: interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        :param pulumi.Input[int] term_length: Device term length.
        :param pulumi.Input[int] throughput: Device license throughput.
        :param pulumi.Input[str] throughput_unit: License throughput unit. One of `Mbps` or `Gbps`.
        :param pulumi.Input[str] type_code: Device type code.
        :param pulumi.Input[str] uuid: Device unique identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] vendor_configuration: An object that has fields relevant to the vendor of the
               cluster device. See Cluster Details - Nodes - Vendor Configuration
               below for more details.
        :param pulumi.Input[str] version: Device software software version.
        :param pulumi.Input[str] wan_interface_id: device interface id picked for WAN
        :param pulumi.Input[str] zone_code: Device location zone code.
        """
        if account_number is not None:
            pulumi.set(__self__, "account_number", account_number)
        if acl_template_id is not None:
            pulumi.set(__self__, "acl_template_id", acl_template_id)
        if additional_bandwidth is not None:
            pulumi.set(__self__, "additional_bandwidth", additional_bandwidth)
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if byol is not None:
            pulumi.set(__self__, "byol", byol)
        if cluster_details is not None:
            pulumi.set(__self__, "cluster_details", cluster_details)
        if core_count is not None:
            pulumi.set(__self__, "core_count", core_count)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ibx is not None:
            pulumi.set(__self__, "ibx", ibx)
        if interface_count is not None:
            pulumi.set(__self__, "interface_count", interface_count)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if license_file is not None:
            pulumi.set(__self__, "license_file", license_file)
        if license_file_id is not None:
            pulumi.set(__self__, "license_file_id", license_file_id)
        if license_status is not None:
            pulumi.set(__self__, "license_status", license_status)
        if license_token is not None:
            pulumi.set(__self__, "license_token", license_token)
        if metro_code is not None:
            pulumi.set(__self__, "metro_code", metro_code)
        if mgmt_acl_template_uuid is not None:
            pulumi.set(__self__, "mgmt_acl_template_uuid", mgmt_acl_template_uuid)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if order_reference is not None:
            pulumi.set(__self__, "order_reference", order_reference)
        if package_code is not None:
            pulumi.set(__self__, "package_code", package_code)
        if purchase_order_number is not None:
            pulumi.set(__self__, "purchase_order_number", purchase_order_number)
        if redundancy_type is not None:
            pulumi.set(__self__, "redundancy_type", redundancy_type)
        if redundant_id is not None:
            pulumi.set(__self__, "redundant_id", redundant_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secondary_device is not None:
            pulumi.set(__self__, "secondary_device", secondary_device)
        if self_managed is not None:
            pulumi.set(__self__, "self_managed", self_managed)
        if ssh_ip_address is not None:
            pulumi.set(__self__, "ssh_ip_address", ssh_ip_address)
        if ssh_ip_fqdn is not None:
            pulumi.set(__self__, "ssh_ip_fqdn", ssh_ip_fqdn)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if term_length is not None:
            pulumi.set(__self__, "term_length", term_length)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if throughput_unit is not None:
            pulumi.set(__self__, "throughput_unit", throughput_unit)
        if type_code is not None:
            pulumi.set(__self__, "type_code", type_code)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if vendor_configuration is not None:
            pulumi.set(__self__, "vendor_configuration", vendor_configuration)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wan_interface_id is not None:
            pulumi.set(__self__, "wan_interface_id", wan_interface_id)
        if zone_code is not None:
            pulumi.set(__self__, "zone_code", zone_code)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> Optional[pulumi.Input[str]]:
        """
        Billing account number for a device.
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_number", value)

    @property
    @pulumi.getter(name="aclTemplateId")
    def acl_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of an ACL template that will be applied on the device.
        """
        return pulumi.get(self, "acl_template_id")

    @acl_template_id.setter
    def acl_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_template_id", value)

    @property
    @pulumi.getter(name="additionalBandwidth")
    def additional_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Additional Internet bandwidth, in Mbps, that will be
        allocated to the device (in addition to default 15Mbps).
        """
        return pulumi.get(self, "additional_bandwidth")

    @additional_bandwidth.setter
    def additional_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_bandwidth", value)

    @property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[int]]:
        """
        (Autonomous System Number) Unique identifier for a network on the internet.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "asn", value)

    @property
    @pulumi.getter
    def byol(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that determines device licensing mode, i.e.,
        `bring your own license` or `subscription` (default).
        """
        return pulumi.get(self, "byol")

    @byol.setter
    def byol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "byol", value)

    @property
    @pulumi.getter(name="clusterDetails")
    def cluster_details(self) -> Optional[pulumi.Input['NetworkDeviceClusterDetailsArgs']]:
        """
        An object that has the cluster details. See
        Cluster Details below for more details.
        """
        return pulumi.get(self, "cluster_details")

    @cluster_details.setter
    def cluster_details(self, value: Optional[pulumi.Input['NetworkDeviceClusterDetailsArgs']]):
        pulumi.set(self, "cluster_details", value)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of CPU cores used by device.
        """
        return pulumi.get(self, "core_count")

    @core_count.setter
    def core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "core_count", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Device hostname prefix.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ibx(self) -> Optional[pulumi.Input[str]]:
        """
        Device location Equinix Business Exchange name.
        """
        return pulumi.get(self, "ibx")

    @ibx.setter
    def ibx(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ibx", value)

    @property
    @pulumi.getter(name="interfaceCount")
    def interface_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of network interfaces on a device. If not specified,
        default number for a given device type will be used.
        """
        return pulumi.get(self, "interface_count")

    @interface_count.setter
    def interface_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interface_count", value)

    @property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceInterfaceArgs']]]]:
        """
        List of device interfaces. See Interface Attribute below
        for more details.
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @property
    @pulumi.getter(name="licenseFile")
    def license_file(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the license file that will be uploaded and applied on a
        device. Applicable for some devices types in BYOL licensing mode.
        """
        return pulumi.get(self, "license_file")

    @license_file.setter
    def license_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_file", value)

    @property
    @pulumi.getter(name="licenseFileId")
    def license_file_id(self) -> Optional[pulumi.Input[str]]:
        """
        License file id. This is necessary for Fortinet and Juniper clusters.
        """
        return pulumi.get(self, "license_file_id")

    @license_file_id.setter
    def license_file_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_file_id", value)

    @property
    @pulumi.getter(name="licenseStatus")
    def license_status(self) -> Optional[pulumi.Input[str]]:
        """
        Device license registration status. Possible values are `APPLYING_LICENSE`,
        `REGISTERED`, `APPLIED`, `WAITING_FOR_CLUSTER_SETUP`, `REGISTRATION_FAILED`.
        """
        return pulumi.get(self, "license_status")

    @license_status.setter
    def license_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_status", value)

    @property
    @pulumi.getter(name="licenseToken")
    def license_token(self) -> Optional[pulumi.Input[str]]:
        """
        License token. This is necessary for Palo Alto clusters.
        """
        return pulumi.get(self, "license_token")

    @license_token.setter
    def license_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_token", value)

    @property
    @pulumi.getter(name="metroCode")
    def metro_code(self) -> Optional[pulumi.Input[str]]:
        """
        Device location metro code.
        """
        return pulumi.get(self, "metro_code")

    @metro_code.setter
    def metro_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metro_code", value)

    @property
    @pulumi.getter(name="mgmtAclTemplateUuid")
    def mgmt_acl_template_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of an MGMT interface ACL template that will be
        applied on the device.
        """
        return pulumi.get(self, "mgmt_acl_template_uuid")

    @mgmt_acl_template_uuid.setter
    def mgmt_acl_template_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mgmt_acl_template_uuid", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Device name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of email addresses that will receive device status
        notifications.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter(name="orderReference")
    def order_reference(self) -> Optional[pulumi.Input[str]]:
        """
        Name/number used to identify device order on the invoice.
        """
        return pulumi.get(self, "order_reference")

    @order_reference.setter
    def order_reference(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order_reference", value)

    @property
    @pulumi.getter(name="packageCode")
    def package_code(self) -> Optional[pulumi.Input[str]]:
        """
        Device software package code.
        """
        return pulumi.get(self, "package_code")

    @package_code.setter
    def package_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_code", value)

    @property
    @pulumi.getter(name="purchaseOrderNumber")
    def purchase_order_number(self) -> Optional[pulumi.Input[str]]:
        """
        Purchase order number associated with a device order.
        """
        return pulumi.get(self, "purchase_order_number")

    @purchase_order_number.setter
    def purchase_order_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purchase_order_number", value)

    @property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> Optional[pulumi.Input[str]]:
        """
        Device redundancy type applicable for HA devices, either
        primary or secondary.
        """
        return pulumi.get(self, "redundancy_type")

    @redundancy_type.setter
    def redundancy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundancy_type", value)

    @property
    @pulumi.getter(name="redundantId")
    def redundant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for a redundant device applicable for HA devices.
        """
        return pulumi.get(self, "redundant_id")

    @redundant_id.setter
    def redundant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundant_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Device location region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secondaryDevice")
    def secondary_device(self) -> Optional[pulumi.Input['NetworkDeviceSecondaryDeviceArgs']]:
        """
        Definition of secondary device for redundant
        device configurations. See Secondary Device below for more details.
        """
        return pulumi.get(self, "secondary_device")

    @secondary_device.setter
    def secondary_device(self, value: Optional[pulumi.Input['NetworkDeviceSecondaryDeviceArgs']]):
        pulumi.set(self, "secondary_device", value)

    @property
    @pulumi.getter(name="selfManaged")
    def self_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that determines device management mode, i.e.,
        `self-managed` or `Equinix managed` (default).
        """
        return pulumi.get(self, "self_managed")

    @self_managed.setter
    def self_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "self_managed", value)

    @property
    @pulumi.getter(name="sshIpAddress")
    def ssh_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of SSH enabled interface on the device.
        """
        return pulumi.get(self, "ssh_ip_address")

    @ssh_ip_address.setter
    def ssh_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_ip_address", value)

    @property
    @pulumi.getter(name="sshIpFqdn")
    def ssh_ip_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        FQDN of SSH enabled interface on the device.
        """
        return pulumi.get(self, "ssh_ip_fqdn")

    @ssh_ip_fqdn.setter
    def ssh_ip_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_ip_fqdn", value)

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input['NetworkDeviceSshKeyArgs']]:
        """
        Definition of SSH key that will be provisioned on a device
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input['NetworkDeviceSshKeyArgs']]):
        pulumi.set(self, "ssh_key", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="termLength")
    def term_length(self) -> Optional[pulumi.Input[int]]:
        """
        Device term length.
        """
        return pulumi.get(self, "term_length")

    @term_length.setter
    def term_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "term_length", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[int]]:
        """
        Device license throughput.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="throughputUnit")
    def throughput_unit(self) -> Optional[pulumi.Input[str]]:
        """
        License throughput unit. One of `Mbps` or `Gbps`.
        """
        return pulumi.get(self, "throughput_unit")

    @throughput_unit.setter
    def throughput_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "throughput_unit", value)

    @property
    @pulumi.getter(name="typeCode")
    def type_code(self) -> Optional[pulumi.Input[str]]:
        """
        Device type code.
        """
        return pulumi.get(self, "type_code")

    @type_code.setter
    def type_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type_code", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Device unique identifier.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter(name="vendorConfiguration")
    def vendor_configuration(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An object that has fields relevant to the vendor of the
        cluster device. See Cluster Details - Nodes - Vendor Configuration
        below for more details.
        """
        return pulumi.get(self, "vendor_configuration")

    @vendor_configuration.setter
    def vendor_configuration(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "vendor_configuration", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Device software software version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="wanInterfaceId")
    def wan_interface_id(self) -> Optional[pulumi.Input[str]]:
        """
        device interface id picked for WAN
        """
        return pulumi.get(self, "wan_interface_id")

    @wan_interface_id.setter
    def wan_interface_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_interface_id", value)

    @property
    @pulumi.getter(name="zoneCode")
    def zone_code(self) -> Optional[pulumi.Input[str]]:
        """
        Device location zone code.
        """
        return pulumi.get(self, "zone_code")

    @zone_code.setter
    def zone_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_code", value)


class NetworkDevice(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_number: Optional[pulumi.Input[str]] = None,
                 acl_template_id: Optional[pulumi.Input[str]] = None,
                 additional_bandwidth: Optional[pulumi.Input[int]] = None,
                 byol: Optional[pulumi.Input[bool]] = None,
                 cluster_details: Optional[pulumi.Input[pulumi.InputType['NetworkDeviceClusterDetailsArgs']]] = None,
                 core_count: Optional[pulumi.Input[int]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 interface_count: Optional[pulumi.Input[int]] = None,
                 license_file: Optional[pulumi.Input[str]] = None,
                 license_token: Optional[pulumi.Input[str]] = None,
                 metro_code: Optional[pulumi.Input[str]] = None,
                 mgmt_acl_template_uuid: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 order_reference: Optional[pulumi.Input[str]] = None,
                 package_code: Optional[pulumi.Input[str]] = None,
                 purchase_order_number: Optional[pulumi.Input[str]] = None,
                 secondary_device: Optional[pulumi.Input[pulumi.InputType['NetworkDeviceSecondaryDeviceArgs']]] = None,
                 self_managed: Optional[pulumi.Input[bool]] = None,
                 ssh_key: Optional[pulumi.Input[pulumi.InputType['NetworkDeviceSshKeyArgs']]] = None,
                 term_length: Optional[pulumi.Input[int]] = None,
                 throughput: Optional[pulumi.Input[int]] = None,
                 throughput_unit: Optional[pulumi.Input[str]] = None,
                 type_code: Optional[pulumi.Input[str]] = None,
                 vendor_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wan_interface_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource `NetworkDevice` allows creation and management of Equinix Network Edge virtual
        network devices.

        Network Edge virtual network devices can be created in two modes:

        * **managed** - (default) Where Equinix manages connectivity and services in the device and
          customer gets limited access to the device.
        * **self-configured** - Where customer provisions and manages own services in the device with less
          restricted access. Some device types are offered only in this mode.

        In addition to management modes, there are two software license modes available:

        * **subscription** - Where Equinix provides software license, including end-to-end support, and
          bills for the service respectively.
        * **BYOL** - [bring your own license] Where customer brings his own, already procured device
          software license. There are no charges associated with such license. It is the only licensing mode
          for `self-configured` devices.

        ## Example Usage

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        dc = equinix.get_network_account(metro_code="DC")
        sv = equinix.get_network_account(metro_code="SV")
        csr1000v_ha = equinix.NetworkDevice("csr1000v-ha",
            throughput=500,
            throughput_unit="Mbps",
            metro_code=dc.metro_code,
            type_code="CSR1000V",
            package_code="SEC",
            notifications=[
                "john@equinix.com",
                "marry@equinix.com",
                "fred@equinix.com",
            ],
            hostname="csr1000v-p",
            term_length=6,
            account_number=dc.number,
            version="16.09.05",
            core_count=2,
            secondary_device=equinix.NetworkDeviceSecondaryDeviceArgs(
                name="tf-csr1000v-s",
                metro_code=sv.metro_code,
                hostname="csr1000v-s",
                notifications=[
                    "john@equinix.com",
                    "marry@equinix.com",
                ],
                account_number=sv.number,
            ))
        ```

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        sv = equinix.get_network_account(metro_code="SV")
        panw_cluster = equinix.NetworkDevice("panw-cluster",
            metro_code=sv.metro_code,
            type_code="PA-VM",
            self_managed=True,
            byol=True,
            package_code="VM100",
            notifications=[
                "john@equinix.com",
                "marry@equinix.com",
                "fred@equinix.com",
            ],
            term_length=6,
            account_number=sv.number,
            version="10.1.3",
            interface_count=10,
            core_count=2,
            ssh_key=equinix.NetworkDeviceSshKeyArgs(
                username="test",
                key_name="test-key",
            ),
            acl_template_id="0bff6e05-f0e7-44cd-804a-25b92b835f8b",
            cluster_details=equinix.NetworkDeviceClusterDetailsArgs(
                cluster_name="tf-panw-cluster",
                node0=equinix.NetworkDeviceClusterDetailsNode0Args(
                    vendor_configuration=equinix.NetworkDeviceClusterDetailsNode0VendorConfigurationArgs(
                        hostname="panw-node0",
                    ),
                    license_token="licenseToken",
                ),
                node1=equinix.NetworkDeviceClusterDetailsNode1Args(
                    vendor_configuration=equinix.NetworkDeviceClusterDetailsNode1VendorConfigurationArgs(
                        hostname="panw-node1",
                    ),
                    license_token="licenseToken",
                ),
            ))
        ```

        ## Import

        This resource can be imported using an existing ID

        ```sh
         $ pulumi import equinix:index/networkDevice:NetworkDevice example {existing_id}
        ```

         The `license_token` and `mgtm_acl_template_uuid` fields can not be imported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_number: Billing account number for a device.
        :param pulumi.Input[str] acl_template_id: Identifier of an ACL template that will be applied on the device.
        :param pulumi.Input[int] additional_bandwidth: Additional Internet bandwidth, in Mbps, that will be
               allocated to the device (in addition to default 15Mbps).
        :param pulumi.Input[bool] byol: Boolean value that determines device licensing mode, i.e.,
               `bring your own license` or `subscription` (default).
        :param pulumi.Input[pulumi.InputType['NetworkDeviceClusterDetailsArgs']] cluster_details: An object that has the cluster details. See
               Cluster Details below for more details.
        :param pulumi.Input[int] core_count: Number of CPU cores used by device.
        :param pulumi.Input[str] hostname: Device hostname prefix.
        :param pulumi.Input[int] interface_count: Number of network interfaces on a device. If not specified,
               default number for a given device type will be used.
        :param pulumi.Input[str] license_file: Path to the license file that will be uploaded and applied on a
               device. Applicable for some devices types in BYOL licensing mode.
        :param pulumi.Input[str] license_token: License token. This is necessary for Palo Alto clusters.
        :param pulumi.Input[str] metro_code: Device location metro code.
        :param pulumi.Input[str] mgmt_acl_template_uuid: Identifier of an MGMT interface ACL template that will be
               applied on the device.
        :param pulumi.Input[str] name: Device name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: List of email addresses that will receive device status
               notifications.
        :param pulumi.Input[str] order_reference: Name/number used to identify device order on the invoice.
        :param pulumi.Input[str] package_code: Device software package code.
        :param pulumi.Input[str] purchase_order_number: Purchase order number associated with a device order.
        :param pulumi.Input[pulumi.InputType['NetworkDeviceSecondaryDeviceArgs']] secondary_device: Definition of secondary device for redundant
               device configurations. See Secondary Device below for more details.
        :param pulumi.Input[bool] self_managed: Boolean value that determines device management mode, i.e.,
               `self-managed` or `Equinix managed` (default).
        :param pulumi.Input[pulumi.InputType['NetworkDeviceSshKeyArgs']] ssh_key: Definition of SSH key that will be provisioned on a device
        :param pulumi.Input[int] term_length: Device term length.
        :param pulumi.Input[int] throughput: Device license throughput.
        :param pulumi.Input[str] throughput_unit: License throughput unit. One of `Mbps` or `Gbps`.
        :param pulumi.Input[str] type_code: Device type code.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] vendor_configuration: An object that has fields relevant to the vendor of the
               cluster device. See Cluster Details - Nodes - Vendor Configuration
               below for more details.
        :param pulumi.Input[str] version: Device software software version.
        :param pulumi.Input[str] wan_interface_id: device interface id picked for WAN
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkDeviceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource `NetworkDevice` allows creation and management of Equinix Network Edge virtual
        network devices.

        Network Edge virtual network devices can be created in two modes:

        * **managed** - (default) Where Equinix manages connectivity and services in the device and
          customer gets limited access to the device.
        * **self-configured** - Where customer provisions and manages own services in the device with less
          restricted access. Some device types are offered only in this mode.

        In addition to management modes, there are two software license modes available:

        * **subscription** - Where Equinix provides software license, including end-to-end support, and
          bills for the service respectively.
        * **BYOL** - [bring your own license] Where customer brings his own, already procured device
          software license. There are no charges associated with such license. It is the only licensing mode
          for `self-configured` devices.

        ## Example Usage

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        dc = equinix.get_network_account(metro_code="DC")
        sv = equinix.get_network_account(metro_code="SV")
        csr1000v_ha = equinix.NetworkDevice("csr1000v-ha",
            throughput=500,
            throughput_unit="Mbps",
            metro_code=dc.metro_code,
            type_code="CSR1000V",
            package_code="SEC",
            notifications=[
                "john@equinix.com",
                "marry@equinix.com",
                "fred@equinix.com",
            ],
            hostname="csr1000v-p",
            term_length=6,
            account_number=dc.number,
            version="16.09.05",
            core_count=2,
            secondary_device=equinix.NetworkDeviceSecondaryDeviceArgs(
                name="tf-csr1000v-s",
                metro_code=sv.metro_code,
                hostname="csr1000v-s",
                notifications=[
                    "john@equinix.com",
                    "marry@equinix.com",
                ],
                account_number=sv.number,
            ))
        ```

        ```python
        import pulumi
        import cuemby_equinix as equinix
        import pulumi_equinix as equinix

        sv = equinix.get_network_account(metro_code="SV")
        panw_cluster = equinix.NetworkDevice("panw-cluster",
            metro_code=sv.metro_code,
            type_code="PA-VM",
            self_managed=True,
            byol=True,
            package_code="VM100",
            notifications=[
                "john@equinix.com",
                "marry@equinix.com",
                "fred@equinix.com",
            ],
            term_length=6,
            account_number=sv.number,
            version="10.1.3",
            interface_count=10,
            core_count=2,
            ssh_key=equinix.NetworkDeviceSshKeyArgs(
                username="test",
                key_name="test-key",
            ),
            acl_template_id="0bff6e05-f0e7-44cd-804a-25b92b835f8b",
            cluster_details=equinix.NetworkDeviceClusterDetailsArgs(
                cluster_name="tf-panw-cluster",
                node0=equinix.NetworkDeviceClusterDetailsNode0Args(
                    vendor_configuration=equinix.NetworkDeviceClusterDetailsNode0VendorConfigurationArgs(
                        hostname="panw-node0",
                    ),
                    license_token="licenseToken",
                ),
                node1=equinix.NetworkDeviceClusterDetailsNode1Args(
                    vendor_configuration=equinix.NetworkDeviceClusterDetailsNode1VendorConfigurationArgs(
                        hostname="panw-node1",
                    ),
                    license_token="licenseToken",
                ),
            ))
        ```

        ## Import

        This resource can be imported using an existing ID

        ```sh
         $ pulumi import equinix:index/networkDevice:NetworkDevice example {existing_id}
        ```

         The `license_token` and `mgtm_acl_template_uuid` fields can not be imported.

        :param str resource_name: The name of the resource.
        :param NetworkDeviceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkDeviceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_number: Optional[pulumi.Input[str]] = None,
                 acl_template_id: Optional[pulumi.Input[str]] = None,
                 additional_bandwidth: Optional[pulumi.Input[int]] = None,
                 byol: Optional[pulumi.Input[bool]] = None,
                 cluster_details: Optional[pulumi.Input[pulumi.InputType['NetworkDeviceClusterDetailsArgs']]] = None,
                 core_count: Optional[pulumi.Input[int]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 interface_count: Optional[pulumi.Input[int]] = None,
                 license_file: Optional[pulumi.Input[str]] = None,
                 license_token: Optional[pulumi.Input[str]] = None,
                 metro_code: Optional[pulumi.Input[str]] = None,
                 mgmt_acl_template_uuid: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 order_reference: Optional[pulumi.Input[str]] = None,
                 package_code: Optional[pulumi.Input[str]] = None,
                 purchase_order_number: Optional[pulumi.Input[str]] = None,
                 secondary_device: Optional[pulumi.Input[pulumi.InputType['NetworkDeviceSecondaryDeviceArgs']]] = None,
                 self_managed: Optional[pulumi.Input[bool]] = None,
                 ssh_key: Optional[pulumi.Input[pulumi.InputType['NetworkDeviceSshKeyArgs']]] = None,
                 term_length: Optional[pulumi.Input[int]] = None,
                 throughput: Optional[pulumi.Input[int]] = None,
                 throughput_unit: Optional[pulumi.Input[str]] = None,
                 type_code: Optional[pulumi.Input[str]] = None,
                 vendor_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wan_interface_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkDeviceArgs.__new__(NetworkDeviceArgs)

            if account_number is None and not opts.urn:
                raise TypeError("Missing required property 'account_number'")
            __props__.__dict__["account_number"] = account_number
            __props__.__dict__["acl_template_id"] = acl_template_id
            __props__.__dict__["additional_bandwidth"] = additional_bandwidth
            __props__.__dict__["byol"] = byol
            __props__.__dict__["cluster_details"] = cluster_details
            if core_count is None and not opts.urn:
                raise TypeError("Missing required property 'core_count'")
            __props__.__dict__["core_count"] = core_count
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["interface_count"] = interface_count
            __props__.__dict__["license_file"] = license_file
            __props__.__dict__["license_token"] = license_token
            if metro_code is None and not opts.urn:
                raise TypeError("Missing required property 'metro_code'")
            __props__.__dict__["metro_code"] = metro_code
            __props__.__dict__["mgmt_acl_template_uuid"] = mgmt_acl_template_uuid
            __props__.__dict__["name"] = name
            if notifications is None and not opts.urn:
                raise TypeError("Missing required property 'notifications'")
            __props__.__dict__["notifications"] = notifications
            __props__.__dict__["order_reference"] = order_reference
            if package_code is None and not opts.urn:
                raise TypeError("Missing required property 'package_code'")
            __props__.__dict__["package_code"] = package_code
            __props__.__dict__["purchase_order_number"] = purchase_order_number
            __props__.__dict__["secondary_device"] = secondary_device
            __props__.__dict__["self_managed"] = self_managed
            __props__.__dict__["ssh_key"] = ssh_key
            if term_length is None and not opts.urn:
                raise TypeError("Missing required property 'term_length'")
            __props__.__dict__["term_length"] = term_length
            __props__.__dict__["throughput"] = throughput
            __props__.__dict__["throughput_unit"] = throughput_unit
            if type_code is None and not opts.urn:
                raise TypeError("Missing required property 'type_code'")
            __props__.__dict__["type_code"] = type_code
            __props__.__dict__["vendor_configuration"] = vendor_configuration
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["wan_interface_id"] = wan_interface_id
            __props__.__dict__["asn"] = None
            __props__.__dict__["ibx"] = None
            __props__.__dict__["interfaces"] = None
            __props__.__dict__["license_file_id"] = None
            __props__.__dict__["license_status"] = None
            __props__.__dict__["redundancy_type"] = None
            __props__.__dict__["redundant_id"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["ssh_ip_address"] = None
            __props__.__dict__["ssh_ip_fqdn"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["uuid"] = None
            __props__.__dict__["zone_code"] = None
        super(NetworkDevice, __self__).__init__(
            'equinix:index/networkDevice:NetworkDevice',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_number: Optional[pulumi.Input[str]] = None,
            acl_template_id: Optional[pulumi.Input[str]] = None,
            additional_bandwidth: Optional[pulumi.Input[int]] = None,
            asn: Optional[pulumi.Input[int]] = None,
            byol: Optional[pulumi.Input[bool]] = None,
            cluster_details: Optional[pulumi.Input[pulumi.InputType['NetworkDeviceClusterDetailsArgs']]] = None,
            core_count: Optional[pulumi.Input[int]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            ibx: Optional[pulumi.Input[str]] = None,
            interface_count: Optional[pulumi.Input[int]] = None,
            interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkDeviceInterfaceArgs']]]]] = None,
            license_file: Optional[pulumi.Input[str]] = None,
            license_file_id: Optional[pulumi.Input[str]] = None,
            license_status: Optional[pulumi.Input[str]] = None,
            license_token: Optional[pulumi.Input[str]] = None,
            metro_code: Optional[pulumi.Input[str]] = None,
            mgmt_acl_template_uuid: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            order_reference: Optional[pulumi.Input[str]] = None,
            package_code: Optional[pulumi.Input[str]] = None,
            purchase_order_number: Optional[pulumi.Input[str]] = None,
            redundancy_type: Optional[pulumi.Input[str]] = None,
            redundant_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            secondary_device: Optional[pulumi.Input[pulumi.InputType['NetworkDeviceSecondaryDeviceArgs']]] = None,
            self_managed: Optional[pulumi.Input[bool]] = None,
            ssh_ip_address: Optional[pulumi.Input[str]] = None,
            ssh_ip_fqdn: Optional[pulumi.Input[str]] = None,
            ssh_key: Optional[pulumi.Input[pulumi.InputType['NetworkDeviceSshKeyArgs']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            term_length: Optional[pulumi.Input[int]] = None,
            throughput: Optional[pulumi.Input[int]] = None,
            throughput_unit: Optional[pulumi.Input[str]] = None,
            type_code: Optional[pulumi.Input[str]] = None,
            uuid: Optional[pulumi.Input[str]] = None,
            vendor_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            version: Optional[pulumi.Input[str]] = None,
            wan_interface_id: Optional[pulumi.Input[str]] = None,
            zone_code: Optional[pulumi.Input[str]] = None) -> 'NetworkDevice':
        """
        Get an existing NetworkDevice resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_number: Billing account number for a device.
        :param pulumi.Input[str] acl_template_id: Identifier of an ACL template that will be applied on the device.
        :param pulumi.Input[int] additional_bandwidth: Additional Internet bandwidth, in Mbps, that will be
               allocated to the device (in addition to default 15Mbps).
        :param pulumi.Input[int] asn: (Autonomous System Number) Unique identifier for a network on the internet.
        :param pulumi.Input[bool] byol: Boolean value that determines device licensing mode, i.e.,
               `bring your own license` or `subscription` (default).
        :param pulumi.Input[pulumi.InputType['NetworkDeviceClusterDetailsArgs']] cluster_details: An object that has the cluster details. See
               Cluster Details below for more details.
        :param pulumi.Input[int] core_count: Number of CPU cores used by device.
        :param pulumi.Input[str] hostname: Device hostname prefix.
        :param pulumi.Input[str] ibx: Device location Equinix Business Exchange name.
        :param pulumi.Input[int] interface_count: Number of network interfaces on a device. If not specified,
               default number for a given device type will be used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkDeviceInterfaceArgs']]]] interfaces: List of device interfaces. See Interface Attribute below
               for more details.
        :param pulumi.Input[str] license_file: Path to the license file that will be uploaded and applied on a
               device. Applicable for some devices types in BYOL licensing mode.
        :param pulumi.Input[str] license_file_id: License file id. This is necessary for Fortinet and Juniper clusters.
        :param pulumi.Input[str] license_status: Device license registration status. Possible values are `APPLYING_LICENSE`,
               `REGISTERED`, `APPLIED`, `WAITING_FOR_CLUSTER_SETUP`, `REGISTRATION_FAILED`.
        :param pulumi.Input[str] license_token: License token. This is necessary for Palo Alto clusters.
        :param pulumi.Input[str] metro_code: Device location metro code.
        :param pulumi.Input[str] mgmt_acl_template_uuid: Identifier of an MGMT interface ACL template that will be
               applied on the device.
        :param pulumi.Input[str] name: Device name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: List of email addresses that will receive device status
               notifications.
        :param pulumi.Input[str] order_reference: Name/number used to identify device order on the invoice.
        :param pulumi.Input[str] package_code: Device software package code.
        :param pulumi.Input[str] purchase_order_number: Purchase order number associated with a device order.
        :param pulumi.Input[str] redundancy_type: Device redundancy type applicable for HA devices, either
               primary or secondary.
        :param pulumi.Input[str] redundant_id: Unique identifier for a redundant device applicable for HA devices.
        :param pulumi.Input[str] region: Device location region.
        :param pulumi.Input[pulumi.InputType['NetworkDeviceSecondaryDeviceArgs']] secondary_device: Definition of secondary device for redundant
               device configurations. See Secondary Device below for more details.
        :param pulumi.Input[bool] self_managed: Boolean value that determines device management mode, i.e.,
               `self-managed` or `Equinix managed` (default).
        :param pulumi.Input[str] ssh_ip_address: IP address of SSH enabled interface on the device.
        :param pulumi.Input[str] ssh_ip_fqdn: FQDN of SSH enabled interface on the device.
        :param pulumi.Input[pulumi.InputType['NetworkDeviceSshKeyArgs']] ssh_key: Definition of SSH key that will be provisioned on a device
        :param pulumi.Input[str] status: interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        :param pulumi.Input[int] term_length: Device term length.
        :param pulumi.Input[int] throughput: Device license throughput.
        :param pulumi.Input[str] throughput_unit: License throughput unit. One of `Mbps` or `Gbps`.
        :param pulumi.Input[str] type_code: Device type code.
        :param pulumi.Input[str] uuid: Device unique identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] vendor_configuration: An object that has fields relevant to the vendor of the
               cluster device. See Cluster Details - Nodes - Vendor Configuration
               below for more details.
        :param pulumi.Input[str] version: Device software software version.
        :param pulumi.Input[str] wan_interface_id: device interface id picked for WAN
        :param pulumi.Input[str] zone_code: Device location zone code.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkDeviceState.__new__(_NetworkDeviceState)

        __props__.__dict__["account_number"] = account_number
        __props__.__dict__["acl_template_id"] = acl_template_id
        __props__.__dict__["additional_bandwidth"] = additional_bandwidth
        __props__.__dict__["asn"] = asn
        __props__.__dict__["byol"] = byol
        __props__.__dict__["cluster_details"] = cluster_details
        __props__.__dict__["core_count"] = core_count
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["ibx"] = ibx
        __props__.__dict__["interface_count"] = interface_count
        __props__.__dict__["interfaces"] = interfaces
        __props__.__dict__["license_file"] = license_file
        __props__.__dict__["license_file_id"] = license_file_id
        __props__.__dict__["license_status"] = license_status
        __props__.__dict__["license_token"] = license_token
        __props__.__dict__["metro_code"] = metro_code
        __props__.__dict__["mgmt_acl_template_uuid"] = mgmt_acl_template_uuid
        __props__.__dict__["name"] = name
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["order_reference"] = order_reference
        __props__.__dict__["package_code"] = package_code
        __props__.__dict__["purchase_order_number"] = purchase_order_number
        __props__.__dict__["redundancy_type"] = redundancy_type
        __props__.__dict__["redundant_id"] = redundant_id
        __props__.__dict__["region"] = region
        __props__.__dict__["secondary_device"] = secondary_device
        __props__.__dict__["self_managed"] = self_managed
        __props__.__dict__["ssh_ip_address"] = ssh_ip_address
        __props__.__dict__["ssh_ip_fqdn"] = ssh_ip_fqdn
        __props__.__dict__["ssh_key"] = ssh_key
        __props__.__dict__["status"] = status
        __props__.__dict__["term_length"] = term_length
        __props__.__dict__["throughput"] = throughput
        __props__.__dict__["throughput_unit"] = throughput_unit
        __props__.__dict__["type_code"] = type_code
        __props__.__dict__["uuid"] = uuid
        __props__.__dict__["vendor_configuration"] = vendor_configuration
        __props__.__dict__["version"] = version
        __props__.__dict__["wan_interface_id"] = wan_interface_id
        __props__.__dict__["zone_code"] = zone_code
        return NetworkDevice(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> pulumi.Output[str]:
        """
        Billing account number for a device.
        """
        return pulumi.get(self, "account_number")

    @property
    @pulumi.getter(name="aclTemplateId")
    def acl_template_id(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier of an ACL template that will be applied on the device.
        """
        return pulumi.get(self, "acl_template_id")

    @property
    @pulumi.getter(name="additionalBandwidth")
    def additional_bandwidth(self) -> pulumi.Output[int]:
        """
        Additional Internet bandwidth, in Mbps, that will be
        allocated to the device (in addition to default 15Mbps).
        """
        return pulumi.get(self, "additional_bandwidth")

    @property
    @pulumi.getter
    def asn(self) -> pulumi.Output[int]:
        """
        (Autonomous System Number) Unique identifier for a network on the internet.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter
    def byol(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value that determines device licensing mode, i.e.,
        `bring your own license` or `subscription` (default).
        """
        return pulumi.get(self, "byol")

    @property
    @pulumi.getter(name="clusterDetails")
    def cluster_details(self) -> pulumi.Output[Optional['outputs.NetworkDeviceClusterDetails']]:
        """
        An object that has the cluster details. See
        Cluster Details below for more details.
        """
        return pulumi.get(self, "cluster_details")

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> pulumi.Output[int]:
        """
        Number of CPU cores used by device.
        """
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        Device hostname prefix.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ibx(self) -> pulumi.Output[str]:
        """
        Device location Equinix Business Exchange name.
        """
        return pulumi.get(self, "ibx")

    @property
    @pulumi.getter(name="interfaceCount")
    def interface_count(self) -> pulumi.Output[int]:
        """
        Number of network interfaces on a device. If not specified,
        default number for a given device type will be used.
        """
        return pulumi.get(self, "interface_count")

    @property
    @pulumi.getter
    def interfaces(self) -> pulumi.Output[Sequence['outputs.NetworkDeviceInterface']]:
        """
        List of device interfaces. See Interface Attribute below
        for more details.
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter(name="licenseFile")
    def license_file(self) -> pulumi.Output[Optional[str]]:
        """
        Path to the license file that will be uploaded and applied on a
        device. Applicable for some devices types in BYOL licensing mode.
        """
        return pulumi.get(self, "license_file")

    @property
    @pulumi.getter(name="licenseFileId")
    def license_file_id(self) -> pulumi.Output[str]:
        """
        License file id. This is necessary for Fortinet and Juniper clusters.
        """
        return pulumi.get(self, "license_file_id")

    @property
    @pulumi.getter(name="licenseStatus")
    def license_status(self) -> pulumi.Output[str]:
        """
        Device license registration status. Possible values are `APPLYING_LICENSE`,
        `REGISTERED`, `APPLIED`, `WAITING_FOR_CLUSTER_SETUP`, `REGISTRATION_FAILED`.
        """
        return pulumi.get(self, "license_status")

    @property
    @pulumi.getter(name="licenseToken")
    def license_token(self) -> pulumi.Output[Optional[str]]:
        """
        License token. This is necessary for Palo Alto clusters.
        """
        return pulumi.get(self, "license_token")

    @property
    @pulumi.getter(name="metroCode")
    def metro_code(self) -> pulumi.Output[str]:
        """
        Device location metro code.
        """
        return pulumi.get(self, "metro_code")

    @property
    @pulumi.getter(name="mgmtAclTemplateUuid")
    def mgmt_acl_template_uuid(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier of an MGMT interface ACL template that will be
        applied on the device.
        """
        return pulumi.get(self, "mgmt_acl_template_uuid")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Device name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Sequence[str]]:
        """
        List of email addresses that will receive device status
        notifications.
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter(name="orderReference")
    def order_reference(self) -> pulumi.Output[Optional[str]]:
        """
        Name/number used to identify device order on the invoice.
        """
        return pulumi.get(self, "order_reference")

    @property
    @pulumi.getter(name="packageCode")
    def package_code(self) -> pulumi.Output[str]:
        """
        Device software package code.
        """
        return pulumi.get(self, "package_code")

    @property
    @pulumi.getter(name="purchaseOrderNumber")
    def purchase_order_number(self) -> pulumi.Output[Optional[str]]:
        """
        Purchase order number associated with a device order.
        """
        return pulumi.get(self, "purchase_order_number")

    @property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> pulumi.Output[str]:
        """
        Device redundancy type applicable for HA devices, either
        primary or secondary.
        """
        return pulumi.get(self, "redundancy_type")

    @property
    @pulumi.getter(name="redundantId")
    def redundant_id(self) -> pulumi.Output[str]:
        """
        Unique identifier for a redundant device applicable for HA devices.
        """
        return pulumi.get(self, "redundant_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Device location region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secondaryDevice")
    def secondary_device(self) -> pulumi.Output[Optional['outputs.NetworkDeviceSecondaryDevice']]:
        """
        Definition of secondary device for redundant
        device configurations. See Secondary Device below for more details.
        """
        return pulumi.get(self, "secondary_device")

    @property
    @pulumi.getter(name="selfManaged")
    def self_managed(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value that determines device management mode, i.e.,
        `self-managed` or `Equinix managed` (default).
        """
        return pulumi.get(self, "self_managed")

    @property
    @pulumi.getter(name="sshIpAddress")
    def ssh_ip_address(self) -> pulumi.Output[str]:
        """
        IP address of SSH enabled interface on the device.
        """
        return pulumi.get(self, "ssh_ip_address")

    @property
    @pulumi.getter(name="sshIpFqdn")
    def ssh_ip_fqdn(self) -> pulumi.Output[str]:
        """
        FQDN of SSH enabled interface on the device.
        """
        return pulumi.get(self, "ssh_ip_fqdn")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> pulumi.Output[Optional['outputs.NetworkDeviceSshKey']]:
        """
        Definition of SSH key that will be provisioned on a device
        """
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="termLength")
    def term_length(self) -> pulumi.Output[int]:
        """
        Device term length.
        """
        return pulumi.get(self, "term_length")

    @property
    @pulumi.getter
    def throughput(self) -> pulumi.Output[Optional[int]]:
        """
        Device license throughput.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="throughputUnit")
    def throughput_unit(self) -> pulumi.Output[Optional[str]]:
        """
        License throughput unit. One of `Mbps` or `Gbps`.
        """
        return pulumi.get(self, "throughput_unit")

    @property
    @pulumi.getter(name="typeCode")
    def type_code(self) -> pulumi.Output[str]:
        """
        Device type code.
        """
        return pulumi.get(self, "type_code")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[str]:
        """
        Device unique identifier.
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="vendorConfiguration")
    def vendor_configuration(self) -> pulumi.Output[Mapping[str, str]]:
        """
        An object that has fields relevant to the vendor of the
        cluster device. See Cluster Details - Nodes - Vendor Configuration
        below for more details.
        """
        return pulumi.get(self, "vendor_configuration")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Device software software version.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="wanInterfaceId")
    def wan_interface_id(self) -> pulumi.Output[Optional[str]]:
        """
        device interface id picked for WAN
        """
        return pulumi.get(self, "wan_interface_id")

    @property
    @pulumi.getter(name="zoneCode")
    def zone_code(self) -> pulumi.Output[str]:
        """
        Device location zone code.
        """
        return pulumi.get(self, "zone_code")

