# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkDeviceLinkArgs', 'NetworkDeviceLink']

@pulumi.input_type
class NetworkDeviceLinkArgs:
    def __init__(__self__, *,
                 devices: pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkDeviceArgs']]],
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkLinkArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NetworkDeviceLink resource.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkDeviceArgs']]] devices: definition of one or more devices belonging to the
               device link. See Device section below for more details.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkLinkArgs']]] links: definition of one or more, inter metro, connections belonging
               to the device link. See Link section below for more details.
        :param pulumi.Input[str] name: device link name.
        :param pulumi.Input[str] subnet: device link subnet in CIDR format. Not required for link
               between self configured devices.
        """
        pulumi.set(__self__, "devices", devices)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def devices(self) -> pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkDeviceArgs']]]:
        """
        definition of one or more devices belonging to the
        device link. See Device section below for more details.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkDeviceArgs']]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkLinkArgs']]]]:
        """
        definition of one or more, inter metro, connections belonging
        to the device link. See Link section below for more details.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkLinkArgs']]]]):
        pulumi.set(self, "links", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        device link name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        device link subnet in CIDR format. Not required for link
        between self configured devices.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class _NetworkDeviceLinkState:
    def __init__(__self__, *,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkDeviceArgs']]]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkLinkArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NetworkDeviceLink resources.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkDeviceArgs']]] devices: definition of one or more devices belonging to the
               device link. See Device section below for more details.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkLinkArgs']]] links: definition of one or more, inter metro, connections belonging
               to the device link. See Link section below for more details.
        :param pulumi.Input[str] name: device link name.
        :param pulumi.Input[str] status: device link provisioning status on a given device. One of `PROVISIONING`,
               `PROVISIONED`, `DEPROVISIONING`, `DEPROVISIONED`, `FAILED`.
        :param pulumi.Input[str] subnet: device link subnet in CIDR format. Not required for link
               between self configured devices.
        :param pulumi.Input[str] uuid: Device link unique identifier.
        """
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkDeviceArgs']]]]:
        """
        definition of one or more devices belonging to the
        device link. See Device section below for more details.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkDeviceArgs']]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkLinkArgs']]]]:
        """
        definition of one or more, inter metro, connections belonging
        to the device link. See Link section below for more details.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDeviceLinkLinkArgs']]]]):
        pulumi.set(self, "links", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        device link name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        device link provisioning status on a given device. One of `PROVISIONING`,
        `PROVISIONED`, `DEPROVISIONING`, `DEPROVISIONED`, `FAILED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        device link subnet in CIDR format. Not required for link
        between self configured devices.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Device link unique identifier.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)


class NetworkDeviceLink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkDeviceLinkDeviceArgs']]]]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkDeviceLinkLinkArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource `NetworkDeviceLink` allows creation and management of Equinix
        Network Edge virtual network device links.

        ## Example Usage

        ```python
        import pulumi
        import cuemby_equinix as equinix

        # Example of device link with HA device pair
        # where each device is in different metro
        test = equinix.NetworkDeviceLink("test",
            subnet="192.168.40.64/27",
            devices=[
                equinix.NetworkDeviceLinkDeviceArgs(
                    id=equinix_network_device["test"]["uuid"],
                    asn=equinix_network_device["test"]["asn"] if equinix_network_device["test"]["asn"] > 0 else 22111,
                    interface_id=6,
                ),
                equinix.NetworkDeviceLinkDeviceArgs(
                    id=equinix_network_device["test"]["secondary_device"][0]["uuid"],
                    asn=equinix_network_device["test"]["secondary_device"][0]["asn"] if equinix_network_device["test"]["secondary_device"][0]["asn"] > 0 else 22333,
                    interface_id=7,
                ),
            ],
            links=[equinix.NetworkDeviceLinkLinkArgs(
                account_number=equinix_network_device["test"]["account_number"],
                src_metro_code=equinix_network_device["test"]["metro_code"],
                dst_metro_code=equinix_network_device["test"]["secondary_device"][0]["metro_code"],
                throughput="50",
                throughput_unit="Mbps",
            )])
        ```

        ## Import

        This resource can be imported using an existing ID

        ```sh
         $ pulumi import equinix:index/networkDeviceLink:NetworkDeviceLink example {existing_id}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkDeviceLinkDeviceArgs']]]] devices: definition of one or more devices belonging to the
               device link. See Device section below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkDeviceLinkLinkArgs']]]] links: definition of one or more, inter metro, connections belonging
               to the device link. See Link section below for more details.
        :param pulumi.Input[str] name: device link name.
        :param pulumi.Input[str] subnet: device link subnet in CIDR format. Not required for link
               between self configured devices.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkDeviceLinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource `NetworkDeviceLink` allows creation and management of Equinix
        Network Edge virtual network device links.

        ## Example Usage

        ```python
        import pulumi
        import cuemby_equinix as equinix

        # Example of device link with HA device pair
        # where each device is in different metro
        test = equinix.NetworkDeviceLink("test",
            subnet="192.168.40.64/27",
            devices=[
                equinix.NetworkDeviceLinkDeviceArgs(
                    id=equinix_network_device["test"]["uuid"],
                    asn=equinix_network_device["test"]["asn"] if equinix_network_device["test"]["asn"] > 0 else 22111,
                    interface_id=6,
                ),
                equinix.NetworkDeviceLinkDeviceArgs(
                    id=equinix_network_device["test"]["secondary_device"][0]["uuid"],
                    asn=equinix_network_device["test"]["secondary_device"][0]["asn"] if equinix_network_device["test"]["secondary_device"][0]["asn"] > 0 else 22333,
                    interface_id=7,
                ),
            ],
            links=[equinix.NetworkDeviceLinkLinkArgs(
                account_number=equinix_network_device["test"]["account_number"],
                src_metro_code=equinix_network_device["test"]["metro_code"],
                dst_metro_code=equinix_network_device["test"]["secondary_device"][0]["metro_code"],
                throughput="50",
                throughput_unit="Mbps",
            )])
        ```

        ## Import

        This resource can be imported using an existing ID

        ```sh
         $ pulumi import equinix:index/networkDeviceLink:NetworkDeviceLink example {existing_id}
        ```

        :param str resource_name: The name of the resource.
        :param NetworkDeviceLinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkDeviceLinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkDeviceLinkDeviceArgs']]]]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkDeviceLinkLinkArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkDeviceLinkArgs.__new__(NetworkDeviceLinkArgs)

            if devices is None and not opts.urn:
                raise TypeError("Missing required property 'devices'")
            __props__.__dict__["devices"] = devices
            __props__.__dict__["links"] = links
            __props__.__dict__["name"] = name
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["status"] = None
            __props__.__dict__["uuid"] = None
        super(NetworkDeviceLink, __self__).__init__(
            'equinix:index/networkDeviceLink:NetworkDeviceLink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkDeviceLinkDeviceArgs']]]]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkDeviceLinkLinkArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet: Optional[pulumi.Input[str]] = None,
            uuid: Optional[pulumi.Input[str]] = None) -> 'NetworkDeviceLink':
        """
        Get an existing NetworkDeviceLink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkDeviceLinkDeviceArgs']]]] devices: definition of one or more devices belonging to the
               device link. See Device section below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkDeviceLinkLinkArgs']]]] links: definition of one or more, inter metro, connections belonging
               to the device link. See Link section below for more details.
        :param pulumi.Input[str] name: device link name.
        :param pulumi.Input[str] status: device link provisioning status on a given device. One of `PROVISIONING`,
               `PROVISIONED`, `DEPROVISIONING`, `DEPROVISIONED`, `FAILED`.
        :param pulumi.Input[str] subnet: device link subnet in CIDR format. Not required for link
               between self configured devices.
        :param pulumi.Input[str] uuid: Device link unique identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkDeviceLinkState.__new__(_NetworkDeviceLinkState)

        __props__.__dict__["devices"] = devices
        __props__.__dict__["links"] = links
        __props__.__dict__["name"] = name
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["uuid"] = uuid
        return NetworkDeviceLink(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def devices(self) -> pulumi.Output[Sequence['outputs.NetworkDeviceLinkDevice']]:
        """
        definition of one or more devices belonging to the
        device link. See Device section below for more details.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter
    def links(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkDeviceLinkLink']]]:
        """
        definition of one or more, inter metro, connections belonging
        to the device link. See Link section below for more details.
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        device link name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        device link provisioning status on a given device. One of `PROVISIONING`,
        `PROVISIONED`, `DEPROVISIONING`, `DEPROVISIONED`, `FAILED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[Optional[str]]:
        """
        device link subnet in CIDR format. Not required for link
        between self configured devices.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[str]:
        """
        Device link unique identifier.
        """
        return pulumi.get(self, "uuid")

