# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'ECXL2ConnectionAction',
    'ECXL2ConnectionActionRequiredData',
    'ECXL2ConnectionAdditionalInfo',
    'ECXL2ConnectionSecondaryConnection',
    'ECXL2ConnectionSecondaryConnectionAction',
    'ECXL2ConnectionSecondaryConnectionActionRequiredData',
    'ECXL2ServiceprofileFeatures',
    'ECXL2ServiceprofilePort',
    'ECXL2ServiceprofileSpeedBand',
    'GetECXL2SellerprofileAdditionalInfoResult',
    'GetECXL2SellerprofileMetroResult',
    'GetECXL2SellerprofileSpeedBandResult',
    'GetECXL2SellerprofilesProfileResult',
    'GetECXL2SellerprofilesProfileAdditionalInfoResult',
    'GetECXL2SellerprofilesProfileMetroResult',
    'GetECXL2SellerprofilesProfileSpeedBandResult',
    'GetMetalConnectionPortResult',
    'GetMetalConnectionServiceTokenResult',
    'GetMetalDeviceBGPNeighborsBgpNeighborResult',
    'GetMetalDeviceBGPNeighborsBgpNeighborRoutesInResult',
    'GetMetalDeviceBGPNeighborsBgpNeighborRoutesOutResult',
    'GetMetalDeviceNetworkResult',
    'GetMetalDevicePortResult',
    'GetMetalFacilityCapacityResult',
    'GetMetalMetroCapacityResult',
    'GetMetalOrganizationAddressResult',
    'GetMetalPlansFilterResult',
    'GetMetalPlansPlanResult',
    'GetMetalPlansSortResult',
    'GetMetalProjectBgpConfigResult',
    'GetNetworkDeviceClusterDetailResult',
    'GetNetworkDeviceClusterDetailNode0Result',
    'GetNetworkDeviceClusterDetailNode0VendorConfigurationResult',
    'GetNetworkDeviceClusterDetailNode1Result',
    'GetNetworkDeviceClusterDetailNode1VendorConfigurationResult',
    'GetNetworkDeviceInterfaceResult',
    'GetNetworkDeviceSecondaryDeviceResult',
    'GetNetworkDeviceSecondaryDeviceInterfaceResult',
    'GetNetworkDeviceSecondaryDeviceSshKeyResult',
    'GetNetworkDeviceSshKeyResult',
    'MetalConnectionPort',
    'MetalConnectionServiceToken',
    'MetalDeviceIpAddress',
    'MetalDeviceNetwork',
    'MetalDevicePort',
    'MetalDeviceReinstall',
    'MetalOrganizationAddress',
    'MetalProjectBgpConfig',
    'MetalSpotMarketRequestInstanceParameters',
    'NetworkACLTemplateDeviceDetail',
    'NetworkACLTemplateInboundRule',
    'NetworkDeviceClusterDetails',
    'NetworkDeviceClusterDetailsNode0',
    'NetworkDeviceClusterDetailsNode0VendorConfiguration',
    'NetworkDeviceClusterDetailsNode1',
    'NetworkDeviceClusterDetailsNode1VendorConfiguration',
    'NetworkDeviceInterface',
    'NetworkDeviceLinkDevice',
    'NetworkDeviceLinkLink',
    'NetworkDeviceSecondaryDevice',
    'NetworkDeviceSecondaryDeviceInterface',
    'NetworkDeviceSecondaryDeviceSshKey',
    'NetworkDeviceSshKey',
]

@pulumi.output_type
class ECXL2ConnectionAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationId":
            suggest = "operation_id"
        elif key == "requiredDatas":
            suggest = "required_datas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ECXL2ConnectionAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ECXL2ConnectionAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ECXL2ConnectionAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: Optional[str] = None,
                 operation_id: Optional[str] = None,
                 required_datas: Optional[Sequence['outputs.ECXL2ConnectionActionRequiredData']] = None,
                 type: Optional[str] = None):
        if message is not None:
            pulumi.set(__self__, "message", message)
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if required_datas is not None:
            pulumi.set(__self__, "required_datas", required_datas)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[str]:
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter(name="requiredDatas")
    def required_datas(self) -> Optional[Sequence['outputs.ECXL2ConnectionActionRequiredData']]:
        return pulumi.get(self, "required_datas")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class ECXL2ConnectionActionRequiredData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "validationPattern":
            suggest = "validation_pattern"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ECXL2ConnectionActionRequiredData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ECXL2ConnectionActionRequiredData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ECXL2ConnectionActionRequiredData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 editable: Optional[bool] = None,
                 key: Optional[str] = None,
                 label: Optional[str] = None,
                 validation_pattern: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str value: additional information value
        """
        if editable is not None:
            pulumi.set(__self__, "editable", editable)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if validation_pattern is not None:
            pulumi.set(__self__, "validation_pattern", validation_pattern)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def editable(self) -> Optional[bool]:
        return pulumi.get(self, "editable")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="validationPattern")
    def validation_pattern(self) -> Optional[str]:
        return pulumi.get(self, "validation_pattern")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        additional information value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ECXL2ConnectionAdditionalInfo(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: additional information key
        :param str value: additional information value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        additional information key
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        additional information value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ECXL2ConnectionSecondaryConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationKey":
            suggest = "authorization_key"
        elif key == "deviceInterfaceId":
            suggest = "device_interface_id"
        elif key == "deviceUuid":
            suggest = "device_uuid"
        elif key == "portUuid":
            suggest = "port_uuid"
        elif key == "profileUuid":
            suggest = "profile_uuid"
        elif key == "providerStatus":
            suggest = "provider_status"
        elif key == "redundancyGroup":
            suggest = "redundancy_group"
        elif key == "redundancyType":
            suggest = "redundancy_type"
        elif key == "redundantUuid":
            suggest = "redundant_uuid"
        elif key == "sellerMetroCode":
            suggest = "seller_metro_code"
        elif key == "sellerRegion":
            suggest = "seller_region"
        elif key == "serviceToken":
            suggest = "service_token"
        elif key == "speedUnit":
            suggest = "speed_unit"
        elif key == "vendorToken":
            suggest = "vendor_token"
        elif key == "vlanCtag":
            suggest = "vlan_ctag"
        elif key == "vlanStag":
            suggest = "vlan_stag"
        elif key == "zsidePortUuid":
            suggest = "zside_port_uuid"
        elif key == "zsideVlanCtag":
            suggest = "zside_vlan_ctag"
        elif key == "zsideVlanStag":
            suggest = "zside_vlan_stag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ECXL2ConnectionSecondaryConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ECXL2ConnectionSecondaryConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ECXL2ConnectionSecondaryConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 actions: Optional[Sequence['outputs.ECXL2ConnectionSecondaryConnectionAction']] = None,
                 authorization_key: Optional[str] = None,
                 device_interface_id: Optional[int] = None,
                 device_uuid: Optional[str] = None,
                 port_uuid: Optional[str] = None,
                 profile_uuid: Optional[str] = None,
                 provider_status: Optional[str] = None,
                 redundancy_group: Optional[str] = None,
                 redundancy_type: Optional[str] = None,
                 redundant_uuid: Optional[str] = None,
                 seller_metro_code: Optional[str] = None,
                 seller_region: Optional[str] = None,
                 service_token: Optional[str] = None,
                 speed: Optional[int] = None,
                 speed_unit: Optional[str] = None,
                 status: Optional[str] = None,
                 uuid: Optional[str] = None,
                 vendor_token: Optional[str] = None,
                 vlan_ctag: Optional[int] = None,
                 vlan_stag: Optional[int] = None,
                 zside_port_uuid: Optional[str] = None,
                 zside_vlan_ctag: Optional[int] = None,
                 zside_vlan_stag: Optional[int] = None):
        """
        :param str name: secondary connection name
        :param Sequence['ECXL2ConnectionSecondaryConnectionActionArgs'] actions: One or more pending actions to complete connection provisioning.
        :param str authorization_key: Unique identifier authorizing Equinix to provision a connection
               towards a cloud service provider. If not specified primary `authorization_key` will be used. However,
               some service providers may require different keys for each connection. More information on
               [Equinix Fabric how to guide](https://developer.equinix.com/docs/ecx-how-to-guide).
        :param int device_interface_id: Applicable with `device_uuid`, identifier of network interface
               on a given device. If not specified then first available interface will be selected.
        :param str device_uuid: Applicable with primary `device_uuid`. Identifier of the Network Edge
               virtual device from which the secondary connection would originate. If not specified primary
               `device_uuid` will be used.
        :param str port_uuid: Applicable with primary `port_uuid`. Identifier of the Equinix Fabric Port from
               which the secondary connection would originate. If not specified primary `port_uuid` will be used.
        :param str profile_uuid: Unique identifier of the service provider's profile.
        :param str provider_status: Connection provisioning status on service provider's side.
        :param str redundancy_group: Unique identifier of group containing a primary and secondary connection.
        :param str redundancy_type: Connection redundancy type, applicable for HA connections. Valid values are
               `PRIMARY`, `SECONDARY`.
        :param str redundant_uuid: Unique identifier of the redundant connection, applicable for HA connections.
        :param str seller_metro_code: The metro code that denotes the secondary connection’s
               destination (Z side). .
        :param str seller_region: The region in which the seller port resides. If not specified
               primary `seller_region` will be used.
        :param str service_token: Required with primary `service_token`. Unique Equinix Fabric key
               given by a provider that grants you authorization to enable connectivity from an Equinix Fabric Port or
               virtual device. Each connection (primary and secondary) requires a separate token.
               More details in [Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm).
        :param int speed: Speed/Bandwidth to be allocated to the secondary connection. If not
               specified primary `speed` will be used.
        :param str speed_unit: Unit of the speed/bandwidth to be allocated to the secondary
               connection. If not specified primary `speed_unit` will be used.
        :param str status: Connection provisioning status on Equinix Fabric side.
        :param str uuid: Unique identifier of the connection.
        :param str vendor_token: The Equinix Fabric Token the connection was created with. Applicable if the
               connection was created with a `service_token` (a-side) or `zside_service_token` (z-side).
               * `secondary_connection`:
               * `zside_port_uuid`
               * `zside_vlan_stag`
               * `zside_vlan_ctag`
               * `redundancy_type`
               * `redundancy_group`
               * `vendor_token`
        :param int vlan_ctag: Applicable with `port_uuid`. C-Tag/Inner-Tag of the secondary
               connection, a numeric character ranging from 2 - 4094.
        :param int vlan_stag: S-Tag/Outer-Tag of the secondary connection, a
               numeric character ranging from 2 - 4094.
        :param str zside_port_uuid: Unique identifier of the port on the remote/destination side
               (z-side). Allows you to connect between your own ports or virtual devices across your company's
               Equinix Fabric deployment, with no need for a private service profile.
        :param int zside_vlan_ctag: C-Tag/Inner-Tag of the connection on the remote/destination
               side (z-side) - a numeric character ranging from 2 - 4094.
               `secondary_connection` is defined it will internally use same `zside_vlan_ctag` for the secondary
               connection.
        :param int zside_vlan_stag: S-Tag/Outer-Tag of the connection on the remote/destination
               side (z-side) - a numeric character ranging from 2 - 4094.
        """
        pulumi.set(__self__, "name", name)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if device_interface_id is not None:
            pulumi.set(__self__, "device_interface_id", device_interface_id)
        if device_uuid is not None:
            pulumi.set(__self__, "device_uuid", device_uuid)
        if port_uuid is not None:
            pulumi.set(__self__, "port_uuid", port_uuid)
        if profile_uuid is not None:
            pulumi.set(__self__, "profile_uuid", profile_uuid)
        if provider_status is not None:
            pulumi.set(__self__, "provider_status", provider_status)
        if redundancy_group is not None:
            pulumi.set(__self__, "redundancy_group", redundancy_group)
        if redundancy_type is not None:
            pulumi.set(__self__, "redundancy_type", redundancy_type)
        if redundant_uuid is not None:
            pulumi.set(__self__, "redundant_uuid", redundant_uuid)
        if seller_metro_code is not None:
            pulumi.set(__self__, "seller_metro_code", seller_metro_code)
        if seller_region is not None:
            pulumi.set(__self__, "seller_region", seller_region)
        if service_token is not None:
            pulumi.set(__self__, "service_token", service_token)
        if speed is not None:
            pulumi.set(__self__, "speed", speed)
        if speed_unit is not None:
            pulumi.set(__self__, "speed_unit", speed_unit)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if vendor_token is not None:
            pulumi.set(__self__, "vendor_token", vendor_token)
        if vlan_ctag is not None:
            pulumi.set(__self__, "vlan_ctag", vlan_ctag)
        if vlan_stag is not None:
            pulumi.set(__self__, "vlan_stag", vlan_stag)
        if zside_port_uuid is not None:
            pulumi.set(__self__, "zside_port_uuid", zside_port_uuid)
        if zside_vlan_ctag is not None:
            pulumi.set(__self__, "zside_vlan_ctag", zside_vlan_ctag)
        if zside_vlan_stag is not None:
            pulumi.set(__self__, "zside_vlan_stag", zside_vlan_stag)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        secondary connection name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence['outputs.ECXL2ConnectionSecondaryConnectionAction']]:
        """
        One or more pending actions to complete connection provisioning.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[str]:
        """
        Unique identifier authorizing Equinix to provision a connection
        towards a cloud service provider. If not specified primary `authorization_key` will be used. However,
        some service providers may require different keys for each connection. More information on
        [Equinix Fabric how to guide](https://developer.equinix.com/docs/ecx-how-to-guide).
        """
        return pulumi.get(self, "authorization_key")

    @property
    @pulumi.getter(name="deviceInterfaceId")
    def device_interface_id(self) -> Optional[int]:
        """
        Applicable with `device_uuid`, identifier of network interface
        on a given device. If not specified then first available interface will be selected.
        """
        return pulumi.get(self, "device_interface_id")

    @property
    @pulumi.getter(name="deviceUuid")
    def device_uuid(self) -> Optional[str]:
        """
        Applicable with primary `device_uuid`. Identifier of the Network Edge
        virtual device from which the secondary connection would originate. If not specified primary
        `device_uuid` will be used.
        """
        return pulumi.get(self, "device_uuid")

    @property
    @pulumi.getter(name="portUuid")
    def port_uuid(self) -> Optional[str]:
        """
        Applicable with primary `port_uuid`. Identifier of the Equinix Fabric Port from
        which the secondary connection would originate. If not specified primary `port_uuid` will be used.
        """
        return pulumi.get(self, "port_uuid")

    @property
    @pulumi.getter(name="profileUuid")
    def profile_uuid(self) -> Optional[str]:
        """
        Unique identifier of the service provider's profile.
        """
        return pulumi.get(self, "profile_uuid")

    @property
    @pulumi.getter(name="providerStatus")
    def provider_status(self) -> Optional[str]:
        """
        Connection provisioning status on service provider's side.
        """
        return pulumi.get(self, "provider_status")

    @property
    @pulumi.getter(name="redundancyGroup")
    def redundancy_group(self) -> Optional[str]:
        """
        Unique identifier of group containing a primary and secondary connection.
        """
        return pulumi.get(self, "redundancy_group")

    @property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> Optional[str]:
        """
        Connection redundancy type, applicable for HA connections. Valid values are
        `PRIMARY`, `SECONDARY`.
        """
        return pulumi.get(self, "redundancy_type")

    @property
    @pulumi.getter(name="redundantUuid")
    def redundant_uuid(self) -> Optional[str]:
        """
        Unique identifier of the redundant connection, applicable for HA connections.
        """
        return pulumi.get(self, "redundant_uuid")

    @property
    @pulumi.getter(name="sellerMetroCode")
    def seller_metro_code(self) -> Optional[str]:
        """
        The metro code that denotes the secondary connection’s
        destination (Z side). .
        """
        return pulumi.get(self, "seller_metro_code")

    @property
    @pulumi.getter(name="sellerRegion")
    def seller_region(self) -> Optional[str]:
        """
        The region in which the seller port resides. If not specified
        primary `seller_region` will be used.
        """
        return pulumi.get(self, "seller_region")

    @property
    @pulumi.getter(name="serviceToken")
    def service_token(self) -> Optional[str]:
        """
        Required with primary `service_token`. Unique Equinix Fabric key
        given by a provider that grants you authorization to enable connectivity from an Equinix Fabric Port or
        virtual device. Each connection (primary and secondary) requires a separate token.
        More details in [Fabric Service Tokens](https://docs.equinix.com/en-us/Content/Interconnection/Fabric/service%20tokens/Fabric-Service-Tokens.htm).
        """
        return pulumi.get(self, "service_token")

    @property
    @pulumi.getter
    def speed(self) -> Optional[int]:
        """
        Speed/Bandwidth to be allocated to the secondary connection. If not
        specified primary `speed` will be used.
        """
        return pulumi.get(self, "speed")

    @property
    @pulumi.getter(name="speedUnit")
    def speed_unit(self) -> Optional[str]:
        """
        Unit of the speed/bandwidth to be allocated to the secondary
        connection. If not specified primary `speed_unit` will be used.
        """
        return pulumi.get(self, "speed_unit")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Connection provisioning status on Equinix Fabric side.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[str]:
        """
        Unique identifier of the connection.
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="vendorToken")
    def vendor_token(self) -> Optional[str]:
        """
        The Equinix Fabric Token the connection was created with. Applicable if the
        connection was created with a `service_token` (a-side) or `zside_service_token` (z-side).
        * `secondary_connection`:
        * `zside_port_uuid`
        * `zside_vlan_stag`
        * `zside_vlan_ctag`
        * `redundancy_type`
        * `redundancy_group`
        * `vendor_token`
        """
        return pulumi.get(self, "vendor_token")

    @property
    @pulumi.getter(name="vlanCtag")
    def vlan_ctag(self) -> Optional[int]:
        """
        Applicable with `port_uuid`. C-Tag/Inner-Tag of the secondary
        connection, a numeric character ranging from 2 - 4094.
        """
        return pulumi.get(self, "vlan_ctag")

    @property
    @pulumi.getter(name="vlanStag")
    def vlan_stag(self) -> Optional[int]:
        """
        S-Tag/Outer-Tag of the secondary connection, a
        numeric character ranging from 2 - 4094.
        """
        return pulumi.get(self, "vlan_stag")

    @property
    @pulumi.getter(name="zsidePortUuid")
    def zside_port_uuid(self) -> Optional[str]:
        """
        Unique identifier of the port on the remote/destination side
        (z-side). Allows you to connect between your own ports or virtual devices across your company's
        Equinix Fabric deployment, with no need for a private service profile.
        """
        return pulumi.get(self, "zside_port_uuid")

    @property
    @pulumi.getter(name="zsideVlanCtag")
    def zside_vlan_ctag(self) -> Optional[int]:
        """
        C-Tag/Inner-Tag of the connection on the remote/destination
        side (z-side) - a numeric character ranging from 2 - 4094.
        `secondary_connection` is defined it will internally use same `zside_vlan_ctag` for the secondary
        connection.
        """
        return pulumi.get(self, "zside_vlan_ctag")

    @property
    @pulumi.getter(name="zsideVlanStag")
    def zside_vlan_stag(self) -> Optional[int]:
        """
        S-Tag/Outer-Tag of the connection on the remote/destination
        side (z-side) - a numeric character ranging from 2 - 4094.
        """
        return pulumi.get(self, "zside_vlan_stag")


@pulumi.output_type
class ECXL2ConnectionSecondaryConnectionAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationId":
            suggest = "operation_id"
        elif key == "requiredDatas":
            suggest = "required_datas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ECXL2ConnectionSecondaryConnectionAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ECXL2ConnectionSecondaryConnectionAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ECXL2ConnectionSecondaryConnectionAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: Optional[str] = None,
                 operation_id: Optional[str] = None,
                 required_datas: Optional[Sequence['outputs.ECXL2ConnectionSecondaryConnectionActionRequiredData']] = None,
                 type: Optional[str] = None):
        if message is not None:
            pulumi.set(__self__, "message", message)
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if required_datas is not None:
            pulumi.set(__self__, "required_datas", required_datas)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[str]:
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter(name="requiredDatas")
    def required_datas(self) -> Optional[Sequence['outputs.ECXL2ConnectionSecondaryConnectionActionRequiredData']]:
        return pulumi.get(self, "required_datas")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class ECXL2ConnectionSecondaryConnectionActionRequiredData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "validationPattern":
            suggest = "validation_pattern"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ECXL2ConnectionSecondaryConnectionActionRequiredData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ECXL2ConnectionSecondaryConnectionActionRequiredData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ECXL2ConnectionSecondaryConnectionActionRequiredData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 editable: Optional[bool] = None,
                 key: Optional[str] = None,
                 label: Optional[str] = None,
                 validation_pattern: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str value: additional information value
        """
        if editable is not None:
            pulumi.set(__self__, "editable", editable)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if validation_pattern is not None:
            pulumi.set(__self__, "validation_pattern", validation_pattern)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def editable(self) -> Optional[bool]:
        return pulumi.get(self, "editable")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="validationPattern")
    def validation_pattern(self) -> Optional[str]:
        return pulumi.get(self, "validation_pattern")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        additional information value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ECXL2ServiceprofileFeatures(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowRemoteConnections":
            suggest = "allow_remote_connections"
        elif key == "testProfile":
            suggest = "test_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ECXL2ServiceprofileFeatures. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ECXL2ServiceprofileFeatures.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ECXL2ServiceprofileFeatures.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_remote_connections: bool,
                 test_profile: Optional[bool] = None):
        """
        :param bool allow_remote_connections: Indicates whether or not connections to this profile
               can be created from remote metro locations.
        :param bool test_profile: Indicates whether or not this profile can be used for test
               connections.
        """
        pulumi.set(__self__, "allow_remote_connections", allow_remote_connections)
        if test_profile is not None:
            pulumi.set(__self__, "test_profile", test_profile)

    @property
    @pulumi.getter(name="allowRemoteConnections")
    def allow_remote_connections(self) -> bool:
        """
        Indicates whether or not connections to this profile
        can be created from remote metro locations.
        """
        return pulumi.get(self, "allow_remote_connections")

    @property
    @pulumi.getter(name="testProfile")
    def test_profile(self) -> Optional[bool]:
        """
        Indicates whether or not this profile can be used for test
        connections.
        """
        return pulumi.get(self, "test_profile")


@pulumi.output_type
class ECXL2ServiceprofilePort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metroCode":
            suggest = "metro_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ECXL2ServiceprofilePort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ECXL2ServiceprofilePort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ECXL2ServiceprofilePort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metro_code: str,
                 uuid: str):
        """
        :param str metro_code: The metro code of location where the port resides.
        :param str uuid: Unique identifier of the port.
        """
        pulumi.set(__self__, "metro_code", metro_code)
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="metroCode")
    def metro_code(self) -> str:
        """
        The metro code of location where the port resides.
        """
        return pulumi.get(self, "metro_code")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        Unique identifier of the port.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class ECXL2ServiceprofileSpeedBand(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "speedUnit":
            suggest = "speed_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ECXL2ServiceprofileSpeedBand. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ECXL2ServiceprofileSpeedBand.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ECXL2ServiceprofileSpeedBand.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 speed: int,
                 speed_unit: str):
        """
        :param int speed: Speed/bandwidth supported by this service profile.
        :param str speed_unit: Unit of the speed/bandwidth supported by this service profile. One of
               `MB`, `GB`.
        """
        pulumi.set(__self__, "speed", speed)
        pulumi.set(__self__, "speed_unit", speed_unit)

    @property
    @pulumi.getter
    def speed(self) -> int:
        """
        Speed/bandwidth supported by this service profile.
        """
        return pulumi.get(self, "speed")

    @property
    @pulumi.getter(name="speedUnit")
    def speed_unit(self) -> str:
        """
        Unit of the speed/bandwidth supported by this service profile. One of
        `MB`, `GB`.
        """
        return pulumi.get(self, "speed_unit")


@pulumi.output_type
class GetECXL2SellerprofileAdditionalInfoResult(dict):
    def __init__(__self__, *,
                 captured_in_email: bool,
                 data_type: str,
                 description: str,
                 mandatory: bool,
                 name: str):
        """
        :param str data_type: Data type of additional information attribute. One of `BOOLEAN`, `INTEGER` or
               `STRING`.
        :param str description: Textual description of additional information attribute.
        :param bool mandatory: Specifies if additional information is mandatory to create
               connection.
        :param str name: Name of the seller profile.
        """
        pulumi.set(__self__, "captured_in_email", captured_in_email)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "mandatory", mandatory)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="capturedInEmail")
    def captured_in_email(self) -> bool:
        return pulumi.get(self, "captured_in_email")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        Data type of additional information attribute. One of `BOOLEAN`, `INTEGER` or
        `STRING`.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Textual description of additional information attribute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mandatory(self) -> bool:
        """
        Specifies if additional information is mandatory to create
        connection.
        """
        return pulumi.get(self, "mandatory")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the seller profile.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetECXL2SellerprofileMetroResult(dict):
    def __init__(__self__, *,
                 code: str,
                 ibxes: Sequence[str],
                 name: str,
                 regions: Mapping[str, str]):
        """
        :param str code: Location metro code.
        :param Sequence[str] ibxes: List of IBXes supported within given metro.
        :param str name: Name of the seller profile.
        :param Mapping[str, str] regions: List of regions supported within given.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "ibxes", ibxes)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Location metro code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def ibxes(self) -> Sequence[str]:
        """
        List of IBXes supported within given metro.
        """
        return pulumi.get(self, "ibxes")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the seller profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def regions(self) -> Mapping[str, str]:
        """
        List of regions supported within given.
        """
        return pulumi.get(self, "regions")


@pulumi.output_type
class GetECXL2SellerprofileSpeedBandResult(dict):
    def __init__(__self__, *,
                 speed: int,
                 speed_unit: str):
        """
        :param int speed: Speed/bandwidth supported by given service profile.
        :param str speed_unit: Unit of the speed/bandwidth supported by given service profile.
        """
        pulumi.set(__self__, "speed", speed)
        pulumi.set(__self__, "speed_unit", speed_unit)

    @property
    @pulumi.getter
    def speed(self) -> int:
        """
        Speed/bandwidth supported by given service profile.
        """
        return pulumi.get(self, "speed")

    @property
    @pulumi.getter(name="speedUnit")
    def speed_unit(self) -> str:
        """
        Unit of the speed/bandwidth supported by given service profile.
        """
        return pulumi.get(self, "speed_unit")


@pulumi.output_type
class GetECXL2SellerprofilesProfileResult(dict):
    def __init__(__self__, *,
                 additional_infos: Sequence['outputs.GetECXL2SellerprofilesProfileAdditionalInfoResult'],
                 description: str,
                 encapsulation: str,
                 metros: Sequence['outputs.GetECXL2SellerprofilesProfileMetroResult'],
                 name: str,
                 organization_global_name: str,
                 organization_name: str,
                 redundancy_required: bool,
                 speed_bands: Sequence['outputs.GetECXL2SellerprofilesProfileSpeedBandResult'],
                 speed_customization_allowed: bool,
                 speed_from_api: bool,
                 uuid: str):
        """
        :param str organization_global_name: Name of seller's global organization.
        :param str organization_name: Name of seller's organization.
        """
        pulumi.set(__self__, "additional_infos", additional_infos)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encapsulation", encapsulation)
        pulumi.set(__self__, "metros", metros)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_global_name", organization_global_name)
        pulumi.set(__self__, "organization_name", organization_name)
        pulumi.set(__self__, "redundancy_required", redundancy_required)
        pulumi.set(__self__, "speed_bands", speed_bands)
        pulumi.set(__self__, "speed_customization_allowed", speed_customization_allowed)
        pulumi.set(__self__, "speed_from_api", speed_from_api)
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="additionalInfos")
    def additional_infos(self) -> Sequence['outputs.GetECXL2SellerprofilesProfileAdditionalInfoResult']:
        return pulumi.get(self, "additional_infos")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def encapsulation(self) -> str:
        return pulumi.get(self, "encapsulation")

    @property
    @pulumi.getter
    def metros(self) -> Sequence['outputs.GetECXL2SellerprofilesProfileMetroResult']:
        return pulumi.get(self, "metros")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationGlobalName")
    def organization_global_name(self) -> str:
        """
        Name of seller's global organization.
        """
        return pulumi.get(self, "organization_global_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> str:
        """
        Name of seller's organization.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="redundancyRequired")
    def redundancy_required(self) -> bool:
        return pulumi.get(self, "redundancy_required")

    @property
    @pulumi.getter(name="speedBands")
    def speed_bands(self) -> Sequence['outputs.GetECXL2SellerprofilesProfileSpeedBandResult']:
        return pulumi.get(self, "speed_bands")

    @property
    @pulumi.getter(name="speedCustomizationAllowed")
    def speed_customization_allowed(self) -> bool:
        return pulumi.get(self, "speed_customization_allowed")

    @property
    @pulumi.getter(name="speedFromApi")
    def speed_from_api(self) -> bool:
        return pulumi.get(self, "speed_from_api")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        return pulumi.get(self, "uuid")


@pulumi.output_type
class GetECXL2SellerprofilesProfileAdditionalInfoResult(dict):
    def __init__(__self__, *,
                 captured_in_email: bool,
                 data_type: str,
                 description: str,
                 mandatory: bool,
                 name: str):
        pulumi.set(__self__, "captured_in_email", captured_in_email)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "mandatory", mandatory)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="capturedInEmail")
    def captured_in_email(self) -> bool:
        return pulumi.get(self, "captured_in_email")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mandatory(self) -> bool:
        return pulumi.get(self, "mandatory")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetECXL2SellerprofilesProfileMetroResult(dict):
    def __init__(__self__, *,
                 code: str,
                 ibxes: Sequence[str],
                 name: str,
                 regions: Mapping[str, str]):
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "ibxes", ibxes)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter
    def code(self) -> str:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def ibxes(self) -> Sequence[str]:
        return pulumi.get(self, "ibxes")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def regions(self) -> Mapping[str, str]:
        return pulumi.get(self, "regions")


@pulumi.output_type
class GetECXL2SellerprofilesProfileSpeedBandResult(dict):
    def __init__(__self__, *,
                 speed: int,
                 speed_unit: str):
        pulumi.set(__self__, "speed", speed)
        pulumi.set(__self__, "speed_unit", speed_unit)

    @property
    @pulumi.getter
    def speed(self) -> int:
        return pulumi.get(self, "speed")

    @property
    @pulumi.getter(name="speedUnit")
    def speed_unit(self) -> str:
        return pulumi.get(self, "speed_unit")


@pulumi.output_type
class GetMetalConnectionPortResult(dict):
    def __init__(__self__, *,
                 id: str,
                 link_status: str,
                 name: str,
                 role: str,
                 speed: int,
                 status: str,
                 virtual_circuit_ids: Sequence[Any]):
        """
        :param str id: Port UUID.
        :param str link_status: Port link status.
        :param str name: Port name.
        :param str role: Port role - primary or secondary.
        :param int speed: Port speed in bits per second.
        :param str status: Port status.
        :param Sequence[Any] virtual_circuit_ids: List of IDs of virtual cicruits attached to this port.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "link_status", link_status)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "speed", speed)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "virtual_circuit_ids", virtual_circuit_ids)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Port UUID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="linkStatus")
    def link_status(self) -> str:
        """
        Port link status.
        """
        return pulumi.get(self, "link_status")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Port name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Port role - primary or secondary.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def speed(self) -> int:
        """
        Port speed in bits per second.
        """
        return pulumi.get(self, "speed")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Port status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="virtualCircuitIds")
    def virtual_circuit_ids(self) -> Sequence[Any]:
        """
        List of IDs of virtual cicruits attached to this port.
        """
        return pulumi.get(self, "virtual_circuit_ids")


@pulumi.output_type
class GetMetalConnectionServiceTokenResult(dict):
    def __init__(__self__, *,
                 expires_at: str,
                 id: str,
                 max_allowed_speed: str,
                 role: str,
                 state: str,
                 type: str):
        """
        :param str expires_at: Expiration date of the service token.
        :param str id: Port UUID.
        :param str max_allowed_speed: Maximum allowed speed for the service token, string like in the `speed` attribute.
        :param str role: Port role - primary or secondary.
        :param str type: Token type, `a_side` or `z_side`.
        """
        pulumi.set(__self__, "expires_at", expires_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "max_allowed_speed", max_allowed_speed)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> str:
        """
        Expiration date of the service token.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Port UUID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxAllowedSpeed")
    def max_allowed_speed(self) -> str:
        """
        Maximum allowed speed for the service token, string like in the `speed` attribute.
        """
        return pulumi.get(self, "max_allowed_speed")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Port role - primary or secondary.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Token type, `a_side` or `z_side`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMetalDeviceBGPNeighborsBgpNeighborResult(dict):
    def __init__(__self__, *,
                 address_family: int,
                 customer_as: int,
                 customer_ip: str,
                 md5_enabled: bool,
                 md5_password: str,
                 multihop: bool,
                 peer_as: int,
                 routes_ins: Sequence['outputs.GetMetalDeviceBGPNeighborsBgpNeighborRoutesInResult'],
                 routes_outs: Sequence['outputs.GetMetalDeviceBGPNeighborsBgpNeighborRoutesOutResult'],
                 peer_ips: Optional[Sequence[str]] = None):
        """
        :param int address_family: IP address version, 4 or 6.
        :param int customer_as: Local autonomous system number.
        :param str customer_ip: Local used peer IP address.
        :param bool md5_enabled: Whether BGP session is password enabled.
        :param str md5_password: BGP session password in plaintext (not a checksum).
        :param bool multihop: Whether the neighbor is in EBGP multihop session.
        :param int peer_as: Peer AS number (different than customer_as for EBGP).
        :param Sequence['GetMetalDeviceBGPNeighborsBgpNeighborRoutesInArgs'] routes_ins: Array of incoming routes.
        :param Sequence['GetMetalDeviceBGPNeighborsBgpNeighborRoutesOutArgs'] routes_outs: Array of outgoing routes in the same format.
        :param Sequence[str] peer_ips: Array of IP addresses of this neighbor's peers.
        """
        pulumi.set(__self__, "address_family", address_family)
        pulumi.set(__self__, "customer_as", customer_as)
        pulumi.set(__self__, "customer_ip", customer_ip)
        pulumi.set(__self__, "md5_enabled", md5_enabled)
        pulumi.set(__self__, "md5_password", md5_password)
        pulumi.set(__self__, "multihop", multihop)
        pulumi.set(__self__, "peer_as", peer_as)
        pulumi.set(__self__, "routes_ins", routes_ins)
        pulumi.set(__self__, "routes_outs", routes_outs)
        if peer_ips is not None:
            pulumi.set(__self__, "peer_ips", peer_ips)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> int:
        """
        IP address version, 4 or 6.
        """
        return pulumi.get(self, "address_family")

    @property
    @pulumi.getter(name="customerAs")
    def customer_as(self) -> int:
        """
        Local autonomous system number.
        """
        return pulumi.get(self, "customer_as")

    @property
    @pulumi.getter(name="customerIp")
    def customer_ip(self) -> str:
        """
        Local used peer IP address.
        """
        return pulumi.get(self, "customer_ip")

    @property
    @pulumi.getter(name="md5Enabled")
    def md5_enabled(self) -> bool:
        """
        Whether BGP session is password enabled.
        """
        return pulumi.get(self, "md5_enabled")

    @property
    @pulumi.getter(name="md5Password")
    def md5_password(self) -> str:
        """
        BGP session password in plaintext (not a checksum).
        """
        return pulumi.get(self, "md5_password")

    @property
    @pulumi.getter
    def multihop(self) -> bool:
        """
        Whether the neighbor is in EBGP multihop session.
        """
        return pulumi.get(self, "multihop")

    @property
    @pulumi.getter(name="peerAs")
    def peer_as(self) -> int:
        """
        Peer AS number (different than customer_as for EBGP).
        """
        return pulumi.get(self, "peer_as")

    @property
    @pulumi.getter(name="routesIns")
    def routes_ins(self) -> Sequence['outputs.GetMetalDeviceBGPNeighborsBgpNeighborRoutesInResult']:
        """
        Array of incoming routes.
        """
        return pulumi.get(self, "routes_ins")

    @property
    @pulumi.getter(name="routesOuts")
    def routes_outs(self) -> Sequence['outputs.GetMetalDeviceBGPNeighborsBgpNeighborRoutesOutResult']:
        """
        Array of outgoing routes in the same format.
        """
        return pulumi.get(self, "routes_outs")

    @property
    @pulumi.getter(name="peerIps")
    def peer_ips(self) -> Optional[Sequence[str]]:
        """
        Array of IP addresses of this neighbor's peers.
        """
        return pulumi.get(self, "peer_ips")


@pulumi.output_type
class GetMetalDeviceBGPNeighborsBgpNeighborRoutesInResult(dict):
    def __init__(__self__, *,
                 exact: bool,
                 route: str):
        """
        :param bool exact: (bool) Whether the route is exact.
        :param str route: CIDR expression of route (IP/mask).
        """
        pulumi.set(__self__, "exact", exact)
        pulumi.set(__self__, "route", route)

    @property
    @pulumi.getter
    def exact(self) -> bool:
        """
        (bool) Whether the route is exact.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    def route(self) -> str:
        """
        CIDR expression of route (IP/mask).
        """
        return pulumi.get(self, "route")


@pulumi.output_type
class GetMetalDeviceBGPNeighborsBgpNeighborRoutesOutResult(dict):
    def __init__(__self__, *,
                 exact: bool,
                 route: str):
        """
        :param bool exact: (bool) Whether the route is exact.
        :param str route: CIDR expression of route (IP/mask).
        """
        pulumi.set(__self__, "exact", exact)
        pulumi.set(__self__, "route", route)

    @property
    @pulumi.getter
    def exact(self) -> bool:
        """
        (bool) Whether the route is exact.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    def route(self) -> str:
        """
        CIDR expression of route (IP/mask).
        """
        return pulumi.get(self, "route")


@pulumi.output_type
class GetMetalDeviceNetworkResult(dict):
    def __init__(__self__, *,
                 address: str,
                 cidr: int,
                 family: int,
                 gateway: str,
                 public: bool):
        """
        :param str address: IPv4 or IPv6 address string.
        :param int cidr: Bit length of the network mask of the address.
        :param int family: IP version. One of `4`, `6`.
        :param str gateway: Address of router.
        :param bool public: Whether the address is routable from the Internet.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "public", public)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        IPv4 or IPv6 address string.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def cidr(self) -> int:
        """
        Bit length of the network mask of the address.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def family(self) -> int:
        """
        IP version. One of `4`, `6`.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def gateway(self) -> str:
        """
        Address of router.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def public(self) -> bool:
        """
        Whether the address is routable from the Internet.
        """
        return pulumi.get(self, "public")


@pulumi.output_type
class GetMetalDevicePortResult(dict):
    def __init__(__self__, *,
                 bonded: bool,
                 id: str,
                 mac: str,
                 name: str,
                 type: str):
        """
        :param bool bonded: Whether this port is part of a bond in bonded network setup.
        :param str id: ID of the port.
        :param str mac: MAC address assigned to the port.
        :param str name: Name of the port (e.g. `eth0`, or `bond0`).
        :param str type: Type of the port (e.g. `NetworkPort` or `NetworkBondPort`).
        """
        pulumi.set(__self__, "bonded", bonded)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def bonded(self) -> bool:
        """
        Whether this port is part of a bond in bonded network setup.
        """
        return pulumi.get(self, "bonded")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the port.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def mac(self) -> str:
        """
        MAC address assigned to the port.
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the port (e.g. `eth0`, or `bond0`).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the port (e.g. `NetworkPort` or `NetworkBondPort`).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMetalFacilityCapacityResult(dict):
    def __init__(__self__, *,
                 plan: str,
                 quantity: Optional[int] = None):
        """
        :param str plan: Device plan that must be available in selected location.
        :param int quantity: Minimun number of devices that must be available in selected location.
               Default is `1`.
        """
        pulumi.set(__self__, "plan", plan)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def plan(self) -> str:
        """
        Device plan that must be available in selected location.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def quantity(self) -> Optional[int]:
        """
        Minimun number of devices that must be available in selected location.
        Default is `1`.
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class GetMetalMetroCapacityResult(dict):
    def __init__(__self__, *,
                 plan: str,
                 quantity: Optional[int] = None):
        """
        :param str plan: Device plan that must be available in selected location.
        :param int quantity: Minimun number of devices that must be available in selected location.
               Default is `1`.
        """
        pulumi.set(__self__, "plan", plan)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def plan(self) -> str:
        """
        Device plan that must be available in selected location.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def quantity(self) -> Optional[int]:
        """
        Minimun number of devices that must be available in selected location.
        Default is `1`.
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class GetMetalOrganizationAddressResult(dict):
    def __init__(__self__, *,
                 address: str,
                 city: str,
                 country: str,
                 state: str,
                 zip_code: str):
        """
        :param str address: Postal address.
        :param str city: City name.
        :param str country: Two letter country code (ISO 3166-1 alpha-2), e.g. US.
        :param str state: State name.
        :param str zip_code: Zip Code.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Postal address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def city(self) -> str:
        """
        City name.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def country(self) -> str:
        """
        Two letter country code (ISO 3166-1 alpha-2), e.g. US.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State name.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> str:
        """
        Zip Code.
        """
        return pulumi.get(self, "zip_code")


@pulumi.output_type
class GetMetalPlansFilterResult(dict):
    def __init__(__self__, *,
                 attribute: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str attribute: The attribute used to filter. Filter attributes are case-sensitive
        :param Sequence[str] values: The filter values. Filter values are case-sensitive. If you specify multiple values for a filter, the values are joined with an OR by default, and the request returns all results that match any of the specified values
        :param bool all: If is set to true, the values are joined with an AND, and the requests returns only the results that match all specified values. Default is `false`.
        :param str match_by: The type of comparison to apply. One of: `in` , `re`, `substring`, `less_than`, `less_than_or_equal`, `greater_than`, `greater_than_or_equal`. Default is `in`.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The attribute used to filter. Filter attributes are case-sensitive
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The filter values. Filter values are case-sensitive. If you specify multiple values for a filter, the values are joined with an OR by default, and the request returns all results that match any of the specified values
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        If is set to true, the values are joined with an AND, and the requests returns only the results that match all specified values. Default is `false`.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        The type of comparison to apply. One of: `in` , `re`, `substring`, `less_than`, `less_than_or_equal`, `greater_than`, `greater_than_or_equal`. Default is `in`.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetMetalPlansPlanResult(dict):
    def __init__(__self__, *,
                 available_in_metros: Sequence[str],
                 available_ins: Sequence[str],
                 class_: str,
                 deployment_types: Sequence[str],
                 description: str,
                 id: str,
                 legacy: bool,
                 line: str,
                 name: str,
                 pricing_hour: float,
                 pricing_month: float,
                 slug: str):
        """
        :param str id: id of the plan
        :param str name: name of the plan
               - `slug`- plan slug
               - `description`- description of the plan
               - `line`- plan line, e.g. baremetal
               - `legacy`- flag showing if it's a legacy plan
               - `class`- plan class
               - `pricing_hour`- plan hourly price
               - `pricing_month`- plan monthly price
               - `deployment_types`- list of deployment types, e.g. on_demand, spot_market
               - `available_in`- list of facilities where the plan is available
               - `available_in_metros`- list of facilities where the plan is available
        """
        pulumi.set(__self__, "available_in_metros", available_in_metros)
        pulumi.set(__self__, "available_ins", available_ins)
        pulumi.set(__self__, "class_", class_)
        pulumi.set(__self__, "deployment_types", deployment_types)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "legacy", legacy)
        pulumi.set(__self__, "line", line)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pricing_hour", pricing_hour)
        pulumi.set(__self__, "pricing_month", pricing_month)
        pulumi.set(__self__, "slug", slug)

    @property
    @pulumi.getter(name="availableInMetros")
    def available_in_metros(self) -> Sequence[str]:
        return pulumi.get(self, "available_in_metros")

    @property
    @pulumi.getter(name="availableIns")
    def available_ins(self) -> Sequence[str]:
        return pulumi.get(self, "available_ins")

    @property
    @pulumi.getter(name="class")
    def class_(self) -> str:
        return pulumi.get(self, "class_")

    @property
    @pulumi.getter(name="deploymentTypes")
    def deployment_types(self) -> Sequence[str]:
        return pulumi.get(self, "deployment_types")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        id of the plan
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def legacy(self) -> bool:
        return pulumi.get(self, "legacy")

    @property
    @pulumi.getter
    def line(self) -> str:
        return pulumi.get(self, "line")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name of the plan
        - `slug`- plan slug
        - `description`- description of the plan
        - `line`- plan line, e.g. baremetal
        - `legacy`- flag showing if it's a legacy plan
        - `class`- plan class
        - `pricing_hour`- plan hourly price
        - `pricing_month`- plan monthly price
        - `deployment_types`- list of deployment types, e.g. on_demand, spot_market
        - `available_in`- list of facilities where the plan is available
        - `available_in_metros`- list of facilities where the plan is available
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pricingHour")
    def pricing_hour(self) -> float:
        return pulumi.get(self, "pricing_hour")

    @property
    @pulumi.getter(name="pricingMonth")
    def pricing_month(self) -> float:
        return pulumi.get(self, "pricing_month")

    @property
    @pulumi.getter
    def slug(self) -> str:
        return pulumi.get(self, "slug")


@pulumi.output_type
class GetMetalPlansSortResult(dict):
    def __init__(__self__, *,
                 attribute: str,
                 direction: Optional[str] = None):
        """
        :param str attribute: The attribute used to filter. Filter attributes are case-sensitive
        :param str direction: Sort results in ascending or descending order. Strings are sorted in alphabetical order. One of: asc, desc
        """
        pulumi.set(__self__, "attribute", attribute)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The attribute used to filter. Filter attributes are case-sensitive
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        Sort results in ascending or descending order. Strings are sorted in alphabetical order. One of: asc, desc
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetMetalProjectBgpConfigResult(dict):
    def __init__(__self__, *,
                 asn: int,
                 deployment_type: str,
                 max_prefix: int,
                 status: str,
                 md5: Optional[str] = None):
        """
        :param int asn: Autonomous System Number for local BGP deployment.
        :param str deployment_type: One of `private`, `public`.
        :param int max_prefix: The maximum number of route filters allowed per server.
        :param str status: Status of BGP configuration in the project.
        :param str md5: Password for BGP session in plaintext (not a checksum).
        """
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "max_prefix", max_prefix)
        pulumi.set(__self__, "status", status)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)

    @property
    @pulumi.getter
    def asn(self) -> int:
        """
        Autonomous System Number for local BGP deployment.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        One of `private`, `public`.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="maxPrefix")
    def max_prefix(self) -> int:
        """
        The maximum number of route filters allowed per server.
        """
        return pulumi.get(self, "max_prefix")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of BGP configuration in the project.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def md5(self) -> Optional[str]:
        """
        Password for BGP session in plaintext (not a checksum).
        """
        return pulumi.get(self, "md5")


@pulumi.output_type
class GetNetworkDeviceClusterDetailResult(dict):
    def __init__(__self__, *,
                 cluster_id: str,
                 cluster_name: str,
                 node0s: Sequence['outputs.GetNetworkDeviceClusterDetailNode0Result'],
                 node1s: Sequence['outputs.GetNetworkDeviceClusterDetailNode1Result'],
                 num_of_nodes: int):
        """
        :param str cluster_id: The id of the cluster
        :param int num_of_nodes: The number of nodes in the cluster
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "node0s", node0s)
        pulumi.set(__self__, "node1s", node1s)
        pulumi.set(__self__, "num_of_nodes", num_of_nodes)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The id of the cluster
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def node0s(self) -> Sequence['outputs.GetNetworkDeviceClusterDetailNode0Result']:
        return pulumi.get(self, "node0s")

    @property
    @pulumi.getter
    def node1s(self) -> Sequence['outputs.GetNetworkDeviceClusterDetailNode1Result']:
        return pulumi.get(self, "node1s")

    @property
    @pulumi.getter(name="numOfNodes")
    def num_of_nodes(self) -> int:
        """
        The number of nodes in the cluster
        """
        return pulumi.get(self, "num_of_nodes")


@pulumi.output_type
class GetNetworkDeviceClusterDetailNode0Result(dict):
    def __init__(__self__, *,
                 license_file_id: str,
                 license_token: str,
                 name: str,
                 uuid: str,
                 vendor_configurations: Sequence['outputs.GetNetworkDeviceClusterDetailNode0VendorConfigurationResult']):
        """
        :param str license_file_id: Unique identifier of applied license file
        :param str name: Name of an existing Equinix Network Edge device
        :param str uuid: UUID of an existing Equinix Network Edge device
        """
        pulumi.set(__self__, "license_file_id", license_file_id)
        pulumi.set(__self__, "license_token", license_token)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uuid", uuid)
        pulumi.set(__self__, "vendor_configurations", vendor_configurations)

    @property
    @pulumi.getter(name="licenseFileId")
    def license_file_id(self) -> str:
        """
        Unique identifier of applied license file
        """
        return pulumi.get(self, "license_file_id")

    @property
    @pulumi.getter(name="licenseToken")
    def license_token(self) -> str:
        return pulumi.get(self, "license_token")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of an existing Equinix Network Edge device
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        UUID of an existing Equinix Network Edge device
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="vendorConfigurations")
    def vendor_configurations(self) -> Sequence['outputs.GetNetworkDeviceClusterDetailNode0VendorConfigurationResult']:
        return pulumi.get(self, "vendor_configurations")


@pulumi.output_type
class GetNetworkDeviceClusterDetailNode0VendorConfigurationResult(dict):
    def __init__(__self__, *,
                 activation_key: str,
                 admin_password: str,
                 controller1: str,
                 controller_fqdn: str,
                 hostname: str,
                 root_password: str):
        pulumi.set(__self__, "activation_key", activation_key)
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "controller1", controller1)
        pulumi.set(__self__, "controller_fqdn", controller_fqdn)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "root_password", root_password)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> str:
        return pulumi.get(self, "activation_key")

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> str:
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter
    def controller1(self) -> str:
        return pulumi.get(self, "controller1")

    @property
    @pulumi.getter(name="controllerFqdn")
    def controller_fqdn(self) -> str:
        return pulumi.get(self, "controller_fqdn")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> str:
        return pulumi.get(self, "root_password")


@pulumi.output_type
class GetNetworkDeviceClusterDetailNode1Result(dict):
    def __init__(__self__, *,
                 license_file_id: str,
                 license_token: str,
                 name: str,
                 uuid: str,
                 vendor_configurations: Sequence['outputs.GetNetworkDeviceClusterDetailNode1VendorConfigurationResult']):
        """
        :param str license_file_id: Unique identifier of applied license file
        :param str name: Name of an existing Equinix Network Edge device
        :param str uuid: UUID of an existing Equinix Network Edge device
        """
        pulumi.set(__self__, "license_file_id", license_file_id)
        pulumi.set(__self__, "license_token", license_token)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uuid", uuid)
        pulumi.set(__self__, "vendor_configurations", vendor_configurations)

    @property
    @pulumi.getter(name="licenseFileId")
    def license_file_id(self) -> str:
        """
        Unique identifier of applied license file
        """
        return pulumi.get(self, "license_file_id")

    @property
    @pulumi.getter(name="licenseToken")
    def license_token(self) -> str:
        return pulumi.get(self, "license_token")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of an existing Equinix Network Edge device
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        UUID of an existing Equinix Network Edge device
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="vendorConfigurations")
    def vendor_configurations(self) -> Sequence['outputs.GetNetworkDeviceClusterDetailNode1VendorConfigurationResult']:
        return pulumi.get(self, "vendor_configurations")


@pulumi.output_type
class GetNetworkDeviceClusterDetailNode1VendorConfigurationResult(dict):
    def __init__(__self__, *,
                 activation_key: str,
                 admin_password: str,
                 controller1: str,
                 controller_fqdn: str,
                 hostname: str,
                 root_password: str):
        pulumi.set(__self__, "activation_key", activation_key)
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "controller1", controller1)
        pulumi.set(__self__, "controller_fqdn", controller_fqdn)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "root_password", root_password)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> str:
        return pulumi.get(self, "activation_key")

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> str:
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter
    def controller1(self) -> str:
        return pulumi.get(self, "controller1")

    @property
    @pulumi.getter(name="controllerFqdn")
    def controller_fqdn(self) -> str:
        return pulumi.get(self, "controller_fqdn")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> str:
        return pulumi.get(self, "root_password")


@pulumi.output_type
class GetNetworkDeviceInterfaceResult(dict):
    def __init__(__self__, *,
                 assigned_type: str,
                 id: int,
                 ip_address: str,
                 mac_address: str,
                 name: str,
                 operational_status: str,
                 status: str,
                 type: str):
        """
        :param str name: Name of an existing Equinix Network Edge device
        :param str status: Device provisioning status
               * INITIALIZING
               * PROVISIONING
               * PROVISIONED  (**NOTE: By default data source will only return devices in this state.  To include other states see `valid_state_list`**)
               * WAITING_FOR_PRIMARY
               * WAITING_FOR_SECONDARY
               * WAITING_FOR_REPLICA_CLUSTER_NODES
               * CLUSTER_SETUP_IN_PROGRESS
               * FAILED
               * DEPROVISIONING
               * DEPROVISIONED
        """
        pulumi.set(__self__, "assigned_type", assigned_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operational_status", operational_status)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="assignedType")
    def assigned_type(self) -> str:
        return pulumi.get(self, "assigned_type")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of an existing Equinix Network Edge device
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationalStatus")
    def operational_status(self) -> str:
        return pulumi.get(self, "operational_status")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Device provisioning status
        * INITIALIZING
        * PROVISIONING
        * PROVISIONED  (**NOTE: By default data source will only return devices in this state.  To include other states see `valid_state_list`**)
        * WAITING_FOR_PRIMARY
        * WAITING_FOR_SECONDARY
        * WAITING_FOR_REPLICA_CLUSTER_NODES
        * CLUSTER_SETUP_IN_PROGRESS
        * FAILED
        * DEPROVISIONING
        * DEPROVISIONED
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkDeviceSecondaryDeviceResult(dict):
    def __init__(__self__, *,
                 account_number: str,
                 acl_template_id: str,
                 additional_bandwidth: int,
                 asn: int,
                 hostname: str,
                 ibx: str,
                 interfaces: Sequence['outputs.GetNetworkDeviceSecondaryDeviceInterfaceResult'],
                 license_file: str,
                 license_file_id: str,
                 license_status: str,
                 license_token: str,
                 metro_code: str,
                 mgmt_acl_template_uuid: str,
                 name: str,
                 notifications: Sequence[str],
                 redundancy_type: str,
                 redundant_id: str,
                 region: str,
                 ssh_ip_address: str,
                 ssh_ip_fqdn: str,
                 ssh_keys: Sequence['outputs.GetNetworkDeviceSecondaryDeviceSshKeyResult'],
                 status: str,
                 uuid: str,
                 vendor_configuration: Mapping[str, str],
                 wan_interface_id: str,
                 zone_code: str):
        """
        :param str acl_template_id: Unique identifier of applied ACL template
        :param int asn: Autonomous system number
        :param str ibx: Device location Equinix Business Exchange name
        :param Sequence['GetNetworkDeviceSecondaryDeviceInterfaceArgs'] interfaces: List of device interfaces
               * `interface.#.id` - interface identifier
               * `interface.#.name` - interface name
               * `interface.#.status` -  interface status (AVAILABLE, RESERVED, ASSIGNED)
               * `interface.#.operational_status` - interface operational status (up or down)
               * `interface.#.mac_address` - interface MAC address
               * `interface.#.ip_address` - interface IP address
               * `interface.#.assigned_type` - interface management type (Equinix Managed or empty)
               * `interface.#.type` - interface type
        :param str license_file_id: Unique identifier of applied license file
        :param str license_status: Device license registration status
               * APPLYING_LICENSE
               * REGISTERED
               * APPLIED
               * WAITING_FOR_CLUSTER_SETUP
               * REGISTRATION_FAILED
        :param str name: Name of an existing Equinix Network Edge device
        :param str redundancy_type: Device redundancy type applicable for HA devices, either
               primary or secondary
        :param str redundant_id: Unique identifier for a redundant device applicable for HA devices
        :param str region: Device location region
        :param str ssh_ip_address: IP address of SSH enabled interface on the device
        :param str ssh_ip_fqdn: FQDN of SSH enabled interface on the device
        :param str status: Device provisioning status
               * INITIALIZING
               * PROVISIONING
               * PROVISIONED  (**NOTE: By default data source will only return devices in this state.  To include other states see `valid_state_list`**)
               * WAITING_FOR_PRIMARY
               * WAITING_FOR_SECONDARY
               * WAITING_FOR_REPLICA_CLUSTER_NODES
               * CLUSTER_SETUP_IN_PROGRESS
               * FAILED
               * DEPROVISIONING
               * DEPROVISIONED
        :param str uuid: UUID of an existing Equinix Network Edge device
        :param str zone_code: Device location zone code
        """
        pulumi.set(__self__, "account_number", account_number)
        pulumi.set(__self__, "acl_template_id", acl_template_id)
        pulumi.set(__self__, "additional_bandwidth", additional_bandwidth)
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ibx", ibx)
        pulumi.set(__self__, "interfaces", interfaces)
        pulumi.set(__self__, "license_file", license_file)
        pulumi.set(__self__, "license_file_id", license_file_id)
        pulumi.set(__self__, "license_status", license_status)
        pulumi.set(__self__, "license_token", license_token)
        pulumi.set(__self__, "metro_code", metro_code)
        pulumi.set(__self__, "mgmt_acl_template_uuid", mgmt_acl_template_uuid)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "notifications", notifications)
        pulumi.set(__self__, "redundancy_type", redundancy_type)
        pulumi.set(__self__, "redundant_id", redundant_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "ssh_ip_address", ssh_ip_address)
        pulumi.set(__self__, "ssh_ip_fqdn", ssh_ip_fqdn)
        pulumi.set(__self__, "ssh_keys", ssh_keys)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "uuid", uuid)
        pulumi.set(__self__, "vendor_configuration", vendor_configuration)
        pulumi.set(__self__, "wan_interface_id", wan_interface_id)
        pulumi.set(__self__, "zone_code", zone_code)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> str:
        return pulumi.get(self, "account_number")

    @property
    @pulumi.getter(name="aclTemplateId")
    def acl_template_id(self) -> str:
        """
        Unique identifier of applied ACL template
        """
        return pulumi.get(self, "acl_template_id")

    @property
    @pulumi.getter(name="additionalBandwidth")
    def additional_bandwidth(self) -> int:
        return pulumi.get(self, "additional_bandwidth")

    @property
    @pulumi.getter
    def asn(self) -> int:
        """
        Autonomous system number
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ibx(self) -> str:
        """
        Device location Equinix Business Exchange name
        """
        return pulumi.get(self, "ibx")

    @property
    @pulumi.getter
    def interfaces(self) -> Sequence['outputs.GetNetworkDeviceSecondaryDeviceInterfaceResult']:
        """
        List of device interfaces
        * `interface.#.id` - interface identifier
        * `interface.#.name` - interface name
        * `interface.#.status` -  interface status (AVAILABLE, RESERVED, ASSIGNED)
        * `interface.#.operational_status` - interface operational status (up or down)
        * `interface.#.mac_address` - interface MAC address
        * `interface.#.ip_address` - interface IP address
        * `interface.#.assigned_type` - interface management type (Equinix Managed or empty)
        * `interface.#.type` - interface type
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter(name="licenseFile")
    def license_file(self) -> str:
        return pulumi.get(self, "license_file")

    @property
    @pulumi.getter(name="licenseFileId")
    def license_file_id(self) -> str:
        """
        Unique identifier of applied license file
        """
        return pulumi.get(self, "license_file_id")

    @property
    @pulumi.getter(name="licenseStatus")
    def license_status(self) -> str:
        """
        Device license registration status
        * APPLYING_LICENSE
        * REGISTERED
        * APPLIED
        * WAITING_FOR_CLUSTER_SETUP
        * REGISTRATION_FAILED
        """
        return pulumi.get(self, "license_status")

    @property
    @pulumi.getter(name="licenseToken")
    def license_token(self) -> str:
        return pulumi.get(self, "license_token")

    @property
    @pulumi.getter(name="metroCode")
    def metro_code(self) -> str:
        return pulumi.get(self, "metro_code")

    @property
    @pulumi.getter(name="mgmtAclTemplateUuid")
    def mgmt_acl_template_uuid(self) -> str:
        return pulumi.get(self, "mgmt_acl_template_uuid")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of an existing Equinix Network Edge device
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notifications(self) -> Sequence[str]:
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> str:
        """
        Device redundancy type applicable for HA devices, either
        primary or secondary
        """
        return pulumi.get(self, "redundancy_type")

    @property
    @pulumi.getter(name="redundantId")
    def redundant_id(self) -> str:
        """
        Unique identifier for a redundant device applicable for HA devices
        """
        return pulumi.get(self, "redundant_id")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Device location region
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sshIpAddress")
    def ssh_ip_address(self) -> str:
        """
        IP address of SSH enabled interface on the device
        """
        return pulumi.get(self, "ssh_ip_address")

    @property
    @pulumi.getter(name="sshIpFqdn")
    def ssh_ip_fqdn(self) -> str:
        """
        FQDN of SSH enabled interface on the device
        """
        return pulumi.get(self, "ssh_ip_fqdn")

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Sequence['outputs.GetNetworkDeviceSecondaryDeviceSshKeyResult']:
        return pulumi.get(self, "ssh_keys")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Device provisioning status
        * INITIALIZING
        * PROVISIONING
        * PROVISIONED  (**NOTE: By default data source will only return devices in this state.  To include other states see `valid_state_list`**)
        * WAITING_FOR_PRIMARY
        * WAITING_FOR_SECONDARY
        * WAITING_FOR_REPLICA_CLUSTER_NODES
        * CLUSTER_SETUP_IN_PROGRESS
        * FAILED
        * DEPROVISIONING
        * DEPROVISIONED
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        UUID of an existing Equinix Network Edge device
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="vendorConfiguration")
    def vendor_configuration(self) -> Mapping[str, str]:
        return pulumi.get(self, "vendor_configuration")

    @property
    @pulumi.getter(name="wanInterfaceId")
    def wan_interface_id(self) -> str:
        return pulumi.get(self, "wan_interface_id")

    @property
    @pulumi.getter(name="zoneCode")
    def zone_code(self) -> str:
        """
        Device location zone code
        """
        return pulumi.get(self, "zone_code")


@pulumi.output_type
class GetNetworkDeviceSecondaryDeviceInterfaceResult(dict):
    def __init__(__self__, *,
                 assigned_type: str,
                 id: int,
                 ip_address: str,
                 mac_address: str,
                 name: str,
                 operational_status: str,
                 status: str,
                 type: str):
        """
        :param str name: Name of an existing Equinix Network Edge device
        :param str status: Device provisioning status
               * INITIALIZING
               * PROVISIONING
               * PROVISIONED  (**NOTE: By default data source will only return devices in this state.  To include other states see `valid_state_list`**)
               * WAITING_FOR_PRIMARY
               * WAITING_FOR_SECONDARY
               * WAITING_FOR_REPLICA_CLUSTER_NODES
               * CLUSTER_SETUP_IN_PROGRESS
               * FAILED
               * DEPROVISIONING
               * DEPROVISIONED
        """
        pulumi.set(__self__, "assigned_type", assigned_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operational_status", operational_status)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="assignedType")
    def assigned_type(self) -> str:
        return pulumi.get(self, "assigned_type")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of an existing Equinix Network Edge device
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationalStatus")
    def operational_status(self) -> str:
        return pulumi.get(self, "operational_status")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Device provisioning status
        * INITIALIZING
        * PROVISIONING
        * PROVISIONED  (**NOTE: By default data source will only return devices in this state.  To include other states see `valid_state_list`**)
        * WAITING_FOR_PRIMARY
        * WAITING_FOR_SECONDARY
        * WAITING_FOR_REPLICA_CLUSTER_NODES
        * CLUSTER_SETUP_IN_PROGRESS
        * FAILED
        * DEPROVISIONING
        * DEPROVISIONED
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkDeviceSecondaryDeviceSshKeyResult(dict):
    def __init__(__self__, *,
                 key_name: str,
                 username: str):
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class GetNetworkDeviceSshKeyResult(dict):
    def __init__(__self__, *,
                 key_name: str,
                 username: str):
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class MetalConnectionPort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkStatus":
            suggest = "link_status"
        elif key == "virtualCircuitIds":
            suggest = "virtual_circuit_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetalConnectionPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetalConnectionPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetalConnectionPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 link_status: Optional[str] = None,
                 name: Optional[str] = None,
                 role: Optional[str] = None,
                 speed: Optional[int] = None,
                 status: Optional[str] = None,
                 virtual_circuit_ids: Optional[Sequence[Any]] = None):
        """
        :param str name: Name of the connection resource
        :param int speed: Connection speed - one of 50Mbps, 200Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps.
        :param str status: Status of the connection resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if link_status is not None:
            pulumi.set(__self__, "link_status", link_status)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if speed is not None:
            pulumi.set(__self__, "speed", speed)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if virtual_circuit_ids is not None:
            pulumi.set(__self__, "virtual_circuit_ids", virtual_circuit_ids)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="linkStatus")
    def link_status(self) -> Optional[str]:
        return pulumi.get(self, "link_status")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the connection resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def speed(self) -> Optional[int]:
        """
        Connection speed - one of 50Mbps, 200Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps.
        """
        return pulumi.get(self, "speed")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the connection resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="virtualCircuitIds")
    def virtual_circuit_ids(self) -> Optional[Sequence[Any]]:
        return pulumi.get(self, "virtual_circuit_ids")


@pulumi.output_type
class MetalConnectionServiceToken(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiresAt":
            suggest = "expires_at"
        elif key == "maxAllowedSpeed":
            suggest = "max_allowed_speed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetalConnectionServiceToken. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetalConnectionServiceToken.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetalConnectionServiceToken.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expires_at: Optional[str] = None,
                 id: Optional[str] = None,
                 max_allowed_speed: Optional[str] = None,
                 role: Optional[str] = None,
                 state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str type: Connection type - dedicated or shared.
        """
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if max_allowed_speed is not None:
            pulumi.set(__self__, "max_allowed_speed", max_allowed_speed)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[str]:
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxAllowedSpeed")
    def max_allowed_speed(self) -> Optional[str]:
        return pulumi.get(self, "max_allowed_speed")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Connection type - dedicated or shared.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MetalDeviceIpAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reservationIds":
            suggest = "reservation_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetalDeviceIpAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetalDeviceIpAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetalDeviceIpAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 cidr: Optional[int] = None,
                 reservation_ids: Optional[Sequence[str]] = None):
        """
        :param str type: One of `private_ipv4`, `public_ipv4`, `public_ipv6`.
        :param int cidr: CIDR suffix for IP address block to be assigned, i.e. amount of addresses.
        :param Sequence[str] reservation_ids: List of UUIDs of IP block reservations
               from which the public IPv4 address should be taken.
        """
        pulumi.set(__self__, "type", type)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if reservation_ids is not None:
            pulumi.set(__self__, "reservation_ids", reservation_ids)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        One of `private_ipv4`, `public_ipv4`, `public_ipv6`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def cidr(self) -> Optional[int]:
        """
        CIDR suffix for IP address block to be assigned, i.e. amount of addresses.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="reservationIds")
    def reservation_ids(self) -> Optional[Sequence[str]]:
        """
        List of UUIDs of IP block reservations
        from which the public IPv4 address should be taken.
        """
        return pulumi.get(self, "reservation_ids")


@pulumi.output_type
class MetalDeviceNetwork(dict):
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 cidr: Optional[int] = None,
                 family: Optional[int] = None,
                 gateway: Optional[str] = None,
                 public: Optional[bool] = None):
        """
        :param str address: IPv4 or IPv6 address string.
        :param int cidr: CIDR suffix for IP address block to be assigned, i.e. amount of addresses.
        :param int family: IP version. One of `4`, `6`.
        :param str gateway: Address of router.
        :param bool public: Whether the address is routable from the Internet.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if public is not None:
            pulumi.set(__self__, "public", public)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        IPv4 or IPv6 address string.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def cidr(self) -> Optional[int]:
        """
        CIDR suffix for IP address block to be assigned, i.e. amount of addresses.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def family(self) -> Optional[int]:
        """
        IP version. One of `4`, `6`.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def gateway(self) -> Optional[str]:
        """
        Address of router.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def public(self) -> Optional[bool]:
        """
        Whether the address is routable from the Internet.
        """
        return pulumi.get(self, "public")


@pulumi.output_type
class MetalDevicePort(dict):
    def __init__(__self__, *,
                 bonded: Optional[bool] = None,
                 id: Optional[str] = None,
                 mac: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param bool bonded: Whether this port is part of a bond in bonded network setup.
        :param str id: ID of the port.
        :param str mac: MAC address assigned to the port.
        :param str name: Name of the port (e.g. `eth0`, or `bond0`).
        :param str type: One of `private_ipv4`, `public_ipv4`, `public_ipv6`.
        """
        if bonded is not None:
            pulumi.set(__self__, "bonded", bonded)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def bonded(self) -> Optional[bool]:
        """
        Whether this port is part of a bond in bonded network setup.
        """
        return pulumi.get(self, "bonded")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of the port.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def mac(self) -> Optional[str]:
        """
        MAC address assigned to the port.
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the port (e.g. `eth0`, or `bond0`).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        One of `private_ipv4`, `public_ipv4`, `public_ipv6`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MetalDeviceReinstall(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deprovisionFast":
            suggest = "deprovision_fast"
        elif key == "preserveData":
            suggest = "preserve_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetalDeviceReinstall. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetalDeviceReinstall.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetalDeviceReinstall.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deprovision_fast: Optional[bool] = None,
                 enabled: Optional[bool] = None,
                 preserve_data: Optional[bool] = None):
        """
        :param bool deprovision_fast: Whether the OS disk should be filled with `00h` bytes before reinstall.
               Defaults to `false`.
        :param bool enabled: Whether the provider should favour reinstall over destroy and create. Defaults to
               `false`.
        :param bool preserve_data: Whether the non-OS disks should be kept or wiped during reinstall.
               Defaults to `false`.
        """
        if deprovision_fast is not None:
            pulumi.set(__self__, "deprovision_fast", deprovision_fast)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if preserve_data is not None:
            pulumi.set(__self__, "preserve_data", preserve_data)

    @property
    @pulumi.getter(name="deprovisionFast")
    def deprovision_fast(self) -> Optional[bool]:
        """
        Whether the OS disk should be filled with `00h` bytes before reinstall.
        Defaults to `false`.
        """
        return pulumi.get(self, "deprovision_fast")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether the provider should favour reinstall over destroy and create. Defaults to
        `false`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="preserveData")
    def preserve_data(self) -> Optional[bool]:
        """
        Whether the non-OS disks should be kept or wiped during reinstall.
        Defaults to `false`.
        """
        return pulumi.get(self, "preserve_data")


@pulumi.output_type
class MetalOrganizationAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "zipCode":
            suggest = "zip_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetalOrganizationAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetalOrganizationAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetalOrganizationAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 city: str,
                 country: str,
                 zip_code: str,
                 state: Optional[str] = None):
        """
        :param str address: Postal address.
        :param str city: City name.
        :param str country: Two letter country code (ISO 3166-1 alpha-2), e.g. US.
        :param str zip_code: Zip Code.
        :param str state: State name.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "zip_code", zip_code)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Postal address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def city(self) -> str:
        """
        City name.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def country(self) -> str:
        """
        Two letter country code (ISO 3166-1 alpha-2), e.g. US.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> str:
        """
        Zip Code.
        """
        return pulumi.get(self, "zip_code")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        State name.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MetalProjectBgpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentType":
            suggest = "deployment_type"
        elif key == "maxPrefix":
            suggest = "max_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetalProjectBgpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetalProjectBgpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetalProjectBgpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asn: int,
                 deployment_type: str,
                 max_prefix: Optional[int] = None,
                 md5: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param int asn: Autonomous System Number for local BGP deployment.
        :param str deployment_type: `private` or `public`, the `private` is likely to be usable immediately, the
               `public` will need to be reviewed by Equinix Metal engineers.
        :param int max_prefix: The maximum number of route filters allowed per server.
        :param str md5: Password for BGP session in plaintext (not a checksum).
        :param str status: status of BGP configuration in the project.
        """
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "deployment_type", deployment_type)
        if max_prefix is not None:
            pulumi.set(__self__, "max_prefix", max_prefix)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def asn(self) -> int:
        """
        Autonomous System Number for local BGP deployment.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        `private` or `public`, the `private` is likely to be usable immediately, the
        `public` will need to be reviewed by Equinix Metal engineers.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="maxPrefix")
    def max_prefix(self) -> Optional[int]:
        """
        The maximum number of route filters allowed per server.
        """
        return pulumi.get(self, "max_prefix")

    @property
    @pulumi.getter
    def md5(self) -> Optional[str]:
        """
        Password for BGP session in plaintext (not a checksum).
        """
        return pulumi.get(self, "md5")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        status of BGP configuration in the project.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class MetalSpotMarketRequestInstanceParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "billingCycle":
            suggest = "billing_cycle"
        elif key == "operatingSystem":
            suggest = "operating_system"
        elif key == "alwaysPxe":
            suggest = "always_pxe"
        elif key == "ipxeScriptUrl":
            suggest = "ipxe_script_url"
        elif key == "projectSshKeys":
            suggest = "project_ssh_keys"
        elif key == "termintationTime":
            suggest = "termintation_time"
        elif key == "userSshKeys":
            suggest = "user_ssh_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetalSpotMarketRequestInstanceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetalSpotMarketRequestInstanceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetalSpotMarketRequestInstanceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 billing_cycle: str,
                 hostname: str,
                 operating_system: str,
                 plan: str,
                 always_pxe: Optional[bool] = None,
                 customdata: Optional[str] = None,
                 description: Optional[str] = None,
                 features: Optional[Sequence[str]] = None,
                 ipxe_script_url: Optional[str] = None,
                 locked: Optional[bool] = None,
                 project_ssh_keys: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None,
                 termintation_time: Optional[str] = None,
                 user_ssh_keys: Optional[Sequence[str]] = None,
                 userdata: Optional[str] = None):
        """
        :param bool locked: Blocks deletion of the SpotMarketRequest device until the lock is disabled.
        """
        pulumi.set(__self__, "billing_cycle", billing_cycle)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "operating_system", operating_system)
        pulumi.set(__self__, "plan", plan)
        if always_pxe is not None:
            pulumi.set(__self__, "always_pxe", always_pxe)
        if customdata is not None:
            pulumi.set(__self__, "customdata", customdata)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if ipxe_script_url is not None:
            pulumi.set(__self__, "ipxe_script_url", ipxe_script_url)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if project_ssh_keys is not None:
            pulumi.set(__self__, "project_ssh_keys", project_ssh_keys)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termintation_time is not None:
            pulumi.set(__self__, "termintation_time", termintation_time)
        if user_ssh_keys is not None:
            pulumi.set(__self__, "user_ssh_keys", user_ssh_keys)
        if userdata is not None:
            pulumi.set(__self__, "userdata", userdata)

    @property
    @pulumi.getter(name="billingCycle")
    def billing_cycle(self) -> str:
        return pulumi.get(self, "billing_cycle")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> str:
        return pulumi.get(self, "operating_system")

    @property
    @pulumi.getter
    def plan(self) -> str:
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="alwaysPxe")
    def always_pxe(self) -> Optional[bool]:
        return pulumi.get(self, "always_pxe")

    @property
    @pulumi.getter
    def customdata(self) -> Optional[str]:
        return pulumi.get(self, "customdata")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def features(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="ipxeScriptUrl")
    def ipxe_script_url(self) -> Optional[str]:
        return pulumi.get(self, "ipxe_script_url")

    @property
    @pulumi.getter
    def locked(self) -> Optional[bool]:
        """
        Blocks deletion of the SpotMarketRequest device until the lock is disabled.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter(name="projectSshKeys")
    def project_ssh_keys(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "project_ssh_keys")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="termintationTime")
    def termintation_time(self) -> Optional[str]:
        return pulumi.get(self, "termintation_time")

    @property
    @pulumi.getter(name="userSshKeys")
    def user_ssh_keys(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "user_ssh_keys")

    @property
    @pulumi.getter
    def userdata(self) -> Optional[str]:
        return pulumi.get(self, "userdata")


@pulumi.output_type
class NetworkACLTemplateDeviceDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aclStatus":
            suggest = "acl_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkACLTemplateDeviceDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkACLTemplateDeviceDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkACLTemplateDeviceDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acl_status: Optional[str] = None,
                 name: Optional[str] = None,
                 uuid: Optional[str] = None):
        """
        :param str acl_status: Device ACL provisioning status where template was applied. One of `PROVISIONING`,
               `PROVISIONED`.
        :param str name: ACL template name.
        :param str uuid: Device uuid.
        """
        if acl_status is not None:
            pulumi.set(__self__, "acl_status", acl_status)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="aclStatus")
    def acl_status(self) -> Optional[str]:
        """
        Device ACL provisioning status where template was applied. One of `PROVISIONING`,
        `PROVISIONED`.
        """
        return pulumi.get(self, "acl_status")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        ACL template name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[str]:
        """
        Device uuid.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class NetworkACLTemplateInboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dstPort":
            suggest = "dst_port"
        elif key == "srcPort":
            suggest = "src_port"
        elif key == "sequenceNumber":
            suggest = "sequence_number"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkACLTemplateInboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkACLTemplateInboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkACLTemplateInboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dst_port: str,
                 protocol: str,
                 src_port: str,
                 sequence_number: Optional[int] = None,
                 source_type: Optional[str] = None,
                 subnet: Optional[str] = None,
                 subnets: Optional[Sequence[str]] = None):
        """
        :param str dst_port: Inbound traffic destination ports. Allowed values are a comma separated
               list of ports, e.g., `20,22,23`, port range, e.g., `1023-1040` or word `any`.
        :param str protocol: Inbound traffic protocol. One of `IP`, `TCP`, `UDP`.
        :param str src_port: Inbound traffic source ports. Allowed values are a comma separated list
               of ports, e.g., `20,22,23`, port range, e.g., `1023-1040` or word `any`.
        :param str subnet: Inbound traffic source IP subnet in CIDR format.
        :param Sequence[str] subnets: Inbound traffic source IP subnets in CIDR format.
        """
        pulumi.set(__self__, "dst_port", dst_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "src_port", src_port)
        if sequence_number is not None:
            pulumi.set(__self__, "sequence_number", sequence_number)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> str:
        """
        Inbound traffic destination ports. Allowed values are a comma separated
        list of ports, e.g., `20,22,23`, port range, e.g., `1023-1040` or word `any`.
        """
        return pulumi.get(self, "dst_port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Inbound traffic protocol. One of `IP`, `TCP`, `UDP`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> str:
        """
        Inbound traffic source ports. Allowed values are a comma separated list
        of ports, e.g., `20,22,23`, port range, e.g., `1023-1040` or word `any`.
        """
        return pulumi.get(self, "src_port")

    @property
    @pulumi.getter(name="sequenceNumber")
    def sequence_number(self) -> Optional[int]:
        return pulumi.get(self, "sequence_number")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[str]:
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def subnet(self) -> Optional[str]:
        """
        Inbound traffic source IP subnet in CIDR format.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def subnets(self) -> Optional[Sequence[str]]:
        """
        Inbound traffic source IP subnets in CIDR format.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class NetworkDeviceClusterDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"
        elif key == "clusterId":
            suggest = "cluster_id"
        elif key == "numOfNodes":
            suggest = "num_of_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceClusterDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceClusterDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceClusterDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_name: str,
                 node0: 'outputs.NetworkDeviceClusterDetailsNode0',
                 node1: 'outputs.NetworkDeviceClusterDetailsNode1',
                 cluster_id: Optional[str] = None,
                 num_of_nodes: Optional[int] = None):
        """
        :param str cluster_name: The name of the cluster device
        :param 'NetworkDeviceClusterDetailsNode0Args' node0: An object that has `node0` configuration.
               See Cluster Details - Nodes below for more details.
        :param 'NetworkDeviceClusterDetailsNode1Args' node1: An object that has `node1` configuration.
               See Cluster Details - Nodes below for more details.
        :param str cluster_id: The ID of the cluster.
        :param int num_of_nodes: The number of nodes in the cluster.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "node0", node0)
        pulumi.set(__self__, "node1", node1)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if num_of_nodes is not None:
            pulumi.set(__self__, "num_of_nodes", num_of_nodes)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        The name of the cluster device
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def node0(self) -> 'outputs.NetworkDeviceClusterDetailsNode0':
        """
        An object that has `node0` configuration.
        See Cluster Details - Nodes below for more details.
        """
        return pulumi.get(self, "node0")

    @property
    @pulumi.getter
    def node1(self) -> 'outputs.NetworkDeviceClusterDetailsNode1':
        """
        An object that has `node1` configuration.
        See Cluster Details - Nodes below for more details.
        """
        return pulumi.get(self, "node1")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[str]:
        """
        The ID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="numOfNodes")
    def num_of_nodes(self) -> Optional[int]:
        """
        The number of nodes in the cluster.
        """
        return pulumi.get(self, "num_of_nodes")


@pulumi.output_type
class NetworkDeviceClusterDetailsNode0(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "licenseFileId":
            suggest = "license_file_id"
        elif key == "licenseToken":
            suggest = "license_token"
        elif key == "vendorConfiguration":
            suggest = "vendor_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceClusterDetailsNode0. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceClusterDetailsNode0.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceClusterDetailsNode0.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 license_file_id: Optional[str] = None,
                 license_token: Optional[str] = None,
                 name: Optional[str] = None,
                 uuid: Optional[str] = None,
                 vendor_configuration: Optional['outputs.NetworkDeviceClusterDetailsNode0VendorConfiguration'] = None):
        """
        :param str license_file_id: License file id. This is necessary for Fortinet and Juniper clusters.
        :param str license_token: License token. This is necessary for Palo Alto clusters.
        :param str name: Device name.
        :param str uuid: Device unique identifier.
        :param 'NetworkDeviceClusterDetailsNode0VendorConfigurationArgs' vendor_configuration: An object that has fields relevant to the vendor of the
               cluster device. See Cluster Details - Nodes - Vendor Configuration
               below for more details.
        """
        if license_file_id is not None:
            pulumi.set(__self__, "license_file_id", license_file_id)
        if license_token is not None:
            pulumi.set(__self__, "license_token", license_token)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if vendor_configuration is not None:
            pulumi.set(__self__, "vendor_configuration", vendor_configuration)

    @property
    @pulumi.getter(name="licenseFileId")
    def license_file_id(self) -> Optional[str]:
        """
        License file id. This is necessary for Fortinet and Juniper clusters.
        """
        return pulumi.get(self, "license_file_id")

    @property
    @pulumi.getter(name="licenseToken")
    def license_token(self) -> Optional[str]:
        """
        License token. This is necessary for Palo Alto clusters.
        """
        return pulumi.get(self, "license_token")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Device name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[str]:
        """
        Device unique identifier.
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="vendorConfiguration")
    def vendor_configuration(self) -> Optional['outputs.NetworkDeviceClusterDetailsNode0VendorConfiguration']:
        """
        An object that has fields relevant to the vendor of the
        cluster device. See Cluster Details - Nodes - Vendor Configuration
        below for more details.
        """
        return pulumi.get(self, "vendor_configuration")


@pulumi.output_type
class NetworkDeviceClusterDetailsNode0VendorConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activationKey":
            suggest = "activation_key"
        elif key == "adminPassword":
            suggest = "admin_password"
        elif key == "controllerFqdn":
            suggest = "controller_fqdn"
        elif key == "rootPassword":
            suggest = "root_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceClusterDetailsNode0VendorConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceClusterDetailsNode0VendorConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceClusterDetailsNode0VendorConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activation_key: Optional[str] = None,
                 admin_password: Optional[str] = None,
                 controller1: Optional[str] = None,
                 controller_fqdn: Optional[str] = None,
                 hostname: Optional[str] = None,
                 root_password: Optional[str] = None):
        """
        :param str activation_key: Activation key. This is required for Velocloud clusters.
        :param str admin_password: The administrative password of the device. You can use it to log in
               to the console. This field is not available for all device types.
        :param str controller1: System IP Address. Mandatory for the Fortinet SDWAN cluster device.
        :param str controller_fqdn: Controller fqdn. This is required for Velocloud clusters.
        :param str hostname: Hostname. This is necessary for Palo Alto, Juniper, and Fortinet clusters.
        :param str root_password: The CLI password of the device. This field is relevant only for the
               Velocloud SDWAN cluster.
        """
        if activation_key is not None:
            pulumi.set(__self__, "activation_key", activation_key)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if controller1 is not None:
            pulumi.set(__self__, "controller1", controller1)
        if controller_fqdn is not None:
            pulumi.set(__self__, "controller_fqdn", controller_fqdn)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> Optional[str]:
        """
        Activation key. This is required for Velocloud clusters.
        """
        return pulumi.get(self, "activation_key")

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[str]:
        """
        The administrative password of the device. You can use it to log in
        to the console. This field is not available for all device types.
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter
    def controller1(self) -> Optional[str]:
        """
        System IP Address. Mandatory for the Fortinet SDWAN cluster device.
        """
        return pulumi.get(self, "controller1")

    @property
    @pulumi.getter(name="controllerFqdn")
    def controller_fqdn(self) -> Optional[str]:
        """
        Controller fqdn. This is required for Velocloud clusters.
        """
        return pulumi.get(self, "controller_fqdn")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Hostname. This is necessary for Palo Alto, Juniper, and Fortinet clusters.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[str]:
        """
        The CLI password of the device. This field is relevant only for the
        Velocloud SDWAN cluster.
        """
        return pulumi.get(self, "root_password")


@pulumi.output_type
class NetworkDeviceClusterDetailsNode1(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "licenseFileId":
            suggest = "license_file_id"
        elif key == "licenseToken":
            suggest = "license_token"
        elif key == "vendorConfiguration":
            suggest = "vendor_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceClusterDetailsNode1. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceClusterDetailsNode1.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceClusterDetailsNode1.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 license_file_id: Optional[str] = None,
                 license_token: Optional[str] = None,
                 name: Optional[str] = None,
                 uuid: Optional[str] = None,
                 vendor_configuration: Optional['outputs.NetworkDeviceClusterDetailsNode1VendorConfiguration'] = None):
        """
        :param str license_file_id: License file id. This is necessary for Fortinet and Juniper clusters.
        :param str license_token: License token. This is necessary for Palo Alto clusters.
        :param str name: Device name.
        :param str uuid: Device unique identifier.
        :param 'NetworkDeviceClusterDetailsNode1VendorConfigurationArgs' vendor_configuration: An object that has fields relevant to the vendor of the
               cluster device. See Cluster Details - Nodes - Vendor Configuration
               below for more details.
        """
        if license_file_id is not None:
            pulumi.set(__self__, "license_file_id", license_file_id)
        if license_token is not None:
            pulumi.set(__self__, "license_token", license_token)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if vendor_configuration is not None:
            pulumi.set(__self__, "vendor_configuration", vendor_configuration)

    @property
    @pulumi.getter(name="licenseFileId")
    def license_file_id(self) -> Optional[str]:
        """
        License file id. This is necessary for Fortinet and Juniper clusters.
        """
        return pulumi.get(self, "license_file_id")

    @property
    @pulumi.getter(name="licenseToken")
    def license_token(self) -> Optional[str]:
        """
        License token. This is necessary for Palo Alto clusters.
        """
        return pulumi.get(self, "license_token")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Device name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[str]:
        """
        Device unique identifier.
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="vendorConfiguration")
    def vendor_configuration(self) -> Optional['outputs.NetworkDeviceClusterDetailsNode1VendorConfiguration']:
        """
        An object that has fields relevant to the vendor of the
        cluster device. See Cluster Details - Nodes - Vendor Configuration
        below for more details.
        """
        return pulumi.get(self, "vendor_configuration")


@pulumi.output_type
class NetworkDeviceClusterDetailsNode1VendorConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activationKey":
            suggest = "activation_key"
        elif key == "adminPassword":
            suggest = "admin_password"
        elif key == "controllerFqdn":
            suggest = "controller_fqdn"
        elif key == "rootPassword":
            suggest = "root_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceClusterDetailsNode1VendorConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceClusterDetailsNode1VendorConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceClusterDetailsNode1VendorConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activation_key: Optional[str] = None,
                 admin_password: Optional[str] = None,
                 controller1: Optional[str] = None,
                 controller_fqdn: Optional[str] = None,
                 hostname: Optional[str] = None,
                 root_password: Optional[str] = None):
        """
        :param str activation_key: Activation key. This is required for Velocloud clusters.
        :param str admin_password: The administrative password of the device. You can use it to log in
               to the console. This field is not available for all device types.
        :param str controller1: System IP Address. Mandatory for the Fortinet SDWAN cluster device.
        :param str controller_fqdn: Controller fqdn. This is required for Velocloud clusters.
        :param str hostname: Hostname. This is necessary for Palo Alto, Juniper, and Fortinet clusters.
        :param str root_password: The CLI password of the device. This field is relevant only for the
               Velocloud SDWAN cluster.
        """
        if activation_key is not None:
            pulumi.set(__self__, "activation_key", activation_key)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if controller1 is not None:
            pulumi.set(__self__, "controller1", controller1)
        if controller_fqdn is not None:
            pulumi.set(__self__, "controller_fqdn", controller_fqdn)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> Optional[str]:
        """
        Activation key. This is required for Velocloud clusters.
        """
        return pulumi.get(self, "activation_key")

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[str]:
        """
        The administrative password of the device. You can use it to log in
        to the console. This field is not available for all device types.
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter
    def controller1(self) -> Optional[str]:
        """
        System IP Address. Mandatory for the Fortinet SDWAN cluster device.
        """
        return pulumi.get(self, "controller1")

    @property
    @pulumi.getter(name="controllerFqdn")
    def controller_fqdn(self) -> Optional[str]:
        """
        Controller fqdn. This is required for Velocloud clusters.
        """
        return pulumi.get(self, "controller_fqdn")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Hostname. This is necessary for Palo Alto, Juniper, and Fortinet clusters.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[str]:
        """
        The CLI password of the device. This field is relevant only for the
        Velocloud SDWAN cluster.
        """
        return pulumi.get(self, "root_password")


@pulumi.output_type
class NetworkDeviceInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignedType":
            suggest = "assigned_type"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "operationalStatus":
            suggest = "operational_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assigned_type: Optional[str] = None,
                 id: Optional[int] = None,
                 ip_address: Optional[str] = None,
                 mac_address: Optional[str] = None,
                 name: Optional[str] = None,
                 operational_status: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str assigned_type: interface management type (Equinix Managed or empty).
        :param int id: interface identifier.
        :param str ip_address: interface IP address.
        :param str mac_address: interface MAC address.
        :param str name: Device name.
        :param str operational_status: interface operational status. One of `up`, `down`.
        :param str status: interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        :param str type: interface type.
        """
        if assigned_type is not None:
            pulumi.set(__self__, "assigned_type", assigned_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operational_status is not None:
            pulumi.set(__self__, "operational_status", operational_status)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="assignedType")
    def assigned_type(self) -> Optional[str]:
        """
        interface management type (Equinix Managed or empty).
        """
        return pulumi.get(self, "assigned_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[int]:
        """
        interface identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        interface IP address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[str]:
        """
        interface MAC address.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Device name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationalStatus")
    def operational_status(self) -> Optional[str]:
        """
        interface operational status. One of `up`, `down`.
        """
        return pulumi.get(self, "operational_status")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        interface type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NetworkDeviceLinkDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "interfaceId":
            suggest = "interface_id"
        elif key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceLinkDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceLinkDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceLinkDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 asn: Optional[int] = None,
                 interface_id: Optional[int] = None,
                 ip_address: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str id: Device identifier.
        :param int asn: Device ASN number. Not required for self configured devices.
        :param int interface_id: Device network interface identifier to use for device link
               connection.
        :param str ip_address: IP address from device link subnet that was assigned to the device
        :param str status: device link provisioning status on a given device. One of `PROVISIONING`,
               `PROVISIONED`, `DEPROVISIONING`, `DEPROVISIONED`, `FAILED`.
        """
        pulumi.set(__self__, "id", id)
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if interface_id is not None:
            pulumi.set(__self__, "interface_id", interface_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Device identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def asn(self) -> Optional[int]:
        """
        Device ASN number. Not required for self configured devices.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> Optional[int]:
        """
        Device network interface identifier to use for device link
        connection.
        """
        return pulumi.get(self, "interface_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        IP address from device link subnet that was assigned to the device
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        device link provisioning status on a given device. One of `PROVISIONING`,
        `PROVISIONED`, `DEPROVISIONING`, `DEPROVISIONED`, `FAILED`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NetworkDeviceLinkLink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountNumber":
            suggest = "account_number"
        elif key == "dstMetroCode":
            suggest = "dst_metro_code"
        elif key == "srcMetroCode":
            suggest = "src_metro_code"
        elif key == "throughputUnit":
            suggest = "throughput_unit"
        elif key == "dstZoneCode":
            suggest = "dst_zone_code"
        elif key == "srcZoneCode":
            suggest = "src_zone_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceLinkLink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceLinkLink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceLinkLink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_number: str,
                 dst_metro_code: str,
                 src_metro_code: str,
                 throughput: str,
                 throughput_unit: str,
                 dst_zone_code: Optional[str] = None,
                 src_zone_code: Optional[str] = None):
        """
        :param str account_number: billing account number to be used for
               connection charges
        :param str dst_metro_code: connection destination metro code.
        :param str src_metro_code: connection source metro code.
        :param str throughput: connection throughput.
        :param str throughput_unit: connection throughput unit (Mbps or Gbps).
        :param str dst_zone_code: connection destination zone code is not required.
        :param str src_zone_code: connection source zone code is not required.
        """
        pulumi.set(__self__, "account_number", account_number)
        pulumi.set(__self__, "dst_metro_code", dst_metro_code)
        pulumi.set(__self__, "src_metro_code", src_metro_code)
        pulumi.set(__self__, "throughput", throughput)
        pulumi.set(__self__, "throughput_unit", throughput_unit)
        if dst_zone_code is not None:
            pulumi.set(__self__, "dst_zone_code", dst_zone_code)
        if src_zone_code is not None:
            pulumi.set(__self__, "src_zone_code", src_zone_code)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> str:
        """
        billing account number to be used for
        connection charges
        """
        return pulumi.get(self, "account_number")

    @property
    @pulumi.getter(name="dstMetroCode")
    def dst_metro_code(self) -> str:
        """
        connection destination metro code.
        """
        return pulumi.get(self, "dst_metro_code")

    @property
    @pulumi.getter(name="srcMetroCode")
    def src_metro_code(self) -> str:
        """
        connection source metro code.
        """
        return pulumi.get(self, "src_metro_code")

    @property
    @pulumi.getter
    def throughput(self) -> str:
        """
        connection throughput.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="throughputUnit")
    def throughput_unit(self) -> str:
        """
        connection throughput unit (Mbps or Gbps).
        """
        return pulumi.get(self, "throughput_unit")

    @property
    @pulumi.getter(name="dstZoneCode")
    def dst_zone_code(self) -> Optional[str]:
        """
        connection destination zone code is not required.
        """
        return pulumi.get(self, "dst_zone_code")

    @property
    @pulumi.getter(name="srcZoneCode")
    def src_zone_code(self) -> Optional[str]:
        """
        connection source zone code is not required.
        """
        return pulumi.get(self, "src_zone_code")


@pulumi.output_type
class NetworkDeviceSecondaryDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountNumber":
            suggest = "account_number"
        elif key == "metroCode":
            suggest = "metro_code"
        elif key == "aclTemplateId":
            suggest = "acl_template_id"
        elif key == "additionalBandwidth":
            suggest = "additional_bandwidth"
        elif key == "licenseFile":
            suggest = "license_file"
        elif key == "licenseFileId":
            suggest = "license_file_id"
        elif key == "licenseStatus":
            suggest = "license_status"
        elif key == "licenseToken":
            suggest = "license_token"
        elif key == "mgmtAclTemplateUuid":
            suggest = "mgmt_acl_template_uuid"
        elif key == "redundancyType":
            suggest = "redundancy_type"
        elif key == "redundantId":
            suggest = "redundant_id"
        elif key == "sshIpAddress":
            suggest = "ssh_ip_address"
        elif key == "sshIpFqdn":
            suggest = "ssh_ip_fqdn"
        elif key == "sshKey":
            suggest = "ssh_key"
        elif key == "vendorConfiguration":
            suggest = "vendor_configuration"
        elif key == "wanInterfaceId":
            suggest = "wan_interface_id"
        elif key == "zoneCode":
            suggest = "zone_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceSecondaryDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceSecondaryDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceSecondaryDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_number: str,
                 metro_code: str,
                 name: str,
                 notifications: Sequence[str],
                 acl_template_id: Optional[str] = None,
                 additional_bandwidth: Optional[int] = None,
                 asn: Optional[int] = None,
                 hostname: Optional[str] = None,
                 ibx: Optional[str] = None,
                 interfaces: Optional[Sequence['outputs.NetworkDeviceSecondaryDeviceInterface']] = None,
                 license_file: Optional[str] = None,
                 license_file_id: Optional[str] = None,
                 license_status: Optional[str] = None,
                 license_token: Optional[str] = None,
                 mgmt_acl_template_uuid: Optional[str] = None,
                 redundancy_type: Optional[str] = None,
                 redundant_id: Optional[str] = None,
                 region: Optional[str] = None,
                 ssh_ip_address: Optional[str] = None,
                 ssh_ip_fqdn: Optional[str] = None,
                 ssh_key: Optional['outputs.NetworkDeviceSecondaryDeviceSshKey'] = None,
                 status: Optional[str] = None,
                 uuid: Optional[str] = None,
                 vendor_configuration: Optional[Mapping[str, str]] = None,
                 wan_interface_id: Optional[str] = None,
                 zone_code: Optional[str] = None):
        """
        :param str account_number: Billing account number for secondary device.
        :param str metro_code: Metro location of a secondary device.
        :param str name: Secondary device name.
        :param Sequence[str] notifications: List of email addresses that will receive notifications about
               secondary device.
        :param str acl_template_id: Identifier of a WAN interface ACL template that will be applied
               on a secondary device.
        :param int additional_bandwidth: Additional Internet bandwidth, in Mbps, for a secondary
               device.
        :param int asn: (Autonomous System Number) Unique identifier for a network on the internet.
        :param str hostname: Secondary device hostname.
        :param str ibx: Device location Equinix Business Exchange name.
        :param Sequence['NetworkDeviceSecondaryDeviceInterfaceArgs'] interfaces: List of device interfaces. See Interface Attribute below
               for more details.
        :param str license_file: Path to the license file that will be uploaded and applied on a
               secondary device. Applicable for some devices types in BYOL licensing mode.
        :param str license_file_id: License file id. This is necessary for Fortinet and Juniper clusters.
        :param str license_status: Device license registration status. Possible values are `APPLYING_LICENSE`,
               `REGISTERED`, `APPLIED`, `WAITING_FOR_CLUSTER_SETUP`, `REGISTRATION_FAILED`.
        :param str license_token: License Token can be provided for some device types o the device.
        :param str mgmt_acl_template_uuid: Identifier of an MGMT interface ACL template that will be
               applied on the device.
               * `ssh-key` - (Optional) Up to one definition of SSH key that will be provisioned on a secondary
               device.
        :param str redundancy_type: Device redundancy type applicable for HA devices, either
               primary or secondary.
        :param str redundant_id: Unique identifier for a redundant device applicable for HA devices.
        :param str region: Device location region.
        :param str ssh_ip_address: IP address of SSH enabled interface on the device.
        :param str ssh_ip_fqdn: FQDN of SSH enabled interface on the device.
        :param str status: interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        :param str uuid: Device unique identifier.
        :param Mapping[str, str] vendor_configuration: Key/Value pairs of vendor specific configuration parameters
               for a secondary device. Key values are `controller1`, `activationKey`, `managementType`, `siteId`,
               `systemIpAddress`.
        :param str zone_code: Device location zone code.
        """
        pulumi.set(__self__, "account_number", account_number)
        pulumi.set(__self__, "metro_code", metro_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "notifications", notifications)
        if acl_template_id is not None:
            pulumi.set(__self__, "acl_template_id", acl_template_id)
        if additional_bandwidth is not None:
            pulumi.set(__self__, "additional_bandwidth", additional_bandwidth)
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ibx is not None:
            pulumi.set(__self__, "ibx", ibx)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if license_file is not None:
            pulumi.set(__self__, "license_file", license_file)
        if license_file_id is not None:
            pulumi.set(__self__, "license_file_id", license_file_id)
        if license_status is not None:
            pulumi.set(__self__, "license_status", license_status)
        if license_token is not None:
            pulumi.set(__self__, "license_token", license_token)
        if mgmt_acl_template_uuid is not None:
            pulumi.set(__self__, "mgmt_acl_template_uuid", mgmt_acl_template_uuid)
        if redundancy_type is not None:
            pulumi.set(__self__, "redundancy_type", redundancy_type)
        if redundant_id is not None:
            pulumi.set(__self__, "redundant_id", redundant_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if ssh_ip_address is not None:
            pulumi.set(__self__, "ssh_ip_address", ssh_ip_address)
        if ssh_ip_fqdn is not None:
            pulumi.set(__self__, "ssh_ip_fqdn", ssh_ip_fqdn)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if vendor_configuration is not None:
            pulumi.set(__self__, "vendor_configuration", vendor_configuration)
        if wan_interface_id is not None:
            pulumi.set(__self__, "wan_interface_id", wan_interface_id)
        if zone_code is not None:
            pulumi.set(__self__, "zone_code", zone_code)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> str:
        """
        Billing account number for secondary device.
        """
        return pulumi.get(self, "account_number")

    @property
    @pulumi.getter(name="metroCode")
    def metro_code(self) -> str:
        """
        Metro location of a secondary device.
        """
        return pulumi.get(self, "metro_code")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Secondary device name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notifications(self) -> Sequence[str]:
        """
        List of email addresses that will receive notifications about
        secondary device.
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter(name="aclTemplateId")
    def acl_template_id(self) -> Optional[str]:
        """
        Identifier of a WAN interface ACL template that will be applied
        on a secondary device.
        """
        return pulumi.get(self, "acl_template_id")

    @property
    @pulumi.getter(name="additionalBandwidth")
    def additional_bandwidth(self) -> Optional[int]:
        """
        Additional Internet bandwidth, in Mbps, for a secondary
        device.
        """
        return pulumi.get(self, "additional_bandwidth")

    @property
    @pulumi.getter
    def asn(self) -> Optional[int]:
        """
        (Autonomous System Number) Unique identifier for a network on the internet.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Secondary device hostname.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ibx(self) -> Optional[str]:
        """
        Device location Equinix Business Exchange name.
        """
        return pulumi.get(self, "ibx")

    @property
    @pulumi.getter
    def interfaces(self) -> Optional[Sequence['outputs.NetworkDeviceSecondaryDeviceInterface']]:
        """
        List of device interfaces. See Interface Attribute below
        for more details.
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter(name="licenseFile")
    def license_file(self) -> Optional[str]:
        """
        Path to the license file that will be uploaded and applied on a
        secondary device. Applicable for some devices types in BYOL licensing mode.
        """
        return pulumi.get(self, "license_file")

    @property
    @pulumi.getter(name="licenseFileId")
    def license_file_id(self) -> Optional[str]:
        """
        License file id. This is necessary for Fortinet and Juniper clusters.
        """
        return pulumi.get(self, "license_file_id")

    @property
    @pulumi.getter(name="licenseStatus")
    def license_status(self) -> Optional[str]:
        """
        Device license registration status. Possible values are `APPLYING_LICENSE`,
        `REGISTERED`, `APPLIED`, `WAITING_FOR_CLUSTER_SETUP`, `REGISTRATION_FAILED`.
        """
        return pulumi.get(self, "license_status")

    @property
    @pulumi.getter(name="licenseToken")
    def license_token(self) -> Optional[str]:
        """
        License Token can be provided for some device types o the device.
        """
        return pulumi.get(self, "license_token")

    @property
    @pulumi.getter(name="mgmtAclTemplateUuid")
    def mgmt_acl_template_uuid(self) -> Optional[str]:
        """
        Identifier of an MGMT interface ACL template that will be
        applied on the device.
        * `ssh-key` - (Optional) Up to one definition of SSH key that will be provisioned on a secondary
        device.
        """
        return pulumi.get(self, "mgmt_acl_template_uuid")

    @property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> Optional[str]:
        """
        Device redundancy type applicable for HA devices, either
        primary or secondary.
        """
        return pulumi.get(self, "redundancy_type")

    @property
    @pulumi.getter(name="redundantId")
    def redundant_id(self) -> Optional[str]:
        """
        Unique identifier for a redundant device applicable for HA devices.
        """
        return pulumi.get(self, "redundant_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Device location region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sshIpAddress")
    def ssh_ip_address(self) -> Optional[str]:
        """
        IP address of SSH enabled interface on the device.
        """
        return pulumi.get(self, "ssh_ip_address")

    @property
    @pulumi.getter(name="sshIpFqdn")
    def ssh_ip_fqdn(self) -> Optional[str]:
        """
        FQDN of SSH enabled interface on the device.
        """
        return pulumi.get(self, "ssh_ip_fqdn")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional['outputs.NetworkDeviceSecondaryDeviceSshKey']:
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[str]:
        """
        Device unique identifier.
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="vendorConfiguration")
    def vendor_configuration(self) -> Optional[Mapping[str, str]]:
        """
        Key/Value pairs of vendor specific configuration parameters
        for a secondary device. Key values are `controller1`, `activationKey`, `managementType`, `siteId`,
        `systemIpAddress`.
        """
        return pulumi.get(self, "vendor_configuration")

    @property
    @pulumi.getter(name="wanInterfaceId")
    def wan_interface_id(self) -> Optional[str]:
        return pulumi.get(self, "wan_interface_id")

    @property
    @pulumi.getter(name="zoneCode")
    def zone_code(self) -> Optional[str]:
        """
        Device location zone code.
        """
        return pulumi.get(self, "zone_code")


@pulumi.output_type
class NetworkDeviceSecondaryDeviceInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignedType":
            suggest = "assigned_type"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "operationalStatus":
            suggest = "operational_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceSecondaryDeviceInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceSecondaryDeviceInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceSecondaryDeviceInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assigned_type: Optional[str] = None,
                 id: Optional[int] = None,
                 ip_address: Optional[str] = None,
                 mac_address: Optional[str] = None,
                 name: Optional[str] = None,
                 operational_status: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str assigned_type: interface management type (Equinix Managed or empty).
        :param int id: interface identifier.
        :param str ip_address: interface IP address.
        :param str mac_address: interface MAC address.
        :param str name: Device name.
        :param str operational_status: interface operational status. One of `up`, `down`.
        :param str status: interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        :param str type: interface type.
        """
        if assigned_type is not None:
            pulumi.set(__self__, "assigned_type", assigned_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operational_status is not None:
            pulumi.set(__self__, "operational_status", operational_status)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="assignedType")
    def assigned_type(self) -> Optional[str]:
        """
        interface management type (Equinix Managed or empty).
        """
        return pulumi.get(self, "assigned_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[int]:
        """
        interface identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        interface IP address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[str]:
        """
        interface MAC address.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Device name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationalStatus")
    def operational_status(self) -> Optional[str]:
        """
        interface operational status. One of `up`, `down`.
        """
        return pulumi.get(self, "operational_status")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        interface status. One of `AVAILABLE`, `RESERVED`, `ASSIGNED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        interface type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NetworkDeviceSecondaryDeviceSshKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceSecondaryDeviceSshKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceSecondaryDeviceSshKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceSecondaryDeviceSshKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: str,
                 username: str):
        """
        :param str username: username associated with given key.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        username associated with given key.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class NetworkDeviceSshKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceSshKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceSshKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceSshKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: str,
                 username: str):
        """
        :param str username: username associated with given key.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        username associated with given key.
        """
        return pulumi.get(self, "username")


