# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 max_retry_wait_seconds: Optional[pulumi.Input[int]] = None,
                 request_timeout: Optional[pulumi.Input[int]] = None,
                 response_max_page_size: Optional[pulumi.Input[int]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] auth_token: The Equinix Metal API auth key for API operations
        :param pulumi.Input[str] client_id: API Consumer Key available under My Apps section in developer portal
        :param pulumi.Input[str] client_secret: API Consumer secret available under My Apps section in developer portal
        :param pulumi.Input[str] endpoint: The Equinix API base URL to point out desired environment. Defaults to https://api.equinix.com
        :param pulumi.Input[int] request_timeout: The duration of time, in seconds, that the Equinix Platform API Client should wait before canceling an API request.
               Defaults to 30
        :param pulumi.Input[int] response_max_page_size: The maximum number of records in a single response for REST queries that produce paginated responses
        :param pulumi.Input[str] token: API token from the developer sandbox
        """
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if max_retry_wait_seconds is not None:
            pulumi.set(__self__, "max_retry_wait_seconds", max_retry_wait_seconds)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if response_max_page_size is not None:
            pulumi.set(__self__, "response_max_page_size", response_max_page_size)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[str]]:
        """
        The Equinix Metal API auth key for API operations
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        API Consumer Key available under My Apps section in developer portal
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        API Consumer secret available under My Apps section in developer portal
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The Equinix API base URL to point out desired environment. Defaults to https://api.equinix.com
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter(name="maxRetryWaitSeconds")
    def max_retry_wait_seconds(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_retry_wait_seconds")

    @max_retry_wait_seconds.setter
    def max_retry_wait_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retry_wait_seconds", value)

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The duration of time, in seconds, that the Equinix Platform API Client should wait before canceling an API request.
        Defaults to 30
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_timeout", value)

    @property
    @pulumi.getter(name="responseMaxPageSize")
    def response_max_page_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of records in a single response for REST queries that produce paginated responses
        """
        return pulumi.get(self, "response_max_page_size")

    @response_max_page_size.setter
    def response_max_page_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "response_max_page_size", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        API token from the developer sandbox
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 max_retry_wait_seconds: Optional[pulumi.Input[int]] = None,
                 request_timeout: Optional[pulumi.Input[int]] = None,
                 response_max_page_size: Optional[pulumi.Input[int]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the equinix package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_token: The Equinix Metal API auth key for API operations
        :param pulumi.Input[str] client_id: API Consumer Key available under My Apps section in developer portal
        :param pulumi.Input[str] client_secret: API Consumer secret available under My Apps section in developer portal
        :param pulumi.Input[str] endpoint: The Equinix API base URL to point out desired environment. Defaults to https://api.equinix.com
        :param pulumi.Input[int] request_timeout: The duration of time, in seconds, that the Equinix Platform API Client should wait before canceling an API request.
               Defaults to 30
        :param pulumi.Input[int] response_max_page_size: The maximum number of records in a single response for REST queries that produce paginated responses
        :param pulumi.Input[str] token: API token from the developer sandbox
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the equinix package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 max_retry_wait_seconds: Optional[pulumi.Input[int]] = None,
                 request_timeout: Optional[pulumi.Input[int]] = None,
                 response_max_page_size: Optional[pulumi.Input[int]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["auth_token"] = auth_token
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = client_secret
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["max_retries"] = pulumi.Output.from_input(max_retries).apply(pulumi.runtime.to_json) if max_retries is not None else None
            __props__.__dict__["max_retry_wait_seconds"] = pulumi.Output.from_input(max_retry_wait_seconds).apply(pulumi.runtime.to_json) if max_retry_wait_seconds is not None else None
            __props__.__dict__["request_timeout"] = pulumi.Output.from_input(request_timeout).apply(pulumi.runtime.to_json) if request_timeout is not None else None
            __props__.__dict__["response_max_page_size"] = pulumi.Output.from_input(response_max_page_size).apply(pulumi.runtime.to_json) if response_max_page_size is not None else None
            __props__.__dict__["token"] = token
        super(Provider, __self__).__init__(
            'equinix',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> pulumi.Output[Optional[str]]:
        """
        The Equinix Metal API auth key for API operations
        """
        return pulumi.get(self, "auth_token")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[str]]:
        """
        API Consumer Key available under My Apps section in developer portal
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[str]]:
        """
        API Consumer secret available under My Apps section in developer portal
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The Equinix API base URL to point out desired environment. Defaults to https://api.equinix.com
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[str]]:
        """
        API token from the developer sandbox
        """
        return pulumi.get(self, "token")

