# Contribution Guide

Thank you for your interest in contributing to our project! Please follow these guidelines to ensure a smooth contribution process.

## Prerequisites

- Python 3.10 or higher
- Git

## Setting Up the Development Environment

1. **Clone the repository:**
   ```bash
   git clone https://github.com/semohr/eyconf.git
   cd eyconf
   ```
2. **Install the dependencies:**
    We recommend using a virtual environment to manage the dependencies.
   ```bash
   pip install -e .[dev]
   ```

## Install pre-commit hooks
We automatically check for code style and formatting issues using pre-commit hooks. To install the hooks, run the following command:

```bash
pip install pre-commit
pre-commit install
```

## Before Submitting a Pull Request

Verify that your code follows the project's coding standards and conventions. Run [Ruff](https://docs.astral.sh/ruff/) manually or use the pre-commit hooks to check for any issues. Additionally, run the tests to ensure that your changes do not break any existing functionality.

```bash
# Run Ruff manually
ruff check
# Run the tests
pytest
```

## Docs

To build the documentation, you need to have `sphinx` and `myst-parser` installed. You can install them using:

```bash
pip install -e .[docs]
```

To build the documentation, run:

```bash
make html
```