#  telectron - Telegram MTProto API Client Library for Python
#  Copyright (C) 2017-present Dan <https://github.com/delivrance>
#
#  This file is part of telectron.
#
#  telectron is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  telectron is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with telectron.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from telectron.raw.core.primitives import Int, Long, Int128, Int256, Bool, Bytes, String, Double, Vector
from telectron.raw.core import TLObject
from telectron import raw
from typing import List, Optional, Any

# # # # # # # # # # # # # # # # # # # # # # # #
#               !!! WARNING !!!               #
#          This is a generated file!          #
# All changes made in this file will be lost! #
# # # # # # # # # # # # # # # # # # # # # # # #


class MediaAreaUrl(TLObject):  # type: ignore
    """Telegram API type.

    Constructor of :obj:`~telectron.raw.base.MediaArea`.

    Details:
        - Layer: ``206``
        - ID: ``37381085``

    Parameters:
        coordinates (:obj:`MediaAreaCoordinates <telectron.raw.base.MediaAreaCoordinates>`):
            N/A

        url (``str``):
            N/A

    """

    __slots__: List[str] = ["coordinates", "url"]

    ID = 0x37381085
    QUALNAME = "types.MediaAreaUrl"

    def __init__(self, *, coordinates: "raw.base.MediaAreaCoordinates", url: str) -> None:
        self.coordinates = coordinates  # MediaAreaCoordinates
        self.url = url  # string

    @staticmethod
    def read(b: BytesIO, *args: Any) -> "MediaAreaUrl":
        # No flags
        
        coordinates = TLObject.read(b)
        
        url = String.read(b)
        
        return MediaAreaUrl(coordinates=coordinates, url=url)

    def write(self, *args) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(self.coordinates.write())
        
        b.write(String(self.url))
        
        return b.getvalue()
