#  telectron - Telegram MTProto API Client Library for Python
#  Copyright (C) 2017-present Dan <https://github.com/delivrance>
#
#  This file is part of telectron.
#
#  telectron is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  telectron is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with telectron.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from telectron.raw.core.primitives import Int, Long, Int128, Int256, Bool, Bytes, String, Double, Vector
from telectron.raw.core import TLObject
from telectron import raw
from typing import List, Optional, Any

# # # # # # # # # # # # # # # # # # # # # # # #
#               !!! WARNING !!!               #
#          This is a generated file!          #
# All changes made in this file will be lost! #
# # # # # # # # # # # # # # # # # # # # # # # #


class MessageMediaToDo(TLObject):  # type: ignore
    """Telegram API type.

    Constructor of :obj:`~telectron.raw.base.MessageMedia`.

    Details:
        - Layer: ``206``
        - ID: ``8A53B014``

    Parameters:
        todo (:obj:`TodoList <telectron.raw.base.TodoList>`):
            N/A

        completions (List of :obj:`TodoCompletion <telectron.raw.base.TodoCompletion>`, *optional*):
            N/A

    Functions:
        This object can be returned by 2 functions.

        .. currentmodule:: telectron.raw.functions

        .. autosummary::
            :nosignatures:

            messages.UploadMedia
            messages.UploadImportedMedia
    """

    __slots__: List[str] = ["todo", "completions"]

    ID = 0x8a53b014
    QUALNAME = "types.MessageMediaToDo"

    def __init__(self, *, todo: "raw.base.TodoList", completions: Optional[List["raw.base.TodoCompletion"]] = None) -> None:
        self.todo = todo  # TodoList
        self.completions = completions  # flags.0?Vector<TodoCompletion>

    @staticmethod
    def read(b: BytesIO, *args: Any) -> "MessageMediaToDo":
        
        flags = Int.read(b)
        
        todo = TLObject.read(b)
        
        completions = TLObject.read(b) if flags & (1 << 0) else []
        
        return MessageMediaToDo(todo=todo, completions=completions)

    def write(self, *args) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        flags = 0
        flags |= (1 << 0) if self.completions else 0
        b.write(Int(flags))
        
        b.write(self.todo.write())
        
        if self.completions is not None:
            b.write(Vector(self.completions))
        
        return b.getvalue()
