#  telectron - Telegram MTProto API Client Library for Python
#  Copyright (C) 2017-present Dan <https://github.com/delivrance>
#
#  This file is part of telectron.
#
#  telectron is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  telectron is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with telectron.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from telectron.raw.core.primitives import Int, Long, Int128, Int256, Bool, Bytes, String, Double, Vector
from telectron.raw.core import TLObject
from telectron import raw
from typing import List, Optional, Any

# # # # # # # # # # # # # # # # # # # # # # # #
#               !!! WARNING !!!               #
#          This is a generated file!          #
# All changes made in this file will be lost! #
# # # # # # # # # # # # # # # # # # # # # # # #


class ConnectedStarRefBots(TLObject):  # type: ignore
    """Telegram API type.

    Constructor of :obj:`~telectron.raw.base.payments.ConnectedStarRefBots`.

    Details:
        - Layer: ``206``
        - ID: ``98D5EA1D``

    Parameters:
        count (``int`` ``32-bit``):
            N/A

        connected_bots (List of :obj:`ConnectedBotStarRef <telectron.raw.base.ConnectedBotStarRef>`):
            N/A

        users (List of :obj:`User <telectron.raw.base.User>`):
            N/A

    Functions:
        This object can be returned by 4 functions.

        .. currentmodule:: telectron.raw.functions

        .. autosummary::
            :nosignatures:

            payments.GetConnectedStarRefBots
            payments.GetConnectedStarRefBot
            payments.ConnectStarRefBot
            payments.EditConnectedStarRefBot
    """

    __slots__: List[str] = ["count", "connected_bots", "users"]

    ID = 0x98d5ea1d
    QUALNAME = "types.payments.ConnectedStarRefBots"

    def __init__(self, *, count: int, connected_bots: List["raw.base.ConnectedBotStarRef"], users: List["raw.base.User"]) -> None:
        self.count = count  # int
        self.connected_bots = connected_bots  # Vector<ConnectedBotStarRef>
        self.users = users  # Vector<User>

    @staticmethod
    def read(b: BytesIO, *args: Any) -> "ConnectedStarRefBots":
        # No flags
        
        count = Int.read(b)
        
        connected_bots = TLObject.read(b)
        
        users = TLObject.read(b)
        
        return ConnectedStarRefBots(count=count, connected_bots=connected_bots, users=users)

    def write(self, *args) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(Int(self.count))
        
        b.write(Vector(self.connected_bots))
        
        b.write(Vector(self.users))
        
        return b.getvalue()
