#  telectron - Telegram MTProto API Client Library for Python
#  Copyright (C) 2017-present Dan <https://github.com/delivrance>
#
#  This file is part of telectron.
#
#  telectron is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  telectron is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with telectron.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from telectron.raw.core.primitives import Int, Long, Int128, Int256, Bool, Bytes, String, Double, Vector
from telectron.raw.core import TLObject
from telectron import raw
from typing import List, Optional, Any

# # # # # # # # # # # # # # # # # # # # # # # #
#               !!! WARNING !!!               #
#          This is a generated file!          #
# All changes made in this file will be lost! #
# # # # # # # # # # # # # # # # # # # # # # # #


class StarGiftAttributeBackdrop(TLObject):  # type: ignore
    """Telegram API type.

    Constructor of :obj:`~telectron.raw.base.StarGiftAttribute`.

    Details:
        - Layer: ``206``
        - ID: ``D93D859C``

    Parameters:
        name (``str``):
            N/A

        backdrop_id (``int`` ``32-bit``):
            N/A

        center_color (``int`` ``32-bit``):
            N/A

        edge_color (``int`` ``32-bit``):
            N/A

        pattern_color (``int`` ``32-bit``):
            N/A

        text_color (``int`` ``32-bit``):
            N/A

        rarity_permille (``int`` ``32-bit``):
            N/A

    """

    __slots__: List[str] = ["name", "backdrop_id", "center_color", "edge_color", "pattern_color", "text_color", "rarity_permille"]

    ID = 0xd93d859c
    QUALNAME = "types.StarGiftAttributeBackdrop"

    def __init__(self, *, name: str, backdrop_id: int, center_color: int, edge_color: int, pattern_color: int, text_color: int, rarity_permille: int) -> None:
        self.name = name  # string
        self.backdrop_id = backdrop_id  # int
        self.center_color = center_color  # int
        self.edge_color = edge_color  # int
        self.pattern_color = pattern_color  # int
        self.text_color = text_color  # int
        self.rarity_permille = rarity_permille  # int

    @staticmethod
    def read(b: BytesIO, *args: Any) -> "StarGiftAttributeBackdrop":
        # No flags
        
        name = String.read(b)
        
        backdrop_id = Int.read(b)
        
        center_color = Int.read(b)
        
        edge_color = Int.read(b)
        
        pattern_color = Int.read(b)
        
        text_color = Int.read(b)
        
        rarity_permille = Int.read(b)
        
        return StarGiftAttributeBackdrop(name=name, backdrop_id=backdrop_id, center_color=center_color, edge_color=edge_color, pattern_color=pattern_color, text_color=text_color, rarity_permille=rarity_permille)

    def write(self, *args) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(String(self.name))
        
        b.write(Int(self.backdrop_id))
        
        b.write(Int(self.center_color))
        
        b.write(Int(self.edge_color))
        
        b.write(Int(self.pattern_color))
        
        b.write(Int(self.text_color))
        
        b.write(Int(self.rarity_permille))
        
        return b.getvalue()
